/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.odps.task;

import com.aliyun.odps.Instance;
import com.aliyun.odps.Odps;
import com.aliyun.odps.OdpsException;
import com.aliyun.odps.Task;
import com.aliyun.odps.mapred.bridge.MetaExplorer;
import com.aliyun.odps.task.SQLTask;
import com.google.gson.GsonBuilder;
import java.util.Map;

public class JobUtils {
    public static Instance submitOpenMR(Odps odps, String project, String sql, String taskName, Map<String, String> hints, Map<String, String> alias) throws OdpsException {
        return SQLTask.run((Odps)odps, (String)project, (String)sql, (String)taskName, hints, alias, (String)"mr");
    }

    public static Instance submitOpenMR(MetaExplorer metaExplorer, String sql, String taskName, Map<String, String> hints, Map<String, String> aliases, int priority) throws OdpsException {
        String json;
        SQLTask task = new SQLTask();
        task.setQuery(sql);
        task.setName(taskName);
        task.setProperty("type", "sql");
        if (hints != null) {
            try {
                hints.put("odps.sql.submit.mode", "script");
                json = new GsonBuilder().disableHtmlEscaping().create().toJson(hints);
                task.setProperty("settings", json);
            }
            catch (Exception e) {
                throw new OdpsException(e.getMessage(), (Throwable)e);
            }
        }
        if (aliases != null) {
            try {
                json = new GsonBuilder().disableHtmlEscaping().create().toJson(aliases);
                task.setProperty("aliases", json);
            }
            catch (Exception e) {
                throw new OdpsException(e.getMessage(), (Throwable)e);
            }
        }
        return metaExplorer.createInstance((Task)task, priority);
    }
}

