/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.odps.mapred.bridge.type;

import com.aliyun.odps.OdpsType;
import com.aliyun.odps.io.AbstractDatetimeWritable;
import com.aliyun.odps.io.BinaryComparable;
import com.aliyun.odps.io.BooleanWritable;
import com.aliyun.odps.io.DatetimeWritable;
import com.aliyun.odps.io.DoubleWritable;
import com.aliyun.odps.io.LongWritable;
import com.aliyun.odps.io.Text;
import java.util.Comparator;

public class ComparatorFactory {
    public static Comparator getComparator(OdpsType type) {
        switch (type) {
            case STRING: {
                return new StringComparator();
            }
            case DOUBLE: {
                return new DoubleComparator();
            }
            case BIGINT: {
                return new BigintComparator();
            }
            case BOOLEAN: {
                return new BooleanComparator();
            }
            case DATETIME: {
                return new DatetimeComparator();
            }
        }
        throw new RuntimeException("Unsupported type in compare:" + type);
    }

    public static class DatetimeComparator
    implements Comparator<DatetimeWritable> {
        @Override
        public int compare(DatetimeWritable o1, DatetimeWritable o2) {
            if (o1 == null) {
                if (o2 == null) {
                    return 0;
                }
                return -1;
            }
            if (o2 == null) {
                return 1;
            }
            return o1.compareTo((AbstractDatetimeWritable)o2);
        }
    }

    public static class BooleanComparator
    implements Comparator<BooleanWritable> {
        @Override
        public int compare(BooleanWritable o1, BooleanWritable o2) {
            if (o1 == null) {
                if (o2 == null) {
                    return 0;
                }
                return -1;
            }
            if (o2 == null) {
                return 1;
            }
            return o1.compareTo((Object)o2);
        }
    }

    public static class BigintComparator
    implements Comparator<LongWritable> {
        @Override
        public int compare(LongWritable o1, LongWritable o2) {
            if (o1 == null) {
                if (o2 == null) {
                    return 0;
                }
                return -1;
            }
            if (o2 == null) {
                return 1;
            }
            return o1.compareTo((Object)o2);
        }
    }

    public static class DoubleComparator
    implements Comparator<DoubleWritable> {
        @Override
        public int compare(DoubleWritable o1, DoubleWritable o2) {
            if (o1 == null) {
                if (o2 == null) {
                    return 0;
                }
                return -1;
            }
            if (o2 == null) {
                return 1;
            }
            return o1.compareTo((Object)o2);
        }
    }

    public static class StringComparator
    implements Comparator<Text> {
        @Override
        public int compare(Text o1, Text o2) {
            if (o1 == null) {
                if (o2 == null) {
                    return 0;
                }
                return -1;
            }
            if (o2 == null) {
                return 1;
            }
            return o1.compareTo((BinaryComparable)o2);
        }
    }
}

