/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.odps.mapred.bridge.streaming.io;

import com.aliyun.odps.io.BytesWritable;
import com.aliyun.odps.io.Text;
import com.aliyun.odps.mapred.bridge.streaming.PipeMapRed;
import com.aliyun.odps.mapred.bridge.streaming.io.InputWriter;
import java.io.DataOutput;
import java.io.IOException;

public class TextInputWriter
extends InputWriter<Object, Object> {
    private DataOutput clientOut;
    private byte[] inputSeparator;

    @Override
    public void initialize(PipeMapRed pipeMapRed) throws IOException {
        super.initialize(pipeMapRed);
        this.clientOut = pipeMapRed.getClientOutput();
        this.inputSeparator = pipeMapRed.getInputSeparator();
    }

    @Override
    public void writeKey(Object key) throws IOException {
        TextInputWriter.writeUTF8(key, this.clientOut);
        this.clientOut.write(this.inputSeparator);
    }

    @Override
    public void writeValue(Object value) throws IOException {
        TextInputWriter.writeUTF8(value, this.clientOut);
        this.clientOut.write(10);
    }

    static void writeUTF8(Object object, DataOutput clientOut) throws IOException {
        int valSize;
        byte[] bval;
        if (object instanceof BytesWritable) {
            BytesWritable val = (BytesWritable)object;
            bval = val.getBytes();
            valSize = val.getLength();
        } else if (object instanceof Text) {
            Text val = (Text)object;
            bval = val.getBytes();
            valSize = val.getLength();
        } else {
            String sval = object.toString();
            bval = sval.getBytes("UTF-8");
            valSize = bval.length;
        }
        clientOut.write(bval, 0, valSize);
    }
}

