/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.odps.mapred.bridge.streaming;

import com.aliyun.odps.conf.Configuration;
import com.aliyun.odps.mapred.bridge.streaming.Environment;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.InetAddress;
import java.net.URL;

public class StreamUtil {
    static final String regexpSpecials = "[]()?*+|.!^-\\~@";
    private static Environment env;
    static String HOST;

    public static Class goodClassOrNull(Configuration conf, String className, String defaultPackage) {
        Class clazz = null;
        try {
            clazz = conf.getClassByName(className);
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        if (clazz == null && className.indexOf(46) == -1 && defaultPackage != null) {
            className = defaultPackage + "." + className;
            try {
                clazz = conf.getClassByName(className);
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        return clazz;
    }

    public static String findInClasspath(String className) {
        return StreamUtil.findInClasspath(className, StreamUtil.class.getClassLoader());
    }

    public static String findInClasspath(String className, ClassLoader loader) {
        String codePath;
        String relPath = className;
        relPath = relPath.replace('.', '/');
        URL classUrl = loader.getResource(relPath = relPath + ".class");
        if (classUrl != null) {
            boolean inJar = classUrl.getProtocol().equals("jar");
            codePath = classUrl.toString();
            if (codePath.startsWith("jar:")) {
                codePath = codePath.substring("jar:".length());
            }
            if (codePath.startsWith("file:")) {
                codePath = codePath.substring("file:".length());
            }
            if (inJar) {
                int bang = codePath.lastIndexOf(33);
                codePath = codePath.substring(0, bang);
            } else {
                int pos = codePath.lastIndexOf(relPath);
                if (pos == -1) {
                    throw new IllegalArgumentException("invalid codePath: className=" + className + " codePath=" + codePath);
                }
                codePath = codePath.substring(0, pos);
            }
        } else {
            codePath = null;
        }
        return codePath;
    }

    static String qualifyHost(String url) {
        try {
            return StreamUtil.qualifyHost(new URL(url)).toString();
        }
        catch (IOException io) {
            return url;
        }
    }

    static URL qualifyHost(URL url) {
        try {
            InetAddress a = InetAddress.getByName(url.getHost());
            String qualHost = a.getCanonicalHostName();
            URL q = new URL(url.getProtocol(), qualHost, url.getPort(), url.getFile());
            return q;
        }
        catch (IOException io) {
            return url;
        }
    }

    public static String regexpEscape(String plain) {
        StringBuffer buf = new StringBuffer();
        char[] ch = plain.toCharArray();
        int csup = ch.length;
        for (int c = 0; c < csup; ++c) {
            if (regexpSpecials.indexOf(ch[c]) != -1) {
                buf.append("\\");
            }
            buf.append(ch[c]);
        }
        return buf.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static String slurp(File f) throws IOException {
        int len = (int)f.length();
        byte[] buf = new byte[len];
        String contents = null;
        try (FileInputStream in = new FileInputStream(f);){
            int readLen = in.read(buf, 0, len);
            if (readLen != len) {
                throw new RuntimeException("read length is not equal to file length");
            }
            contents = new String(buf, "UTF-8");
        }
        return contents;
    }

    static Environment env() {
        if (env != null) {
            return env;
        }
        try {
            env = new Environment();
        }
        catch (IOException io) {
            io.printStackTrace();
        }
        return env;
    }

    static {
        try {
            env = new Environment();
            HOST = env.getHost();
        }
        catch (IOException io) {
            io.printStackTrace();
        }
    }
}

