/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.odps.mapred.bridge.streaming;

import com.aliyun.odps.Column;
import com.aliyun.odps.OdpsType;
import com.aliyun.odps.conf.Configuration;
import com.aliyun.odps.data.Record;
import com.aliyun.odps.io.Text;
import com.aliyun.odps.mapred.Mapper;
import com.aliyun.odps.mapred.Reducer;
import com.aliyun.odps.mapred.TaskContext;
import com.aliyun.odps.mapred.bridge.streaming.StreamSecurityHelper;
import com.aliyun.odps.mapred.bridge.streaming.StreamUtil;
import com.aliyun.odps.mapred.bridge.streaming.io.InputWriter;
import com.aliyun.odps.mapred.bridge.streaming.io.LineReader;
import com.aliyun.odps.mapred.bridge.streaming.io.OutputReader;
import com.aliyun.odps.mapred.bridge.streaming.io.RecordOutputReader;
import com.aliyun.odps.mapred.bridge.streaming.io.TextInputWriter;
import com.aliyun.odps.mapred.bridge.streaming.io.TextOutputReader;
import com.aliyun.odps.mapred.conf.BridgeJobConf;
import com.aliyun.odps.mapred.conf.JobConf;
import com.aliyun.odps.utils.ReflectionUtils;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class PipeMapRed {
    protected static final Log LOG = LogFactory.getLog((String)PipeMapRed.class.getName());
    static final int OUTSIDE = 1;
    static final int SINGLEQ = 2;
    static final int DOUBLEQ = 3;
    private static final int BUFFER_SIZE = 131072;
    long startTime_;
    long numRecRead_ = 0L;
    long numRecWritten_ = 0L;
    long numRecSkipped_ = 0L;
    long nextRecReadLog_ = 1L;
    long minRecWrittenToEnableSkip_ = Long.MAX_VALUE;
    long reporterOutDelay_ = 10000L;
    long reporterErrDelay_ = 10000L;
    long joinDelay_;
    BridgeJobConf job_;
    boolean doPipe_;
    Class<? extends InputWriter> mapInputWriterClass_;
    Class<? extends OutputReader> mapOutputReaderClass_;
    Class<? extends InputWriter> reduceInputWriterClass_;
    Class<? extends OutputReader> reduceOutputReaderClass_;
    boolean nonZeroExitIsFailure_;
    Process sim;
    InputWriter inWriter_;
    OutputReader outReader_;
    MROutputThread outThread_;
    MRErrorThread errThread_;
    DataOutputStream clientOut_;
    DataInputStream clientErr_;
    DataInputStream clientIn_;
    int numExceptions_;
    protected volatile Throwable outerrThreadsThrowable;
    volatile boolean processProvidedStatus_ = false;

    public Configuration getConfiguration() {
        return this.job_;
    }

    public DataOutput getClientOutput() {
        return this.clientOut_;
    }

    public DataInput getClientInput() {
        return this.clientIn_;
    }

    public abstract byte[] getInputSeparator();

    public abstract byte[] getFieldSeparator();

    public abstract int getNumOfKeyFields();

    abstract boolean getDoPipe();

    abstract String getPipeCommand(JobConf var1);

    public int getNumOfOutputFields() {
        return this.job_.getOutputSchema().length;
    }

    static String[] splitArgs(String args) {
        ArrayList<String> argList = new ArrayList<String>();
        char[] ch = args.toCharArray();
        int clen = ch.length;
        int state = 1;
        int argstart = 0;
        for (int c = 0; c <= clen; ++c) {
            boolean last = c == clen;
            int lastState = state;
            boolean endToken = false;
            if (!last) {
                if (ch[c] == '\'') {
                    if (state == 1) {
                        state = 2;
                    } else if (state == 2) {
                        state = 1;
                    }
                    endToken = state != lastState;
                } else if (ch[c] == '\"') {
                    if (state == 1) {
                        state = 3;
                    } else if (state == 3) {
                        state = 1;
                    }
                    endToken = state != lastState;
                } else if (ch[c] == ' ' && state == 1) {
                    endToken = true;
                }
            }
            if (!last && !endToken) continue;
            if (c != argstart) {
                String a = args.substring(argstart, c);
                argList.add(a);
            }
            argstart = c + 1;
            lastState = state;
        }
        return argList.toArray(new String[0]);
    }

    public void configure(JobConf job) {
        try {
            String argv = this.getPipeCommand(job);
            if (argv == null) {
                throw new RuntimeException("streaming pipe cmd is null");
            }
            this.joinDelay_ = job.getLong("stream.joindelay.milli", 0L);
            this.job_ = new BridgeJobConf((Configuration)job);
            this.mapInputWriterClass_ = this.job_.getClass("stream.map.input.writer.class", TextInputWriter.class, InputWriter.class);
            this.mapOutputReaderClass_ = this.job_.getClass("stream.map.output.reader.class", TextOutputReader.class, OutputReader.class);
            this.reduceInputWriterClass_ = this.job_.getClass("stream.reduce.input.writer.class", TextInputWriter.class, InputWriter.class);
            this.reduceOutputReaderClass_ = this.job_.getClass("stream.reduce.output.reader.class", TextOutputReader.class, OutputReader.class);
            this.nonZeroExitIsFailure_ = this.job_.getBoolean("stream.non.zero.exit.is.failure", true);
            this.doPipe_ = this.getDoPipe();
            if (!this.doPipe_) {
                return;
            }
            this.setStreamJobDetails(job);
            String[] argvSplit = PipeMapRed.splitArgs(argv);
            String prog = argvSplit[0];
            LOG.info((Object)("PipeMapRed exec " + Arrays.asList(argvSplit)));
            Properties childEnv = new Properties();
            this.addJobConfToEnvironment(this.job_, childEnv);
            this.addEnvironment(childEnv, this.job_.get("stream.addenvironment"));
            this.envPut(childEnv, "TMPDIR", System.getProperty("java.io.tmpdir"));
            this.envPut(childEnv, "TABLE_RESOURCE_READER", "../table_resource_reader");
            HashMap<String, String> envMap = new HashMap<String, String>();
            for (String key : childEnv.stringPropertyNames()) {
                envMap.put(key, childEnv.getProperty(key));
            }
            this.sim = StreamSecurityHelper.startChildProcess(argvSplit, envMap);
            this.clientOut_ = new DataOutputStream(new BufferedOutputStream(this.sim.getOutputStream(), 131072));
            this.clientIn_ = new DataInputStream(new BufferedInputStream(this.sim.getInputStream(), 131072));
            this.clientErr_ = new DataInputStream(new BufferedInputStream(this.sim.getErrorStream()));
            this.startTime_ = System.currentTimeMillis();
        }
        catch (IOException e) {
            LOG.error((Object)"configuration exception", (Throwable)e);
            throw new RuntimeException("configuration exception", e);
        }
    }

    void setStreamJobDetails(JobConf job) {
        String s = job.get("stream.minRecWrittenToEnableSkip_");
        if (s != null) {
            this.minRecWrittenToEnableSkip_ = Long.parseLong(s);
            LOG.info((Object)("JobConf set minRecWrittenToEnableSkip_ =" + this.minRecWrittenToEnableSkip_));
        }
    }

    void addJobConfToEnvironment(JobConf conf, Properties env) {
        for (Map.Entry en : conf) {
            String name = (String)en.getKey();
            String value = conf.get(name);
            name = this.safeEnvVarName(name);
            this.envPut(env, name, value);
        }
    }

    String safeEnvVarName(String var) {
        StringBuffer safe = new StringBuffer();
        int len = var.length();
        for (int i = 0; i < len; ++i) {
            int c = var.charAt(i);
            int s = c >= 48 && c <= 57 || c >= 65 && c <= 90 || c >= 97 && c <= 122 ? c : 95;
            safe.append((char)s);
        }
        return safe.toString();
    }

    void addEnvironment(Properties env, String nameVals) {
        if (nameVals == null) {
            return;
        }
        String[] nv = nameVals.split(" ");
        for (int i = 0; i < nv.length; ++i) {
            String[] pair = nv[i].split("=", 2);
            if (pair.length != 2) {
                LOG.info((Object)("Skip env entry:" + nv[i]));
                continue;
            }
            this.envPut(env, pair[0], pair[1]);
        }
    }

    void envPut(Properties env, String name, String value) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Add  env entry:" + name + "=" + value));
        }
        env.put(name, value);
    }

    void startOutputThreads(TaskContext context) throws IOException {
        this.inWriter_ = this.createInputWriter();
        this.outReader_ = this.createOutputReader();
        this.outThread_ = new MROutputThread(this.outReader_, context);
        this.outThread_.start();
        this.errThread_ = new MRErrorThread();
        this.errThread_.setReporter(context);
        this.errThread_.start();
    }

    void waitOutputThreads() throws IOException {
        try {
            if (this.outThread_ == null) {
                this.startOutputThreads(null);
            }
            int exitVal = this.sim.waitFor();
            System.err.println("Streaming subprocess exited with code " + exitVal);
            if (this.outThread_ != null) {
                this.outThread_.join(this.joinDelay_);
            }
            if (this.errThread_ != null) {
                this.errThread_.join(this.joinDelay_);
            }
            if (this.outerrThreadsThrowable != null) {
                throw new RuntimeException(this.outerrThreadsThrowable);
            }
            if (exitVal != 0 && this.nonZeroExitIsFailure_) {
                throw new RuntimeException("Streaming subprocess failed with code " + exitVal + ", see stderr of failed worker for perhaps more info.");
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    abstract InputWriter createInputWriter() throws IOException;

    InputWriter createInputWriter(Class<? extends InputWriter> inputWriterClass) throws IOException {
        InputWriter inputWriter = (InputWriter)ReflectionUtils.newInstance(inputWriterClass, (Configuration)this.job_);
        inputWriter.initialize(this);
        return inputWriter;
    }

    abstract OutputReader createOutputReader() throws IOException;

    OutputReader createOutputReader(Class<? extends OutputReader> outputReaderClass) throws IOException {
        OutputReader outputReader = (OutputReader)ReflectionUtils.newInstance(outputReaderClass, (Configuration)this.job_);
        outputReader.initialize(this);
        return outputReader;
    }

    public void mapRedFinished() {
        try {
            if (!this.doPipe_) {
                LOG.info((Object)"mapRedFinished");
                return;
            }
            if (this.clientOut_ != null) {
                try {
                    this.clientOut_.flush();
                    this.clientOut_.close();
                }
                catch (IOException io) {
                    LOG.warn((Object)io);
                }
            }
            try {
                this.waitOutputThreads();
            }
            catch (IOException io) {
                LOG.warn((Object)io);
            }
            if (this.sim != null) {
                this.sim.destroy();
            }
            LOG.info((Object)"mapRedFinished");
        }
        catch (RuntimeException e) {
            LOG.info((Object)"PipeMapRed failed!", (Throwable)e);
            throw e;
        }
    }

    void maybeLogRecord() {
        if (this.numRecRead_ >= this.nextRecReadLog_) {
            String info = this.numRecInfo();
            LOG.info((Object)info);
            this.nextRecReadLog_ = this.nextRecReadLog_ < 100000L ? (this.nextRecReadLog_ *= 10L) : (this.nextRecReadLog_ += 100000L);
        }
    }

    public String getContext() {
        String s = this.numRecInfo() + "\n";
        if (this.outThread_ != null) {
            s = s + "last tool output: |" + this.outReader_.getLastOutput() + "|\n";
        }
        return s;
    }

    String envline(String var) {
        return var + "=" + StreamUtil.env().get(var) + "\n";
    }

    String numRecInfo() {
        long elapsed = (System.currentTimeMillis() - this.startTime_) / 1000L;
        return "R/W/S=" + this.numRecRead_ + "/" + this.numRecWritten_ + "/" + this.numRecSkipped_ + " in:" + this.safeDiv(this.numRecRead_, elapsed) + " [rec/s] out:" + this.safeDiv(this.numRecWritten_, elapsed) + " [rec/s]";
    }

    String safeDiv(long n, long d) {
        return d == 0L ? "NA" : "" + n / d + "=" + n + "/" + d;
    }

    class MRErrorThread
    extends Thread {
        long lastStderrReport = 0L;
        volatile TaskContext reporter;
        private final String reporterPrefix;
        private final String counterPrefix;
        private final String statusPrefix;

        public MRErrorThread() {
            this.reporterPrefix = PipeMapRed.this.job_.get("stream.stderr.reporter.prefix", "reporter:");
            this.counterPrefix = this.reporterPrefix + "counter:";
            this.statusPrefix = this.reporterPrefix + "status:";
            this.setDaemon(true);
        }

        public void setReporter(TaskContext reporter) {
            this.reporter = reporter;
        }

        @Override
        public void run() {
            Text line = new Text();
            LineReader lineReader = null;
            try {
                lineReader = new LineReader((InputStream)PipeMapRed.this.clientErr_, (Configuration)PipeMapRed.this.job_);
                while (lineReader.readLine(line) > 0) {
                    String lineStr = line.toString();
                    if (this.matchesReporter(lineStr)) {
                        if (this.reporter != null) {
                            if (this.matchesCounter(lineStr)) {
                                this.incrCounter(lineStr);
                            } else if (this.matchesStatus(lineStr)) {
                                PipeMapRed.this.processProvidedStatus_ = true;
                                this.setStatus(lineStr);
                            } else {
                                LOG.warn((Object)("Cannot parse reporter line: " + lineStr));
                            }
                        }
                    } else {
                        System.err.println(lineStr);
                    }
                    long now = System.currentTimeMillis();
                    if (this.reporter != null && now - this.lastStderrReport > PipeMapRed.this.reporterErrDelay_) {
                        this.lastStderrReport = now;
                        this.reporter.progress();
                    }
                    line.clear();
                }
                if (lineReader != null) {
                    lineReader.close();
                }
                if (PipeMapRed.this.clientErr_ != null) {
                    PipeMapRed.this.clientErr_.close();
                    PipeMapRed.this.clientErr_ = null;
                    LOG.info((Object)"MRErrorThread done");
                }
            }
            catch (Throwable th) {
                PipeMapRed.this.outerrThreadsThrowable = th;
                LOG.warn((Object)th);
                try {
                    if (lineReader != null) {
                        lineReader.close();
                    }
                    if (PipeMapRed.this.clientErr_ != null) {
                        PipeMapRed.this.clientErr_.close();
                        PipeMapRed.this.clientErr_ = null;
                    }
                }
                catch (IOException io) {
                    LOG.info((Object)io);
                }
            }
        }

        private boolean matchesReporter(String line) {
            return line.startsWith(this.reporterPrefix);
        }

        private boolean matchesCounter(String line) {
            return line.startsWith(this.counterPrefix);
        }

        private boolean matchesStatus(String line) {
            return line.startsWith(this.statusPrefix);
        }

        private void incrCounter(String line) {
            String trimmedLine = line.substring(this.counterPrefix.length()).trim();
            String[] columns = trimmedLine.split(",");
            if (columns.length == 3) {
                try {
                    this.reporter.getCounter(columns[0], columns[1]).increment(Long.parseLong(columns[2]));
                }
                catch (NumberFormatException e) {
                    LOG.warn((Object)("Cannot parse counter increment '" + columns[2] + "' from line: " + line));
                }
            } else {
                LOG.warn((Object)("Cannot parse counter line: " + line));
            }
        }

        private void setStatus(String line) {
        }
    }

    class MROutputThread
    extends Thread {
        OutputReader outReader = null;
        TaskContext context = null;
        long lastStdoutReport = 0L;
        String badDataBehavior;
        boolean ignoreBadCast;

        MROutputThread(OutputReader outReader, TaskContext context) {
            this.setDaemon(true);
            this.outReader = outReader;
            this.context = context;
            if (this.context != null) {
                this.badDataBehavior = context.getJobConf().get("stream.bad.data.behavior", "strict");
                this.ignoreBadCast = !this.badDataBehavior.equals("strict");
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                while (this.outReader.readKeyValue()) {
                    Object key = this.outReader.getCurrentKey();
                    Object value = this.outReader.getCurrentValue();
                    if (this.context == null || key == null) continue;
                    if (!this.context.getTaskID().isMap() || this.context.getNumReduceTasks() == 0) {
                        Record record = this.context.createOutputRecord();
                        if (this.outReader instanceof RecordOutputReader) {
                            Text[] fields = (Text[])value;
                            this.fillOutputRecord(record, fields, this.ignoreBadCast);
                        } else {
                            record.setString(0, key.toString());
                            record.setString(1, value.toString());
                        }
                        if (this.context.getTaskID().isMap()) {
                            ((Mapper.TaskContext)this.context).write(record);
                        } else {
                            ((Reducer.TaskContext)this.context).write(record);
                        }
                    } else {
                        Record keyRecord = this.context.createMapOutputKeyRecord();
                        keyRecord.setString(0, key.toString());
                        Record valueRecord = this.context.createMapOutputValueRecord();
                        valueRecord.setString(0, value.toString());
                        ((Mapper.TaskContext)this.context).write(keyRecord, valueRecord);
                    }
                    ++PipeMapRed.this.numRecWritten_;
                    long now = System.currentTimeMillis();
                    if (now - this.lastStdoutReport <= PipeMapRed.this.reporterOutDelay_) continue;
                    this.lastStdoutReport = now;
                    String hline = "Records R/W=" + PipeMapRed.this.numRecRead_ + "/" + PipeMapRed.this.numRecWritten_;
                    if (PipeMapRed.this.processProvidedStatus_) {
                        this.context.progress();
                    }
                    LOG.info((Object)hline);
                }
            }
            catch (Throwable th) {
                PipeMapRed.this.outerrThreadsThrowable = th;
                LOG.warn((Object)th);
            }
            finally {
                try {
                    if (PipeMapRed.this.clientIn_ != null) {
                        PipeMapRed.this.clientIn_.close();
                        PipeMapRed.this.clientIn_ = null;
                    }
                }
                catch (IOException io) {
                    LOG.info((Object)io);
                }
            }
        }

        void fillOutputRecord(Record record, Text[] fields, boolean ignoreBadCast) {
            if (fields.length != record.getColumnCount()) {
                throw new RuntimeException("output record not match output schema...");
            }
            Column[] columns = record.getColumns();
            for (int i = 0; i < fields.length; ++i) {
                Object val;
                block14: {
                    Column col = columns[i];
                    Text field = fields[i];
                    val = null;
                    if (col.getType().equals((Object)OdpsType.STRING)) {
                        val = field;
                    } else if (field.getLength() == 0) {
                        val = null;
                    } else {
                        String fieldStr = null;
                        try {
                            fieldStr = field.toString();
                            switch (col.getType()) {
                                case BIGINT: {
                                    val = Long.valueOf(fieldStr);
                                    break;
                                }
                                case DOUBLE: {
                                    val = Double.valueOf(fieldStr);
                                    break;
                                }
                                case BOOLEAN: {
                                    val = Boolean.valueOf(fieldStr);
                                    break;
                                }
                                default: {
                                    throw new RuntimeException("output column " + col.getName() + "'s type " + col.getType() + " not supported by streaming job");
                                }
                            }
                        }
                        catch (Exception e) {
                            if (ignoreBadCast) break block14;
                            if (fieldStr == null) {
                                throw new RuntimeException("Failed to decode streaming field as UTF-8 for column " + col.getName());
                            }
                            throw new RuntimeException("Invalid streaming field value for " + col.getType() + " column " + col.getName() + ":" + fieldStr, e);
                        }
                    }
                }
                record.set(i, val);
            }
        }
    }
}

