/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.odps.mapred.bridge;

import com.aliyun.odps.Column;
import com.aliyun.odps.OdpsType;
import com.aliyun.odps.counter.Counter;
import com.aliyun.odps.data.Record;
import com.aliyun.odps.data.TableInfo;
import com.aliyun.odps.data.VolumeInfo;
import com.aliyun.odps.io.Text;
import com.aliyun.odps.io.Writable;
import com.aliyun.odps.mapred.Mapper;
import com.aliyun.odps.mapred.Reducer;
import com.aliyun.odps.mapred.TaskContext;
import com.aliyun.odps.mapred.TaskId;
import com.aliyun.odps.mapred.bridge.ErrorCode;
import com.aliyun.odps.mapred.bridge.WritableRecord;
import com.aliyun.odps.mapred.bridge.utils.ResourceUtils;
import com.aliyun.odps.mapred.conf.BridgeJobConf;
import com.aliyun.odps.mapred.conf.JobConf;
import com.aliyun.odps.mapred.utils.InputUtils;
import com.aliyun.odps.mapred.utils.OutputUtils;
import com.aliyun.odps.mapred.utils.SchemaUtils;
import com.aliyun.odps.pipeline.Pipeline;
import com.aliyun.odps.udf.ExecutionContext;
import com.aliyun.odps.volume.FileSystem;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.lang.ArrayUtils;

public abstract class UDTFTaskContextImpl
implements TaskContext {
    protected BridgeJobConf conf;
    protected TaskId taskId;
    protected ExecutionContext ctx;
    protected Pipeline pipeline;
    protected boolean pipeMode;
    protected int pipeIndex = -1;
    protected Pipeline.TransformNode pipeNode;
    protected int reducerNum = 0;
    protected boolean innerOutput;
    protected Map<String, Integer> label2offset = new HashMap<String, Integer>();
    protected Column[] packagedOutputSchema;
    private static final String MULTIDEST_LABEL = "MULTIDEST_LABEL";
    private static final String INNEROUTPUT_LABEL = "INNEROUTPUT_LABEL";
    private static final String PARTITION_ID = "__partition_id__";
    protected int innerOutputIndex = 0;

    public UDTFTaskContextImpl(BridgeJobConf conf) {
        this.conf = conf;
        this.pipeline = Pipeline.fromJobConf((JobConf)conf);
        if (this.pipeline != null) {
            this.pipeMode = true;
        }
        this.innerOutput = this.isMapper() ? conf.getInnerOutputEnable() && conf.getMapperInnerOutputEnable() : conf.getInnerOutputEnable();
        this.initOutputSchema();
    }

    boolean isMapper() {
        return false;
    }

    public Class<? extends Reducer> getCombinerClass() {
        return this.conf.getCombinerClass();
    }

    public Column[] getMapOutputKeySchema() {
        return this.conf.getMapOutputKeySchema();
    }

    public Column[] getMapOutputKeySchema4Pipeline(int nodeId) {
        return this.conf.getMapOutputKeySchema4Pileline(nodeId);
    }

    public Column[] getMapOutputValueSchema4Pipeline(int nodeId) {
        return this.conf.getMapOutputValueSchema4Pileline(nodeId);
    }

    public Column[] getMapOutputValueSchema() {
        return this.conf.getMapOutputValueSchema();
    }

    public Class<? extends Mapper> getMapperClass() {
        return this.conf.getMapperClass();
    }

    public int getNumReduceTasks() {
        return this.reducerNum;
    }

    public Class<? extends Reducer> getReducerClass() {
        return this.conf.getReducerClass();
    }

    public Record createOutputRecord() throws IOException {
        return this.createOutputRecord("__default__");
    }

    public Record createOutputRecord(String label) throws IOException {
        if (!this.hasLabel(label)) {
            throw new IOException(ErrorCode.NO_SUCH_LABEL.toString() + " " + label);
        }
        return new WritableRecord(this.conf.getOutputSchema(label));
    }

    public Counter getCounter(Enum<?> key) {
        return this.ctx.getCounter(key);
    }

    public Counter getCounter(String groupName, String counterName) {
        return this.ctx.getCounter(groupName, counterName);
    }

    public TaskId getTaskID() {
        return this.taskId;
    }

    public void progress() {
        this.ctx.claimAlive();
    }

    public BufferedInputStream readResourceFileAsStream(String name) throws IOException {
        return ResourceUtils.readResourceFileAsStream(name);
    }

    public Iterable<BufferedInputStream> readResourceArchiveAsStream(String resourceName) throws IOException {
        return ResourceUtils.readResourceArchiveFileAsStream(resourceName);
    }

    public Iterable<BufferedInputStream> readResourceArchiveAsStream(String resourceName, String relativePath) throws IOException {
        return ResourceUtils.readResourceArchiveFileAsStream(resourceName, relativePath);
    }

    public Iterator<Record> readResourceTable(String tbl) throws IOException {
        return ResourceUtils.readResourceTable(tbl);
    }

    public JobConf getJobConf() {
        return this.conf;
    }

    public Record createMapOutputKeyRecord() throws IOException {
        if (this.pipeMode && this.pipeNode != null && this.pipeNode.getType().equals("map")) {
            return new WritableRecord(this.pipeNode.getOutputKeySchema());
        }
        return new WritableRecord(this.conf.getMapOutputKeySchema());
    }

    public Record createMapOutputValueRecord() throws IOException {
        if (this.pipeMode && this.pipeNode != null && this.pipeNode.getType().equals("map")) {
            return new WritableRecord(this.pipeNode.getOutputValueSchema());
        }
        return new WritableRecord(this.conf.getMapOutputValueSchema());
    }

    public Record createOutputKeyRecord() throws IOException {
        if (this.pipeMode && this.pipeNode != null) {
            return new WritableRecord(this.pipeNode.getOutputKeySchema());
        }
        return null;
    }

    public Record createOutputValueRecord() throws IOException {
        if (this.pipeMode && this.pipeNode != null) {
            return new WritableRecord(this.pipeNode.getOutputValueSchema());
        }
        return null;
    }

    public boolean isPipelineMode() {
        return this.pipeMode;
    }

    public Pipeline getPipeline() {
        return this.pipeline;
    }

    public Pipeline.TransformNode getCurrentNode() {
        return this.pipeNode;
    }

    public TableInfo[] getOutputTableInfo() {
        return OutputUtils.getTables((JobConf)this.conf);
    }

    private void initOutputSchema() {
        TableInfo[] tables = this.getOutputTableInfo();
        if (tables == null) {
            this.packagedOutputSchema = new Column[]{new Column("nil", OdpsType.STRING)};
            return;
        }
        ArrayList<Column[]> schemas = new ArrayList<Column[]>();
        ArrayList<OdpsType> outputColumnTypes = new ArrayList<OdpsType>();
        boolean multiInsert = tables.length > 1;
        int length = 0;
        for (TableInfo t : tables) {
            Column[] output = t.getLabel() == null ? this.conf.getOutputSchema() : this.conf.getOutputSchema(t.getLabel());
            ArrayList<OdpsType> tbColumnTypes = new ArrayList<OdpsType>();
            for (Column col : output) {
                tbColumnTypes.add(col.getType());
            }
            int idx = Collections.indexOfSubList(outputColumnTypes, tbColumnTypes);
            if (idx >= 0) {
                this.label2offset.put(t.getLabel(), idx);
                continue;
            }
            this.label2offset.put(t.getLabel(), length);
            for (Column col : output) {
                outputColumnTypes.add(col.getType());
            }
            length += output.length;
            schemas.add(output);
        }
        length += multiInsert ? 1 : 0;
        Column[] outputFields = new Column[length += this.innerOutput ? 1 : 0];
        length = 0;
        Iterator iterator = schemas.iterator();
        while (iterator.hasNext()) {
            Column[] r;
            Column[] columnArray = r = (Column[])iterator.next();
            int n = columnArray.length;
            for (int i = 0; i < n; ++i) {
                Column f;
                outputFields[length] = f = columnArray[i];
                ++length;
            }
        }
        if (multiInsert) {
            outputFields[length] = new Column(MULTIDEST_LABEL, OdpsType.STRING);
            ++length;
        }
        if (this.innerOutput) {
            outputFields[length] = new Column(INNEROUTPUT_LABEL, OdpsType.STRING);
        }
        this.packagedOutputSchema = outputFields;
    }

    protected Column[] getPackagedOutputSchema() {
        return this.packagedOutputSchema;
    }

    protected Column[] getIntermediateOutputSchema() {
        Object[] intermediateFields = (Column[])ArrayUtils.addAll((Object[])this.getMapOutputKeySchema(), (Object[])this.getMapOutputValueSchema());
        if (this.getPartitioner() != null) {
            intermediateFields = (Column[])ArrayUtils.addAll((Object[])SchemaUtils.fromString((String)String.format("%s:BIGINT", PARTITION_ID)), (Object[])intermediateFields);
        }
        return intermediateFields;
    }

    protected Column[] getPipelineOutputSchema(int nodeId) {
        Object[] intermediateFields = (Column[])ArrayUtils.addAll((Object[])this.getMapOutputKeySchema4Pipeline(nodeId), (Object[])this.getMapOutputValueSchema4Pipeline(nodeId));
        if (this.getPartitioner(nodeId) != null) {
            intermediateFields = (Column[])ArrayUtils.addAll((Object[])SchemaUtils.fromString((String)String.format("%s:BIGINT", PARTITION_ID)), (Object[])intermediateFields);
        }
        return intermediateFields;
    }

    protected Class getPartitioner() {
        return this.conf.getPartitionerClass();
    }

    protected String getPartitioner(int nodeId) {
        return this.conf.getPartitioner(nodeId);
    }

    public String[] getGroupingColumns() {
        return this.conf.getOutputGroupingColumns();
    }

    protected void configure(ExecutionContext ctx) {
        this.taskId = new TaskId(ctx.getStageID(), ctx.getWorkerID());
        this.ctx = ctx;
        if (this.pipeMode) {
            TableInfo[] infos;
            String tid = this.getTaskID().toString();
            System.out.println("Task ID: " + tid);
            this.pipeIndex = Integer.parseInt(tid.split("_")[0].substring(1)) - 1;
            String exeMode = this.conf.get("odps.mr.run.mode");
            if (exeMode != null && (exeMode.equalsIgnoreCase("sql") || exeMode.equalsIgnoreCase("hybrid")) && (infos = InputUtils.getTables((JobConf)this.conf)) != null && infos.length > 1 && this.pipeIndex > 0) {
                this.pipeIndex = this.pipeIndex - infos.length + 1;
                this.pipeIndex = this.pipeIndex < 0 ? 0 : this.pipeIndex;
            }
            this.resolveSqlModeNodeIndex(exeMode, tid);
            this.pipeNode = this.pipeline.getNode(this.pipeIndex);
        }
        this.reducerNum = this.pipeMode && this.pipeNode != null ? (this.pipeNode.getNextNode() != null ? this.pipeNode.getNextNode().getNumTasks() : (this.pipeIndex > 0 ? this.pipeNode.getNumTasks() : 0)) : this.conf.getNumReduceTasks();
    }

    private void resolveSqlModeNodeIndex(String exeMode, String tid) {
        if (exeMode != null && exeMode.equalsIgnoreCase("lot") && (this.conf.get("odps.mr.project.disable") == null || !Boolean.parseBoolean(this.conf.get("odps.mr.project.disable")))) {
            return;
        }
        TableInfo[] infos = InputUtils.getTables((JobConf)this.conf);
        if (infos == null || infos.length < 2) {
            return;
        }
        String projectConfMode = "";
        if (this.conf.get("odps.mr.project.conf") != null) {
            projectConfMode = this.conf.get("odps.mr.project.conf").toLowerCase();
        }
        if (projectConfMode.equals("lot")) {
            return;
        }
        if (tid.startsWith("M")) {
            this.pipeIndex = 0;
        } else {
            int pipePrefix = Integer.parseInt(tid.split("_")[0].substring(1));
            String taskIdPrefix = "R" + pipePrefix;
            int prefixLength = pipePrefix > 9 ? 9 : pipePrefix;
            for (int i = 1; i < prefixLength; ++i) {
                taskIdPrefix = taskIdPrefix + "_" + i;
            }
            if (tid.startsWith(taskIdPrefix)) {
                this.pipeIndex = 1;
            } else if (tid.startsWith("R3_2_")) {
                this.pipeIndex = 2;
            } else if (this.pipeIndex > 2 && (projectConfMode.equals("sql") || projectConfMode.equals("hybrid"))) {
                this.pipeIndex = pipePrefix - infos.length;
                this.pipeIndex = this.pipeIndex < 0 ? 0 : this.pipeIndex;
            }
        }
    }

    protected boolean hasLabel(String label) {
        return this.label2offset.get(label) != null;
    }

    protected Writable[] createOutputRow(Record r, String label) {
        if (this.label2offset.size() == 1 && !this.innerOutput) {
            return ((WritableRecord)r).toWritableArray();
        }
        Writable[] row = new Writable[this.packagedOutputSchema.length];
        Writable[] output = ((WritableRecord)r).toWritableArray();
        System.arraycopy(output, 0, row, this.label2offset.get(label), output.length);
        int index = row.length - 1;
        if (this.innerOutput) {
            row[index] = new Text("INNER_OUTPUT");
            --index;
        }
        if (this.label2offset.size() > 1) {
            row[index] = new Text(label);
        }
        return row;
    }

    protected Writable[] createInnerOutputRow(Writable[] w, boolean isInnerOutput, String innerOutputLabel, String multiOutputLabel) {
        if (this.label2offset.size() == 1 && !this.innerOutput) {
            return w;
        }
        Writable[] row = new Writable[this.packagedOutputSchema.length];
        Writable[] output = w;
        if (isInnerOutput) {
            System.arraycopy(output, 0, row, this.innerOutputIndex + this.label2offset.get(multiOutputLabel), output.length);
        } else {
            System.arraycopy(output, 0, row, 0, output.length);
        }
        int index = row.length - 1;
        if (this.innerOutput) {
            row[index] = new Text(innerOutputLabel);
            --index;
        }
        if (this.label2offset.size() > 1) {
            row[index] = new Text(multiOutputLabel);
        }
        return row;
    }

    protected long getNextCntr(long cntr, boolean isMem) {
        long statBase;
        long l = statBase = isMem ? 10000L : 1000000L;
        if (cntr >= statBase) {
            return cntr + statBase;
        }
        return 10L * cntr;
    }

    public VolumeInfo getInputVolumeInfo() throws IOException {
        return this.ctx.getInputVolumeInfo();
    }

    public VolumeInfo getInputVolumeInfo(String label) throws IOException {
        return this.ctx.getInputVolumeInfo(label);
    }

    public VolumeInfo getOutputVolumeInfo() throws IOException {
        return this.ctx.getOutputVolumeInfo();
    }

    public VolumeInfo getOutputVolumeInfo(String label) throws IOException {
        return this.ctx.getOutputVolumeInfo(label);
    }

    public FileSystem getInputVolumeFileSystem() throws IOException {
        return this.ctx.getInputVolumeFileSystem();
    }

    public FileSystem getInputVolumeFileSystem(String label) throws IOException {
        return this.ctx.getInputVolumeFileSystem(label);
    }

    public FileSystem getOutputVolumeFileSystem() throws IOException {
        return this.ctx.getOutputVolumeFileSystem();
    }

    public FileSystem getOutputVolumeFileSystem(String label) throws IOException {
        return this.ctx.getOutputVolumeFileSystem(label);
    }

    public FileSystem getTempFileSystem() throws IOException {
        if (this.conf.getBoolean("odps.mapred.enable.user.tempfile", false)) {
            return this.ctx.getTempFileSystem();
        }
        throw new UnsupportedOperationException("user tempfile disabled");
    }
}

