/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.odps.mapred.bridge;

import apsara.odps.ExpressionProtos;
import apsara.odps.LanguageProtos;
import apsara.odps.OrderProtos;
import apsara.odps.PartitionSpecProtos;
import apsara.odps.TypesProtos;
import apsara.odps.lot.DataSinkProtos;
import apsara.odps.lot.DataSourceProtos;
import apsara.odps.lot.DistributeByProtos;
import apsara.odps.lot.ExpressionProtos;
import apsara.odps.lot.FakeSinkProtos;
import apsara.odps.lot.FilterProtos;
import apsara.odps.lot.LanguageSourceProtos;
import apsara.odps.lot.LanguageTransformProtos;
import apsara.odps.lot.Lot;
import apsara.odps.lot.Lottask;
import apsara.odps.lot.SchemaProtos;
import apsara.odps.lot.SelectProtos;
import apsara.odps.lot.SortByProtos;
import apsara.odps.lot.StreamingTransformProtos;
import apsara.odps.lot.TableScanProtos;
import apsara.odps.lot.TableSinkProtos;
import apsara.odps.lot.TransformProtos;
import apsara.odps.lot.UnionAllProtos;
import apsara.odps.lot.VolumeProtos;
import com.aliyun.odps.Column;
import com.aliyun.odps.OdpsType;
import com.aliyun.odps.conf.Configuration;
import com.aliyun.odps.data.TableInfo;
import com.aliyun.odps.data.VolumeInfo;
import com.aliyun.odps.mapred.bridge.EmptyDataSource;
import com.aliyun.odps.mapred.bridge.LotMapperUDTF;
import com.aliyun.odps.mapred.bridge.LotReducerUDTF;
import com.aliyun.odps.mapred.bridge.utils.TypeUtils;
import com.aliyun.odps.mapred.conf.BridgeJobConf;
import com.aliyun.odps.mapred.conf.JobConf;
import com.aliyun.odps.mapred.utils.InputUtils;
import com.aliyun.odps.mapred.utils.OutputUtils;
import com.aliyun.odps.pipeline.Pipeline;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class LOTGenerator {
    private static final Log LOG = LogFactory.getLog(LOTGenerator.class);
    private static final String NO_OUTPUT_DUMMY_COLUMN = "__no_output__";
    private static final String MULTI_INSERT_SELECTOR = "__multiins_selector__";
    private static final String PARTITION_ID = "__partition_id__";
    private static final String MAP_OUT_KEY_PREFIX = "k_";
    private static final String MAP_OUT_VAL_PREFIX = "v_";
    private static final String INNER_OUTPUT_SELECTOR = "__inner_output_selector__";
    private final String project;
    private final BridgeJobConf job;
    private Pipeline pipeline;
    private boolean pipeMode;
    private List<ResourceItem> resourceItems;
    private int opId = 0;
    private boolean isStreamingMap;
    private boolean isStreamingReduce;
    private boolean hasReducer;
    private boolean hasPartitioner;
    private boolean isMultiInsert;
    private boolean isNoOutput;
    private boolean isInnerOutput;
    private boolean isTableOverwrite;
    private TableInfo[] inputTableInfos;
    private VolumeInfo[] inputVolumeInfos;
    private TableInfo[] outputTableInfos;
    private VolumeInfo[] outputVolumeInfos;
    private List<Column> outputColumns = new ArrayList<Column>();
    private Map<String, Integer> outputIndexes = new HashMap<String, Integer>();

    public LOTGenerator(String project, JobConf job, Pipeline pipeline) {
        this.project = project;
        this.job = new BridgeJobConf((Configuration)job);
        this.pipeline = pipeline;
        if (this.pipeline != null) {
            this.pipeMode = true;
        }
        boolean bl = this.pipeMode ? pipeline.getNodeNum() > 1 : (this.hasReducer = job.getNumReduceTasks() > 0);
        this.hasPartitioner = this.pipeMode ? pipeline.getFirstNode().getPartitionerClass() != null : job.getPartitionerClass() != null;
        this.isStreamingMap = job.get("stream.map.streamprocessor", null) != null;
        this.isStreamingReduce = job.get("stream.reduce.streamprocessor", null) != null;
        this.isInnerOutput = job.getInnerOutputEnable();
        this.isTableOverwrite = this.isInnerOutput ? false : job.getOutputOverwrite();
    }

    public byte[] generate() {
        Lottask.LotTask.Builder builder = Lottask.LotTask.newBuilder();
        builder.setLot(this.genTree());
        Lottask.LotTask lotTask = builder.build();
        LOG.debug((Object)lotTask.toString());
        return lotTask.toByteArray();
    }

    Lot.LogicalOperatorTree genTree() {
        List<Column> mapOutColumns;
        this.resourceItems = this.buildResourceList();
        Lot.LogicalOperatorTree.Builder builder = Lot.LogicalOperatorTree.newBuilder();
        this.inputTableInfos = InputUtils.getTables((JobConf)this.job);
        this.inputVolumeInfos = InputUtils.getVolumes((JobConf)this.job);
        Map<TableInfoKey, List<LinkedHashMap<String, String>>> inputTables = this.mergeInputTableInfos(this.inputTableInfos);
        this.outputTableInfos = OutputUtils.getTables((JobConf)this.job);
        this.outputVolumeInfos = OutputUtils.getVolumes((JobConf)this.job);
        this.isNoOutput = this.outputTableInfos == null;
        this.isMultiInsert = !this.isNoOutput && this.outputTableInfos.length > 1;
        boolean isStreamingOutput = this.job.getNumReduceTasks() > 0 ? this.isStreamingReduce : this.isStreamingMap;
        ArrayList<OdpsType> outputColumnTypes = new ArrayList<OdpsType>();
        if (this.isMultiInsert) {
            for (TableInfo tableInfo : this.outputTableInfos) {
                int n;
                Column[] tbColumnTypes = new ArrayList();
                Column[] columnArray = this.job.getOutputSchema(tableInfo.getLabel());
                int n2 = columnArray.length;
                for (n = 0; n < n2; ++n) {
                    Column col = columnArray[n];
                    tbColumnTypes.add(col.getType());
                }
                int idx = Collections.indexOfSubList(outputColumnTypes, tbColumnTypes);
                if (idx >= 0) {
                    this.outputIndexes.put(tableInfo.getLabel(), idx);
                    continue;
                }
                idx = this.outputColumns.size();
                this.outputIndexes.put(tableInfo.getLabel(), idx);
                Column[] columnArray2 = this.job.getOutputSchema(tableInfo.getLabel());
                n = columnArray2.length;
                for (int col = 0; col < n; ++col) {
                    Column col2 = columnArray2[col];
                    String colName = "multiins" + idx + "_" + col2.getName();
                    if (isStreamingOutput) {
                        this.outputColumns.add(new Column(colName, OdpsType.STRING));
                        outputColumnTypes.add(OdpsType.STRING);
                        continue;
                    }
                    this.outputColumns.add(TypeUtils.createColumnWithNewName(colName, col2));
                    outputColumnTypes.add(col2.getType());
                }
            }
            this.outputColumns.add(new Column(MULTI_INSERT_SELECTOR, OdpsType.STRING));
        } else if (this.isNoOutput) {
            this.outputColumns.add(new Column(NO_OUTPUT_DUMMY_COLUMN, OdpsType.STRING));
        } else {
            for (TableInfo tableInfo : this.job.getOutputSchema(this.outputTableInfos[0].getLabel())) {
                if (isStreamingOutput) {
                    this.outputColumns.add(new Column(tableInfo.getName(), OdpsType.STRING));
                    continue;
                }
                this.outputColumns.add(TypeUtils.cloneColumn((Column)tableInfo));
            }
        }
        ArrayList<Column> firstReduceInColumns = null;
        int innerOutputIndex = 0;
        if (this.hasReducer) {
            Column[] values;
            Column[] columnArray;
            mapOutColumns = new ArrayList<Column>();
            firstReduceInColumns = new ArrayList<Column>();
            if (this.hasPartitioner) {
                mapOutColumns.add(new Column(PARTITION_ID, OdpsType.BIGINT));
            }
            for (Column col : columnArray = this.pipeMode ? this.pipeline.getFirstNode().getOutputKeySchema() : this.job.getMapOutputKeySchema()) {
                Column keyCol = TypeUtils.createColumnWithNewName(MAP_OUT_KEY_PREFIX + col.getName(), col);
                mapOutColumns.add(keyCol);
                firstReduceInColumns.add(keyCol);
            }
            for (Column col : values = this.pipeMode ? this.pipeline.getFirstNode().getOutputValueSchema() : this.job.getMapOutputValueSchema()) {
                Column valCol = TypeUtils.createColumnWithNewName(MAP_OUT_VAL_PREFIX + col.getName(), col);
                mapOutColumns.add(valCol);
                firstReduceInColumns.add(valCol);
            }
        } else {
            mapOutColumns = this.outputColumns;
        }
        String string = this.genMapBlock(builder, inputTables, mapOutColumns, innerOutputIndex, this.hasReducer && this.isInnerOutput && inputTables.size() <= 1);
        if (this.hasReducer) {
            this.genReduceBlock(builder, firstReduceInColumns, string);
        } else {
            this.handleOutput(builder, false, this.outputColumns, string, this.isTableOverwrite, innerOutputIndex);
        }
        return builder.build();
    }

    private int appendInnerOutputColumns(List<Column> mapOutColumns) {
        int innerOutputIndex = mapOutColumns.size();
        for (Column col : this.outputColumns) {
            if (col.getName().equals(MULTI_INSERT_SELECTOR)) {
                mapOutColumns.add(col);
                continue;
            }
            Column valCol = TypeUtils.createColumnWithNewName("inneroutputs" + innerOutputIndex + "_" + col.getName(), col);
            mapOutColumns.add(valCol);
        }
        mapOutColumns.add(new Column(INNER_OUTPUT_SELECTOR, OdpsType.STRING));
        return innerOutputIndex;
    }

    private String genMapBlock(Lot.LogicalOperatorTree.Builder builder, Map<TableInfoKey, List<LinkedHashMap<String, String>>> inputTables, List<Column> mapOutColumns, int innerOutputIndex, boolean innerOutput) {
        String mapperId;
        if (innerOutput) {
            innerOutputIndex = this.appendInnerOutputColumns(mapOutColumns);
        }
        ArrayList<String> mappers = new ArrayList<String>();
        List<Column> mapCols = mapOutColumns;
        if (inputTables.size() == 0) {
            String mapperId2;
            int numMapTasks = this.job.getNumMapTasks();
            if (this.isStreamingMap) {
                DataSourceProtos.DataSource emptySource = this.genEmptyStreamingSource(builder, numMapTasks);
                mapperId2 = this.genMapper(builder, emptySource.getId(), new Column[0], mapOutColumns, emptySource.getId());
                mappers.add(mapperId2);
            } else {
                DataSourceProtos.DataSource mapper = this.genJavaSource(builder, numMapTasks, mapOutColumns);
                mapperId2 = mapper.getId();
                if (this.hasReducer && innerOutput) {
                    mapCols = mapOutColumns.subList(0, innerOutputIndex);
                    mapperId2 = this.genInnerOutputBlock(builder, mapOutColumns, innerOutputIndex, mapperId2, mapperId2);
                }
                mappers.add(mapperId2);
            }
        } else {
            for (Map.Entry<TableInfoKey, List<LinkedHashMap<String, String>>> e : inputTables.entrySet()) {
                TableInfo inputTable = e.getKey().getTableInfo();
                List<LinkedHashMap<String, String>> partList = e.getValue();
                DataSourceProtos.DataSource tableSource = this.genTableSource(builder, inputTable);
                String mapParentId = tableSource.getId();
                if (!partList.isEmpty()) {
                    FilterProtos.Filter partFilter = this.genPartitionFilter(builder, tableSource.getId(), partList, tableSource.getId());
                    mapParentId = partFilter.getId();
                }
                String mapperId3 = this.genMapper(builder, tableSource.getId(), this.job.getInputSchema(inputTable), mapOutColumns, mapParentId);
                if (this.hasReducer && innerOutput) {
                    mapCols = mapOutColumns.subList(0, innerOutputIndex);
                    mapperId3 = this.genInnerOutputBlock(builder, mapOutColumns, innerOutputIndex, mapperId3, mapperId3);
                }
                mappers.add(mapperId3);
            }
        }
        if (mappers.size() > 1) {
            UnionAllProtos.UnionAll.Builder unionAllBuilder = UnionAllProtos.UnionAll.newBuilder();
            for (String mid : mappers) {
                SelectProtos.Select mapOutSelect = this.genSelect(builder, mid, mapCols, mid);
                unionAllBuilder.addParents(mapOutSelect.getId());
            }
            unionAllBuilder.setId("UNION_" + this.opId++);
            UnionAllProtos.UnionAll mapper = unionAllBuilder.build();
            Lot.LogicalOperator.Builder b = Lot.LogicalOperator.newBuilder();
            b.setUnionAll(mapper);
            builder.addOperators(b.build());
            mapperId = mapper.getId();
        } else {
            mapperId = (String)mappers.get(0);
        }
        return mapperId;
    }

    private String genReduceBlock(Lot.LogicalOperatorTree.Builder tree, List<Column> firstReduceInColumns, String finalId) {
        ArrayList<List<Object>> reduceInColumnsList = new ArrayList<List<Object>>();
        ArrayList<List<Column>> reduceOutColumnsList = new ArrayList<List<Column>>();
        reduceInColumnsList.add(firstReduceInColumns);
        int innerOutputIndex = 0;
        if (this.pipeMode) {
            for (int i = 1; i < this.pipeline.getNodeNum() - 1; ++i) {
                ArrayList<Column> reduceOut = new ArrayList<Column>();
                ArrayList<Column> reduceIn = new ArrayList<Column>();
                if (this.pipeline.getNode(i).getPartitionerClass() != null) {
                    reduceOut.add(new Column(PARTITION_ID, OdpsType.BIGINT));
                }
                for (Column col : this.pipeline.getNode(i).getOutputKeySchema()) {
                    Column keyCol = TypeUtils.createColumnWithNewName(MAP_OUT_KEY_PREFIX + col.getName(), col);
                    reduceOut.add(keyCol);
                    reduceIn.add(keyCol);
                }
                for (Column col : this.pipeline.getNode(i).getOutputValueSchema()) {
                    Column valCol = TypeUtils.createColumnWithNewName(MAP_OUT_VAL_PREFIX + col.getName(), col);
                    reduceOut.add(valCol);
                    reduceIn.add(valCol);
                }
                if (this.isInnerOutput) {
                    innerOutputIndex = this.appendInnerOutputColumns(reduceOut);
                }
                reduceOutColumnsList.add(reduceOut);
                reduceInColumnsList.add(reduceIn);
            }
        }
        reduceOutColumnsList.add(this.outputColumns);
        Pipeline.TransformNode node = null;
        for (int i = 0; i < reduceInColumnsList.size(); ++i) {
            String[] stringArray;
            boolean hasPartitioner;
            List reduceInCols = (List)reduceInColumnsList.get(i);
            List reduceOutCols = (List)reduceOutColumnsList.get(i);
            String sourceId = finalId;
            String parentId = finalId;
            if (this.pipeMode) {
                node = this.pipeline.getNode(i + 1 - 1);
            }
            boolean bl = this.pipeMode ? node.getPartitionerClass() != null : (hasPartitioner = this.job.getPartitionerClass() != null);
            if (hasPartitioner) {
                String[] stringArray2 = new String[1];
                stringArray = stringArray2;
                stringArray2[0] = PARTITION_ID;
            } else {
                stringArray = this.transformKeyColumnNames(this.pipeMode ? node.getPartitionColumns() : this.job.getPartitionColumns());
            }
            String[] partitionColumns = stringArray;
            DistributeByProtos.DistributeBy shuffle = this.genShuffle(tree, sourceId, Arrays.asList(partitionColumns), parentId);
            String[] sortColumns = this.transformKeyColumnNames(this.pipeMode ? node.getOutputKeySortColumns() : this.job.getOutputKeySortColumns());
            JobConf.SortOrder[] order = this.pipeMode ? node.getOutputKeySortOrder() : this.job.getOutputKeySortOrder();
            SortByProtos.SortBy sort = this.genSort(tree, sourceId, sortColumns, order, shuffle.getId());
            parentId = sort.getId();
            TransformProtos.Transform reducer = this.genReducer(tree, sourceId, reduceInCols, reduceOutCols, parentId);
            sourceId = parentId = reducer.getId();
            if (i == reduceInColumnsList.size() - 1) {
                this.handleOutput(tree, false, this.outputColumns, sourceId, this.isTableOverwrite, 0);
                continue;
            }
            finalId = this.isInnerOutput ? this.genInnerOutputBlock(tree, reduceOutCols, innerOutputIndex, sourceId, parentId) : reducer.getId();
        }
        return finalId;
    }

    private String genInnerOutputBlock(Lot.LogicalOperatorTree.Builder builder, List<Column> reduceOutCols, int innerOutputIndex, String sourceId, String parentId) {
        this.handleOutput(builder, true, reduceOutCols, sourceId, false, innerOutputIndex);
        FilterProtos.Filter innertOutputSelector = this.genInnerOutputSelector(builder, sourceId, parentId, "__default__");
        parentId = innertOutputSelector.getId();
        SelectProtos.Select reduceOutSelect = this.genSelect(builder, sourceId, reduceOutCols.subList(0, innerOutputIndex), parentId);
        String finalId = reduceOutSelect.getId();
        return finalId;
    }

    private String handleOutput(Lot.LogicalOperatorTree.Builder tree, boolean innerOutput, List<Column> outputColumns, String finalTaskId, boolean overwrite, int innerOutputIndex) {
        String parentId = null;
        if (this.isMultiInsert) {
            for (TableInfo ti : this.outputTableInfos) {
                FilterProtos.Filter multiInsertSelector = this.genMultiInsertSelector(tree, finalTaskId, ti.getLabel(), finalTaskId);
                parentId = multiInsertSelector.getId();
                if (innerOutput) {
                    FilterProtos.Filter innertOutputSelector = this.genInnerOutputSelector(tree, finalTaskId, parentId, "INNER_OUTPUT");
                    parentId = innertOutputSelector.getId();
                }
                int idx = innerOutputIndex + this.outputIndexes.get(ti.getLabel());
                List<Column> columns = outputColumns.subList(idx, idx + this.job.getOutputSchema(ti.getLabel()).length);
                SelectProtos.Select outputSelect = this.genSelect(tree, finalTaskId, columns, parentId);
                parentId = outputSelect.getId();
                this.genTableSink(tree, ti, parentId, overwrite);
            }
        } else if (this.isNoOutput) {
            this.genFakeSink(tree, finalTaskId);
        } else {
            List<Column> columns = outputColumns;
            parentId = finalTaskId;
            if (innerOutput) {
                FilterProtos.Filter innertOutputSelector = this.genInnerOutputSelector(tree, finalTaskId, finalTaskId, "INNER_OUTPUT");
                parentId = innertOutputSelector.getId();
                columns = outputColumns.subList(innerOutputIndex, outputColumns.size() - 1);
            }
            SelectProtos.Select outputSelect = this.genSelect(tree, finalTaskId, columns, parentId);
            parentId = outputSelect.getId();
            this.genTableSink(tree, this.outputTableInfos[0], parentId, overwrite);
        }
        return parentId;
    }

    private DataSourceProtos.DataSource genTableSource(Lot.LogicalOperatorTree.Builder tree, TableInfo tableInfo) {
        Lot.LogicalOperator.Builder builder = Lot.LogicalOperator.newBuilder();
        DataSourceProtos.DataSource.Builder db = DataSourceProtos.DataSource.newBuilder();
        TableScanProtos.TableScan.Builder tb = TableScanProtos.TableScan.newBuilder();
        tb.setTable(tableInfo.getTableName());
        tb.setProject(tableInfo.getProjectName() == null ? this.project : tableInfo.getProjectName());
        db.setTableScan(tb.build());
        db.setId("DataSource_" + this.opId++);
        DataSourceProtos.DataSource dataSource = db.build();
        builder.setDataSource(dataSource);
        tree.addOperators(builder.build());
        return dataSource;
    }

    private FilterProtos.Filter genPartitionFilter(Lot.LogicalOperatorTree.Builder tree, String sourceId, List<LinkedHashMap<String, String>> partList, String parentId) {
        Lot.LogicalOperator.Builder builder = Lot.LogicalOperator.newBuilder();
        FilterProtos.Filter.Builder fb = FilterProtos.Filter.newBuilder();
        ArrayList<ExpressionProtos.ScalarExpression> parts = new ArrayList<ExpressionProtos.ScalarExpression>();
        for (LinkedHashMap<String, String> partSpec : partList) {
            ExpressionProtos.ScalarExpression lastCol = null;
            for (Map.Entry<String, String> e : partSpec.entrySet()) {
                ExpressionProtos.ScalarExpression.Builder colBuilder = ExpressionProtos.ScalarExpression.newBuilder();
                ExpressionProtos.ScalarFunction.Builder eqBuilder = ExpressionProtos.ScalarFunction.newBuilder();
                eqBuilder.setProject(this.project);
                eqBuilder.setName("EQ");
                ExpressionProtos.ScalarExpression.Builder keyBuilder = ExpressionProtos.ScalarExpression.newBuilder();
                ExpressionProtos.Reference.Builder keyReference = ExpressionProtos.Reference.newBuilder();
                keyReference.setName(e.getKey());
                keyReference.setFrom(sourceId);
                keyBuilder.setReference(keyReference.build());
                eqBuilder.addParameters(keyBuilder.build());
                ExpressionProtos.ScalarExpression.Builder valueBuilder = ExpressionProtos.ScalarExpression.newBuilder();
                ExpressionProtos.Constant.Builder valueConstant = ExpressionProtos.Constant.newBuilder();
                valueConstant.setString(e.getValue());
                valueBuilder.setConstant(valueConstant.build());
                eqBuilder.addParameters(valueBuilder.build());
                colBuilder.setExpression(eqBuilder.build());
                if (lastCol == null) {
                    lastCol = colBuilder.build();
                    continue;
                }
                ExpressionProtos.ScalarExpression.Builder newColBuilder = ExpressionProtos.ScalarExpression.newBuilder();
                ExpressionProtos.ScalarFunction.Builder andBuilder = ExpressionProtos.ScalarFunction.newBuilder();
                andBuilder.setProject(this.project);
                andBuilder.setName("AND");
                andBuilder.addParameters(lastCol);
                andBuilder.addParameters(colBuilder.build());
                newColBuilder.setExpression(andBuilder.build());
                lastCol = newColBuilder.build();
            }
            parts.add(lastCol);
        }
        ArrayList<ExpressionProtos.ScalarExpression> children = parts;
        while (children.size() > 1) {
            ArrayList<ExpressionProtos.ScalarExpression> parents = new ArrayList<ExpressionProtos.ScalarExpression>(children.size() / 2 + 1);
            for (int i = 0; i < children.size(); i += 2) {
                ExpressionProtos.ScalarExpression eLeft = (ExpressionProtos.ScalarExpression)children.get(i);
                if (i + 1 >= children.size()) {
                    parents.add(eLeft);
                    continue;
                }
                ExpressionProtos.ScalarExpression eRight = (ExpressionProtos.ScalarExpression)children.get(i + 1);
                ExpressionProtos.ScalarExpression.Builder parentBuilder = ExpressionProtos.ScalarExpression.newBuilder();
                ExpressionProtos.ScalarFunction.Builder orBuilder = ExpressionProtos.ScalarFunction.newBuilder();
                orBuilder.setProject(this.project);
                orBuilder.setName("OR");
                orBuilder.addParameters(eLeft);
                orBuilder.addParameters(eRight);
                parentBuilder.setExpression(orBuilder.build());
                parents.add(parentBuilder.build());
            }
            children = parents;
        }
        ExpressionProtos.ScalarExpression partCond = (ExpressionProtos.ScalarExpression)children.get(0);
        fb.setCondition(partCond);
        fb.setParentId(parentId);
        fb.setId("FIL_" + this.opId++);
        FilterProtos.Filter filter = fb.build();
        builder.setFilter(filter);
        tree.addOperators(builder.build());
        return filter;
    }

    private String genMapper(Lot.LogicalOperatorTree.Builder tree, String sourceId, Column[] inColumns, List<Column> outColumns, String parentId) {
        Lot.LogicalOperator.Builder builder = Lot.LogicalOperator.newBuilder();
        boolean isStreaming = this.isStreamingMap;
        TransformProtos.Transform.Builder ab = TransformProtos.Transform.newBuilder();
        for (ResourceItem item : this.resourceItems) {
            TransformProtos.Transform.Resources.Builder rb = TransformProtos.Transform.Resources.newBuilder();
            rb.setProject(item.projectName);
            rb.setResourceName(item.resourceName);
            ab.addResources(rb.build());
        }
        if (!isStreaming) {
            LanguageTransformProtos.LanguageTransform.Builder tb = LanguageTransformProtos.LanguageTransform.newBuilder();
            tb.setClassName(LotMapperUDTF.class.getName());
            tb.setLanguage(LanguageProtos.Language.Java);
            ab.setLanguageTransform(tb.build());
        } else {
            Column[] sb = StreamingTransformProtos.StreamingTransform.newBuilder();
            sb.setCmd(this.job.get("stream.map.streamprocessor", null));
            this.fillStreamingMapProperties((StreamingTransformProtos.StreamingTransform.Builder)sb);
            ab.setStreamingTransform(sb.build());
        }
        for (Column col : inColumns) {
            ExpressionProtos.ScalarExpression.Builder builder2 = ExpressionProtos.ScalarExpression.newBuilder();
            ExpressionProtos.Reference.Builder builder3 = ExpressionProtos.Reference.newBuilder();
            builder3.setName(col.getName());
            builder3.setFrom(sourceId);
            if (isStreaming) {
                if (col.getType().equals((Object)OdpsType.BOOLEAN)) {
                    builder2.setExpression(this.castBooleanAsStreamingString(builder3.build()));
                } else if (!col.getType().equals((Object)OdpsType.STRING)) {
                    ExpressionProtos.ScalarFunction.Builder castBuilder = ExpressionProtos.ScalarFunction.newBuilder();
                    castBuilder.setProject(this.project);
                    castBuilder.setName("TOSTRING");
                    castBuilder.addParameters(ExpressionProtos.ScalarExpression.newBuilder().setReference(builder3.build()).build());
                    builder2.setExpression(castBuilder.build());
                } else {
                    builder2.setReference(builder3.build());
                }
            } else {
                builder2.setReference(builder3.build());
            }
            ab.addParameters(builder2.build());
        }
        SchemaProtos.Schema.Builder schemaBuilder = SchemaProtos.Schema.newBuilder();
        for (Column col : outColumns) {
            SchemaProtos.Schema.Columns.Builder scb = SchemaProtos.Schema.Columns.newBuilder();
            scb.setName(col.getName());
            scb.setType(isStreaming && !col.getName().equals(PARTITION_ID) ? TypesProtos.Type.String : TypeUtils.getLotTypeFromColumn(col));
            schemaBuilder.addColumns(scb.build());
        }
        ab.setSchema(schemaBuilder.build());
        ab.setParentId(parentId);
        ab.setId("MapTransform_" + this.opId++);
        if (this.inputVolumeInfos != null && this.inputVolumeInfos.length > 0) {
            for (VolumeInfo volumeInfo : this.inputVolumeInfos) {
                VolumeProtos.Volume.Builder builder4 = VolumeProtos.Volume.newBuilder();
                builder4.setProject(volumeInfo.getProjectName());
                builder4.setVolumeName(volumeInfo.getVolumeName());
                builder4.setPartition(volumeInfo.getPartSpec());
                builder4.setLabel(volumeInfo.getLabel());
                builder4.setIsInput(true);
                ab.addVolumes(builder4.build());
            }
        }
        if (this.outputVolumeInfos != null && this.outputVolumeInfos.length > 0) {
            for (VolumeInfo volumeInfo : this.outputVolumeInfos) {
                VolumeProtos.Volume.Builder builder5 = VolumeProtos.Volume.newBuilder();
                builder5.setProject(volumeInfo.getProjectName());
                builder5.setVolumeName(volumeInfo.getVolumeName());
                builder5.setPartition(volumeInfo.getPartSpec());
                builder5.setLabel(volumeInfo.getLabel());
                builder5.setIsInput(false);
                ab.addVolumes(builder5.build());
            }
        }
        TransformProtos.Transform mapper = ab.build();
        builder.setTransform(mapper);
        tree.addOperators(builder.build());
        String mapperId = mapper.getId();
        if (this.job.getNumReduceTasks() > 0 && isStreaming) {
            boolean hasNonStringOutput = false;
            for (Column column : outColumns) {
                if (column.getName().equals(PARTITION_ID) || column.getType().equals((Object)OdpsType.STRING)) continue;
                hasNonStringOutput = true;
            }
            if (hasNonStringOutput) {
                SelectProtos.Select.Builder builder6 = SelectProtos.Select.newBuilder();
                for (Column col : outColumns) {
                    SelectProtos.Select.Expressions.Builder seb = SelectProtos.Select.Expressions.newBuilder();
                    ExpressionProtos.ScalarExpression.Builder eb = ExpressionProtos.ScalarExpression.newBuilder();
                    ExpressionProtos.Reference.Builder refBuilder = ExpressionProtos.Reference.newBuilder();
                    refBuilder.setName(col.getName());
                    refBuilder.setFrom(mapper.getId());
                    if (col.getName().equals(PARTITION_ID) || col.getType().equals((Object)OdpsType.STRING)) {
                        eb.setReference(refBuilder.build());
                    } else {
                        ExpressionProtos.ScalarFunction.Builder castBuilder = ExpressionProtos.ScalarFunction.newBuilder();
                        castBuilder.setProject(this.project);
                        castBuilder.setName("TO" + col.getType().toString());
                        castBuilder.addParameters(ExpressionProtos.ScalarExpression.newBuilder().setReference(refBuilder.build()).build());
                        eb.setExpression(castBuilder.build());
                    }
                    seb.setExpression(eb.build());
                    seb.setAlias(col.getName());
                    builder6.addExpressions(seb.build());
                }
                builder6.setParentId(mapper.getId());
                builder6.setId("SEL_" + this.opId++);
                SelectProtos.Select select = builder6.build();
                tree.addOperators(Lot.LogicalOperator.newBuilder().setSelect(select).build());
                mapperId = select.getId();
            }
        }
        return mapperId;
    }

    private DataSourceProtos.DataSource genJavaSource(Lot.LogicalOperatorTree.Builder tree, int instanceCount, List<Column> outColumns) {
        VolumeProtos.Volume.Builder volumeBuilder;
        Lot.LogicalOperator.Builder builder = Lot.LogicalOperator.newBuilder();
        DataSourceProtos.DataSource.Builder db = DataSourceProtos.DataSource.newBuilder();
        LanguageSourceProtos.LanguageSource.Builder jb = LanguageSourceProtos.LanguageSource.newBuilder();
        jb.setClassName(LotMapperUDTF.class.getName());
        jb.setLanguage(LanguageProtos.Language.Java);
        for (ResourceItem resourceItem : this.resourceItems) {
            LanguageSourceProtos.LanguageSource.Resources.Builder rb = LanguageSourceProtos.LanguageSource.Resources.newBuilder();
            rb.setProject(resourceItem.projectName);
            rb.setResourceName(resourceItem.resourceName);
            jb.addResources(rb.build());
        }
        jb.setInstanceCount(instanceCount);
        SchemaProtos.Schema.Builder schemaBuilder = SchemaProtos.Schema.newBuilder();
        for (Column col : outColumns) {
            SchemaProtos.Schema.Columns.Builder scb = SchemaProtos.Schema.Columns.newBuilder();
            scb.setName(col.getName());
            scb.setType(TypeUtils.getLotTypeFromColumn(col));
            schemaBuilder.addColumns(scb.build());
        }
        jb.setSchema(schemaBuilder.build());
        if (this.inputVolumeInfos != null && this.inputVolumeInfos.length > 0) {
            for (VolumeInfo vol : this.inputVolumeInfos) {
                volumeBuilder = VolumeProtos.Volume.newBuilder();
                volumeBuilder.setProject(vol.getProjectName());
                volumeBuilder.setVolumeName(vol.getVolumeName());
                volumeBuilder.setPartition(vol.getPartSpec());
                volumeBuilder.setLabel(vol.getLabel());
                volumeBuilder.setIsInput(true);
                jb.addVolumes(volumeBuilder.build());
            }
        }
        if (this.outputVolumeInfos != null && this.outputVolumeInfos.length > 0) {
            for (VolumeInfo vol : this.outputVolumeInfos) {
                volumeBuilder = VolumeProtos.Volume.newBuilder();
                volumeBuilder.setProject(vol.getProjectName());
                volumeBuilder.setVolumeName(vol.getVolumeName());
                volumeBuilder.setPartition(vol.getPartSpec());
                volumeBuilder.setLabel(vol.getLabel());
                volumeBuilder.setIsInput(false);
                jb.addVolumes(volumeBuilder.build());
            }
        }
        db.setLanguageSource(jb.build());
        db.setId("MapJavaSource_" + this.opId++);
        DataSourceProtos.DataSource dataSource = db.build();
        builder.setDataSource(dataSource);
        tree.addOperators(builder.build());
        return dataSource;
    }

    private DataSourceProtos.DataSource genEmptyStreamingSource(Lot.LogicalOperatorTree.Builder tree, int instanceCount) {
        Lot.LogicalOperator.Builder builder = Lot.LogicalOperator.newBuilder();
        DataSourceProtos.DataSource.Builder db = DataSourceProtos.DataSource.newBuilder();
        LanguageSourceProtos.LanguageSource.Builder jb = LanguageSourceProtos.LanguageSource.newBuilder();
        jb.setClassName(EmptyDataSource.class.getName());
        jb.setLanguage(LanguageProtos.Language.Java);
        jb.setInstanceCount(instanceCount);
        jb.setSchema(SchemaProtos.Schema.newBuilder().build());
        db.setLanguageSource(jb.build());
        db.setId("EmptySource_" + this.opId++);
        DataSourceProtos.DataSource emptySource = db.build();
        builder.setDataSource(emptySource);
        tree.addOperators(builder.build());
        return emptySource;
    }

    private TransformProtos.Transform genReducer(Lot.LogicalOperatorTree.Builder tree, String sourceId, List<Column> mapOutColumns, List<Column> outputColumns, String parentId) {
        Lot.LogicalOperator.Builder builder = Lot.LogicalOperator.newBuilder();
        TransformProtos.Transform.Builder ab = TransformProtos.Transform.newBuilder();
        boolean isStreaming = this.isStreamingReduce;
        for (ResourceItem resourceItem : this.resourceItems) {
            TransformProtos.Transform.Resources.Builder rb = TransformProtos.Transform.Resources.newBuilder();
            rb.setProject(resourceItem.projectName);
            rb.setResourceName(resourceItem.resourceName);
            ab.addResources(rb.build());
        }
        if (!isStreaming) {
            LanguageTransformProtos.LanguageTransform.Builder tb = LanguageTransformProtos.LanguageTransform.newBuilder();
            tb.setClassName(LotReducerUDTF.class.getName());
            tb.setLanguage(LanguageProtos.Language.Java);
            ab.setLanguageTransform(tb.build());
        } else {
            StreamingTransformProtos.StreamingTransform.Builder sb = StreamingTransformProtos.StreamingTransform.newBuilder();
            sb.setCmd(this.job.get("stream.reduce.streamprocessor", null));
            this.fillStreamingReduceProperties(sb);
            ab.setStreamingTransform(sb.build());
        }
        for (Column column : mapOutColumns) {
            ExpressionProtos.ScalarExpression.Builder exprBuilder = ExpressionProtos.ScalarExpression.newBuilder();
            ExpressionProtos.Reference.Builder refBuilder = ExpressionProtos.Reference.newBuilder();
            refBuilder.setName(column.getName());
            refBuilder.setFrom(sourceId);
            if (isStreaming && !column.getType().equals((Object)OdpsType.STRING)) {
                ExpressionProtos.ScalarFunction.Builder castBuilder = ExpressionProtos.ScalarFunction.newBuilder();
                castBuilder.setProject(this.project);
                castBuilder.setName("TOSTRING");
                castBuilder.addParameters(ExpressionProtos.ScalarExpression.newBuilder().setReference(refBuilder.build()).build());
                exprBuilder.setExpression(castBuilder.build());
            } else {
                exprBuilder.setReference(refBuilder.build());
            }
            ab.addParameters(exprBuilder.build());
        }
        SchemaProtos.Schema.Builder schemaBuilder = SchemaProtos.Schema.newBuilder();
        for (Column col : outputColumns) {
            SchemaProtos.Schema.Columns.Builder scb = SchemaProtos.Schema.Columns.newBuilder();
            scb.setName(col.getName());
            scb.setType(TypeUtils.getLotTypeFromColumn(col));
            schemaBuilder.addColumns(scb.build());
        }
        ab.setSchema(schemaBuilder.build());
        ab.setParentId(parentId);
        ab.setId("ReduceTransform_" + this.opId++);
        TransformProtos.Transform transform = ab.build();
        builder.setTransform(transform);
        tree.addOperators(builder.build());
        return transform;
    }

    private DistributeByProtos.DistributeBy genShuffle(Lot.LogicalOperatorTree.Builder tree, String sourceId, List<String> columns, String parentId) {
        Lot.LogicalOperator.Builder builder = Lot.LogicalOperator.newBuilder();
        DistributeByProtos.DistributeBy.Builder db = DistributeByProtos.DistributeBy.newBuilder();
        for (String col : columns) {
            ExpressionProtos.Reference.Builder refBuilder = ExpressionProtos.Reference.newBuilder();
            refBuilder.setName(col);
            refBuilder.setFrom(sourceId);
            db.addColumns(refBuilder.build());
        }
        db.setParentId(parentId);
        db.setId("DIS_" + this.opId++);
        DistributeByProtos.DistributeBy shuffle = db.build();
        builder.setDistributeBy(shuffle);
        tree.addOperators(builder.build());
        return shuffle;
    }

    private SortByProtos.SortBy genSort(Lot.LogicalOperatorTree.Builder tree, String sourceId, String[] sortColumns, JobConf.SortOrder[] order, String parentId) {
        Lot.LogicalOperator.Builder builder = Lot.LogicalOperator.newBuilder();
        SortByProtos.SortBy.Builder sb = SortByProtos.SortBy.newBuilder();
        sb.setIsPartial(false);
        assert (sortColumns.length == order.length);
        for (int i = 0; i < sortColumns.length; ++i) {
            OrderProtos.Order.Builder o = OrderProtos.Order.newBuilder();
            ExpressionProtos.Reference.Builder refBuilder = ExpressionProtos.Reference.newBuilder();
            refBuilder.setName(sortColumns[i]);
            refBuilder.setFrom(sourceId);
            o.setColumn(refBuilder.build());
            o.setAsc(order[i] == JobConf.SortOrder.ASC);
            sb.addOrders(o.build());
        }
        sb.setParentId(parentId);
        sb.setId("SORT_" + this.opId++);
        SortByProtos.SortBy sort = sb.build();
        builder.setSortBy(sort);
        tree.addOperators(builder.build());
        return sort;
    }

    private SelectProtos.Select genSelect(Lot.LogicalOperatorTree.Builder tree, String sourceId, List<Column> columns, String parentId) {
        Lot.LogicalOperator.Builder builder = Lot.LogicalOperator.newBuilder();
        SelectProtos.Select.Builder sb = SelectProtos.Select.newBuilder();
        for (Column col : columns) {
            SelectProtos.Select.Expressions.Builder seb = SelectProtos.Select.Expressions.newBuilder();
            ExpressionProtos.ScalarExpression.Builder eb = ExpressionProtos.ScalarExpression.newBuilder();
            ExpressionProtos.Reference.Builder refBuilder = ExpressionProtos.Reference.newBuilder();
            refBuilder.setName(col.getName());
            refBuilder.setFrom(sourceId);
            eb.setReference(refBuilder.build());
            seb.setExpression(eb.build());
            seb.setAlias(col.getName());
            sb.addExpressions(seb.build());
        }
        sb.setParentId(parentId);
        sb.setId("SEL_" + this.opId++);
        SelectProtos.Select select = sb.build();
        builder.setSelect(sb.build());
        tree.addOperators(builder.build());
        return select;
    }

    private DataSinkProtos.DataSink genTableSink(Lot.LogicalOperatorTree.Builder tree, TableInfo tableInfo, String parentId, boolean overwrite) {
        Lot.LogicalOperator.Builder builder = Lot.LogicalOperator.newBuilder();
        DataSinkProtos.DataSink.Builder db = DataSinkProtos.DataSink.newBuilder();
        TableSinkProtos.TableSink.Builder tw = TableSinkProtos.TableSink.newBuilder();
        tw.setProject(tableInfo.getProjectName() == null ? this.project : tableInfo.getProjectName());
        tw.setTable(tableInfo.getTableName());
        tw.setIsOverwrite(overwrite);
        LinkedHashMap partSpec = tableInfo.getPartSpec();
        if (!partSpec.isEmpty()) {
            PartitionSpecProtos.PartitionSpec.Builder pb = PartitionSpecProtos.PartitionSpec.newBuilder();
            for (Map.Entry e : partSpec.entrySet()) {
                PartitionSpecProtos.PartitionSpec.Items.Builder ib = PartitionSpecProtos.PartitionSpec.Items.newBuilder();
                ib.setKey((String)e.getKey());
                ExpressionProtos.Constant.Builder cb = ExpressionProtos.Constant.newBuilder();
                cb.setString((String)e.getValue());
                ib.setValue(cb.build());
                pb.addItems(ib.build());
            }
            tw.setPartition(pb.build());
        }
        db.setTableSink(tw.build());
        db.setParentId(parentId);
        db.setId("DataSink_" + this.opId++);
        DataSinkProtos.DataSink dataSink = db.build();
        builder.setDataSink(dataSink);
        tree.addOperators(builder.build());
        return dataSink;
    }

    private FilterProtos.Filter genMultiInsertSelector(Lot.LogicalOperatorTree.Builder tree, String sourceId, String label, String parentId) {
        Lot.LogicalOperator.Builder builder = Lot.LogicalOperator.newBuilder();
        FilterProtos.Filter.Builder fb = FilterProtos.Filter.newBuilder();
        ExpressionProtos.ScalarExpression.Builder condBuilder = ExpressionProtos.ScalarExpression.newBuilder();
        ExpressionProtos.ScalarFunction.Builder opBuilder = ExpressionProtos.ScalarFunction.newBuilder();
        opBuilder.setProject(this.project);
        opBuilder.setName("EQ");
        ExpressionProtos.ScalarExpression.Builder eb = ExpressionProtos.ScalarExpression.newBuilder();
        ExpressionProtos.Reference.Builder refBuilder = ExpressionProtos.Reference.newBuilder();
        refBuilder.setName(MULTI_INSERT_SELECTOR);
        refBuilder.setFrom(sourceId);
        eb.setReference(refBuilder.build());
        opBuilder.addParameters(eb.build());
        eb = ExpressionProtos.ScalarExpression.newBuilder();
        ExpressionProtos.Constant.Builder cBuilder = ExpressionProtos.Constant.newBuilder();
        cBuilder.setString(label);
        eb.setConstant(cBuilder.build());
        opBuilder.addParameters(eb.build());
        condBuilder.setExpression(opBuilder.build());
        fb.setCondition(condBuilder.build());
        fb.setParentId(parentId);
        fb.setId("FIL_" + this.opId++);
        FilterProtos.Filter selector = fb.build();
        builder.setFilter(selector);
        tree.addOperators(builder.build());
        return selector;
    }

    private FilterProtos.Filter genInnerOutputSelector(Lot.LogicalOperatorTree.Builder tree, String sourceId, String parentId, String label) {
        Lot.LogicalOperator.Builder builder = Lot.LogicalOperator.newBuilder();
        FilterProtos.Filter.Builder fb = FilterProtos.Filter.newBuilder();
        ExpressionProtos.ScalarExpression.Builder condBuilder = ExpressionProtos.ScalarExpression.newBuilder();
        ExpressionProtos.ScalarFunction.Builder opBuilder = ExpressionProtos.ScalarFunction.newBuilder();
        opBuilder.setProject(this.project);
        opBuilder.setName("EQ");
        ExpressionProtos.ScalarExpression.Builder eb = ExpressionProtos.ScalarExpression.newBuilder();
        ExpressionProtos.Reference.Builder refBuilder = ExpressionProtos.Reference.newBuilder();
        refBuilder.setName(INNER_OUTPUT_SELECTOR);
        refBuilder.setFrom(sourceId);
        eb.setReference(refBuilder.build());
        opBuilder.addParameters(eb.build());
        eb = ExpressionProtos.ScalarExpression.newBuilder();
        ExpressionProtos.Constant.Builder cBuilder = ExpressionProtos.Constant.newBuilder();
        cBuilder.setString(label);
        eb.setConstant(cBuilder.build());
        opBuilder.addParameters(eb.build());
        condBuilder.setExpression(opBuilder.build());
        fb.setCondition(condBuilder.build());
        fb.setParentId(parentId);
        fb.setId("FIL_" + this.opId++);
        FilterProtos.Filter selector = fb.build();
        builder.setFilter(selector);
        tree.addOperators(builder.build());
        return selector;
    }

    private DataSinkProtos.DataSink genFakeSink(Lot.LogicalOperatorTree.Builder tree, String parentId) {
        Lot.LogicalOperator.Builder builder = Lot.LogicalOperator.newBuilder();
        DataSinkProtos.DataSink.Builder db = DataSinkProtos.DataSink.newBuilder();
        db.setFakeSink(FakeSinkProtos.FakeSink.newBuilder().build());
        db.setParentId(parentId);
        db.setId("DataSink_" + this.opId++);
        DataSinkProtos.DataSink dataSink = db.build();
        builder.setDataSink(dataSink);
        tree.addOperators(builder.build());
        return dataSink;
    }

    private Map<TableInfoKey, List<LinkedHashMap<String, String>>> mergeInputTableInfos(TableInfo[] inputTableInfos) {
        HashMap<TableInfoKey, List<LinkedHashMap<String, String>>> inputTables = new HashMap<TableInfoKey, List<LinkedHashMap<String, String>>>();
        if (inputTableInfos == null) {
            return inputTables;
        }
        for (TableInfo ti : inputTableInfos) {
            TableInfoKey key;
            ArrayList<LinkedHashMap> partList;
            LinkedHashMap partSpec = null;
            if (ti.getPartSpec() != null && !ti.getPartSpec().isEmpty()) {
                partSpec = ti.getPartSpec();
            }
            if ((partList = (ArrayList<LinkedHashMap>)inputTables.get(key = new TableInfoKey(ti))) == null) {
                partList = new ArrayList<LinkedHashMap>();
                if (partSpec != null) {
                    partList.add(partSpec);
                }
                inputTables.put(key, partList);
                continue;
            }
            if (partList.isEmpty()) {
                if (partSpec != null) {
                    throw new IllegalArgumentException("conflict input for table:" + ti.getTableName());
                }
                throw new IllegalArgumentException("duplicate input for table:" + ti.getTableName());
            }
            if (partSpec == null) {
                throw new IllegalArgumentException("conflict input for table:" + ti.getTableName());
            }
            partList.add(partSpec);
        }
        return inputTables;
    }

    private List<ResourceItem> buildResourceList() {
        ArrayList<ResourceItem> r = new ArrayList<ResourceItem>();
        if (this.job.getResources() == null) {
            return r;
        }
        for (String res : this.job.getResources()) {
            String resName;
            String resProject;
            String linkName = null;
            String[] parts = res.split("/");
            if (parts.length == 1) {
                resProject = this.project;
                resName = parts[0];
            } else if (parts.length == 3 && parts[1].equals("resources")) {
                resProject = parts[0];
                resName = parts[2];
            } else {
                throw new IllegalArgumentException("Invalid resource name: '" + res + "'");
            }
            String[] nameParts = resName.split("#");
            if (nameParts.length != 1) {
                if (nameParts.length == 2) {
                    resName = nameParts[0];
                    linkName = nameParts[1];
                } else {
                    throw new IllegalArgumentException("Invalid resource name: '" + resName + "'");
                }
            }
            r.add(new ResourceItem(resProject, resName, linkName));
        }
        return r;
    }

    private String[] transformKeyColumnNames(String[] cols) {
        String[] keyCols = new String[cols.length];
        for (int i = 0; i < cols.length; ++i) {
            keyCols[i] = MAP_OUT_KEY_PREFIX + cols[i];
        }
        return keyCols;
    }

    private void fillStreamingMapProperties(StreamingTransformProtos.StreamingTransform.Builder sb) {
        Iterator iterator = this.job.iterator();
        while (iterator.hasNext()) {
            Map.Entry e = (Map.Entry)iterator.next();
            this.addStreamingProperty(sb, (String)e.getKey(), (String)e.getValue());
        }
        this.addStreamingProperty(sb, "stream.stage", "map");
    }

    private void fillStreamingReduceProperties(StreamingTransformProtos.StreamingTransform.Builder sb) {
        Iterator iterator = this.job.iterator();
        while (iterator.hasNext()) {
            Map.Entry e = (Map.Entry)iterator.next();
            this.addStreamingProperty(sb, (String)e.getKey(), (String)e.getValue());
        }
        this.addStreamingProperty(sb, "stream.stage", "reduce");
    }

    private void addStreamingProperty(StreamingTransformProtos.StreamingTransform.Builder sb, String name, String value) {
        sb.addProperties(StreamingTransformProtos.StreamingTransform.Properties.newBuilder().setKey(name).setValue(value).build());
    }

    private ExpressionProtos.ScalarFunction castBooleanAsStreamingString(ExpressionProtos.Reference colRef) {
        ExpressionProtos.ScalarFunction.Builder caseBuilder = ExpressionProtos.ScalarFunction.newBuilder();
        caseBuilder.setProject(this.project);
        caseBuilder.setName("WHEN");
        ExpressionProtos.ScalarFunction.Builder eqBuilder = ExpressionProtos.ScalarFunction.newBuilder();
        eqBuilder.setProject(this.project);
        eqBuilder.setName("EQ");
        eqBuilder.addParameters(ExpressionProtos.ScalarExpression.newBuilder().setReference(colRef).build());
        eqBuilder.addParameters(ExpressionProtos.ScalarExpression.newBuilder().setConstant(ExpressionProtos.Constant.newBuilder().setBool(true).build()).build());
        caseBuilder.addParameters(ExpressionProtos.ScalarExpression.newBuilder().setExpression(eqBuilder.build()).build());
        caseBuilder.addParameters(ExpressionProtos.ScalarExpression.newBuilder().setConstant(ExpressionProtos.Constant.newBuilder().setString("true").build()).build());
        ExpressionProtos.ScalarFunction.Builder caseBuilder2 = ExpressionProtos.ScalarFunction.newBuilder();
        caseBuilder2.setProject(this.project);
        caseBuilder2.setName("WHEN");
        ExpressionProtos.ScalarFunction.Builder eqBuilder2 = ExpressionProtos.ScalarFunction.newBuilder();
        eqBuilder2.setProject(this.project);
        eqBuilder2.setName("EQ");
        eqBuilder2.addParameters(ExpressionProtos.ScalarExpression.newBuilder().setReference(colRef).build());
        eqBuilder2.addParameters(ExpressionProtos.ScalarExpression.newBuilder().setConstant(ExpressionProtos.Constant.newBuilder().setBool(false).build()).build());
        caseBuilder2.addParameters(ExpressionProtos.ScalarExpression.newBuilder().setExpression(eqBuilder2.build()).build());
        caseBuilder2.addParameters(ExpressionProtos.ScalarExpression.newBuilder().setConstant(ExpressionProtos.Constant.newBuilder().setString("false").build()).build());
        caseBuilder2.addParameters(ExpressionProtos.ScalarExpression.newBuilder().setNull(ExpressionProtos.Null.newBuilder().build()).build());
        caseBuilder.addParameters(ExpressionProtos.ScalarExpression.newBuilder().setExpression(caseBuilder2.build()).build());
        return caseBuilder.build();
    }

    private static class ResourceItem {
        public String projectName;
        public String resourceName;
        public String linkName;

        public ResourceItem(String projectName, String resourceName, String linkName) {
            this.projectName = projectName;
            this.resourceName = resourceName;
            this.linkName = linkName;
        }
    }

    private static class TableInfoKey {
        private TableInfo tableInfo;

        public TableInfoKey(TableInfo tableInfo) {
            this.tableInfo = tableInfo;
        }

        public TableInfo getTableInfo() {
            return this.tableInfo;
        }

        public boolean equals(Object o) {
            String otherPrj;
            if (o == null || !(o instanceof TableInfoKey)) {
                return false;
            }
            TableInfoKey other = (TableInfoKey)o;
            String prj = this.tableInfo.getProjectName();
            return StringUtils.equals((String)prj, (String)(otherPrj = other.tableInfo.getProjectName())) && StringUtils.equals((String)this.tableInfo.getTableName(), (String)other.tableInfo.getTableName());
        }

        public int hashCode() {
            int code = this.tableInfo.getTableName().hashCode();
            String prj = this.tableInfo.getProjectName();
            if (prj != null) {
                code = code * 71 + prj.hashCode();
            }
            return code;
        }
    }
}

