# main.py

from oss_dataloader import make_oss_dataloader
from pre_trained_model import make_resnet_model
from osstorchconnector import OssMapDataset
from resnet_train import train

# Define basic training parameters.
NUM_EPOCHS = 30 # epoch number
BATCH_SIZE = 64 # batch size
NUM_WORKER = 4 # dataloader worker number

# Use the pretrained ResNet18 model.
model, device = make_resnet_model()

# Use the OssMapDataset dataset to construct a Dataloader.
dataloaders = make_oss_dataloader(OssMapDataset, BATCH_SIZE, NUM_WORKER, True)

# Call the train function.
train(model, dataloaders, device, NUM_EPOCHS)
