package com.aliyun.lindorm.sql.demo;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Arrays;
import java.util.Properties;
import java.util.Random;

/**
 * @author jianhong.hjh
 * @date 2022/12/6 11:00 AM
 */
public class BasicDemo {

  public static void main(String[] args) throws SQLException {
    // Lindorm宽表SQL的连接地址
    String url = "jdbc:lindorm:table:url=http://ld-bp13ky5********-proxy-lindorm-pub.lindorm.rds.aliyuncs.com:30060";
    // Lindorm控制台获取的数据库用户名
    String username = "root";
    // Lindorm控制台获取的数据库密码
    String password = "root";
    // 建立连接时可指定某一database。若不指定database，默认使用default。
    String database = "default";

    Properties properties = new Properties();
    properties.put("user", username);
    properties.put("password", password);
    properties.put("database", database);

    // 获取连接
    Connection connection = DriverManager.getConnection(url, properties);

    /* -------------- 基于JDBC的CRUD示例 ----------------- */

    String tableName = "sql_table_" + new Random().nextInt(1000);
    // 创建表
    try (Statement statement = connection.createStatement()) {
      String sql = "create table if not exists " + tableName + "(id VARCHAR, name VARCHAR, primary key(id))";
      int ret = statement.executeUpdate(sql);
      System.out.println(ret);
    }

    // 插入数据
    String upsertSql = "upsert into " + tableName + "(id,name) values(?,?)";
    try (PreparedStatement ps = connection.prepareStatement(upsertSql)) {
      int batchSize = 100;
      for (int i = 0; i < batchSize; i++) {
        ps.setString(1, "aa" + i);
        ps.setString(2, "bb" + i);
        // 加入批次
        ps.addBatch();
      }
      // 执行全部批次的写入。
      // 出于性能和稳定性考量，添加的批次数量不宜过大。
      // 建议一次executeBatch()写入的批次数最多在百级别。
      int[] ret = ps.executeBatch();
      System.out.println(Arrays.toString(ret));
    }

    // 查询数据
    String querySql = "select * from " + tableName + " where id=?";
    try (PreparedStatement ps = connection.prepareStatement(querySql)) {
      ps.setString(1, "aa1");
      ResultSet rs = ps.executeQuery();
      while (rs.next()) {
        String id = rs.getString(1);
        String name = rs.getString(2);
        System.out.println("id=" + id);
        System.out.println("name=" + name);
      }
    }

    // 删除数据
    // Lindorm SQL DELETE语句仅支持单行删除，不支持批量更新
    // 即where条件必须指定全部主键
    String deleteSql = "delete from " + tableName + " where id=?";
    try (PreparedStatement ps = connection.prepareStatement(deleteSql)) {
      ps.setString(1, "aa1");
      ps.executeUpdate();
    }


    // 更新数据
    // Lindorm SQL Update语句仅支持单行更新，不支持批量更新
    // 即where条件必须指定全部主键
    String updateSql = "update " + tableName + " set name = ? where id=?";
    try (PreparedStatement ps = connection.prepareStatement(updateSql)) {
      ps.setString(1, "bb2update");
      ps.setString(2, "aa2");
      ps.executeUpdate();
    }
    String querySql1 = "select * from " + tableName + " where id=?";
    try (PreparedStatement ps = connection.prepareStatement(querySql1)) {
      ps.setString(1, "aa2");
      ResultSet rs = ps.executeQuery();
      System.out.println("--------- update-----------");
      while (rs.next()) {
        String id = rs.getString(1);
        String name = rs.getString(2);
        System.out.println("id=" + id);
        System.out.println("name=" + name);
      }
    }

    // 删除表
    String dropTable = "drop table " + tableName;
    try (Statement stmt = connection.createStatement()) {
      stmt.execute(dropTable);
    }


    // 关闭连接，当结束操作时要确保连接被关闭，否则会造成连接泄漏
    connection.close();
  }
}
