/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.odps.graph.local;

import com.aliyun.odps.graph.Edge;
import com.aliyun.odps.graph.Vertex;
import com.aliyun.odps.graph.VertexChanges;
import com.aliyun.odps.io.Writable;
import com.aliyun.odps.io.WritableComparable;
import java.util.ArrayList;
import java.util.List;

public class LocalVertexMutations<I extends WritableComparable, V extends Writable, E extends Writable, M extends Writable>
implements VertexChanges<I, V, E, M> {
    private List<Vertex<I, V, E, M>> addedVertexList;
    private int removedVertexCount = 0;
    private List<Edge<I, E>> addedEdgeList;
    private List<I> removedEdgeList;

    public List<Vertex<I, V, E, M>> getAddedVertexList() {
        return this.addedVertexList;
    }

    public void addVertex(Vertex<I, V, E, M> vertex) {
        if (this.addedVertexList == null) {
            this.addedVertexList = new ArrayList<Vertex<I, V, E, M>>(1);
        }
        this.addedVertexList.add(vertex);
    }

    public int getRemovedVertexCount() {
        return this.removedVertexCount;
    }

    public void removeVertex() {
        ++this.removedVertexCount;
    }

    public List<Edge<I, E>> getAddedEdgeList() {
        return this.addedEdgeList;
    }

    public void addEdge(Edge<I, E> edge) {
        if (this.addedEdgeList == null) {
            this.addedEdgeList = new ArrayList<Edge<I, E>>(1);
        }
        this.addedEdgeList.add(edge);
    }

    public List<I> getRemovedEdgeList() {
        return this.removedEdgeList;
    }

    public void removeEdge(I destinationVertexId) {
        if (this.removedEdgeList == null) {
            this.removedEdgeList = new ArrayList<I>(1);
        }
        this.removedEdgeList.add(destinationVertexId);
    }

    public void addVertexMutations(LocalVertexMutations<I, V, E, M> other) {
        List<I> otherRemovedEdgeList;
        List<Vertex<I, V, E, M>> otherAddedVertexList = other.getAddedVertexList();
        if (otherAddedVertexList != null) {
            if (this.addedVertexList == null) {
                this.addedVertexList = new ArrayList<Vertex<I, V, Vertex<I, V, E, M>, M>>(otherAddedVertexList);
            } else {
                this.addedVertexList.addAll(otherAddedVertexList);
            }
        }
        this.removedVertexCount += other.getRemovedVertexCount();
        List<Edge<I, E>> otherAddedEdgeList = other.getAddedEdgeList();
        if (otherAddedEdgeList != null) {
            if (this.addedEdgeList == null) {
                this.addedEdgeList = new ArrayList<Edge<I, Edge<I, E>>>(otherAddedEdgeList);
            } else {
                this.addedEdgeList.addAll(otherAddedEdgeList);
            }
        }
        if ((otherRemovedEdgeList = other.getRemovedEdgeList()) != null) {
            if (this.removedEdgeList == null) {
                this.removedEdgeList = new ArrayList<I>(otherRemovedEdgeList);
            } else {
                this.removedEdgeList.addAll(otherRemovedEdgeList);
            }
        }
    }
}

