/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.odps.mapred.unittest;

import com.aliyun.odps.Column;
import com.aliyun.odps.OdpsType;
import com.aliyun.odps.conf.Configuration;
import com.aliyun.odps.data.Record;
import com.aliyun.odps.data.TableInfo;
import com.aliyun.odps.local.common.TableMeta;
import com.aliyun.odps.mapred.unittest.MRUnitTest;
import com.aliyun.odps.mapred.unittest.RuntimeContext;
import com.aliyun.odps.mapred.utils.SchemaUtils;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;

public abstract class UTContext {
    private int taskId = 0;
    protected RuntimeContext runtimeContext;
    private Map<String, String> outputSchemas = new HashMap<String, String>();
    private Set<String> resources = new HashSet<String>();
    private Map<String, byte[]> fileResources = new HashMap<String, byte[]>();
    private Map<String, File> archiveResources = new HashMap<String, File>();
    private Map<String, List<Record>> tableResources = new HashMap<String, List<Record>>();
    private Map<String, TableMeta> tableMetas = new HashMap<String, TableMeta>();
    private boolean isCleanUtDir = false;

    public int getTaskId() {
        return this.taskId;
    }

    public void setTaskId(int taskId) {
        this.taskId = taskId;
    }

    public void setFileResource(String resourceName, File file) throws IOException {
        this.checkResource(resourceName, file);
        this.setFileResource(resourceName, FileUtils.readFileToByteArray((File)file));
    }

    public void setFileResource(String resourceName, String content) throws IOException {
        this.checkResource(resourceName);
        this.setFileResource(resourceName, content == null ? null : content.getBytes());
    }

    public void setFileResource(String resourceName, byte[] content) throws IOException {
        this.checkResource(resourceName);
        if (content == null) {
            throw new IOException("content is null for resource: " + resourceName);
        }
        this.fileResources.put(resourceName, content);
        this.resources.add(resourceName);
    }

    public void setArchiveResource(String resourceName, File path) throws IOException {
        this.checkResource(resourceName, path);
        this.archiveResources.put(resourceName, path);
        this.resources.add(resourceName);
    }

    public void setTableResource(String resourceName, TableInfo info, String schema, List<Record> records) throws IOException {
        this.checkResource(resourceName);
        if (info == null) {
            throw new IOException("table info is null for resource: " + resourceName);
        }
        if (schema == null) {
            throw new IOException("schema is null for resource: " + resourceName);
        }
        if (records == null) {
            throw new IOException("record list is null for resource: " + resourceName);
        }
        Column[] parts = new Column[info.getPartSpec().size()];
        int i = 0;
        for (Map.Entry part : info.getPartSpec().entrySet()) {
            Column col = new Column((String)part.getKey(), OdpsType.STRING);
            parts[i++] = col;
        }
        TableMeta meta = new TableMeta(info.getProjectName(), info.getTableName(), com.aliyun.odps.local.common.utils.SchemaUtils.fromString((String)schema), parts);
        this.tableResources.put(resourceName, records);
        this.tableMetas.put(resourceName, meta);
        this.resources.add(resourceName);
    }

    public void setTableResource(String resourceName, File dir) throws IOException {
        this.checkResource(resourceName, dir);
        TableMeta meta = com.aliyun.odps.local.common.utils.SchemaUtils.readSchema((File)dir);
        String schemaStr = com.aliyun.odps.local.common.utils.SchemaUtils.toString((Column[])meta.getCols());
        TableInfo info = new TableInfo();
        info.setProjectName(meta.getProjName());
        info.setTableName(meta.getTableName());
        List<Record> records = MRUnitTest.readRecords(dir);
        this.setTableResource(resourceName, info, schemaStr, records);
    }

    public void setOutputSchema(String schema, Configuration conf) throws IOException {
        this.setOutputSchema("__default__", schema, conf);
    }

    public void setOutputSchema(String label, String schema, Configuration conf) throws IOException {
        try {
            Column[] columns = SchemaUtils.fromString((String)schema.trim());
            conf.set("odps.mapred.output.schema." + label, schema);
        }
        catch (Exception ex) {
            throw new IOException("bad schema format: " + schema);
        }
        this.outputSchemas.put(label, schema);
    }

    private void checkResource(String resourceName) throws IOException {
        if (StringUtils.isEmpty((String)resourceName)) {
            throw new IOException("invalid resource name: " + resourceName);
        }
        if (this.resources.contains(resourceName)) {
            throw new IOException("duplicate resource: " + resourceName);
        }
    }

    private void checkResource(String resourceName, File file) throws IOException {
        this.checkResource(resourceName);
        if (file == null) {
            throw new IOException("file or directory is null for resource: " + resourceName);
        }
        if (!file.exists()) {
            throw new IOException("file or directory not found for resource: " + resourceName + ", file: " + file);
        }
    }

    RuntimeContext getRuntimeContext() {
        return this.runtimeContext;
    }

    void setRuntimeContext(RuntimeContext runtimeContext) {
        this.runtimeContext = runtimeContext;
    }

    Map<String, String> getOutputSchemas() {
        return this.outputSchemas;
    }

    Map<String, byte[]> getFileResources() {
        return this.fileResources;
    }

    Map<String, File> getArchiveResources() {
        return this.archiveResources;
    }

    Map<String, List<Record>> getTableResources() {
        return this.tableResources;
    }

    Map<String, TableMeta> getTableMetas() {
        return this.tableMetas;
    }

    void clearResources() {
        this.resources.clear();
        this.fileResources.clear();
        this.archiveResources.clear();
        this.tableMetas.clear();
    }

    public boolean isCleanUtDir() {
        return this.isCleanUtDir;
    }

    public void setCleanUtDir(boolean isClean) {
        this.isCleanUtDir = isClean;
    }
}

