/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.odps.mapred.unittest;

import com.aliyun.odps.Column;
import com.aliyun.odps.conf.Configuration;
import com.aliyun.odps.data.Record;
import com.aliyun.odps.mapred.conf.BridgeJobConf;
import com.aliyun.odps.mapred.conf.JobConf;
import com.aliyun.odps.mapred.unittest.KeyValue;
import com.aliyun.odps.mapred.unittest.MRUnitTest;
import com.aliyun.odps.mapred.unittest.TaskOutput;
import com.aliyun.odps.mapred.unittest.UTContext;
import com.aliyun.odps.mapred.utils.SchemaUtils;
import com.aliyun.odps.pipeline.Pipeline;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class ReduceUTContext
extends UTContext {
    private List<KeyValue<Record, Record>> inputKeyVals = new ArrayList<KeyValue<Record, Record>>();
    private String inputKeySchema = "";
    private String inputValueSchema = "";
    private int reducerIndex;

    private void getInputKeyValueSchema(Configuration conf) {
        BridgeJobConf job = new BridgeJobConf(conf);
        Pipeline pipeline = Pipeline.fromJobConf((JobConf)job);
        if (pipeline != null) {
            Pipeline.TransformNode node = pipeline.getNode(this.reducerIndex + 1);
            this.inputKeySchema = SchemaUtils.toString((Column[])node.getInputKeySchema());
            this.inputValueSchema = SchemaUtils.toString((Column[])node.getInputValueSchema());
        } else {
            this.inputKeySchema = SchemaUtils.toString((Column[])job.getMapOutputKeySchema());
            this.inputValueSchema = SchemaUtils.toString((Column[])job.getMapOutputValueSchema());
        }
    }

    public Record createInputKeyRecord(Configuration conf) throws IOException {
        this.getInputKeyValueSchema(conf);
        if (this.inputKeySchema == null) {
            throw new IOException("input key schema is not set.");
        }
        return MRUnitTest.createRecord(this.inputKeySchema);
    }

    public Record createInputValueRecord(Configuration conf) throws IOException {
        this.getInputKeyValueSchema(conf);
        if (this.inputValueSchema == null) {
            throw new IOException("input value schema is not set.");
        }
        return MRUnitTest.createRecord(this.inputValueSchema);
    }

    public void addInputKeyValue(Record k, Record v) {
        this.inputKeyVals.add(new KeyValue<Record, Record>(k.clone(), v.clone()));
    }

    public void addInputKeyValues(List<KeyValue<Record, Record>> kvs) {
        this.inputKeyVals.addAll(kvs);
    }

    public void addInputKeyValues(TaskOutput mapOutput) {
        this.addInputKeyValues(mapOutput.getOutputKeyValues());
    }

    public void addInputKeyValues(TaskOutput mapOutput, int reduceId) {
        this.addInputKeyValues(mapOutput.getOutputKeyValues(reduceId));
    }

    public List<KeyValue<Record, Record>> getInputKeyVals() {
        return this.inputKeyVals;
    }

    public int getReducerIndex() {
        return this.reducerIndex;
    }

    public void setReducerIndex(int reducerIndex) {
        this.reducerIndex = reducerIndex;
    }
}

