/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.odps.mapred.local;

import com.aliyun.odps.PartitionSpec;
import com.aliyun.odps.conf.Configuration;
import com.aliyun.odps.counter.Counter;
import com.aliyun.odps.counter.Counters;
import com.aliyun.odps.data.Record;
import com.aliyun.odps.data.RecordReader;
import com.aliyun.odps.data.RecordWriter;
import com.aliyun.odps.data.TableInfo;
import com.aliyun.odps.data.VolumeInfo;
import com.aliyun.odps.local.common.FileSplit;
import com.aliyun.odps.local.common.TableMeta;
import com.aliyun.odps.local.common.WareHouse;
import com.aliyun.odps.local.common.utils.PartitionUtils;
import com.aliyun.odps.mapred.Mapper;
import com.aliyun.odps.mapred.Partitioner;
import com.aliyun.odps.mapred.Reducer;
import com.aliyun.odps.mapred.TaskId;
import com.aliyun.odps.mapred.bridge.ErrorCode;
import com.aliyun.odps.mapred.bridge.WritableRecord;
import com.aliyun.odps.mapred.bridge.type.ColumnBasedRecordComparator;
import com.aliyun.odps.mapred.conf.BridgeJobConf;
import com.aliyun.odps.mapred.conf.JobConf;
import com.aliyun.odps.mapred.local.CSVRecordReader;
import com.aliyun.odps.mapred.local.DriverBase;
import com.aliyun.odps.mapred.local.JobCounter;
import com.aliyun.odps.mapred.local.LocalGroupingRecordIterator;
import com.aliyun.odps.mapred.local.LocalTaskContext;
import com.aliyun.odps.mapred.local.MapOutputBuffer;
import com.aliyun.odps.utils.ReflectionUtils;
import com.aliyun.odps.volume.FileSystem;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedList;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class MapDriver
extends DriverBase {
    public static final Log LOG = LogFactory.getLog(MapDriver.class);
    private Mapper.TaskContext mapContext;
    MapOutputBuffer outputBuffer;
    private Counters counters;
    private FileSplit split;

    public MapDriver(BridgeJobConf job, FileSplit split, TaskId id, MapOutputBuffer buffer, Counters counters, TableInfo tableInfo) throws IOException {
        super(job, id, counters);
        this.outputBuffer = buffer;
        this.split = split;
        Counter mapInputByteCounter = counters.findCounter((Enum)JobCounter.MAP_INPUT_BYTES);
        Counter mapInputRecordCounter = counters.findCounter((Enum)JobCounter.MAP_INPUT_RECORDS);
        TableMeta tableMeta = null;
        if (tableInfo != null) {
            tableMeta = new TableMeta(tableInfo.getProjectName(), tableInfo.getTableName(), null);
        }
        CSVRecordReader reader = new CSVRecordReader(split, tableMeta, mapInputRecordCounter, mapInputByteCounter, counters, WareHouse.getInstance().getInputColumnSeperator());
        this.mapContext = job.getCombinerClass() != null ? new ProxiedMapContextImpl(job, this.taskId, counters, reader, tableInfo) : new DirectMapContextImpl(job, id, counters, reader, tableInfo);
        this.counters = counters;
    }

    @Override
    public void run() throws IOException {
        Mapper mapper = ((LocalTaskContext)this.mapContext).createMapper();
        if (this.split != null && this.split != FileSplit.NullSplit) {
            File whInputFile = WareHouse.getInstance().getJobDir().convertInputFile(this.split.getFile());
            PartitionSpec partitionSpec = WareHouse.getInstance().resolvePartition(this.mapContext.getInputTableInfo().getProjectName(), this.mapContext.getInputTableInfo().getTableName(), whInputFile);
            this.mapContext.getInputTableInfo().setPartSpec(PartitionUtils.convert((PartitionSpec)partitionSpec));
        }
        mapper.setup(this.mapContext);
        while (this.mapContext.nextRecord()) {
            mapper.map(this.mapContext.getCurrentRecordNum(), this.mapContext.getCurrentRecord(), this.mapContext);
        }
        mapper.cleanup(this.mapContext);
        ((DirectMapContextImpl)this.mapContext).close();
    }

    class ProxiedMapContextImpl
    extends DirectMapContextImpl
    implements Mapper.TaskContext {
        private LinkedList<Object[]> queue;

        public ProxiedMapContextImpl(BridgeJobConf conf, TaskId taskid, Counters counters, RecordReader reader, TableInfo inputTableInfo) throws IOException {
            super(conf, taskid, counters, reader, inputTableInfo);
            this.queue = new LinkedList();
        }

        @Override
        public void write(Record key, Record value) {
            this.mapOutputRecordCounter.increment(1L);
            this.queue.add(ArrayUtils.addAll((Object[])((WritableRecord)key).toWritableArray(), (Object[])((WritableRecord)value).toWritableArray()));
            MapDriver.this.counters.findCounter((Enum)JobCounter.__EMPTY_OUTPUT_RECORD_COUNT).increment(1L);
        }

        @Override
        public void close() throws IOException {
            Collections.sort(this.queue, MapDriver.this.outputBuffer.getComparator());
            Reducer combiner = (Reducer)ReflectionUtils.newInstance(this.getCombinerClass(), (Configuration)this.conf);
            CombinerContextImpl combineCtx = new CombinerContextImpl(this.conf, MapDriver.this.taskId, MapDriver.this.counters);
            LOG.info((Object)("Start to run Combiner, TaskId: " + MapDriver.this.taskId));
            combiner.setup((Reducer.TaskContext)combineCtx);
            while (combineCtx.nextKeyValue()) {
                combiner.reduce(combineCtx.getCurrentKey(), combineCtx.getValues(), (Reducer.TaskContext)combineCtx);
            }
            combiner.cleanup((Reducer.TaskContext)combineCtx);
            super.close();
            LOG.info((Object)("Fininshed run Combiner, TaskId: " + MapDriver.this.taskId));
        }

        class CombinerContextImpl
        extends DirectMapContextImpl
        implements Reducer.TaskContext {
            private Record key;
            private Iterator<Record> itr;
            private Counter combineInputGroupCounter;
            private Counter combineOutputRecordCounter;

            public CombinerContextImpl(BridgeJobConf conf, TaskId taskid, Counters counters) throws IOException {
                super(conf, taskid, counters, null, null);
                this.combineInputGroupCounter = counters.findCounter((Enum)JobCounter.COMBINE_INPUT_GROUPS);
                this.combineOutputRecordCounter = counters.findCounter((Enum)JobCounter.COMBINE_OUTPUT_RECORDS);
            }

            public boolean nextKeyValue() {
                if (this.itr == null) {
                    Object[] init = (Object[])ProxiedMapContextImpl.this.queue.peek();
                    if (init == null) {
                        return false;
                    }
                    this.key = this.createMapOutputKeyRecord();
                    Record value = this.createMapOutputValueRecord();
                    String[] groupingColumns = this.getGroupingColumns();
                    ColumnBasedRecordComparator grpComparator = new ColumnBasedRecordComparator(groupingColumns, this.key.getColumns());
                    this.itr = new LocalGroupingRecordIterator(ProxiedMapContextImpl.this.queue, (WritableRecord)this.key, (WritableRecord)value, (Comparator<Object[]>)grpComparator, false, MapDriver.this.counters);
                    this.key.set(Arrays.copyOf(init, this.key.getColumnCount()));
                } else {
                    while (this.itr.hasNext()) {
                        this.itr.remove();
                    }
                    if (!((LocalGroupingRecordIterator)this.itr).reset()) {
                        return false;
                    }
                }
                this.combineInputGroupCounter.increment(1L);
                return true;
            }

            public Record getCurrentKey() {
                return this.key;
            }

            public Iterator<Record> getValues() {
                return this.itr;
            }

            @Override
            public void write(Record record) throws IOException {
                this.write(record, "__default__");
                this.combineOutputRecordCounter.increment(1L);
            }

            @Override
            public void write(Record record, String label) throws IOException {
                ((RecordWriter)this.recordWriters.get(label)).write(record);
            }

            @Override
            public void write(Record key, Record value) {
                if (this.partitioner != null) {
                    int part = this.partitioner.getPartition(key, value, this.getNumReduceTasks());
                    if (part < 0 || part >= this.getNumReduceTasks()) {
                        throw new RuntimeException("partitioner return invalid partition value:" + part);
                    }
                    MapDriver.this.outputBuffer.add(key, value, part);
                } else {
                    MapDriver.this.outputBuffer.add(key, value);
                }
                this.combineOutputRecordCounter.increment(1L);
            }

            @Override
            public Record createOutputKeyRecord() throws IOException {
                return null;
            }

            @Override
            public Record createOutputValueRecord() throws IOException {
                return null;
            }

            @Override
            public VolumeInfo getInputVolumeInfo() throws IOException {
                return null;
            }

            @Override
            public VolumeInfo getInputVolumeInfo(String label) throws IOException {
                return null;
            }

            @Override
            public VolumeInfo getOutputVolumeInfo() throws IOException {
                return null;
            }

            @Override
            public VolumeInfo getOutputVolumeInfo(String label) throws IOException {
                return null;
            }

            @Override
            public FileSystem getInputVolumeFileSystem() throws IOException {
                return null;
            }

            @Override
            public FileSystem getInputVolumeFileSystem(String label) throws IOException {
                return null;
            }

            @Override
            public FileSystem getOutputVolumeFileSystem() throws IOException {
                return null;
            }

            @Override
            public FileSystem getOutputVolumeFileSystem(String label) throws IOException {
                return null;
            }
        }
    }

    class DirectMapContextImpl
    extends LocalTaskContext
    implements Mapper.TaskContext {
        int rowNumber;
        protected RecordReader reader;
        Record record;
        protected Counter mapOutputRecordCounter;
        protected TableInfo inputTableInfo;
        protected Partitioner partitioner;

        public DirectMapContextImpl(BridgeJobConf conf, TaskId taskid, Counters counters, RecordReader reader, TableInfo inputTableInfo) throws IOException {
            Class partitionerClass;
            super(conf, taskid, counters);
            this.rowNumber = 1;
            this.reader = reader;
            this.mapOutputRecordCounter = counters.findCounter((Enum)JobCounter.MAP_OUTPUT_RECORDS);
            this.inputTableInfo = inputTableInfo;
            if (this.pipeMode) {
                conf.setMapperClass(this.pipeNode.getTransformClass());
                partitionerClass = this.pipeNode.getPartitionerClass();
            } else {
                partitionerClass = this.getJobConf().getPartitionerClass();
            }
            if (partitionerClass != null) {
                this.partitioner = (Partitioner)ReflectionUtils.newInstance((Class)partitionerClass, (Configuration)this.getJobConf());
                this.partitioner.configure((JobConf)conf);
            }
        }

        public long getCurrentRecordNum() {
            return this.rowNumber;
        }

        public Record getCurrentRecord() {
            return this.record;
        }

        public boolean nextRecord() {
            try {
                this.record = this.reader.read();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            return this.record != null;
        }

        public void write(Record record) throws IOException {
            this.mapOutputRecordCounter.increment(1L);
            this.write(record, "__default__");
        }

        public void write(Record record, String label) throws IOException {
            if (this.getNumReduceTasks() > 0) {
                throw new UnsupportedOperationException(ErrorCode.UNEXPECTED_MAP_WRITE_OUTPUT.toString());
            }
            if (MapDriver.this.outputBuffer != null) {
                MapDriver.this.outputBuffer.add(record, label);
            }
            ((RecordWriter)this.recordWriters.get(label)).write(record);
            MapDriver.this.counters.findCounter((Enum)JobCounter.__EMPTY_OUTPUT_RECORD_COUNT).increment(1L);
        }

        public void write(Record key, Record value) {
            if (this.getNumReduceTasks() == 0) {
                throw new UnsupportedOperationException(ErrorCode.UNEXPECTED_MAP_WRITE_INTER.toString());
            }
            this.mapOutputRecordCounter.increment(1L);
            if (this.partitioner != null) {
                int part = this.partitioner.getPartition(key, value, this.getNumReduceTasks());
                if (part < 0 || part >= this.getNumReduceTasks()) {
                    throw new RuntimeException("partitioner return invalid partition value:" + part);
                }
                MapDriver.this.outputBuffer.add(key, value, part);
            } else {
                MapDriver.this.outputBuffer.add(key, value);
            }
            MapDriver.this.counters.findCounter((Enum)JobCounter.__EMPTY_OUTPUT_RECORD_COUNT).increment(1L);
        }

        public void close() throws IOException {
            this.reader.close();
            this.closeWriters();
        }

        public TableInfo getInputTableInfo() {
            return this.inputTableInfo;
        }

        @Override
        public Record createOutputKeyRecord() throws IOException {
            return null;
        }

        @Override
        public Record createOutputValueRecord() throws IOException {
            return null;
        }

        public VolumeInfo getInputVolumeInfo() throws IOException {
            return null;
        }

        public VolumeInfo getInputVolumeInfo(String label) throws IOException {
            return null;
        }

        public VolumeInfo getOutputVolumeInfo() throws IOException {
            return null;
        }

        public VolumeInfo getOutputVolumeInfo(String label) throws IOException {
            return null;
        }

        public FileSystem getInputVolumeFileSystem() throws IOException {
            return null;
        }

        public FileSystem getInputVolumeFileSystem(String label) throws IOException {
            return null;
        }

        public FileSystem getOutputVolumeFileSystem() throws IOException {
            return null;
        }

        public FileSystem getOutputVolumeFileSystem(String label) throws IOException {
            return null;
        }
    }
}

