/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.odps.tunnel.io;

import com.aliyun.odps.commons.transport.HttpStatus;
import com.aliyun.odps.rest.RestClient;
import com.aliyun.odps.tunnel.Configuration;
import com.aliyun.odps.tunnel.TunnelException;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import java.util.function.IntConsumer;

public class TunnelRetryHandler {
    private RetryPolicy defaultRetryPolicy;
    private RestClient.RetryLogger retryLogger;

    public TunnelRetryHandler() {
        this(NoRetryPolicy.INSTANCE, null);
    }

    public TunnelRetryHandler(Configuration configuration) {
        this(configuration.getRetryPolicy(), configuration.getRetryLogger());
    }

    public TunnelRetryHandler(RetryPolicy defaultRetryPolicy, RestClient.RetryLogger retryLogger) {
        this.defaultRetryPolicy = defaultRetryPolicy == null ? NoRetryPolicy.INSTANCE : defaultRetryPolicy;
        this.retryLogger = retryLogger;
    }

    public boolean onFailure(Exception e, int attempt) {
        RetryPolicy policy = e instanceof TunnelException ? this.getRetryPolicy(((TunnelException)e).getStatus()) : this.defaultRetryPolicy;
        if (policy.shouldRetry(e, attempt)) {
            if (this.retryLogger != null) {
                this.retryLogger.onRetryLog(e, attempt, policy.getRetryWaitTime(attempt));
            }
            try {
                policy.waitForNextRetry(attempt);
            }
            catch (InterruptedException i) {
                Thread.currentThread().interrupt();
            }
            return true;
        }
        return false;
    }

    private RetryPolicy getRetryPolicy(Integer errorCode) {
        if (errorCode == 308 || errorCode == 429) {
            return InfiniteExponentialWaitRetryPolicy.INSTANCE;
        }
        if (HttpStatus.isServerError(errorCode)) {
            return ExponentialWaitRetryPolicy.INSTANCE;
        }
        return this.defaultRetryPolicy;
    }

    public <T> T executeWithRetry(Callable<T> action) throws Exception {
        return this.executeWithRetry(action, null);
    }

    public <T> T executeWithRetry(Callable<T> action, IntConsumer errorCodeHandler) throws Exception {
        int attempt = 1;
        while (true) {
            try {
                return action.call();
            }
            catch (Exception e) {
                RetryPolicy policy = e instanceof TunnelException ? this.getRetryPolicy(((TunnelException)e).getStatus()) : this.defaultRetryPolicy;
                if (!policy.shouldRetry(e, attempt)) {
                    throw e;
                }
                this.retryLogger.onRetryLog(e, attempt, policy.getRetryWaitTime(attempt));
                try {
                    policy.waitForNextRetry(attempt);
                    if (errorCodeHandler != null && e instanceof TunnelException) {
                        errorCodeHandler.accept(((TunnelException)e).getStatus());
                    }
                }
                catch (InterruptedException ie) {
                    Thread.currentThread().interrupt();
                    throw e;
                }
                ++attempt;
                continue;
            }
            break;
        }
    }

    static class ExponentialWaitRetryPolicy
    implements RetryPolicy {
        static final ExponentialWaitRetryPolicy INSTANCE = new ExponentialWaitRetryPolicy();

        ExponentialWaitRetryPolicy() {
        }

        @Override
        public boolean shouldRetry(Exception e, int attempt) {
            return attempt <= 7;
        }

        @Override
        public long getRetryWaitTime(int attempt) {
            int waitTime = (int)Math.pow(2.0, attempt - 1);
            return TimeUnit.SECONDS.toMillis(waitTime);
        }
    }

    static class InfiniteExponentialWaitRetryPolicy
    implements RetryPolicy {
        static final InfiniteExponentialWaitRetryPolicy INSTANCE = new InfiniteExponentialWaitRetryPolicy();

        InfiniteExponentialWaitRetryPolicy() {
        }

        @Override
        public boolean shouldRetry(Exception e, int attempt) {
            return true;
        }

        @Override
        public long getRetryWaitTime(int attempt) {
            if (attempt < 7) {
                int waitTime = (int)Math.pow(2.0, attempt - 1);
                return TimeUnit.SECONDS.toMillis(waitTime);
            }
            return TimeUnit.SECONDS.toMillis(64L);
        }
    }

    static class NoRetryPolicy
    implements RetryPolicy {
        static final NoRetryPolicy INSTANCE = new NoRetryPolicy();

        NoRetryPolicy() {
        }

        @Override
        public boolean shouldRetry(Exception e, int attempt) {
            return false;
        }

        @Override
        public long getRetryWaitTime(int attempt) {
            return 0L;
        }

        @Override
        public void waitForNextRetry(int attempt) {
        }
    }

    public static interface RetryPolicy {
        public boolean shouldRetry(Exception var1, int var2);

        public long getRetryWaitTime(int var1);

        default public void waitForNextRetry(int attempt) throws InterruptedException {
            TimeUnit.MILLISECONDS.sleep(this.getRetryWaitTime(attempt));
        }
    }
}

