/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.odps.tunnel.impl;

import com.aliyun.odps.Column;
import com.aliyun.odps.Odps;
import com.aliyun.odps.OdpsType;
import com.aliyun.odps.PartitionSpec;
import com.aliyun.odps.TableSchema;
import com.aliyun.odps.commons.transport.Request;
import com.aliyun.odps.data.Record;
import com.aliyun.odps.tunnel.Configuration;
import com.aliyun.odps.tunnel.TableTunnel;
import com.aliyun.odps.tunnel.TunnelException;
import com.aliyun.odps.tunnel.TunnelTableSchema;
import com.aliyun.odps.tunnel.impl.SessionBase;
import com.aliyun.odps.tunnel.impl.Slot;
import com.aliyun.odps.tunnel.impl.UpsertRecord;
import com.aliyun.odps.tunnel.impl.UpsertStreamImpl;
import com.aliyun.odps.tunnel.impl.Util;
import com.aliyun.odps.tunnel.io.CompressOption;
import com.aliyun.odps.tunnel.io.TunnelRetryHandler;
import com.aliyun.odps.tunnel.streams.UpsertStream;
import com.aliyun.odps.type.TypeInfo;
import com.aliyun.odps.type.TypeInfoFactory;
import com.aliyun.odps.utils.FixedNettyChannelPool;
import com.aliyun.odps.utils.StringUtils;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonSyntaxException;
import io.netty.bootstrap.Bootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.handler.codec.http.HttpClientCodec;
import io.netty.handler.codec.http.HttpContentDecompressor;
import io.netty.handler.codec.http.HttpObjectAggregator;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslContextBuilder;
import io.netty.handler.ssl.util.InsecureTrustManagerFactory;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class UpsertSessionImpl
extends SessionBase
implements TableTunnel.UpsertSession {
    private long slotNum;
    private String status;
    private Map<Integer, Slot> buckets = new HashMap<Integer, Slot>();
    private String hasher;
    private List<String> hashKeys = new ArrayList<String>();
    private TunnelTableSchema recordSchema;
    private long commitTimeout;
    private long connectTimeout;
    private long readTimeout;
    private boolean supportPartialUpdate = false;
    private EventLoopGroup group;
    private Bootstrap bootstrap;
    private ScheduledExecutorService scheduler = Executors.newScheduledThreadPool(1);
    ReentrantReadWriteLock rwLock = new ReentrantReadWriteLock();
    ReentrantReadWriteLock.ReadLock readLock = this.rwLock.readLock();
    ReentrantReadWriteLock.WriteLock writeLock = this.rwLock.writeLock();
    private FixedNettyChannelPool channelPool;

    public UpsertSessionImpl(Builder builder) throws TunnelException, IOException {
        this.projectName = builder.getProjectName();
        this.schemaName = builder.getSchemaName();
        this.tableName = builder.getTableName();
        this.partitionSpec = builder.getPartitionSpec();
        this.config = builder.getConfig();
        this.httpClient = this.config.newRestClient(this.projectName);
        this.slotNum = builder.getSlotNum();
        this.commitTimeout = builder.getCommitTimeout();
        this.connectTimeout = (long)this.config.getSocketConnectTimeout() * 1000L;
        this.readTimeout = (long)this.config.getSocketTimeout() * 1000L;
        this.id = builder.getUpsertId();
        this.tunnelRetryHandler = new TunnelRetryHandler(this.config);
        if (this.id == null) {
            this.initiate();
        } else {
            this.reload(true);
        }
        this.initScheduler();
        if (builder.bootstrap == null) {
            this.initNettyBootstrap(builder.threadNum);
        } else {
            this.bootstrap = builder.bootstrap;
        }
        this.channelPool = this.newChannelPool(builder.concurrentNum);
    }

    public FixedNettyChannelPool getChannelPool() {
        return this.channelPool;
    }

    @Override
    public Record newRecord() {
        return new UpsertRecord(this.recordSchema.getColumns().toArray(new Column[0]));
    }

    @Override
    public UpsertStream.Builder buildUpsertStream() {
        return new UpsertStreamImpl.Builder().setSession(this).setCompressOption(this.config.getCompressOption()).setListener(new DefaultUpsertSteamListener(this));
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String getQuotaName() {
        return this.quotaName;
    }

    @Override
    public String getStatus() throws TunnelException {
        this.reload(false);
        try {
            this.readLock.lock();
            String string = this.status;
            return string;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public TableSchema getSchema() {
        return this.schema;
    }

    public boolean supportPartialUpdate() {
        return this.supportPartialUpdate;
    }

    @Override
    public void commit(boolean async) throws TunnelException {
        HashMap<String, String> params = this.getCommonParams();
        params.put("upsertid", this.id);
        HashMap<String, String> headers = this.getCommonHeaders();
        headers.put("odps-tunnel-routed-server", this.buckets.get(0).getServer());
        SessionBase.HttpResult result = this.httpRequest(headers, params, "POST", "commit upsert session");
        this.load(result, false);
        if (!async) {
            int i = 1;
            long start = System.currentTimeMillis();
            while (this.status.equalsIgnoreCase("committing") || this.status.equalsIgnoreCase("normal")) {
                try {
                    if (System.currentTimeMillis() - start > this.commitTimeout) {
                        throw new TunnelException("Commit session timeout");
                    }
                    Thread.sleep(i * 1000);
                    result = this.httpRequest(headers, params, "POST", "commit upsert session");
                    this.load(result, false);
                    if (i >= 16) continue;
                    i *= 2;
                }
                catch (InterruptedException e) {
                    throw new TunnelException(e.getMessage(), e);
                }
                catch (TunnelException e) {
                    if (e.getErrorCode().equalsIgnoreCase("UpsertSessionNotFound")) {
                        this.status = "committed";
                        continue;
                    }
                    throw e;
                }
            }
            if (!this.status.equalsIgnoreCase("committed")) {
                throw new TunnelException("Commit session failed, status:" + this.status);
            }
        }
    }

    @Override
    public void abort() throws TunnelException {
        HashMap<String, String> params = this.getCommonParams();
        params.put("upsertid", this.id);
        HashMap<String, String> headers = this.getCommonHeaders();
        headers.put("odps-tunnel-routed-server", this.buckets.get(0).getServer());
        this.httpRequest(headers, params, "DELETE", "abort upsert session");
    }

    @Override
    public void close() {
        this.scheduler.shutdownNow();
        if (this.group != null) {
            this.group.shutdownGracefully().syncUninterruptibly();
        }
    }

    private void reload(boolean init) throws TunnelException {
        HashMap<String, String> params = this.getCommonParams();
        params.put("upsertid", this.id);
        HashMap<String, String> headers = this.getCommonHeaders();
        SessionBase.HttpResult result = this.httpRequest(headers, params, "GET", "get upsert session");
        this.load(result, init);
    }

    private void initiate() throws TunnelException, IOException {
        HashMap<String, String> params = this.getCommonParams();
        params.put("slotnum", String.valueOf(this.slotNum));
        HashMap<String, String> headers = this.getCommonHeaders();
        SessionBase.HttpResult result = this.httpRequest(headers, params, "POST", "create upsert session");
        this.load(result, true);
    }

    private void load(SessionBase.HttpResult result, boolean loadAll) throws TunnelException {
        try {
            JsonObject tree = new JsonParser().parse(result.body).getAsJsonObject();
            this.loadFromJson(result.requestId, tree, loadAll);
        }
        catch (JsonSyntaxException e) {
            throw new TunnelException(result.requestId, "Invalid json content: '" + result.body + "'", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadFromJson(String requestId, JsonObject tree, boolean loadAll) throws TunnelException {
        try {
            if (tree.has("id") && tree.has("schema") && tree.has("hash_key") && tree.has("hasher") && tree.has("slots") && tree.has("status")) {
                if (loadAll) {
                    this.id = tree.get("id").getAsString();
                    JsonObject tunnelTableSchema = tree.get("schema").getAsJsonObject();
                    this.schema = new TunnelTableSchema(tunnelTableSchema);
                    this.recordSchema = new TunnelTableSchema(tunnelTableSchema);
                    this.recordSchema.addColumn(new Column("__version", (TypeInfo)TypeInfoFactory.getPrimitiveTypeInfo((OdpsType)OdpsType.BIGINT)));
                    this.recordSchema.addColumn(new Column("__app_version", (TypeInfo)TypeInfoFactory.getPrimitiveTypeInfo((OdpsType)OdpsType.BIGINT)));
                    this.recordSchema.addColumn(new Column("__operation", (TypeInfo)TypeInfoFactory.getPrimitiveTypeInfo((OdpsType)OdpsType.TINYINT)));
                    this.recordSchema.addColumn(new Column("__key_cols", (TypeInfo)TypeInfoFactory.getArrayTypeInfo((TypeInfo)TypeInfoFactory.getPrimitiveTypeInfo((OdpsType)OdpsType.BIGINT))));
                    this.recordSchema.addColumn(new Column("__value_cols", (TypeInfo)TypeInfoFactory.getArrayTypeInfo((TypeInfo)TypeInfoFactory.getPrimitiveTypeInfo((OdpsType)OdpsType.BIGINT))));
                    tree.get("hash_key").getAsJsonArray().forEach(v -> this.hashKeys.add(v.getAsString()));
                    this.hasher = tree.get("hasher").getAsString();
                    if (tree.has("quota_name")) {
                        this.quotaName = tree.get("quota_name").getAsString();
                    }
                    if (tree.has("enable_partial_update")) {
                        this.supportPartialUpdate = tree.get("enable_partial_update").getAsBoolean();
                    }
                }
            } else {
                throw new TunnelException(requestId, "Incomplete session info: '" + tree.toString() + "'");
            }
            HashMap<Integer, Slot> bucketMap = new HashMap<Integer, Slot>();
            ArrayList<Slot> slotList = new ArrayList<Slot>();
            JsonArray slotElements = tree.getAsJsonArray("slots");
            for (JsonElement slotElement : slotElements) {
                JsonObject slotInfo = slotElement.getAsJsonObject();
                String slotId = slotInfo.get("slot_id").getAsString();
                JsonArray bucketElements = slotInfo.get("buckets").getAsJsonArray();
                String workerAddr = slotInfo.get("worker_addr").getAsString();
                Slot slot = new Slot(slotId, workerAddr);
                slotList.add(slot);
                for (JsonElement bucketElement : bucketElements) {
                    bucketMap.put(bucketElement.getAsInt(), slot);
                }
            }
            for (Integer bucket : bucketMap.keySet()) {
                if (bucket >= 0 && bucket < bucketMap.size()) continue;
                throw new TunnelException("Invalid bucket value:" + bucket);
            }
            try {
                this.writeLock.lock();
                this.buckets = bucketMap;
                this.status = tree.get("status").getAsString();
            }
            finally {
                this.writeLock.unlock();
            }
        }
        catch (TunnelException e) {
            throw e;
        }
        catch (Exception e) {
            throw new TunnelException(requestId, "Invalid json content: '" + tree.toString() + "'", e);
        }
    }

    private void initScheduler() {
        Runnable task = () -> {
            try {
                this.reload(false);
                if (!this.status.equalsIgnoreCase("normal") && !this.status.equalsIgnoreCase("committing")) {
                    this.scheduler.shutdownNow();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        };
        this.scheduler.scheduleAtFixedRate(task, 30L, 30L, TimeUnit.SECONDS);
    }

    private void initNettyBootstrap(int threadNum) throws TunnelException {
        this.group = new NioEventLoopGroup(threadNum);
        this.bootstrap = UpsertSessionImpl.generateNettyBootstrap(this.config, this.group);
    }

    private FixedNettyChannelPool newChannelPool(int concurrentNum) throws TunnelException {
        try {
            URI uri = new URI(this.httpClient.getEndpoint() + this.getResource());
            String host = uri.getHost();
            int port = uri.getPort();
            if (port == -1) {
                port = "https".equalsIgnoreCase(uri.getScheme()) ? 443 : 80;
            }
            int finalPort = port;
            FixedNettyChannelPool.ChannelFactory channelFactory = () -> this.bootstrap.connect(host, finalPort).sync().channel();
            return new FixedNettyChannelPool(concurrentNum, channelFactory);
        }
        catch (Exception e) {
            throw new TunnelException(e.getMessage(), e);
        }
    }

    public static Bootstrap generateNettyBootstrap(Configuration configuration, EventLoopGroup group) {
        Bootstrap bootstrap = new Bootstrap();
        final Odps odps = configuration.getOdps();
        ((Bootstrap)((Bootstrap)bootstrap.group(group)).channel(NioSocketChannel.class)).handler((ChannelHandler)new ChannelInitializer<Channel>(){

            protected void initChannel(Channel channel) throws Exception {
                URI uri = new URI(odps.getEndpoint());
                if ("https".equalsIgnoreCase(uri.getScheme())) {
                    SslContextBuilder builder = SslContextBuilder.forClient();
                    if (odps.getRestClient().isIgnoreCerts()) {
                        builder = builder.trustManager(InsecureTrustManagerFactory.INSTANCE);
                    }
                    SslContext sc = builder.build();
                    channel.pipeline().addLast(new ChannelHandler[]{sc.newHandler(channel.alloc())});
                }
                channel.pipeline().addLast(new ChannelHandler[]{new HttpClientCodec()}).addLast(new ChannelHandler[]{new HttpObjectAggregator(65536)}).addLast(new ChannelHandler[]{new HttpContentDecompressor()});
            }
        });
        bootstrap.option(ChannelOption.CONNECT_TIMEOUT_MILLIS, (Object)(configuration.getSocketConnectTimeout() * 1000));
        return bootstrap;
    }

    void updateBuckets(int bucketId, String newSlotServer) throws TunnelException {
        if (StringUtils.isNullOrEmpty((String)newSlotServer)) {
            this.reload(false);
        } else {
            try {
                this.readLock.lock();
                this.buckets.get(bucketId).setServer(newSlotServer);
            }
            finally {
                this.readLock.unlock();
            }
        }
    }

    Request buildRequest(String method, int bucket, Slot slot, long contentLength, long recordCount, CompressOption compressOption) throws TunnelException {
        if (slot.getServer().isEmpty()) {
            throw new TunnelException("slot addr is empty");
        }
        HashMap<String, String> params = this.getCommonParams();
        params.put("bucketid", String.valueOf(bucket));
        params.put("slotid", slot.getSlot());
        params.put("upsertid", this.id);
        HashMap<String, String> headers = Util.getCommonHeader();
        headers.put("Content-Length", String.valueOf(contentLength));
        headers.put("odps-tunnel-routed-server", slot.getServer());
        params.put("record_count", String.valueOf(recordCount));
        switch (compressOption.algorithm) {
            case ODPS_RAW: {
                break;
            }
            case ODPS_ZLIB: {
                headers.put("Content-Encoding", "deflate");
                break;
            }
            case ODPS_SNAPPY: {
                headers.put("Content-Encoding", "x-snappy-framed");
                break;
            }
            case ODPS_LZ4_FRAME: {
                headers.put("Content-Encoding", "x-lz4-frame");
                break;
            }
            default: {
                throw new TunnelException("unsupported compression option.");
            }
        }
        return this.httpClient.buildRequest(this.getResource(), method, params, headers);
    }

    URI getEndpoint() throws TunnelException {
        return this.config.getEndpoint(this.projectName);
    }

    Map<Integer, Slot> getBuckets() {
        try {
            this.readLock.lock();
            Map<Integer, Slot> map = this.buckets;
            return map;
        }
        finally {
            this.readLock.unlock();
        }
    }

    TunnelTableSchema getRecordSchema() {
        return this.recordSchema;
    }

    String getHasher() {
        return this.hasher;
    }

    List<Integer> getHashKeys() {
        ArrayList<Integer> keys = new ArrayList<Integer>();
        for (String key : this.hashKeys) {
            keys.add(this.recordSchema.getColumnIndex(key));
        }
        return keys;
    }

    Bootstrap getBootstrap() {
        return this.bootstrap;
    }

    @Override
    protected String getResource() {
        return this.config.getResource(this.projectName, this.schemaName, this.tableName) + "/" + "upserts";
    }

    public long getConnectTimeout() {
        return this.connectTimeout;
    }

    public long getReadTimeout() {
        return this.readTimeout;
    }

    public static class Builder
    implements TableTunnel.UpsertSession.Builder {
        private String upsertId;
        private String projectName;
        private String schemaName;
        private String tableName;
        private PartitionSpec partitionSpec;
        Bootstrap bootstrap;
        int concurrentNum = 20;
        int threadNum = 1;
        private long slotNum = 1L;
        private long commitTimeout = 120000L;
        Configuration config;

        @Override
        public String getUpsertId() {
            return this.upsertId;
        }

        @Override
        public Builder setUpsertId(String upsertId) {
            this.upsertId = upsertId;
            return this;
        }

        public String getProjectName() {
            return this.projectName;
        }

        public Builder setProjectName(String projectName) {
            this.projectName = projectName;
            return this;
        }

        @Override
        public String getSchemaName() {
            return this.schemaName;
        }

        @Override
        public Builder setSchemaName(String schemaName) {
            this.schemaName = schemaName;
            return this;
        }

        public String getTableName() {
            return this.tableName;
        }

        public Builder setTableName(String tableName) {
            this.tableName = tableName;
            return this;
        }

        @Override
        public String getPartitionSpec() {
            return this.partitionSpec == null ? null : this.partitionSpec.toString().replaceAll("'", "");
        }

        @Override
        public Builder setPartitionSpec(PartitionSpec spec) {
            this.partitionSpec = spec;
            return this;
        }

        @Override
        public Builder setPartitionSpec(String spec) {
            this.partitionSpec = spec == null ? null : new PartitionSpec(spec);
            return this;
        }

        @Override
        public long getSlotNum() {
            return this.slotNum;
        }

        @Override
        public Builder setSlotNum(long slotNum) {
            this.slotNum = slotNum;
            return this;
        }

        public Configuration getConfig() {
            return this.config;
        }

        public Builder setConfig(Configuration config) {
            if (config == null) {
                throw new IllegalArgumentException("config can not be null!");
            }
            this.config = config;
            return this;
        }

        @Override
        public long getCommitTimeout() {
            return this.commitTimeout;
        }

        @Override
        public TableTunnel.UpsertSession.Builder setCommitTimeout(long commitTimeout) {
            if (commitTimeout <= 0L) {
                throw new IllegalArgumentException("timeout value must be positive");
            }
            this.commitTimeout = commitTimeout;
            return this;
        }

        @Override
        public Builder setNetworkThreadNum(int threadNum) {
            this.threadNum = threadNum;
            return this;
        }

        @Override
        public Builder setConcurrentNum(int concurrentNum) {
            this.concurrentNum = concurrentNum;
            return this;
        }

        @Override
        public Builder setConnectTimeout(long timeout) {
            if (timeout <= 0L) {
                throw new IllegalArgumentException("timeout value must be positive");
            }
            this.config.setSocketConnectTimeout((int)(timeout / 1000L));
            return this;
        }

        @Override
        public Builder setReadTimeout(long timeout) {
            if (timeout <= 0L) {
                throw new IllegalArgumentException("timeout value must be positive");
            }
            this.config.setSocketTimeout((int)(timeout / 1000L));
            return this;
        }

        public Builder setNettyBootStrap(Bootstrap bootstrap) {
            this.bootstrap = bootstrap;
            return this;
        }

        @Override
        public UpsertSessionImpl build() throws TunnelException, IOException {
            return new UpsertSessionImpl(this);
        }
    }

    public static class DefaultUpsertSteamListener
    implements UpsertStream.Listener {
        UpsertSessionImpl session;

        public DefaultUpsertSteamListener(UpsertSessionImpl session) {
            this.session = session;
        }

        @Override
        public void onFlush(UpsertStream.FlushResult result) {
        }

        @Override
        public boolean onFlushFail(Exception error, int retry) {
            int errorStatus;
            if (error instanceof TunnelException && ((errorStatus = ((TunnelException)error).getStatus().intValue()) == 502 || errorStatus == 504)) {
                try {
                    this.session.reload(false);
                }
                catch (TunnelException e) {
                    return false;
                }
            }
            return this.session.getTunnelRetryHandler().onFailure(error, retry);
        }
    }
}

