/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.odps.simpleframework.xml.core;

import com.aliyun.odps.simpleframework.xml.ElementArray;
import com.aliyun.odps.simpleframework.xml.core.ArrayFactory;
import com.aliyun.odps.simpleframework.xml.core.ClassType;
import com.aliyun.odps.simpleframework.xml.core.CompositeArray;
import com.aliyun.odps.simpleframework.xml.core.Contact;
import com.aliyun.odps.simpleframework.xml.core.Context;
import com.aliyun.odps.simpleframework.xml.core.Converter;
import com.aliyun.odps.simpleframework.xml.core.Decorator;
import com.aliyun.odps.simpleframework.xml.core.Expression;
import com.aliyun.odps.simpleframework.xml.core.Factory;
import com.aliyun.odps.simpleframework.xml.core.InstantiationException;
import com.aliyun.odps.simpleframework.xml.core.Introspector;
import com.aliyun.odps.simpleframework.xml.core.PrimitiveArray;
import com.aliyun.odps.simpleframework.xml.core.Qualifier;
import com.aliyun.odps.simpleframework.xml.core.TemplateLabel;
import com.aliyun.odps.simpleframework.xml.strategy.Type;
import com.aliyun.odps.simpleframework.xml.stream.Format;
import com.aliyun.odps.simpleframework.xml.stream.Style;
import java.lang.annotation.Annotation;

class ElementArrayLabel
extends TemplateLabel {
    private Decorator decorator;
    private ElementArray label;
    private Introspector detail;
    private Expression path;
    private Format format;
    private Class type;
    private String entry;
    private String name;
    private boolean required;
    private boolean data;

    public ElementArrayLabel(Contact contact, ElementArray label, Format format) {
        this.detail = new Introspector(contact, this, format);
        this.decorator = new Qualifier(contact);
        this.required = label.required();
        this.type = contact.getType();
        this.entry = label.entry();
        this.data = label.data();
        this.name = label.name();
        this.format = format;
        this.label = label;
    }

    @Override
    public Decorator getDecorator() throws Exception {
        return this.decorator;
    }

    @Override
    public Converter getConverter(Context context) throws Exception {
        Contact contact = this.getContact();
        String entry = this.getEntry();
        if (!this.type.isArray()) {
            throw new InstantiationException("Type is not an array %s for %s", this.type, contact);
        }
        return this.getConverter(context, entry);
    }

    private Converter getConverter(Context context, String name) throws Exception {
        Type entry = this.getDependent();
        Contact type = this.getContact();
        if (!context.isPrimitive(entry)) {
            return new CompositeArray(context, type, entry, name);
        }
        return new PrimitiveArray(context, type, entry, name);
    }

    @Override
    public Object getEmpty(Context context) throws Exception {
        ClassType array = new ClassType(this.type);
        ArrayFactory factory = new ArrayFactory(context, array);
        if (!this.label.empty()) {
            return ((Factory)factory).getInstance();
        }
        return null;
    }

    @Override
    public String getEntry() throws Exception {
        Style style = this.format.getStyle();
        if (this.detail.isEmpty(this.entry)) {
            this.entry = this.detail.getEntry();
        }
        return style.getElement(this.entry);
    }

    @Override
    public String getName() throws Exception {
        Style style = this.format.getStyle();
        String name = this.detail.getName();
        return style.getElement(name);
    }

    @Override
    public String getPath() throws Exception {
        Expression path = this.getExpression();
        String name = this.getName();
        return path.getElement(name);
    }

    @Override
    public Expression getExpression() throws Exception {
        if (this.path == null) {
            this.path = this.detail.getExpression();
        }
        return this.path;
    }

    @Override
    public Annotation getAnnotation() {
        return this.label;
    }

    @Override
    public Type getDependent() {
        Class<?> entry = this.type.getComponentType();
        if (entry == null) {
            return new ClassType(this.type);
        }
        return new ClassType(entry);
    }

    @Override
    public Class getType() {
        return this.type;
    }

    @Override
    public Contact getContact() {
        return this.detail.getContact();
    }

    @Override
    public String getOverride() {
        return this.name;
    }

    @Override
    public boolean isRequired() {
        return this.required;
    }

    @Override
    public boolean isData() {
        return this.data;
    }

    @Override
    public String toString() {
        return this.detail.toString();
    }
}

