/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.odps.simpleframework.xml.core;

import com.aliyun.odps.simpleframework.xml.core.CollectionFactory;
import com.aliyun.odps.simpleframework.xml.core.Context;
import com.aliyun.odps.simpleframework.xml.core.Converter;
import com.aliyun.odps.simpleframework.xml.core.Instance;
import com.aliyun.odps.simpleframework.xml.core.PersistenceException;
import com.aliyun.odps.simpleframework.xml.core.Traverser;
import com.aliyun.odps.simpleframework.xml.strategy.Type;
import com.aliyun.odps.simpleframework.xml.stream.InputNode;
import com.aliyun.odps.simpleframework.xml.stream.OutputNode;
import java.util.Collection;

class CompositeList
implements Converter {
    private final CollectionFactory factory;
    private final Traverser root;
    private final String name;
    private final Type entry;
    private final Type type;

    public CompositeList(Context context, Type type, Type entry, String name) {
        this.factory = new CollectionFactory(context, type);
        this.root = new Traverser(context);
        this.entry = entry;
        this.type = type;
        this.name = name;
    }

    @Override
    public Object read(InputNode node) throws Exception {
        Instance type = this.factory.getInstance(node);
        Object list = type.getInstance();
        if (!type.isReference()) {
            return this.populate(node, list);
        }
        return list;
    }

    @Override
    public Object read(InputNode node, Object result) throws Exception {
        Instance type = this.factory.getInstance(node);
        if (type.isReference()) {
            return type.getInstance();
        }
        type.setInstance(result);
        if (result != null) {
            return this.populate(node, result);
        }
        return result;
    }

    private Object populate(InputNode node, Object result) throws Exception {
        Collection list = (Collection)result;
        while (true) {
            InputNode next = node.getNext();
            Class expect = this.entry.getType();
            if (next == null) {
                return list;
            }
            list.add(this.root.read(next, expect));
        }
    }

    @Override
    public boolean validate(InputNode node) throws Exception {
        Instance value = this.factory.getInstance(node);
        if (!value.isReference()) {
            Object result = value.setInstance(null);
            Class type = value.getType();
            return this.validate(node, type);
        }
        return true;
    }

    private boolean validate(InputNode node, Class type) throws Exception {
        while (true) {
            InputNode next = node.getNext();
            Class expect = this.entry.getType();
            if (next == null) {
                return true;
            }
            this.root.validate(next, expect);
        }
    }

    @Override
    public void write(OutputNode node, Object source) throws Exception {
        Collection list = (Collection)source;
        for (Object item : list) {
            Class<?> actual;
            if (item == null) continue;
            Class expect = this.entry.getType();
            if (!expect.isAssignableFrom(actual = item.getClass())) {
                throw new PersistenceException("Entry %s does not match %s for %s", actual, this.entry, this.type);
            }
            this.root.write(node, item, expect, this.name);
        }
    }
}

