/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.odps.data.converter;

import com.aliyun.odps.Column;
import com.aliyun.odps.OdpsType;
import com.aliyun.odps.data.ArrayRecord;
import com.aliyun.odps.data.Record;
import com.aliyun.odps.data.converter.ObjectConverterFactory;
import com.aliyun.odps.data.converter.OdpsObjectConverter;
import com.aliyun.odps.data.converter.OdpsRecordConverter;
import java.time.ZoneId;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;

public class OdpsRecordConverterBuilder {
    private final Config config = new Config();
    private Function<Column[], Record> recordProvider;
    private final Map<OdpsType, OdpsObjectConverter> formatterMap = new HashMap<OdpsType, OdpsObjectConverter>();
    private static final OdpsType[] defaultSupportedTypes = new OdpsType[]{OdpsType.TINYINT, OdpsType.SMALLINT, OdpsType.INT, OdpsType.BIGINT, OdpsType.CHAR, OdpsType.VARCHAR, OdpsType.STRING, OdpsType.FLOAT, OdpsType.DOUBLE, OdpsType.DECIMAL, OdpsType.DATE, OdpsType.DATETIME, OdpsType.TIMESTAMP, OdpsType.TIMESTAMP_NTZ, OdpsType.BOOLEAN, OdpsType.BINARY, OdpsType.JSON, OdpsType.ARRAY, OdpsType.MAP, OdpsType.STRUCT};

    OdpsRecordConverterBuilder() {
    }

    public OdpsRecordConverterBuilder floatingNumberFormatCompatible() {
        this.config.floatingNumberOutputFormat = "sql_compatible";
        return this;
    }

    public OdpsRecordConverterBuilder floatingNumberFormatToString() {
        this.config.floatingNumberOutputFormat = "to_string";
        return this;
    }

    public OdpsRecordConverterBuilder decimalFormatWithZeroPadding() {
        this.config.decimalOutputFormat = "zero_padding";
        return this;
    }

    public OdpsRecordConverterBuilder decimalFormatWithoutZeroPadding() {
        this.config.decimalOutputFormat = "non_zero_padding";
        return this;
    }

    public OdpsRecordConverterBuilder dateFormat(String format) {
        this.config.dateParseFormat = format;
        this.config.dateOutputFormat = format;
        return this;
    }

    public OdpsRecordConverterBuilder dateFormat(String parseFormat, String outputFormat) {
        this.config.dateParseFormat = parseFormat;
        this.config.dateOutputFormat = outputFormat;
        return this;
    }

    public OdpsRecordConverterBuilder datetimeFormat(String format) {
        this.config.datetimeOutputFormat = format;
        this.config.datetimeParseFormat = format;
        return this;
    }

    public OdpsRecordConverterBuilder datetimeFormat(String parseFormat, String outputFormat) {
        this.config.datetimeOutputFormat = outputFormat;
        this.config.datetimeParseFormat = parseFormat;
        return this;
    }

    public OdpsRecordConverterBuilder timestampFormat(String format) {
        this.config.timestampOutputFormat = format;
        this.config.timestampParseFormat = format;
        return this;
    }

    public OdpsRecordConverterBuilder timestampFormat(String parseFormat, String outputFormat) {
        this.config.timestampOutputFormat = outputFormat;
        this.config.timestampParseFormat = parseFormat;
        return this;
    }

    public OdpsRecordConverterBuilder timestampNtzFormat(String format) {
        this.config.timestampNtzOutputFormat = format;
        this.config.timestampNtzParseFormat = format;
        return this;
    }

    public OdpsRecordConverterBuilder timestampNtzFormat(String parseFormat, String outputFormat) {
        this.config.timestampNtzParseFormat = parseFormat;
        this.config.timestampNtzOutputFormat = outputFormat;
        return this;
    }

    public OdpsRecordConverterBuilder timezone(String timezone) {
        this.config.timezone = ZoneId.of(timezone);
        return this;
    }

    public OdpsRecordConverterBuilder complexFormatJson() {
        this.config.complexTypeFormat = "json";
        return this;
    }

    public OdpsRecordConverterBuilder complexFormatJsonStr() {
        this.config.complexTypeFormat = "json_str";
        return this;
    }

    public OdpsRecordConverterBuilder complexFormatHumanReadable() {
        this.config.complexTypeFormat = "human_readable";
        return this;
    }

    public OdpsRecordConverterBuilder binaryFormatQuotedPrintable() {
        this.config.binaryFormat = "quoted_printable";
        return this;
    }

    public OdpsRecordConverterBuilder binaryFormatUtf8() {
        this.config.binaryFormat = "utf8";
        return this;
    }

    public OdpsRecordConverterBuilder binaryFormatBase64() {
        this.config.binaryFormat = "base64";
        return this;
    }

    public OdpsRecordConverterBuilder nullFormat(String format) {
        this.config.nullFormat = format;
        return this;
    }

    public OdpsRecordConverterBuilder enableParseNull() {
        this.config.enableNullParse = true;
        return this;
    }

    public OdpsRecordConverterBuilder disableParseNull() {
        this.config.enableNullParse = false;
        return this;
    }

    public OdpsRecordConverterBuilder useLegacyTimeType() {
        this.config.legacyTimeType = true;
        return this;
    }

    public OdpsRecordConverterBuilder registerRecordProvider(Function<Column[], Record> recordProvider) {
        this.recordProvider = recordProvider;
        return this;
    }

    public OdpsRecordConverterBuilder register(OdpsType odpsType, OdpsObjectConverter converter) {
        this.formatterMap.put(odpsType, converter);
        return this;
    }

    public OdpsRecordConverter build() {
        for (OdpsType odpsType : defaultSupportedTypes) {
            if (this.formatterMap.containsKey(odpsType)) continue;
            this.formatterMap.put(odpsType, ObjectConverterFactory.getFormatter(odpsType, this.config));
        }
        if (this.recordProvider == null) {
            this.recordProvider = ArrayRecord::new;
        }
        return new OdpsRecordConverter(this.config, this.recordProvider, this.formatterMap);
    }

    static class Config {
        String decimalOutputFormat = "non_zero_padding";
        String floatingNumberOutputFormat = "to_string";
        String dateParseFormat;
        String dateOutputFormat;
        String datetimeParseFormat;
        String datetimeOutputFormat;
        String timestampParseFormat;
        String timestampOutputFormat;
        String timestampNtzParseFormat;
        String timestampNtzOutputFormat;
        ZoneId timezone = ZoneId.systemDefault();
        String complexTypeFormat = "json";
        String binaryFormat = "quoted_printable";
        String nullFormat = "NULL";
        boolean enableNullParse = false;
        boolean legacyTimeType = false;

        Config() {
        }
    }
}

