/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.odps.data.converter;

import com.aliyun.odps.OdpsType;
import com.aliyun.odps.data.Binary;
import com.aliyun.odps.data.Char;
import com.aliyun.odps.data.SimpleJsonValue;
import com.aliyun.odps.data.Varchar;
import com.aliyun.odps.data.converter.ComplexObjectConverter;
import com.aliyun.odps.data.converter.OdpsObjectConverter;
import com.aliyun.odps.data.converter.OdpsRecordConverter;
import com.aliyun.odps.data.converter.OdpsRecordConverterBuilder;
import com.aliyun.odps.type.DecimalTypeInfo;
import com.aliyun.odps.type.TypeInfo;
import java.math.BigDecimal;
import java.math.MathContext;
import java.math.RoundingMode;
import java.nio.charset.StandardCharsets;
import java.sql.Date;
import java.sql.Timestamp;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.format.DateTimeParseException;
import java.time.format.ResolverStyle;
import java.time.temporal.ChronoField;
import java.util.Base64;

class ObjectConverterFactory {
    ObjectConverterFactory() {
    }

    static OdpsObjectConverter getFormatter(OdpsType odpsType, OdpsRecordConverterBuilder.Config config) {
        switch (odpsType) {
            case TINYINT: {
                return TinyIntConverter.INSTANCE;
            }
            case SMALLINT: {
                return SmallIntConverter.INSTANCE;
            }
            case INT: {
                return IntConverter.INSTANCE;
            }
            case BIGINT: {
                return BigIntConverter.INSTANCE;
            }
            case CHAR: {
                return CharConverter.INSTANCE;
            }
            case VARCHAR: {
                return VarcharConverter.INSTANCE;
            }
            case STRING: {
                return StringConverter.INSTANCE;
            }
            case FLOAT: {
                switch (config.floatingNumberOutputFormat) {
                    case "to_string": {
                        return FloatConverter.TO_STRING;
                    }
                    case "sql_compatible": {
                        return FloatConverter.SQL_COMPATIBLE;
                    }
                }
                throw new IllegalArgumentException("unsupported float format type");
            }
            case JSON: {
                return JsonConverter.INSTANCE;
            }
            case BOOLEAN: {
                return BooleanConverter.INSTANCE;
            }
            case DOUBLE: {
                switch (config.floatingNumberOutputFormat) {
                    case "to_string": {
                        return DoubleConverter.TO_STRING;
                    }
                    case "sql_compatible": {
                        return DoubleConverter.SQL_COMPATIBLE;
                    }
                }
                throw new IllegalArgumentException("unsupported double format type");
            }
            case DECIMAL: {
                switch (config.decimalOutputFormat) {
                    case "non_zero_padding": {
                        return DecimalConverter.NO_PADDING;
                    }
                    case "zero_padding": {
                        return DecimalConverter.PADDING;
                    }
                }
                throw new IllegalArgumentException("unsupported decimal format type");
            }
            case DATE: {
                return new DateConverter(config.dateOutputFormat, config.dateParseFormat, config.legacyTimeType);
            }
            case DATETIME: {
                return new DatetimeConverter(config.datetimeOutputFormat, config.datetimeParseFormat, config.timezone, config.legacyTimeType);
            }
            case TIMESTAMP: {
                return new TimestampConverter(config.timestampOutputFormat, config.timestampParseFormat, config.timezone, config.legacyTimeType);
            }
            case TIMESTAMP_NTZ: {
                return new TimestampNtzConverter(config.timestampNtzOutputFormat, config.timestampNtzParseFormat);
            }
            case BINARY: {
                switch (config.binaryFormat) {
                    case "base64": {
                        return BinaryConverter.BASE64;
                    }
                    case "utf8": {
                        return BinaryConverter.UTF8;
                    }
                    case "quoted_printable": {
                        return BinaryConverter.QUOTED_PRINTABLE;
                    }
                }
            }
            case ARRAY: 
            case MAP: 
            case STRUCT: {
                switch (config.complexTypeFormat) {
                    case "json": {
                        return ComplexObjectConverter.JSON;
                    }
                    case "json_str": {
                        return ComplexObjectConverter.JSON_ALL_STR;
                    }
                    case "human_readable": {
                        return ComplexObjectConverter.HUMAN_READABLE;
                    }
                }
            }
        }
        throw new IllegalArgumentException("unsupported data type");
    }

    private static DateTimeFormatter getDateTimeFormatter(String pattern, ZoneId zoneId, OdpsType odpsType) {
        try {
            DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern(pattern);
            if (zoneId != null) {
                dateTimeFormatter = dateTimeFormatter.withZone(zoneId);
            }
            return dateTimeFormatter.withResolverStyle(ResolverStyle.LENIENT);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("DateTime format for " + odpsType + " illegal: " + pattern);
        }
    }

    private static SimpleDateFormat getLegacyDateTimeFormatter(String pattern, OdpsType odpsType) {
        try {
            pattern = pattern.replace("u", "y");
            return new SimpleDateFormat(pattern);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("DateTime format for " + odpsType + " illegal: " + pattern);
        }
    }

    private static boolean isNan(String value) {
        return value.equalsIgnoreCase("nan") || value.equalsIgnoreCase("+nan") || value.equalsIgnoreCase("-nan");
    }

    private static boolean isPositiveInfinity(String value) {
        return value.equalsIgnoreCase("infinity") || value.equalsIgnoreCase("+infinity") || value.equalsIgnoreCase("inf") || value.equalsIgnoreCase("+inf");
    }

    static boolean isNegativeInfinity(String value) {
        return value.equalsIgnoreCase("-infinity") || value.equalsIgnoreCase("-inf");
    }

    private static class TimestampNtzConverter
    extends AbstractTimestampFormatter {
        TimestampNtzConverter(String outputPattern, String parsePattern) {
            if (outputPattern != null) {
                this.outputFormatter = ObjectConverterFactory.getDateTimeFormatter(outputPattern, null, OdpsType.TIMESTAMP_NTZ);
            }
            if (parsePattern != null) {
                this.parseFormatter = ObjectConverterFactory.getDateTimeFormatter(outputPattern, null, OdpsType.TIMESTAMP_NTZ);
            }
        }

        @Override
        public String format(Object object, TypeInfo typeInfo, OdpsRecordConverter converter) {
            LocalDateTime localDateTime = (LocalDateTime)object;
            return localDateTime.format(this.outputFormatter);
        }

        @Override
        public Object parse(String str, TypeInfo typeInfo, OdpsRecordConverter converter) {
            return LocalDateTime.parse(str, this.parseFormatter);
        }
    }

    private static class TimestampConverter
    extends AbstractTimestampFormatter {
        private boolean isLegacyType;

        TimestampConverter(String outputPattern, String parsePattern, ZoneId timezone, boolean isLegacyType) {
            this.isLegacyType = isLegacyType;
            this.outputFormatter = outputPattern != null ? ObjectConverterFactory.getDateTimeFormatter(outputPattern, timezone, OdpsType.TIMESTAMP) : this.outputFormatter.withZone(timezone);
            this.parseFormatter = parsePattern != null ? ObjectConverterFactory.getDateTimeFormatter(parsePattern, timezone, OdpsType.TIMESTAMP) : this.parseFormatter.withZone(timezone);
        }

        @Override
        public String format(Object object, TypeInfo typeInfo, OdpsRecordConverter converter) {
            if (this.isLegacyType) {
                Timestamp timestamp = (Timestamp)object;
                String output = timestamp.toString();
                return timestamp.getNanos() == 0 ? output.substring(0, output.length() - 2) : output;
            }
            Instant i = (Instant)object;
            return this.outputFormatter.format(i);
        }

        @Override
        public Object parse(String str, TypeInfo typeInfo, OdpsRecordConverter converter) {
            if (this.isLegacyType) {
                return Timestamp.valueOf(str);
            }
            return ZonedDateTime.parse(str, this.parseFormatter).toInstant();
        }
    }

    private static abstract class AbstractTimestampFormatter
    implements OdpsObjectConverter {
        DateTimeFormatter outputFormatter = new DateTimeFormatterBuilder().appendPattern("uuuu-MM-dd HH:mm:ss").appendFraction(ChronoField.NANO_OF_SECOND, 0, 9, true).toFormatter();
        DateTimeFormatter parseFormatter = new DateTimeFormatterBuilder().appendPattern("uuuu-M-d H:m:s").optionalStart().appendFraction(ChronoField.NANO_OF_SECOND, 0, 9, true).toFormatter().withResolverStyle(ResolverStyle.LENIENT);

        private AbstractTimestampFormatter() {
        }
    }

    private static class DatetimeConverter
    implements OdpsObjectConverter {
        private static final String DEFAULT_OUTPUT_PATTERN = "uuuu-MM-dd HH:mm:ss";
        private static final String DEFAULT_PARSE_PATTERN = "uuuu-M-d H:m:s";
        private static final DateTimeFormatter DEFAULT_PARSER = new DateTimeFormatterBuilder().appendPattern("uuuu-M-d H:m:s").optionalStart().appendFraction(ChronoField.NANO_OF_SECOND, 0, 9, true).toFormatter().withResolverStyle(ResolverStyle.LENIENT);
        private DateTimeFormatter outputFormatter;
        private DateTimeFormatter parseFormatter;
        private SimpleDateFormat legacyOutputFormatter;
        private SimpleDateFormat legacyParseFormatter;
        private boolean isLegacyType;

        DatetimeConverter(String outputPattern, String parsePattern, ZoneId zoneId, boolean isLegacyType) {
            this.isLegacyType = isLegacyType;
            if (null == outputPattern) {
                outputPattern = DEFAULT_OUTPUT_PATTERN;
            }
            if (null == parsePattern) {
                parsePattern = DEFAULT_PARSE_PATTERN;
                this.parseFormatter = DEFAULT_PARSER.withZone(zoneId);
            } else {
                this.parseFormatter = ObjectConverterFactory.getDateTimeFormatter(parsePattern, zoneId, OdpsType.DATETIME);
            }
            if (isLegacyType) {
                this.legacyOutputFormatter = ObjectConverterFactory.getLegacyDateTimeFormatter(outputPattern, OdpsType.DATETIME);
                this.legacyParseFormatter = ObjectConverterFactory.getLegacyDateTimeFormatter(parsePattern, OdpsType.DATETIME);
            } else {
                this.outputFormatter = ObjectConverterFactory.getDateTimeFormatter(outputPattern, zoneId, OdpsType.DATETIME);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public String format(Object object, TypeInfo typeInfo, OdpsRecordConverter converter) {
            if (this.isLegacyType) {
                java.util.Date date = (java.util.Date)object;
                SimpleDateFormat simpleDateFormat = this.legacyOutputFormatter;
                synchronized (simpleDateFormat) {
                    return this.legacyOutputFormatter.format(date);
                }
            }
            ZonedDateTime zdt = (ZonedDateTime)object;
            return zdt.format(this.outputFormatter);
        }

        @Override
        public Object parse(String str, TypeInfo typeInfo, OdpsRecordConverter converter) {
            if (this.isLegacyType) {
                try {
                    return this.legacyParseFormatter.parse(str);
                }
                catch (ParseException e) {
                    throw new DateTimeParseException(null, str, 0, e);
                }
            }
            ZonedDateTime zdt = ZonedDateTime.parse(str, this.parseFormatter);
            Instant instant = zdt.toInstant();
            instant = instant.minusNanos(instant.getNano() % 1000000);
            return ZonedDateTime.ofInstant(instant, this.parseFormatter.getZone());
        }
    }

    private static class DateConverter
    implements OdpsObjectConverter {
        private static final String DEFAULT_OUTPUT_PATTERN = "uuuu-MM-dd";
        private static final String DEFAULT_PARSE_PATTERN = "uuuu-M-d";
        private DateTimeFormatter outputFormatter;
        private DateTimeFormatter parseFormatter;
        private SimpleDateFormat legacyOutputFormatter;
        private SimpleDateFormat legacyParseFormatter;
        private boolean isLegacyType;

        DateConverter(String outputPattern, String parsePattern, boolean isLegacyType) {
            this.isLegacyType = isLegacyType;
            if (null == outputPattern) {
                outputPattern = DEFAULT_OUTPUT_PATTERN;
            }
            if (null == parsePattern) {
                parsePattern = DEFAULT_PARSE_PATTERN;
            }
            if (isLegacyType) {
                this.legacyOutputFormatter = ObjectConverterFactory.getLegacyDateTimeFormatter(outputPattern, OdpsType.DATE);
                this.legacyParseFormatter = ObjectConverterFactory.getLegacyDateTimeFormatter(parsePattern, OdpsType.DATE);
            } else {
                this.outputFormatter = ObjectConverterFactory.getDateTimeFormatter(outputPattern, null, OdpsType.DATE);
                this.parseFormatter = ObjectConverterFactory.getDateTimeFormatter(parsePattern, null, OdpsType.DATE);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public String format(Object object, TypeInfo typeInfo, OdpsRecordConverter converter) {
            if (this.isLegacyType) {
                Date date = (Date)object;
                SimpleDateFormat simpleDateFormat = this.legacyOutputFormatter;
                synchronized (simpleDateFormat) {
                    return this.legacyOutputFormatter.format(date);
                }
            }
            LocalDate localDate = (LocalDate)object;
            return localDate.format(this.outputFormatter);
        }

        @Override
        public Object parse(String str, TypeInfo typeInfo, OdpsRecordConverter converter) {
            if (this.isLegacyType) {
                try {
                    java.util.Date date = this.legacyParseFormatter.parse(str);
                    return new Date(date.getTime());
                }
                catch (ParseException e) {
                    throw new DateTimeParseException(null, str, 0, e);
                }
            }
            return LocalDate.parse(str, this.parseFormatter);
        }
    }

    private static enum JsonConverter implements OdpsObjectConverter
    {
        INSTANCE;


        @Override
        public String format(Object object, TypeInfo typeInfo, OdpsRecordConverter converter) {
            return object.toString();
        }

        @Override
        public Object parse(String str, TypeInfo typeInfo, OdpsRecordConverter converter) {
            return new SimpleJsonValue(str);
        }
    }

    private static enum BinaryConverter implements OdpsObjectConverter
    {
        BASE64("base64"),
        UTF8("utf8"),
        QUOTED_PRINTABLE("quoted_printable");

        private String type;

        private BinaryConverter(String type) {
            this.type = type.toLowerCase();
        }

        @Override
        public String format(Object object, TypeInfo typeInfo, OdpsRecordConverter converter) {
            Binary binary = (Binary)object;
            byte[] bytes = binary.data();
            switch (this.type) {
                case "utf8": {
                    return new String(bytes, StandardCharsets.UTF_8);
                }
                case "base64": {
                    return Base64.getEncoder().encodeToString(bytes);
                }
                case "quoted_printable": {
                    return binary.toString();
                }
            }
            throw new RuntimeException("Unsupported binary encode type: " + this.type);
        }

        @Override
        public Object parse(String str, TypeInfo typeInfo, OdpsRecordConverter converter) {
            switch (this.type) {
                case "utf8": {
                    return str.getBytes(StandardCharsets.UTF_8);
                }
                case "base64": {
                    return Base64.getDecoder().decode(str);
                }
            }
            throw new IllegalArgumentException();
        }
    }

    private static enum BooleanConverter implements OdpsObjectConverter
    {
        INSTANCE;


        @Override
        public String format(Object object, TypeInfo typeInfo, OdpsRecordConverter converter) {
            return object.toString();
        }

        @Override
        public Object parse(String str, TypeInfo typeInfo, OdpsRecordConverter converter) {
            return Boolean.parseBoolean(str);
        }
    }

    private static enum StringConverter implements OdpsObjectConverter
    {
        INSTANCE;


        @Override
        public String format(Object object, TypeInfo typeInfo, OdpsRecordConverter converter) {
            if (object instanceof byte[]) {
                return new String((byte[])object, StandardCharsets.UTF_8);
            }
            return (String)object;
        }

        @Override
        public Object parse(String str, TypeInfo typeInfo, OdpsRecordConverter converter) {
            return str;
        }
    }

    private static enum VarcharConverter implements OdpsObjectConverter
    {
        INSTANCE;


        @Override
        public String format(Object object, TypeInfo typeInfo, OdpsRecordConverter converter) {
            return object.toString();
        }

        @Override
        public Object parse(String str, TypeInfo typeInfo, OdpsRecordConverter converter) {
            return new Varchar(str);
        }
    }

    private static enum CharConverter implements OdpsObjectConverter
    {
        INSTANCE;


        @Override
        public String format(Object object, TypeInfo typeInfo, OdpsRecordConverter converter) {
            return object.toString();
        }

        @Override
        public Object parse(String str, TypeInfo typeInfo, OdpsRecordConverter converter) {
            return new Char(str);
        }
    }

    private static enum DecimalConverter implements OdpsObjectConverter
    {
        PADDING(true),
        NO_PADDING(false);

        private final boolean padding;

        private DecimalConverter(boolean padding) {
            this.padding = padding;
        }

        @Override
        public String format(Object object, TypeInfo typeInfo, OdpsRecordConverter converter) {
            BigDecimal decimal = (BigDecimal)object;
            if (this.padding) {
                DecimalTypeInfo decimalTypeInfo = (DecimalTypeInfo)typeInfo;
                decimal = decimal.setScale(decimalTypeInfo.getScale(), RoundingMode.HALF_DOWN);
                return decimal.toPlainString();
            }
            return decimal.stripTrailingZeros().toPlainString();
        }

        @Override
        public Object parse(String str, TypeInfo typeInfo, OdpsRecordConverter converter) {
            int typeIntLength;
            DecimalTypeInfo decimalTypeInfo = (DecimalTypeInfo)typeInfo;
            BigDecimal bigDecimal = new BigDecimal(str);
            int valueIntLength = bigDecimal.precision() - bigDecimal.scale();
            if (valueIntLength > (typeIntLength = decimalTypeInfo.getPrecision() - decimalTypeInfo.getScale())) {
                throw new IllegalArgumentException(String.format("InvalidData: decimal value %s overflow, max integer digit number is %s.", str, typeIntLength));
            }
            bigDecimal = bigDecimal.setScale(decimalTypeInfo.getScale(), RoundingMode.HALF_DOWN);
            return bigDecimal;
        }
    }

    private static class FloatingNumberFormatter {
        MathContext mathContext;
        DecimalFormat posScientificFormat;
        DecimalFormat negScientificFormat;
        int minFractionDigits;
        int maxFractionDigits;
        boolean appendZero;

        private void setExpSymbol(DecimalFormat format, String symbol) {
            DecimalFormatSymbols symbols = format.getDecimalFormatSymbols();
            symbols.setExponentSeparator(symbol);
            format.setDecimalFormatSymbols(symbols);
        }

        FloatingNumberFormatter(int precise, int minFractionDigits, int maxFractionDigits, String scientificFormatPattern, boolean expPlus, boolean appendZero) {
            this.mathContext = new MathContext(precise, RoundingMode.HALF_EVEN);
            this.posScientificFormat = new DecimalFormat(scientificFormatPattern);
            this.setExpSymbol(this.posScientificFormat, "e");
            this.negScientificFormat = new DecimalFormat(scientificFormatPattern);
            this.setExpSymbol(this.negScientificFormat, "e");
            if (expPlus) {
                this.setExpSymbol(this.posScientificFormat, "e+");
            }
            this.minFractionDigits = minFractionDigits;
            this.maxFractionDigits = maxFractionDigits;
            this.appendZero = appendZero;
        }

        private String format(double f) {
            if (!Double.isFinite(f)) {
                return Double.toString(f);
            }
            BigDecimal bigDecimal = new BigDecimal(String.valueOf(f));
            String eStr = String.format("%e", bigDecimal = bigDecimal.round(this.mathContext)).split("e")[1];
            int e = Integer.parseInt(eStr);
            if (e < this.minFractionDigits || e >= this.maxFractionDigits) {
                if (e >= 0) {
                    return this.posScientificFormat.format(bigDecimal);
                }
                return this.negScientificFormat.format(bigDecimal);
            }
            String result = bigDecimal.stripTrailingZeros().toPlainString();
            if (this.appendZero && !result.contains(".")) {
                result = result + ".0";
            }
            return result;
        }
    }

    private static enum FloatConverter implements OdpsObjectConverter
    {
        TO_STRING{

            @Override
            public String format(Object object, TypeInfo typeInfo, OdpsRecordConverter converter) {
                float f = ((Float)object).floatValue();
                return Float.toString(f);
            }
        }
        ,
        SQL_COMPATIBLE{
            private final FloatingNumberFormatter formatter = new FloatingNumberFormatter(7, -4, 7, "#.########E00", true, false);

            @Override
            public String format(Object object, TypeInfo typeInfo, OdpsRecordConverter converter) {
                double f = ((Float)object).floatValue();
                return this.formatter.format(f);
            }
        };


        @Override
        public Object parse(String str, TypeInfo typeInfo, OdpsRecordConverter converter) {
            if (ObjectConverterFactory.isNan(str)) {
                return Float.valueOf(Float.NaN);
            }
            if (ObjectConverterFactory.isPositiveInfinity(str)) {
                return Float.valueOf(Float.POSITIVE_INFINITY);
            }
            if (ObjectConverterFactory.isNegativeInfinity(str)) {
                return Float.valueOf(Float.NEGATIVE_INFINITY);
            }
            return Float.valueOf(Float.parseFloat(str));
        }
    }

    private static enum DoubleConverter implements OdpsObjectConverter
    {
        TO_STRING{

            @Override
            public String format(Object object, TypeInfo typeInfo, OdpsRecordConverter converter) {
                double value = (Double)object;
                return Double.toString(value);
            }
        }
        ,
        SQL_COMPATIBLE{
            private final FloatingNumberFormatter formatter = new FloatingNumberFormatter(17, -6, 20, "#.###################E00", false, true);

            @Override
            public String format(Object object, TypeInfo typeInfo, OdpsRecordConverter converter) {
                double d = (Double)object;
                return this.formatter.format(d);
            }
        };


        @Override
        public Object parse(String str, TypeInfo typeInfo, OdpsRecordConverter converter) {
            if (ObjectConverterFactory.isNan(str)) {
                return Double.NaN;
            }
            if (ObjectConverterFactory.isPositiveInfinity(str)) {
                return Double.POSITIVE_INFINITY;
            }
            if (ObjectConverterFactory.isNegativeInfinity(str)) {
                return Double.NEGATIVE_INFINITY;
            }
            return Double.parseDouble(str);
        }
    }

    private static enum BigIntConverter implements OdpsObjectConverter
    {
        INSTANCE;


        @Override
        public String format(Object object, TypeInfo typeInfo, OdpsRecordConverter converter) {
            return object.toString();
        }

        @Override
        public Object parse(String str, TypeInfo typeInfo, OdpsRecordConverter converter) {
            long longVal = Long.parseLong(str);
            if (Long.MIN_VALUE == longVal) {
                throw new IllegalArgumentException("InvalidData: Bigint out of range.");
            }
            return Long.valueOf(str);
        }
    }

    private static enum IntConverter implements OdpsObjectConverter
    {
        INSTANCE;


        @Override
        public String format(Object object, TypeInfo typeInfo, OdpsRecordConverter converter) {
            return object.toString();
        }

        @Override
        public Object parse(String str, TypeInfo typeInfo, OdpsRecordConverter converter) {
            return Integer.valueOf(str);
        }
    }

    private static enum SmallIntConverter implements OdpsObjectConverter
    {
        INSTANCE;


        @Override
        public String format(Object object, TypeInfo typeInfo, OdpsRecordConverter converter) {
            return object.toString();
        }

        @Override
        public Object parse(String str, TypeInfo typeInfo, OdpsRecordConverter converter) {
            return Short.valueOf(str);
        }
    }

    private static enum TinyIntConverter implements OdpsObjectConverter
    {
        INSTANCE;


        @Override
        public String format(Object object, TypeInfo typeInfo, OdpsRecordConverter converter) {
            return object.toString();
        }

        @Override
        public Object parse(String str, TypeInfo typeInfo, OdpsRecordConverter converter) {
            return Byte.valueOf(str);
        }
    }
}

