/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.odps.data.converter;

import com.aliyun.odps.OdpsType;
import com.aliyun.odps.data.SimpleStruct;
import com.aliyun.odps.data.Struct;
import com.aliyun.odps.data.converter.OdpsObjectConverter;
import com.aliyun.odps.data.converter.OdpsRecordConverter;
import com.aliyun.odps.type.ArrayTypeInfo;
import com.aliyun.odps.type.MapTypeInfo;
import com.aliyun.odps.type.StructTypeInfo;
import com.aliyun.odps.type.TypeInfo;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonPrimitive;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

enum ComplexObjectConverter implements OdpsObjectConverter
{
    JSON("json"),
    JSON_ALL_STR("json_str"),
    HUMAN_READABLE("human_readable");

    private final String type;
    private final boolean convertToString;

    private ComplexObjectConverter(String type) {
        this.type = type;
        this.convertToString = "json_str".equalsIgnoreCase(type);
    }

    @Override
    public String format(Object object, TypeInfo typeInfo, OdpsRecordConverter converter) {
        switch (this.type) {
            case "human_readable": {
                return this.humanReadableFormat(object, typeInfo, converter);
            }
            case "json": 
            case "json_str": {
                return this.convertToJson(object, typeInfo, converter).toString();
            }
        }
        throw new IllegalArgumentException();
    }

    @Override
    public Object parse(String str, TypeInfo typeInfo, OdpsRecordConverter converter) {
        switch (typeInfo.getOdpsType()) {
            case ARRAY: 
            case MAP: 
            case STRUCT: {
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        return this.parse(JsonParser.parseString((String)str), typeInfo, converter);
    }

    public Object parse(JsonElement jsonElement, TypeInfo typeInfo, OdpsRecordConverter formatter) {
        if (jsonElement.isJsonNull()) {
            return null;
        }
        switch (typeInfo.getOdpsType()) {
            case ARRAY: {
                if (!(formatter.objectConverterMap.get(OdpsType.ARRAY) instanceof ComplexObjectConverter)) {
                    return formatter.parseObject(jsonElement.getAsString(), typeInfo);
                }
                ArrayList<Object> result = new ArrayList<Object>();
                JsonArray jsonArray = jsonElement.getAsJsonArray();
                ArrayTypeInfo arrayTypeInfo = (ArrayTypeInfo)typeInfo;
                TypeInfo elementTypeInfo = arrayTypeInfo.getElementTypeInfo();
                for (JsonElement e : jsonArray) {
                    result.add(this.parse(e, elementTypeInfo, formatter));
                }
                return result;
            }
            case MAP: {
                if (!(formatter.objectConverterMap.get(OdpsType.MAP) instanceof ComplexObjectConverter)) {
                    return formatter.parseObject(jsonElement.getAsString(), typeInfo);
                }
                HashMap<Object, Object> resultMap = new HashMap<Object, Object>();
                JsonObject jsonObject = jsonElement.getAsJsonObject();
                MapTypeInfo mapTypeInfo = (MapTypeInfo)typeInfo;
                TypeInfo keyTypeInfo = mapTypeInfo.getKeyTypeInfo();
                TypeInfo valueTypeInfo = mapTypeInfo.getValueTypeInfo();
                for (Map.Entry entry : jsonObject.entrySet()) {
                    Object key = formatter.parseObject((String)entry.getKey(), keyTypeInfo);
                    Object value = this.parse((JsonElement)entry.getValue(), valueTypeInfo, formatter);
                    resultMap.put(key, value);
                }
                return resultMap;
            }
            case STRUCT: {
                if (!(formatter.objectConverterMap.get(OdpsType.STRUCT) instanceof ComplexObjectConverter)) {
                    return formatter.parseObject(jsonElement.getAsString(), typeInfo);
                }
                StructTypeInfo structTypeInfo = (StructTypeInfo)typeInfo;
                ArrayList<Object> values = new ArrayList<Object>();
                JsonObject struct = jsonElement.getAsJsonObject();
                for (int i = 0; i < structTypeInfo.getFieldCount(); ++i) {
                    String name = (String)structTypeInfo.getFieldNames().get(i);
                    TypeInfo valueType = (TypeInfo)structTypeInfo.getFieldTypeInfos().get(i);
                    Object value = this.parse(struct.get(name), valueType, formatter);
                    values.add(value);
                }
                return new SimpleStruct(structTypeInfo, values);
            }
            case BOOLEAN: {
                if (!this.convertToString) {
                    return jsonElement.getAsBoolean();
                }
            }
            case TINYINT: {
                if (!this.convertToString) {
                    return jsonElement.getAsByte();
                }
            }
            case SMALLINT: {
                if (!this.convertToString) {
                    return jsonElement.getAsShort();
                }
            }
            case INT: {
                if (!this.convertToString) {
                    return jsonElement.getAsInt();
                }
            }
            case BIGINT: {
                if (!this.convertToString) {
                    return jsonElement.getAsLong();
                }
            }
            case FLOAT: {
                if (!this.convertToString) {
                    return Float.valueOf(jsonElement.getAsFloat());
                }
            }
            case DOUBLE: {
                if (!this.convertToString) {
                    return jsonElement.getAsDouble();
                }
            }
            case DECIMAL: {
                if (this.convertToString) break;
                return jsonElement.getAsBigDecimal();
            }
        }
        return formatter.parseObject(jsonElement.getAsString(), typeInfo);
    }

    private JsonElement convertToJson(final Object object, TypeInfo typeInfo, OdpsRecordConverter formatter) {
        if (object == null) {
            return JsonNull.INSTANCE;
        }
        switch (typeInfo.getOdpsType()) {
            case ARRAY: {
                if (formatter.objectConverterMap.get(OdpsType.ARRAY) != JSON && formatter.objectConverterMap.get(OdpsType.ARRAY) != JSON_ALL_STR) {
                    return new JsonPrimitive(formatter.formatObject(object, typeInfo));
                }
                JsonArray jsonArray = new JsonArray();
                ArrayTypeInfo arrayTypeInfo = (ArrayTypeInfo)typeInfo;
                TypeInfo elementType = arrayTypeInfo.getElementTypeInfo();
                List list = (List)object;
                for (Object listItem : list) {
                    JsonElement element = this.convertToJson(listItem, elementType, formatter);
                    jsonArray.add(element);
                }
                return jsonArray;
            }
            case MAP: {
                if (formatter.objectConverterMap.get(OdpsType.MAP) != JSON && formatter.objectConverterMap.get(OdpsType.MAP) != JSON_ALL_STR) {
                    return new JsonPrimitive(formatter.formatObject(object, typeInfo));
                }
                JsonObject jsonObject = new JsonObject();
                MapTypeInfo mapTypeInfo = (MapTypeInfo)typeInfo;
                TypeInfo keyInfo = mapTypeInfo.getKeyTypeInfo();
                TypeInfo valueInfo = mapTypeInfo.getValueTypeInfo();
                Map map = (Map)object;
                Iterator iterator = map.entrySet().iterator();
                while (iterator.hasNext()) {
                    Map.Entry entryObject;
                    Map.Entry entry = entryObject = iterator.next();
                    String keyString = formatter.formatObject(entry.getKey(), keyInfo);
                    JsonElement valString = this.convertToJson(entry.getValue(), valueInfo, formatter);
                    jsonObject.add(keyString, valString);
                }
                return jsonObject;
            }
            case STRUCT: {
                if (formatter.objectConverterMap.get(OdpsType.STRUCT) != JSON && formatter.objectConverterMap.get(OdpsType.STRUCT) != JSON_ALL_STR) {
                    return new JsonPrimitive(formatter.formatObject(object, typeInfo));
                }
                JsonObject jsonStruct = new JsonObject();
                SimpleStruct struct = (SimpleStruct)object;
                for (int i = 0; i < struct.getFieldCount(); ++i) {
                    TypeInfo fieldType = struct.getFieldTypeInfo(i);
                    String key = struct.getFieldName(i);
                    Object value = struct.getFieldValue(i);
                    jsonStruct.add(key, this.convertToJson(value, fieldType, formatter));
                }
                return jsonStruct;
            }
            case BOOLEAN: {
                if (this.convertToString) {
                    return new JsonPrimitive(formatter.formatObject(object, typeInfo));
                }
                return new JsonPrimitive((Boolean)object);
            }
            case TINYINT: 
            case SMALLINT: 
            case INT: 
            case BIGINT: 
            case FLOAT: 
            case DOUBLE: {
                if (this.convertToString) {
                    return new JsonPrimitive(formatter.formatObject(object, typeInfo));
                }
                return new JsonPrimitive((Number)object);
            }
            case DECIMAL: {
                if (this.convertToString) {
                    return new JsonPrimitive(formatter.formatObject(object, typeInfo));
                }
                Number n = new Number(){

                    @Override
                    public int intValue() {
                        return 0;
                    }

                    @Override
                    public long longValue() {
                        return 0L;
                    }

                    @Override
                    public float floatValue() {
                        return 0.0f;
                    }

                    @Override
                    public double doubleValue() {
                        return 0.0;
                    }

                    public String toString() {
                        return ((BigDecimal)object).stripTrailingZeros().toPlainString();
                    }
                };
                return new JsonPrimitive(n);
            }
            case DATE: 
            case DATETIME: 
            case TIMESTAMP: 
            case TIMESTAMP_NTZ: 
            case BINARY: 
            case CHAR: 
            case VARCHAR: 
            case STRING: {
                return new JsonPrimitive(formatter.formatObject(object, typeInfo));
            }
        }
        throw new IllegalArgumentException("unsupported odpstype: " + typeInfo);
    }

    private String humanReadableFormat(Object object, TypeInfo typeInfo, OdpsRecordConverter formatter) {
        if (object == null) {
            return "null";
        }
        StringBuilder sb = new StringBuilder();
        switch (typeInfo.getOdpsType()) {
            case ARRAY: {
                if (formatter.objectConverterMap.get(OdpsType.ARRAY) != HUMAN_READABLE) {
                    return formatter.formatObject(object, typeInfo);
                }
                ArrayTypeInfo arrayTypeInfo = (ArrayTypeInfo)typeInfo;
                List list = (List)object;
                sb.append("[");
                for (int i = 0; i < list.size(); ++i) {
                    Object element = list.get(i);
                    sb.append(formatter.formatObject(element, arrayTypeInfo.getElementTypeInfo()));
                    if (i >= list.size() - 1) continue;
                    sb.append(", ");
                }
                return sb.append("]").toString();
            }
            case MAP: {
                if (formatter.objectConverterMap.get(OdpsType.MAP) != HUMAN_READABLE) {
                    return formatter.formatObject(object, typeInfo);
                }
                MapTypeInfo mapTypeInfo = (MapTypeInfo)typeInfo;
                Map map = (Map)object;
                sb.append("{");
                TypeInfo keyTypeInfo = mapTypeInfo.getKeyTypeInfo();
                TypeInfo valueTypeInfo = mapTypeInfo.getValueTypeInfo();
                int cnt = 0;
                int size = map.entrySet().size();
                Iterator iterator = map.entrySet().iterator();
                while (iterator.hasNext()) {
                    Map.Entry entry;
                    Map.Entry entry1 = entry = iterator.next();
                    Object key = entry1.getKey();
                    Object value = entry1.getValue();
                    sb.append(formatter.formatObject(key, keyTypeInfo));
                    sb.append(":");
                    sb.append(formatter.formatObject(value, valueTypeInfo));
                    if (cnt < size - 1) {
                        sb.append(", ");
                    }
                    ++cnt;
                }
                return sb.append("}").toString();
            }
            case STRUCT: {
                if (formatter.objectConverterMap.get(OdpsType.STRUCT) != HUMAN_READABLE) {
                    return formatter.formatObject(object, typeInfo);
                }
                Struct struct = (Struct)object;
                sb.append("{");
                StructTypeInfo structTypeInfo = (StructTypeInfo)typeInfo;
                for (int i = 0; i < structTypeInfo.getFieldCount(); ++i) {
                    String name = struct.getFieldName(i);
                    TypeInfo typeInfo1 = struct.getFieldTypeInfo(i);
                    sb.append(name).append(":");
                    String valueFormat = formatter.formatObject(struct.getFieldValue(i), typeInfo1);
                    sb.append(valueFormat);
                    if (i >= struct.getFieldCount() - 1) continue;
                    sb.append(", ");
                }
                return sb.append("}").toString();
            }
        }
        throw new IllegalArgumentException("not supported type");
    }
}

