/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.odps.data;

import com.aliyun.odps.data.JsonValue;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.Serializable;

public class SimpleJsonValue
implements JsonValue,
Serializable {
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    private String stringValue;
    private transient JsonNode value;

    public SimpleJsonValue(String value) {
        this(value, false);
    }

    public SimpleJsonValue(String value, boolean validate) {
        this.stringValue = value;
        if (validate) {
            this.lazyLoad();
        }
    }

    public SimpleJsonValue(JsonNode jsonNode) {
        this.stringValue = jsonNode.toString();
        this.value = jsonNode;
    }

    public int size() {
        this.lazyLoad();
        if (!this.value.isArray()) {
            throw new UnsupportedOperationException();
        }
        ArrayNode arrayNode = (ArrayNode)this.value;
        return arrayNode.size();
    }

    private void lazyLoad() {
        if (this.value == null) {
            try {
                this.value = OBJECT_MAPPER.readTree(this.stringValue);
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Illegal argument for JsonValue value.");
            }
        }
    }

    public boolean isJsonPrimitive() {
        this.lazyLoad();
        return !this.value.isArray() && !this.value.isObject();
    }

    public boolean isJsonArray() {
        this.lazyLoad();
        return this.value.isArray();
    }

    public boolean isJsonObject() {
        this.lazyLoad();
        return this.value.isObject();
    }

    public boolean isJsonNull() {
        this.lazyLoad();
        return this.value.isNull();
    }

    public JsonValue get(int index) {
        this.lazyLoad();
        if (!this.isJsonArray()) {
            throw new UnsupportedOperationException();
        }
        ArrayNode arrayNode = (ArrayNode)this.value;
        return new SimpleJsonValue(arrayNode.get(index));
    }

    public JsonValue get(String filedName) {
        this.lazyLoad();
        if (!this.isJsonObject()) {
            throw new UnsupportedOperationException();
        }
        ObjectNode objectNode = (ObjectNode)this.value;
        return new SimpleJsonValue(objectNode.get(filedName));
    }

    public Boolean getAsBoolean() {
        this.lazyLoad();
        if (!this.value.isBoolean()) {
            throw new UnsupportedOperationException();
        }
        return this.value.asBoolean();
    }

    public Number getAsNumber() {
        this.lazyLoad();
        if (!this.value.isNumber()) {
            throw new UnsupportedOperationException();
        }
        return new Number(){
            private static final long serialVersionUID = -8816955119176578371L;

            @Override
            public int intValue() {
                return SimpleJsonValue.this.value.asInt();
            }

            @Override
            public long longValue() {
                return SimpleJsonValue.this.value.asLong();
            }

            @Override
            public float floatValue() {
                return (float)SimpleJsonValue.this.value.asDouble();
            }

            @Override
            public double doubleValue() {
                return SimpleJsonValue.this.value.asDouble();
            }
        };
    }

    public String getAsString() {
        this.lazyLoad();
        if (!this.value.isTextual()) {
            throw new UnsupportedOperationException();
        }
        return this.value.asText();
    }

    public String toString() {
        return this.stringValue;
    }
}

