/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.odps.data;

import com.aliyun.odps.data.Record;
import java.io.Closeable;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;

public interface RecordReader
extends Closeable,
Iterable<Record> {
    public Record read() throws IOException;

    @Override
    default public Iterator<Record> iterator() {
        return new Iterator<Record>(){
            private Record nextRecord;
            {
                try {
                    this.nextRecord = RecordReader.this.read();
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            }

            @Override
            public boolean hasNext() {
                return this.nextRecord != null;
            }

            @Override
            public Record next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                Record current = this.nextRecord;
                try {
                    this.nextRecord = RecordReader.this.read();
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
                return current;
            }
        };
    }

    default public Stream<Record> stream() {
        return StreamSupport.stream(this.spliterator(), false);
    }
}

