/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.odps;

import com.aliyun.odps.Column;
import com.aliyun.odps.Instance;
import com.aliyun.odps.ListIterator;
import com.aliyun.odps.NoSuchObjectException;
import com.aliyun.odps.Odps;
import com.aliyun.odps.OdpsException;
import com.aliyun.odps.Table;
import com.aliyun.odps.TableFilter;
import com.aliyun.odps.TableSchema;
import com.aliyun.odps.rest.ResourceBuilder;
import com.aliyun.odps.rest.RestClient;
import com.aliyun.odps.rest.SimpleXmlUtils;
import com.aliyun.odps.simpleframework.xml.Element;
import com.aliyun.odps.simpleframework.xml.ElementList;
import com.aliyun.odps.simpleframework.xml.Root;
import com.aliyun.odps.simpleframework.xml.convert.Convert;
import com.aliyun.odps.table.utils.Preconditions;
import com.aliyun.odps.task.SQLTask;
import com.aliyun.odps.utils.ExceptionUtils;
import com.aliyun.odps.utils.NameSpaceSchemaUtils;
import com.aliyun.odps.utils.StringUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class Tables
implements Iterable<Table> {
    private RestClient client;
    private Odps odps;

    Tables(Odps odps) {
        this.odps = odps;
        this.client = odps.getRestClient();
    }

    public Table get(String tableName) {
        return this.get(this.getDefaultProjectName(), tableName);
    }

    public Table get(String projectName, String tableName) {
        return this.get(projectName, this.odps.getCurrentSchema(), tableName);
    }

    public Table get(String projectName, String schemaName, String tableName) {
        Table.TableModel model = new Table.TableModel();
        model.name = tableName;
        return new Table(model, projectName, schemaName, this.odps);
    }

    public boolean exists(String tableName) throws OdpsException {
        return this.exists(this.getDefaultProjectName(), tableName);
    }

    public boolean exists(String projectName, String tableName) throws OdpsException {
        return this.exists(projectName, this.odps.getCurrentSchema(), tableName);
    }

    public boolean exists(String projectName, String schemaName, String tableName) throws OdpsException {
        if (StringUtils.isNullOrEmpty((String)tableName)) {
            return false;
        }
        try {
            Table t = this.get(projectName, schemaName, tableName);
            t.reload();
            return true;
        }
        catch (NoSuchObjectException e) {
            return false;
        }
    }

    @Override
    public Iterator<Table> iterator() {
        return this.iterator(this.getDefaultProjectName(), null);
    }

    public Iterator<Table> iterator(String projectName) {
        return this.iterator(projectName, null);
    }

    public Iterator<Table> iterator(TableFilter filter) {
        return this.iterator(this.getDefaultProjectName(), filter);
    }

    public Iterator<Table> iterator(String projectName, TableFilter filter) {
        return this.iterator(projectName, filter, false);
    }

    public Iterator<Table> iterator(String projectName, TableFilter filter, boolean extended) {
        return new TableListIterator(projectName, this.odps.getCurrentSchema(), filter, extended);
    }

    public Iterator<Table> iterator(String projectName, String schemaName, TableFilter filter, boolean extended) {
        return new TableListIterator(projectName, schemaName, filter, extended);
    }

    public Iterable<Table> iterable() {
        return this.iterable(this.getDefaultProjectName());
    }

    public Iterable<Table> iterable(String projectName) {
        return this.iterable(projectName, null);
    }

    public Iterable<Table> iterable(TableFilter filter) {
        return this.iterable(this.getDefaultProjectName(), filter);
    }

    public Iterable<Table> iterable(String projectName, TableFilter filter) {
        return this.iterable(projectName, filter, false);
    }

    public Iterable<Table> iterable(String projectName, TableFilter filter, boolean extended) {
        return this.iterable(projectName, this.odps.getCurrentSchema(), filter, extended);
    }

    public Iterable<Table> iterable(String projectName, String schemaName, TableFilter filter, boolean extended) {
        return () -> new TableListIterator(projectName, schemaName, filter, extended);
    }

    public void create(String tableName, TableSchema schema) throws OdpsException {
        this.create(this.client.getDefaultProject(), tableName, schema);
    }

    public void create(String tableName, TableSchema schema, boolean ifNotExists) throws OdpsException {
        this.create(this.client.getDefaultProject(), tableName, schema, ifNotExists);
    }

    public void create(String projectName, String tableName, TableSchema schema, boolean ifNotExists, Long shardNum, Long hubLifecycle) throws OdpsException {
        this.create(projectName, tableName, schema, null, ifNotExists, shardNum, hubLifecycle);
    }

    public void create(String projectName, String tableName, TableSchema schema) throws OdpsException {
        this.create(projectName, tableName, schema, false);
    }

    public void create(String projectName, String tableName, TableSchema schema, boolean ifNotExists) throws OdpsException {
        this.create(projectName, tableName, schema, null, ifNotExists);
    }

    public void create(String projectName, String tableName, TableSchema schema, String comment, boolean ifNotExists, Long shardNum, Long hubLifecycle) throws OdpsException {
        TableCreator tableCreator = this.newTableCreator(projectName, tableName, schema).withSchemaName(this.odps.getCurrentSchema()).withComment(comment).withShardNum(shardNum).withHubLifecycle(hubLifecycle);
        if (ifNotExists) {
            tableCreator = tableCreator.ifNotExists();
        }
        tableCreator.create();
    }

    public void create(String projectName, String tableName, TableSchema schema, String comment, boolean ifNotExists) throws OdpsException {
        this.createTableWithLifeCycle(projectName, tableName, schema, comment, ifNotExists, null);
    }

    public void createTableWithLifeCycle(String projectName, String tableName, TableSchema schema, String comment, boolean ifNotExists, Long lifeCycle) throws OdpsException {
        this.create(projectName, tableName, schema, comment, ifNotExists, lifeCycle, null, null);
    }

    public void create(String projectName, String tableName, TableSchema schema, String comment, boolean ifNotExists, Long lifeCycle, Map<String, String> hints, Map<String, String> aliases) throws OdpsException {
        this.create(projectName, this.odps.getCurrentSchema(), tableName, schema, comment, ifNotExists, lifeCycle, hints, aliases);
    }

    public void create(String projectName, String schemaName, String tableName, TableSchema schema, String comment, boolean ifNotExists, Long lifeCycle, Map<String, String> hints, Map<String, String> aliases) throws OdpsException {
        TableCreator tableCreator = this.newTableCreator(projectName, tableName, schema).withSchemaName(schemaName).withComment(comment).withLifeCycle(lifeCycle).withHints(hints).withAliases(aliases);
        if (ifNotExists) {
            tableCreator = tableCreator.ifNotExists();
        }
        tableCreator.create();
    }

    public void createExternal(String projectName, String tableName, TableSchema schema, String location, String storedBy, List<String> usingJars, Map<String, String> serdeProperties, String comment, boolean ifNotExists, Long lifeCycle, Map<String, String> hints, Map<String, String> aliases) throws OdpsException {
        this.createExternal(projectName, this.odps.getCurrentSchema(), tableName, schema, location, storedBy, usingJars, serdeProperties, comment, ifNotExists, lifeCycle, hints, aliases);
    }

    public void createExternal(String projectName, String schemaName, String tableName, TableSchema schema, String location, String storedBy, List<String> usingJars, Map<String, String> serdeProperties, String comment, boolean ifNotExists, Long lifeCycle, Map<String, String> hints, Map<String, String> aliases) throws OdpsException {
        TableCreator tableCreator = this.newTableCreator(projectName, tableName, schema).withSchemaName(schemaName).withJars(usingJars).withSerdeProperties(serdeProperties).withComment(comment).withLifeCycle(lifeCycle).withHints(hints).withAliases(aliases);
        if (ifNotExists) {
            tableCreator = tableCreator.ifNotExists();
        }
        tableCreator.createExternal(storedBy, location);
    }

    public void delete(String tableName) throws OdpsException {
        this.delete(this.client.getDefaultProject(), tableName);
    }

    public void delete(String tableName, boolean ifExists) throws OdpsException {
        this.delete(this.client.getDefaultProject(), tableName, ifExists);
    }

    public void delete(String projectName, String tableName) throws OdpsException {
        this.delete(projectName, tableName, false);
    }

    public void delete(String projectName, String tableName, boolean ifExists) throws OdpsException {
        this.delete(projectName, this.odps.getCurrentSchema(), tableName, ifExists);
    }

    public void delete(String projectName, String schemaName, String tableName, boolean ifExists) throws OdpsException {
        if (projectName == null || tableName == null) {
            throw new IllegalArgumentException("Argument 'projectName' or 'tableName' cannot be null");
        }
        StringBuilder sb = new StringBuilder();
        sb.append("DROP TABLE ");
        if (ifExists) {
            sb.append(" IF EXISTS ");
        }
        sb.append(NameSpaceSchemaUtils.getFullName(projectName, schemaName, tableName));
        sb.append(";");
        String taskName = "SQLDropTableTask";
        SQLTask task = new SQLTask();
        task.setName(taskName);
        task.setQuery(sb.toString());
        this.submitCreateAndWait(schemaName, sb.toString(), "SQLDropTableTask", null, null);
    }

    public List<Table> loadTables(Collection<String> tableNames) throws OdpsException {
        return this.loadTables(this.getDefaultProjectName(), tableNames);
    }

    public List<Table> loadTables(String projectName, Collection<String> tableNames) throws OdpsException {
        return this.loadTables(projectName, this.odps.getCurrentSchema(), tableNames);
    }

    public List<Table> loadTables(String projectName, String schemaName, Collection<String> tableNames) throws OdpsException {
        if (StringUtils.isNullOrEmpty((String)projectName)) {
            throw new IllegalArgumentException("Invalid project name.");
        }
        if (tableNames == null) {
            throw new IllegalArgumentException("Invalid table names.");
        }
        QueryTables queryTables = new QueryTables();
        for (String name : tableNames) {
            queryTables.tables.add(new QueryTables.QueryTable(projectName, schemaName, name));
        }
        return this.loadTablesInternal(queryTables);
    }

    public List<Table> reloadTables(Collection<Table> tables) throws OdpsException {
        if (tables == null) {
            throw new IllegalArgumentException("Invalid tables.");
        }
        return this.reloadTables(tables.iterator());
    }

    public List<Table> reloadTables(Iterator<Table> tables) throws OdpsException {
        if (tables == null) {
            throw new IllegalArgumentException("Invalid tables.");
        }
        ArrayList<Table> loadedTables = new ArrayList<Table>();
        if (!tables.hasNext()) {
            return loadedTables;
        }
        QueryTables queryTables = new QueryTables();
        while (tables.hasNext()) {
            Table t = tables.next();
            if (t.isLoaded()) {
                loadedTables.add(t);
                continue;
            }
            queryTables.tables.add(new QueryTables.QueryTable(t.getProject(), t.getSchemaName(), t.getName()));
        }
        if (!queryTables.tables.isEmpty()) {
            loadedTables.addAll(this.loadTablesInternal(queryTables));
        }
        return loadedTables;
    }

    private List<Table> loadTablesInternal(QueryTables queryTables) throws OdpsException {
        ArrayList<Table> reloadTables = new ArrayList<Table>();
        if (queryTables.tables.isEmpty()) {
            return reloadTables;
        }
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("query", null);
        String resource = ResourceBuilder.buildTablesResource(this.getDefaultProjectName());
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Content-Type", "application/xml");
        String xml = null;
        try {
            xml = SimpleXmlUtils.marshal(queryTables);
        }
        catch (Exception e) {
            throw new OdpsException(e.getMessage(), e);
        }
        ListTablesResponse resp = this.client.stringRequest(ListTablesResponse.class, resource, "POST", params, headers, xml);
        for (Table.TableModel model : resp.tables) {
            Table t = new Table(model, model.projectName, model.schemaName, this.odps);
            t.reload(model);
            reloadTables.add(t);
        }
        return reloadTables;
    }

    private String getDefaultProjectName() {
        String project = this.client.getDefaultProject();
        if (project == null || project.length() == 0) {
            throw new RuntimeException("No default project specified.");
        }
        return project;
    }

    private void submitCreateAndWait(String schemaName, String sql, String taskName, Map<String, String> hints, Map<String, String> aliases) throws OdpsException {
        hints = NameSpaceSchemaUtils.setSchemaFlagInHints(hints, schemaName);
        Instance i = SQLTask.run(this.odps, this.odps.getDefaultProject(), sql, taskName, hints, aliases);
        i.waitForSuccess();
    }

    public TableCreator newTableCreator(String tableName, TableSchema schema) {
        return new TableCreator(this.odps, this.odps.getDefaultProject(), tableName, schema);
    }

    public TableCreator newTableCreator(String projectName, String tableName, TableSchema schema) {
        return new TableCreator(this.odps, projectName, tableName, schema);
    }

    public static class TableCreator {
        private Odps odps;
        private String projectName;
        private String tableName;
        private TableSchema tableSchema;
        private String schemaName;
        private String comment;
        private boolean ifNotExists = false;
        private Long lifeCycle;
        private Map<String, String> hints;
        private Map<String, String> aliases;
        private List<String> primaryKeys;
        private boolean debug = false;
        private Long shardNum;
        private Long hubLifecycle;
        private boolean transactionTable = false;
        private Map<String, String> tblProperties;
        private String storedBy;
        private String location;
        private List<String> jars;
        private Map<String, String> serdeProperties;

        private TableCreator(Odps odps, String projectName, String tableName, TableSchema tableSchema) {
            ExceptionUtils.checkArgumentNotNull("odps", odps);
            ExceptionUtils.checkStringArgumentNotNull("projectName", projectName);
            ExceptionUtils.checkStringArgumentNotNull("tableName", tableName);
            ExceptionUtils.checkArgumentNotNull("tableSchema", tableSchema);
            this.odps = odps;
            this.projectName = projectName;
            this.tableName = tableName;
            this.tableSchema = tableSchema;
            this.schemaName = odps.getCurrentSchema();
        }

        public TableCreator withSchemaName(String schemaName) {
            this.schemaName = schemaName;
            return this;
        }

        public TableCreator withComment(String comment) {
            this.comment = comment;
            return this;
        }

        public TableCreator ifNotExists() {
            this.ifNotExists = true;
            return this;
        }

        public TableCreator withLifeCycle(Long lifeCycle) {
            this.lifeCycle = lifeCycle;
            return this;
        }

        public TableCreator transactionTable() {
            this.getTblProperties().put("transactional", "true");
            this.getHints().put("odps.sql.upsertable.table.enable", "true");
            this.transactionTable = true;
            return this;
        }

        public TableCreator withPrimaryKeys(List<String> primaryKeys) {
            this.primaryKeys = primaryKeys;
            return this;
        }

        public TableCreator withBucketNum(Integer bucketNum) {
            Preconditions.checkInteger(bucketNum, 1, "bucketNum");
            this.getTblProperties().put("write.bucket.num", String.valueOf(bucketNum));
            return this;
        }

        public TableCreator withTblProperties(Map<String, String> tblProperties) {
            if (tblProperties != null) {
                this.getTblProperties().putAll(tblProperties);
            }
            return this;
        }

        public TableCreator withSerdeProperties(Map<String, String> serdeProperties) {
            if (serdeProperties != null) {
                this.getSerdeProperties().putAll(serdeProperties);
            }
            return this;
        }

        public TableCreator withHints(Map<String, String> hints) {
            if (hints != null) {
                this.getHints().putAll(hints);
            }
            return this;
        }

        public TableCreator withAliases(Map<String, String> aliases) {
            if (aliases != null) {
                this.getAliases().putAll(aliases);
            }
            return this;
        }

        public TableCreator withShardNum(Long shardNum) {
            this.shardNum = shardNum;
            return this;
        }

        public TableCreator withHubLifecycle(Long hubLifecycle) {
            this.hubLifecycle = hubLifecycle;
            return this;
        }

        public TableCreator withJars(List<String> jars) {
            if (jars != null) {
                if (this.jars == null) {
                    this.jars = new ArrayList<String>();
                }
                this.jars.addAll(jars);
            }
            return this;
        }

        public TableCreator debug() {
            this.debug = true;
            return this;
        }

        public void create() throws OdpsException {
            this.hints = NameSpaceSchemaUtils.setSchemaFlagInHints(this.hints, this.schemaName);
            Instance i = SQLTask.run(this.odps, this.projectName, this.generateCreateTableSql(), "SQLCreateTableTask", this.hints, this.aliases);
            if (this.debug) {
                String logView = this.odps.logview().generateLogView(i, 24L);
                System.out.println(logView);
            }
            i.waitForSuccess();
        }

        public void createExternal(String storedBy, String location) throws OdpsException {
            this.storedBy = storedBy;
            this.location = location;
            this.hints = NameSpaceSchemaUtils.setSchemaFlagInHints(this.hints, this.schemaName);
            Instance i = SQLTask.run(this.odps, this.projectName, this.generateCreateExternalTableSql(), "SQLCreateExternalTableTask", this.hints, this.aliases);
            if (this.debug) {
                String logView = this.odps.logview().generateLogView(i, 24L);
                System.out.println(logView);
            }
            i.waitForSuccess();
        }

        private String generateCreateExternalTableSql() {
            int index;
            if (this.storedBy == null || this.location == null) {
                throw new IllegalArgumentException("Create external table must with storedBy and location");
            }
            String plainString = this.generateCreateTableSql();
            plainString = new StringBuilder(plainString).insert("CREATE".length(), " EXTERNAL").toString();
            StringBuilder sb = new StringBuilder();
            sb.append(" STORED BY '").append(this.storedBy.trim()).append("'");
            if (this.serdeProperties != null && !this.serdeProperties.isEmpty()) {
                sb.append(" WITH SERDEPROPERTIES(");
                index = 0;
                for (Map.Entry<String, String> entry : this.serdeProperties.entrySet()) {
                    sb.append("'").append(entry.getKey()).append("' = '").append(entry.getValue()).append("'");
                    if (++index == this.serdeProperties.size()) continue;
                    sb.append(" , ");
                }
                sb.append(")");
            }
            sb.append(" LOCATION '").append(this.location).append("'");
            if (this.jars != null && !this.jars.isEmpty()) {
                sb.append(" USING '");
                index = 0;
                for (String jar : this.jars) {
                    sb.append(jar);
                    if (++index == this.jars.size()) continue;
                    sb.append(",");
                }
                sb.append("'");
            }
            if (this.lifeCycle != null) {
                index = plainString.lastIndexOf(" LIFECYCLE ");
                if (index < 0) {
                    throw new IllegalArgumentException();
                }
                plainString = plainString.substring(0, index);
                sb.append(" LIFECYCLE ").append(this.lifeCycle).append(";");
            } else {
                plainString = plainString.substring(0, plainString.length() - 1);
                sb.append(";");
            }
            if (this.debug) {
                System.out.println(plainString + sb);
            }
            return plainString + sb;
        }

        private String generateCreateTableSql() {
            List partitionColumns;
            StringBuilder sql = new StringBuilder();
            sql.append("CREATE TABLE ");
            if (this.ifNotExists) {
                sql.append("IF NOT EXISTS ");
            }
            sql.append(NameSpaceSchemaUtils.getFullName(this.projectName, this.schemaName, this.tableName));
            sql.append(" (");
            List columns = this.tableSchema.getColumns();
            for (int i = 0; i < columns.size(); ++i) {
                Column column = (Column)columns.get(i);
                sql.append("`").append(column.getName()).append("` ").append(column.getTypeInfo().getTypeName());
                if (!column.isNullable()) {
                    sql.append(" NOT NULL");
                }
                if (StringUtils.isNotBlank((String)column.getDefaultValue())) {
                    sql.append(" DEFAULT ").append(column.getDefaultValue());
                }
                if (column.getComment() != null) {
                    sql.append(" COMMENT '").append(column.getComment()).append("'");
                }
                if (i + 1 >= columns.size()) continue;
                sql.append(',');
            }
            if (this.transactionTable) {
                if (this.primaryKeys == null || this.primaryKeys.isEmpty()) {
                    throw new IllegalArgumentException("transaction table must have a primary key");
                }
                sql.append(", PRIMARY KEY(").append(this.primaryKeys.stream().map(s -> '`' + s + '`').collect(Collectors.joining(","))).append(")");
            }
            sql.append(')');
            if (this.comment != null) {
                sql.append(" COMMENT '").append(this.comment).append("' ");
            }
            if (!(partitionColumns = this.tableSchema.getPartitionColumns()).isEmpty()) {
                sql.append(" PARTITIONED BY (");
                for (int i = 0; i < partitionColumns.size(); ++i) {
                    Column column = (Column)partitionColumns.get(i);
                    sql.append(column.getName()).append(" ").append(column.getTypeInfo().getTypeName());
                    if (column.getComment() != null) {
                        sql.append(" COMMENT '").append(column.getComment()).append("'");
                    }
                    if (i + 1 >= partitionColumns.size()) continue;
                    sql.append(',');
                }
                sql.append(')');
            }
            if (this.tblProperties != null && !this.tblProperties.isEmpty()) {
                sql.append(" TBLPROPERTIES(");
                for (Map.Entry<String, String> entry : this.tblProperties.entrySet()) {
                    sql.append("'").append(entry.getKey()).append("'='").append(entry.getValue()).append("',");
                }
                sql.deleteCharAt(sql.length() - 1);
                sql.append(")");
            }
            if (this.lifeCycle != null) {
                sql.append(" LIFECYCLE ").append(this.lifeCycle);
            }
            if (this.shardNum != null) {
                sql.append(" INTO ").append(this.shardNum).append(" SHARDS");
            }
            if (this.hubLifecycle != null) {
                if (this.lifeCycle != null) {
                    throw new IllegalArgumentException("only one of lifeCycle and hubLifecycle can be set");
                }
                sql.append(" HUBLIFECYCLE ").append(this.hubLifecycle);
            }
            sql.append(';');
            if (this.debug) {
                System.out.println(sql);
            }
            return sql.toString();
        }

        private Map<String, String> getHints() {
            if (this.hints == null) {
                this.hints = new HashMap<String, String>();
            }
            return this.hints;
        }

        private Map<String, String> getAliases() {
            if (this.aliases == null) {
                this.aliases = new HashMap<String, String>();
            }
            return this.aliases;
        }

        private Map<String, String> getTblProperties() {
            if (this.tblProperties == null) {
                this.tblProperties = new HashMap<String, String>();
            }
            return this.tblProperties;
        }

        private Map<String, String> getSerdeProperties() {
            if (this.serdeProperties == null) {
                this.serdeProperties = new HashMap<String, String>();
            }
            return this.serdeProperties;
        }
    }

    private class TableListIterator
    extends ListIterator<Table> {
        Map<String, String> params = new HashMap<String, String>();
        private TableFilter filter;
        private String projectName;
        private String schemaName;
        private boolean extended;

        TableListIterator(String projectName, String schemaName, TableFilter filter, boolean extended) {
            this.filter = filter;
            this.projectName = projectName;
            this.schemaName = schemaName;
            this.extended = extended;
            this.params = NameSpaceSchemaUtils.initParamsWithSchema(schemaName);
        }

        @Override
        public List<Table> list(String marker, long maxItems) {
            if (marker != null) {
                this.params.put("marker", marker);
            }
            if (maxItems >= 0L) {
                this.params.put("maxitems", String.valueOf(maxItems));
            }
            return this.list();
        }

        @Override
        public String getMarker() {
            return this.params.get("marker");
        }

        @Override
        protected List<Table> list() {
            ArrayList<Table> tables = new ArrayList<Table>();
            this.params.put("expectmarker", "true");
            String lastMarker = this.params.get("marker");
            if (this.params.containsKey("marker") && lastMarker.length() == 0) {
                return null;
            }
            if (this.filter != null) {
                if (this.filter.getName() != null) {
                    this.params.put("name", this.filter.getName());
                }
                if (this.filter.getOwner() != null) {
                    this.params.put("owner", this.filter.getOwner());
                }
                if (this.filter.getType() != null) {
                    this.params.put("type", this.filter.getType().toString());
                }
            }
            if (this.extended) {
                this.params.put("extended", null);
            }
            String resource = ResourceBuilder.buildTablesResource(this.projectName);
            try {
                ListTablesResponse resp = Tables.this.client.request(ListTablesResponse.class, resource, "GET", this.params);
                for (Table.TableModel model : resp.tables) {
                    Table t = new Table(model, this.projectName, this.schemaName, Tables.this.odps);
                    tables.add(t);
                }
                this.params.put("marker", resp.marker);
            }
            catch (OdpsException e) {
                throw new RuntimeException(e.getMessage(), e);
            }
            return tables;
        }
    }

    @Root(name="Tables", strict=false)
    private static class QueryTables {
        @ElementList(entry="Table", inline=true, required=false)
        private List<QueryTable> tables = new ArrayList<QueryTable>();

        private QueryTables() {
        }

        @Root(name="Table", strict=false)
        private static class QueryTable {
            @Element(name="Project", required=false)
            @Convert(value=SimpleXmlUtils.EmptyStringConverter.class)
            private String projectName;
            @Element(name="Name", required=false)
            @Convert(value=SimpleXmlUtils.EmptyStringConverter.class)
            private String tableName;
            @Element(name="Schema", required=false)
            @Convert(value=SimpleXmlUtils.EmptyStringConverter.class)
            private String schemaName;

            QueryTable() {
            }

            QueryTable(String projectName, String schemaName, String tableName) {
                this.projectName = projectName;
                this.schemaName = schemaName;
                this.tableName = tableName;
            }
        }
    }

    @Root(name="Tables", strict=false)
    private static class ListTablesResponse {
        @ElementList(entry="Table", inline=true, required=false)
        private List<Table.TableModel> tables = new ArrayList<Table.TableModel>();
        @Element(name="Marker", required=false)
        @Convert(value=SimpleXmlUtils.EmptyStringConverter.class)
        private String marker;
        @Element(name="MaxItems", required=false)
        private Integer maxItems;

        private ListTablesResponse() {
        }
    }
}

