/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.odps;

import com.aliyun.odps.LazyLoad;
import com.aliyun.odps.Odps;
import com.aliyun.odps.OdpsException;
import com.aliyun.odps.rest.ResourceBuilder;
import com.aliyun.odps.rest.RestClient;
import com.aliyun.odps.rest.SimpleXmlUtils;
import com.aliyun.odps.simpleframework.xml.Element;
import com.aliyun.odps.simpleframework.xml.Root;
import com.aliyun.odps.simpleframework.xml.convert.Convert;
import java.util.Date;

public class Stream
extends LazyLoad {
    private StreamModel model;
    private final RestClient client;

    Stream(StreamModel model, String projectName, Odps odps) {
        this.model = model;
        this.model.projectName = projectName;
        this.client = odps.getRestClient();
    }

    @Override
    public void reload() throws OdpsException {
        String resource = ResourceBuilder.buildStreamObjectResource(this.model.projectName, this.model.name);
        this.reload(this.client.request(StreamModel.class, resource, "GET"));
    }

    private void reload(StreamModel model) {
        this.model = model;
        this.setLoaded(true);
    }

    public String getName() {
        return this.model.name;
    }

    public String getProjectName() {
        return this.model.projectName;
    }

    public String getRefTableProject() {
        if (this.model.refTableProject == null) {
            this.lazyLoad();
        }
        return this.model.refTableProject;
    }

    public String getRefTableName() {
        if (this.model.refTableName == null) {
            this.lazyLoad();
        }
        return this.model.refTableName;
    }

    public String getRefTableId() {
        if (this.model.refTableId == null) {
            this.lazyLoad();
        }
        return this.model.refTableId;
    }

    public String getRefTableVersion() {
        if (this.model.refTableVersion == null) {
            this.lazyLoad();
        }
        return this.model.refTableVersion;
    }

    public Date getCreateTime() {
        if (this.model.createdTime == null) {
            this.lazyLoad();
        }
        return this.model.createdTime;
    }

    public Date getLastModifiedTime() {
        if (this.model.lastModifiedTime == null) {
            this.lazyLoad();
        }
        return this.model.lastModifiedTime;
    }

    public String version() {
        if (this.model.version == null) {
            this.lazyLoad();
        }
        return this.model.version;
    }

    @Root(name="StreamObject", strict=false)
    static class StreamModel {
        @Element(name="Project")
        String projectName;
        @Element(name="Name")
        String name;
        @Element(name="RefTableProject")
        String refTableProject;
        @Element(name="RefTableName")
        String refTableName;
        @Element(name="RefTableId", required=false)
        String refTableId;
        @Element(name="RefTableVersion", required=false)
        String refTableVersion;
        @Element(name="CreateTime", required=false)
        @Convert(value=SimpleXmlUtils.DateConverter.class)
        Date createdTime;
        @Element(name="LastModifiedTime", required=false)
        @Convert(value=SimpleXmlUtils.DateConverter.class)
        Date lastModifiedTime;
        @Element(name="version", required=false)
        String version;

        StreamModel() {
        }
    }
}

