/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.odps;

import com.aliyun.odps.utils.StringUtils;
import com.google.gson.JsonObject;
import java.util.Arrays;
import java.util.Date;
import java.util.Map;
import java.util.stream.Collectors;

public class StorageTierInfo {
    private StorageTier storageTier;
    private Date storageLastModifiedTime;
    private Map<StorageTier, Long> storageSize;

    public StorageTier getStorageTier() {
        return this.storageTier;
    }

    public Date getStorageLastModifiedTime() {
        return this.storageLastModifiedTime;
    }

    public Long getStorageSize(String tier) {
        return this.getStorageSize(StorageTier.getStorageTierByName(tier));
    }

    public Long getStorageSize(StorageTier tier) {
        if (this.storageSize == null || tier == null || !this.storageSize.containsKey((Object)tier)) {
            return null;
        }
        return this.storageSize.get((Object)tier);
    }

    static StorageTierInfo getStorageTierInfo(JsonObject tree) {
        Map<StorageTier, Long> filterSize;
        StorageTierInfo result = new StorageTierInfo();
        boolean isNull = true;
        if (tree.has("StorageTier")) {
            isNull = false;
            result.storageTier = StorageTier.getStorageTierByName(tree.get("StorageTier").getAsString());
        }
        if (tree.has("StorageLastModifiedTime")) {
            isNull = false;
            result.storageLastModifiedTime = new Date(tree.get("StorageLastModifiedTime").getAsLong() * 1000L);
        }
        if ((filterSize = Arrays.stream(StorageTier.values()).filter(tier -> tree.has(tier.getSizeName())).collect(Collectors.toMap(tier -> tier, tier -> tree.get(tier.getSizeName()).getAsLong()))).size() != 0) {
            isNull = false;
            result.storageSize = filterSize;
        }
        if (isNull) {
            result = null;
        }
        return result;
    }

    static StorageTierInfo getStorageTierInfo(Map<String, String> map) {
        StorageTierInfo result = null;
        Map<StorageTier, Long> filterSize = Arrays.stream(StorageTier.values()).filter(tier -> map.containsKey(tier.getChargeSizeName())).collect(Collectors.toMap(tier -> tier, tier -> Long.valueOf((String)map.get(tier.getChargeSizeName()))));
        if (filterSize.size() != 0) {
            result = new StorageTierInfo();
            result.storageSize = filterSize;
        }
        return result;
    }

    public static enum StorageTier {
        STANDARD("Standard", "StandardSize", "chargableAliveDataSize"),
        LOWFREQUENCY("LowFrequency", "LowFrequencySize", "chargableLowFreqStorageSize"),
        LONGTERM("LongTerm", "LongTermSize", "chargableLongTermStorageSize");

        private final String name;
        private final String sizeName;
        private final String chargeSizeName;

        private StorageTier(String name, String sizeName, String chargeSizeName) {
            this.name = name;
            this.sizeName = sizeName;
            this.chargeSizeName = chargeSizeName;
        }

        public String getName() {
            return this.name;
        }

        public String getSizeName() {
            return this.sizeName;
        }

        public String getChargeSizeName() {
            return this.chargeSizeName;
        }

        public static StorageTier getStorageTierByName(String tier) {
            for (StorageTier type : StorageTier.values()) {
                if (!StringUtils.equals((String)type.getName().toLowerCase(), (String)tier.toLowerCase())) continue;
                return type;
            }
            return null;
        }
    }
}

