/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.odps;

import com.aliyun.odps.FileResource;
import com.aliyun.odps.ListIterator;
import com.aliyun.odps.NoSuchObjectException;
import com.aliyun.odps.Odps;
import com.aliyun.odps.OdpsException;
import com.aliyun.odps.ReloadException;
import com.aliyun.odps.Resource;
import com.aliyun.odps.ResourceInputStream;
import com.aliyun.odps.TableResource;
import com.aliyun.odps.VolumeResource;
import com.aliyun.odps.commons.util.IOUtils;
import com.aliyun.odps.rest.ResourceBuilder;
import com.aliyun.odps.rest.RestClient;
import com.aliyun.odps.rest.SimpleXmlUtils;
import com.aliyun.odps.simpleframework.xml.Element;
import com.aliyun.odps.simpleframework.xml.ElementList;
import com.aliyun.odps.simpleframework.xml.Root;
import com.aliyun.odps.simpleframework.xml.convert.Convert;
import com.aliyun.odps.utils.NameSpaceSchemaUtils;
import com.aliyun.odps.utils.StringUtils;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import org.apache.commons.codec.digest.DigestUtils;

public class Resources
implements Iterable<Resource> {
    private final RestClient client;
    private Odps odps;
    private int chunkSize;

    Resources(Odps odps) {
        this.odps = odps;
        this.client = odps.getRestClient();
        this.chunkSize = 0x4000000;
    }

    public void create(FileResource r, InputStream in) throws OdpsException {
        this.create(this.getDefaultProjectName(), r, in);
    }

    public void create(String projectName, FileResource r, InputStream in) throws OdpsException {
        this.create(projectName, this.odps.getCurrentSchema(), r, in);
    }

    public void create(String project, String schema, FileResource resource, InputStream in) throws OdpsException {
        try {
            this.createFileResource(project, schema, resource, in, false);
        }
        catch (IOException e) {
            throw new OdpsException(e);
        }
    }

    public void create(TableResource resource) throws OdpsException {
        this.create(this.getDefaultProjectName(), resource);
    }

    public void create(String projectName, TableResource resource) throws OdpsException {
        this.create(projectName, this.odps.getCurrentSchema(), resource);
    }

    public void create(String projectName, String schemaName, TableResource resource) throws OdpsException {
        this.createTableResource(projectName, schemaName, resource, false);
    }

    public void create(VolumeResource resource) throws OdpsException {
        this.create(this.getDefaultProjectName(), resource);
    }

    public void create(String projectName, VolumeResource resource) throws OdpsException {
        this.addVolumeResource(projectName, resource, false);
    }

    public void update(VolumeResource resource) throws OdpsException {
        this.update(this.getDefaultProjectName(), resource);
    }

    public void update(String projectName, VolumeResource r) throws OdpsException {
        this.addVolumeResource(projectName, r, true);
    }

    private void addVolumeResource(String projectName, VolumeResource r, boolean isUpdate) throws OdpsException {
        String resource;
        String method;
        if (StringUtils.isNullOrEmpty((String)projectName)) {
            throw new IllegalArgumentException("Argument 'projectName' cannot be null or empty");
        }
        if (r == null) {
            throw new IllegalArgumentException("Argument 'resource' cannot be null or empty");
        }
        RestClient client = this.odps.getRestClient();
        if (isUpdate) {
            method = "PUT";
            resource = ResourceBuilder.buildResourceResource(projectName, r.getName());
        } else {
            method = "POST";
            resource = ResourceBuilder.buildResourcesResource(projectName);
        }
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("x-odps-resource-type", r.model.type.toLowerCase());
        headers.put("x-odps-resource-name", r.getName());
        headers.put("x-odps-copy-file-source", r.getVolumePath());
        if (r.getComment() != null) {
            headers.put("x-odps-comment", r.getComment());
        }
        client.request(resource, method, null, headers, null);
    }

    public void update(TableResource r) throws OdpsException {
        this.update(this.getDefaultProjectName(), r);
    }

    public void update(String projectName, TableResource r) throws OdpsException {
        this.update(projectName, this.odps.getCurrentSchema(), r);
    }

    public void update(String projectName, String schemaName, TableResource resource) throws OdpsException {
        this.createTableResource(projectName, schemaName, resource, true);
    }

    public void update(FileResource r, InputStream in) throws OdpsException {
        this.update(this.getDefaultProjectName(), r, in);
    }

    public void update(String projectName, FileResource r, InputStream in) throws OdpsException {
        this.update(projectName, this.odps.getCurrentSchema(), r, in);
    }

    public void update(String projectName, String schemaName, FileResource resource, InputStream in) throws OdpsException {
        try {
            this.createFileResource(projectName, schemaName, resource, in, true);
        }
        catch (IOException e) {
            throw new OdpsException(e);
        }
    }

    public InputStream getResourceAsStream(String resourceName) throws OdpsException {
        return this.getResourceAsStream(this.getDefaultProjectName(), resourceName);
    }

    public InputStream getResourceAsStream(String projectName, String resourceName) throws OdpsException {
        return this.getResourceAsStream(projectName, this.odps.getCurrentSchema(), resourceName);
    }

    public InputStream getResourceAsStream(String projectName, String schemaName, String resourceName) throws OdpsException {
        if (StringUtils.isNullOrEmpty((String)projectName)) {
            throw new IllegalArgumentException("Argument 'projectName' cannot be null or empty");
        }
        if (StringUtils.isNullOrEmpty((String)resourceName)) {
            throw new IllegalArgumentException("Argument 'resourceName' cannot be null or empty");
        }
        return new ResourceInputStream(this.client, projectName, schemaName, resourceName);
    }

    private void createTableResource(String project, String schema, TableResource r, boolean overwrite) throws OdpsException {
        String resource;
        String method;
        if (StringUtils.isNullOrEmpty((String)project)) {
            throw new IllegalArgumentException("Argument 'project' cannot be null or empty");
        }
        if (r == null) {
            throw new IllegalArgumentException("Argument 'resource' cannot be null");
        }
        if (r.getName() == null || r.getName().length() == 0) {
            throw new OdpsException("Table Resource Name should not empty.");
        }
        if (overwrite) {
            method = "PUT";
            resource = ResourceBuilder.buildResourceResource(project, r.getName());
        } else {
            method = "POST";
            resource = ResourceBuilder.buildResourcesResource(project);
        }
        HashMap<String, String> params = NameSpaceSchemaUtils.initParamsWithSchema(schema);
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Content-Type", "text/plain");
        headers.put("x-odps-resource-type", r.getType().toString().toLowerCase());
        headers.put("x-odps-resource-name", r.getName());
        headers.put("x-odps-copy-table-source", r.getSourceTableName());
        if (r.getComment() != null) {
            headers.put("x-odps-comment", r.getComment());
        }
        this.client.request(resource, method, params, headers, null);
    }

    private void createFileResource(String project, String schema, FileResource r, InputStream in, boolean overwrite) throws OdpsException, IOException {
        int readSize;
        if (StringUtils.isNullOrEmpty((String)project)) {
            throw new IllegalArgumentException("Argument 'project' cannot be null or empty");
        }
        if (r == null) {
            throw new IllegalArgumentException("Argument 'resource' cannot be null");
        }
        if (StringUtils.isNullOrEmpty((String)r.getName())) {
            throw new OdpsException("Resource Name should not empty.");
        }
        if (in == null) {
            throw new OdpsException("Argument 'in' cannot be null");
        }
        MessageDigest digest = DigestUtils.getMd5Digest();
        byte[] tmpContent = new byte[this.chunkSize];
        long totalBytes = 0L;
        int cnt = 0;
        ArrayList<String> tmpFiles = new ArrayList<String>();
        while ((readSize = in.read(tmpContent)) != -1) {
            digest.update(tmpContent, 0, readSize);
            ByteArrayInputStream input = new ByteArrayInputStream(tmpContent, 0, readSize);
            FileResource tmp = new FileResource();
            String tmpName = NameSpaceSchemaUtils.isSchemaEnabled(schema) ? String.format("%s.%s.part.tmp.%06d", schema, r.getName(), cnt) : String.format("%s.part.tmp.%06d", r.getName(), cnt);
            tmp.setIsTempResource(true);
            tmp.setName(tmpName);
            tmpFiles.add(tmpName);
            this.createTempPartFile(project, schema, tmp, input);
            ++cnt;
            totalBytes += (long)readSize;
            ((InputStream)input).close();
        }
        byte[] md5Bytes = digest.digest();
        String commitContent = this.toHexString(md5Bytes) + "|" + String.join((CharSequence)",", tmpFiles);
        ByteArrayInputStream is = new ByteArrayInputStream(commitContent.getBytes(StandardCharsets.UTF_8));
        FileResource f = new FileResource();
        f.setName(r.getName());
        f.setComment(r.getComment());
        f.setIsTempResource(r.getIsTempResource());
        f.model.type = r.getType().toString();
        this.mergeTempPartFiles(project, schema, f, is, overwrite, totalBytes);
        ((InputStream)is).close();
    }

    public Resource get(String name) {
        String[] tmpPair = name.split("/resources/");
        if (tmpPair.length > 1) {
            String project = tmpPair[0];
            String resourceName = tmpPair[1];
            return this.get(project, resourceName);
        }
        return this.get(this.getDefaultProjectName(), name);
    }

    public Resource get(String projectName, String resourceName) {
        return this.get(projectName, this.odps.getCurrentSchema(), resourceName);
    }

    public Resource get(String projectName, String schemaName, String resourceName) {
        if (StringUtils.isNullOrEmpty((String)projectName)) {
            throw new IllegalArgumentException("Argument 'projectName' cannot be null or empty");
        }
        if (StringUtils.isNullOrEmpty((String)resourceName)) {
            throw new IllegalArgumentException("Argument 'resourceName' cannot be null");
        }
        Resource.ResourceModel rm = new Resource.ResourceModel();
        rm.name = resourceName;
        rm.schemaName = schemaName;
        return Resource.getResource(rm, projectName, this.odps);
    }

    public boolean exists(String resourceName) throws OdpsException {
        return this.exists(this.getDefaultProjectName(), resourceName);
    }

    public boolean exists(String projectName, String resourceName) throws OdpsException {
        return this.exists(projectName, this.odps.getCurrentSchema(), resourceName);
    }

    public boolean exists(String projectName, String schemaName, String resourceName) throws OdpsException {
        if (StringUtils.isNullOrEmpty((String)projectName)) {
            throw new IllegalArgumentException("Argument 'projectName' cannot be null or empty");
        }
        if (StringUtils.isNullOrEmpty((String)resourceName)) {
            throw new IllegalArgumentException("Argument 'resourceName' cannot be null or empty");
        }
        try {
            Resource t = this.get(projectName, schemaName, resourceName);
            t.reload();
            return true;
        }
        catch (NoSuchObjectException e) {
            return false;
        }
        catch (ReloadException e) {
            if (e.getCause() instanceof NoSuchObjectException) {
                return false;
            }
            throw e;
        }
    }

    public void delete(String resourceName) throws OdpsException {
        this.delete(this.getDefaultProjectName(), resourceName);
    }

    public void delete(String projectName, String resourceName) throws OdpsException {
        this.delete(projectName, this.odps.getCurrentSchema(), resourceName);
    }

    public void delete(String projectName, String schemaName, String resourceName) throws OdpsException {
        if (StringUtils.isNullOrEmpty((String)projectName)) {
            throw new IllegalArgumentException("Argument 'projectName' cannot be null or empty");
        }
        if (StringUtils.isNullOrEmpty((String)resourceName)) {
            throw new IllegalArgumentException("Argument 'resourceName' cannot be null or empty");
        }
        String resource = ResourceBuilder.buildResourceResource(projectName, resourceName);
        HashMap<String, String> params = NameSpaceSchemaUtils.initParamsWithSchema(schemaName);
        this.client.request(resource, "DELETE", params, null, null);
    }

    public FileResource createTempResource(String fileName) throws OdpsException {
        return this.createTempResource(this.getDefaultProjectName(), fileName);
    }

    public FileResource createTempResource(String projectName, String fileName) throws OdpsException {
        return this.createTempResource(projectName, fileName, Resource.Type.FILE);
    }

    public FileResource createTempFileResource(String projectName, String schemaName, String filePath, Resource.Type type) throws OdpsException {
        FileInputStream input;
        if (StringUtils.isNullOrEmpty((String)projectName)) {
            throw new IllegalArgumentException("Argument 'projectName' cannot be null or empty");
        }
        if (StringUtils.isNullOrEmpty((String)filePath)) {
            throw new IllegalArgumentException("Argument 'filePath' cannot be null or empty");
        }
        if (type == null) {
            throw new IllegalArgumentException("Argument 'type' cannot be null");
        }
        File tempFile = new File(filePath);
        if (!tempFile.exists()) {
            throw new IllegalArgumentException("File or Directory '" + filePath + "' does not exist.");
        }
        if (tempFile.isDirectory()) {
            throw new IllegalArgumentException("Temp resource should be file, not directory:" + filePath);
        }
        Resource resource = Resource.createResource(type);
        if (!(resource instanceof FileResource)) {
            throw new IllegalArgumentException("Unsupported resource type: " + type.toString());
        }
        ((FileResource)resource).setIsTempResource(true);
        String resourceName = UUID.randomUUID().toString() + "_" + tempFile.getName();
        resource.setName(resourceName);
        try {
            input = new FileInputStream(tempFile);
        }
        catch (FileNotFoundException e) {
            throw new OdpsException("File or Directory '" + filePath + "' does not exist.");
        }
        this.create(projectName, schemaName, (FileResource)resource, input);
        IOUtils.closeSilently(input);
        return (FileResource)this.get(projectName, resourceName);
    }

    public FileResource createTempResource(String projectName, String filePath, Resource.Type type) throws OdpsException {
        return this.createTempFileResource(projectName, this.odps.getCurrentSchema(), filePath, type);
    }

    private String toHexString(byte[] bytes) {
        String md5 = new BigInteger(1, bytes).toString(16);
        return new String(new char[32 - md5.length()]).replace("\u0000", "0") + md5;
    }

    private void createTempPartFile(String project, String schema, Resource res, InputStream in) throws OdpsException, IOException {
        FileResource r = (FileResource)res;
        if (r.getName() == null || r.getName().length() == 0) {
            throw new OdpsException("Temp Part Resource Name should not empty.");
        }
        if (!r.getIsTempResource()) {
            throw new OdpsException("Part Resource must be Temp Resource.");
        }
        if (r.getType().equals((Object)Resource.Type.VOLUMEFILE) || r.getType().equals((Object)Resource.Type.VOLUMEARCHIVE) || r.getType().equals((Object)Resource.Type.TABLE) || r.getType().equals((Object)Resource.Type.UNKOWN)) {
            throw new OdpsException("Temp Part Resource's type is invalid!");
        }
        String resource = ResourceBuilder.buildResourcesResource(project);
        String method = "POST";
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Content-Type", "application/octet-stream");
        headers.put("Content-Disposition", "attachment;filename=" + r.getName());
        headers.put("x-odps-resource-type", r.getType().toString().toLowerCase());
        headers.put("x-odps-resource-name", r.getName());
        if (r.getComment() != null) {
            headers.put("x-odps-comment", r.getComment());
        }
        headers.put("x-odps-resource-istemp", String.valueOf(r.getIsTempResource()));
        HashMap<String, String> params = NameSpaceSchemaUtils.initParamsWithSchema(schema);
        params.put("rIsPart", "true");
        this.client.request(resource, method, params, headers, in, IOUtils.getInputStreamLength(in));
    }

    private void mergeTempPartFiles(String project, String schema, Resource res, InputStream in, boolean overwrite, long totalBytes) throws OdpsException, IOException {
        String resource;
        String method;
        InputStream inputStream = Objects.requireNonNull(in);
        FileResource r = (FileResource)res;
        if (r.getName() == null || r.getName().length() == 0) {
            throw new OdpsException("File Resource Name should not empty.");
        }
        if (overwrite) {
            method = "PUT";
            resource = ResourceBuilder.buildResourceResource(project, r.getName());
        } else {
            method = "POST";
            resource = ResourceBuilder.buildResourcesResource(project);
        }
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Content-Type", "application/octet-stream");
        headers.put("Content-Disposition", "attachment;filename=" + r.getName());
        headers.put("x-odps-resource-type", r.getType().toString().toLowerCase());
        headers.put("x-odps-resource-name", r.getName());
        if (r.getComment() != null) {
            headers.put("x-odps-comment", r.getComment());
        }
        if (r.getIsTempResource()) {
            headers.put("x-odps-resource-istemp", String.valueOf(r.getIsTempResource()));
        }
        headers.put("x-odps-resource-merge-total-bytes", String.valueOf(totalBytes));
        HashMap<String, String> params = NameSpaceSchemaUtils.initParamsWithSchema(schema);
        params.put("rOpMerge", "true");
        this.odps.getRestClient().request(resource, method, params, headers, inputStream, IOUtils.getInputStreamLength(inputStream));
    }

    public Iterator<Resource> iterator(String projectName) {
        return new ResourceListIterator(projectName, this.odps.getCurrentSchema(), null);
    }

    public Iterator<Resource> iterator(String projectName, String schemaName) {
        return this.iterator(projectName, schemaName, null);
    }

    public Iterator<Resource> iterator(String projectName, String schemaName, String resourceName) {
        if (StringUtils.isNullOrEmpty((String)projectName)) {
            throw new IllegalArgumentException("Argument 'projectName' cannot be null or empty");
        }
        return new ResourceListIterator(projectName, schemaName, resourceName);
    }

    @Override
    public Iterator<Resource> iterator() {
        return this.iterator(this.getDefaultProjectName());
    }

    public Iterable<Resource> iterable(String projectName) {
        return () -> new ResourceListIterator(projectName, this.odps.getCurrentSchema(), null);
    }

    public Iterable<Resource> iterable() {
        return this.iterable(this.getDefaultProjectName());
    }

    public Iterable<Resource> iterable(String projectName, String schemaName) {
        return this.iterable(projectName, schemaName, null);
    }

    public Iterable<Resource> iterable(String projectName, String schemaName, String resourceName) {
        if (StringUtils.isNullOrEmpty((String)projectName)) {
            throw new IllegalArgumentException("Argument 'projectName' cannot be null or empty");
        }
        return () -> new ResourceListIterator(projectName, schemaName, resourceName);
    }

    private String getDefaultProjectName() {
        String project = this.client.getDefaultProject();
        if (project == null || project.length() == 0) {
            throw new RuntimeException("No default project specified.");
        }
        return project;
    }

    protected void setChunkSize(int chunkSize) {
        this.chunkSize = chunkSize;
    }

    private class ResourceListIterator
    extends ListIterator<Resource> {
        Map<String, String> params = new HashMap<String, String>();
        String name;
        String project;
        String schemaName;

        ResourceListIterator(String projectName, String schemaName, String resourceName) {
            this.project = projectName;
            this.schemaName = schemaName;
            this.name = resourceName;
            this.params = NameSpaceSchemaUtils.initParamsWithSchema(schemaName);
        }

        @Override
        public List<Resource> list(String marker, long maxItems) {
            if (marker != null) {
                this.params.put("marker", marker);
            }
            if (maxItems >= 0L) {
                this.params.put("maxitems", String.valueOf(maxItems));
            }
            return this.list();
        }

        @Override
        public String getMarker() {
            return this.params.get("marker");
        }

        @Override
        protected List<Resource> list() {
            ArrayList<Resource> resources = new ArrayList<Resource>();
            this.params.put("expectmarker", "true");
            String lastMarker = this.params.get("marker");
            if (this.params.containsKey("marker") && lastMarker.length() == 0) {
                return null;
            }
            if (this.name != null) {
                this.params.put("name", this.name);
            }
            String resource = ResourceBuilder.buildResourcesResource(this.project);
            try {
                ListResourcesResponse resp = Resources.this.client.request(ListResourcesResponse.class, resource, "GET", this.params);
                for (Resource.ResourceModel model : resp.resources) {
                    model.schemaName = this.schemaName;
                    Resource t = Resource.getResource(model, this.project, Resources.this.odps);
                    resources.add(t);
                }
                this.params.put("marker", resp.marker);
            }
            catch (OdpsException e) {
                throw new RuntimeException(e.getMessage(), e);
            }
            return resources;
        }
    }

    @Root(name="Resources", strict=false)
    private static class ListResourcesResponse {
        @Element(name="Marker", required=false)
        @Convert(value=SimpleXmlUtils.EmptyStringConverter.class)
        private String marker;
        @Element(name="MaxItems", required=false)
        private Integer maxItems;
        @ElementList(entry="Resource", inline=true, required=false)
        private List<Resource.ResourceModel> resources = new ArrayList<Resource.ResourceModel>();

        private ListResourcesResponse() {
        }
    }
}

