/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.odps;

import com.aliyun.odps.ArchiveResource;
import com.aliyun.odps.FileResource;
import com.aliyun.odps.JarResource;
import com.aliyun.odps.LazyLoad;
import com.aliyun.odps.Odps;
import com.aliyun.odps.OdpsException;
import com.aliyun.odps.PyResource;
import com.aliyun.odps.ReloadException;
import com.aliyun.odps.TableResource;
import com.aliyun.odps.Tag;
import com.aliyun.odps.VolumeArchiveResource;
import com.aliyun.odps.VolumeFileResource;
import com.aliyun.odps.commons.transport.Response;
import com.aliyun.odps.commons.util.DateUtils;
import com.aliyun.odps.rest.ResourceBuilder;
import com.aliyun.odps.rest.RestClient;
import com.aliyun.odps.rest.SimpleXmlUtils;
import com.aliyun.odps.simpleframework.xml.Element;
import com.aliyun.odps.simpleframework.xml.Root;
import com.aliyun.odps.simpleframework.xml.convert.Convert;
import com.aliyun.odps.utils.NameSpaceSchemaUtils;
import com.aliyun.odps.utils.StringUtils;
import com.aliyun.odps.utils.TagUtils;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class Resource
extends LazyLoad {
    ResourceModel model;
    private TagUtils.ObjectTagInfo resourceTagInfo;
    String project;
    RestClient client;
    Odps odps;

    public Resource() {
        this.model = new ResourceModel();
    }

    Resource(ResourceModel model, String project, Odps odps) {
        this.model = model;
        this.project = project;
        this.odps = odps;
        this.client = odps.getRestClient();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static Resource from(String defaultProjectName, String fullName, Odps odps) {
        if (StringUtils.isNullOrEmpty((String)fullName)) {
            throw new IllegalArgumentException("Argument 'fullName' cannot be null or empty");
        }
        String projectName = defaultProjectName;
        ResourceModel model = new ResourceModel();
        String[] parts = fullName.split("/");
        if (parts.length == 1) {
            model.name = parts[0];
            return new Resource(model, projectName, odps);
        } else if (parts.length == 3) {
            if (!"resources".equalsIgnoreCase(parts[1])) throw new IllegalArgumentException("Invalid resource full name");
            projectName = parts[0];
            model.name = parts[2];
            return new Resource(model, projectName, odps);
        } else {
            if (parts.length != 5) throw new IllegalArgumentException("Invalid resource full name");
            if (!"schemas".equalsIgnoreCase(parts[1]) || !"resources".equalsIgnoreCase(parts[3])) throw new IllegalArgumentException("Invalid resource full name");
            projectName = parts[0];
            model.schemaName = parts[2];
            model.name = parts[4];
        }
        return new Resource(model, projectName, odps);
    }

    static Resource createResource(Type type) {
        Resource resource;
        switch (type) {
            case ARCHIVE: {
                resource = new ArchiveResource();
                break;
            }
            case FILE: {
                resource = new FileResource();
                break;
            }
            case JAR: {
                resource = new JarResource();
                break;
            }
            case PY: {
                resource = new PyResource();
                break;
            }
            case TABLE: {
                resource = new TableResource();
                break;
            }
            case VOLUMEFILE: {
                resource = new VolumeFileResource();
                break;
            }
            case VOLUMEARCHIVE: {
                resource = new VolumeArchiveResource();
                break;
            }
            case UNKOWN: {
                resource = new Resource();
                break;
            }
            default: {
                resource = new Resource();
            }
        }
        return resource;
    }

    static Resource getResource(ResourceModel model, String project, Odps odps) {
        if (model.type == null) {
            Resource resource = new Resource(model, project, odps);
            try {
                resource.reload();
                model = resource.model;
            }
            catch (OdpsException e) {
                return resource;
            }
        }
        Type type = Type.valueOf(model.type.toUpperCase());
        Resource resource = Resource.createResource(type);
        resource.model = model;
        resource.project = project;
        resource.odps = odps;
        resource.client = odps.getRestClient();
        return resource;
    }

    public String getName() {
        if (this.model.name == null && this.client != null) {
            this.lazyLoad();
        }
        return this.model.name;
    }

    public void setName(String name) {
        this.model.name = name;
    }

    public String getComment() {
        if (this.model.comment == null && this.client != null) {
            this.lazyLoad();
        }
        return this.model.comment;
    }

    public void setComment(String comment) {
        this.model.comment = comment;
    }

    public String getOwner() {
        if (this.model.owner == null && this.client != null) {
            this.lazyLoad();
        }
        return this.model.owner;
    }

    public Type getType() {
        if (this.model.type == null && this.client != null) {
            this.lazyLoad();
        }
        if (this.model.type == null) {
            return Type.UNKOWN;
        }
        try {
            return Type.valueOf(this.model.type.toUpperCase());
        }
        catch (IllegalArgumentException e) {
            return Type.UNKOWN;
        }
    }

    public Date getCreatedTime() {
        if (this.model.createdTime == null && this.client != null) {
            this.lazyLoad();
        }
        return this.model.createdTime;
    }

    public Date getLastModifiedTime() {
        if (this.model.lastModifiedTime == null && this.client != null) {
            this.lazyLoad();
        }
        return this.model.lastModifiedTime;
    }

    public String getLastUpdator() {
        if (this.model.lastUpdator == null && this.client != null) {
            this.lazyLoad();
        }
        return this.model.lastUpdator;
    }

    public Long getSize() {
        if (this.model.size == null && this.client != null) {
            this.lazyLoad();
        }
        return this.model.size;
    }

    public String getProject() {
        return this.project;
    }

    public String getSchemaName() {
        this.lazyLoad();
        return this.model.schemaName;
    }

    @Override
    public void reload() throws OdpsException {
        String resource = ResourceBuilder.buildResourceResource(this.project, this.model.name);
        HashMap<String, String> params = NameSpaceSchemaUtils.initParamsWithSchema(this.model.schemaName);
        params.put("meta", null);
        Response rp = this.client.request(resource, "GET", params, null, null);
        Map<String, String> headers = rp.getHeaders();
        this.model.owner = headers.get("x-odps-owner");
        this.model.type = headers.get("x-odps-resource-type");
        this.model.comment = headers.get("x-odps-comment");
        this.model.lastUpdator = headers.get("x-odps-updator");
        this.model.schemaName = headers.get("schema-name");
        String sizeStr = headers.get("x-odps-resource-size");
        try {
            this.model.size = sizeStr == null ? null : Long.valueOf(Long.parseLong(sizeStr));
        }
        catch (NumberFormatException e) {
            throw new OdpsException("Invalid resource size format" + sizeStr, e);
        }
        try {
            this.model.createdTime = DateUtils.parseRfc822Date(headers.get("x-odps-creation-time"));
            this.model.lastModifiedTime = DateUtils.parseRfc822Date(headers.get("Last-Modified"));
        }
        catch (Exception e) {
            throw new OdpsException("Invalid date format", e);
        }
        this.model.sourceTableName = headers.get("x-odps-copy-table-source");
        this.model.volumePath = headers.get("x-odps-copy-file-source");
        this.model.contentMD5 = headers.get("Content-MD5");
        this.setLoaded(true);
    }

    private void reloadTagInfo() {
        String resource = ResourceBuilder.buildResourceResource(this.project, this.model.name);
        try {
            this.resourceTagInfo = TagUtils.getObjectTagInfo(resource, null, this.client);
        }
        catch (OdpsException e) {
            throw new ReloadException(e);
        }
    }

    public void updateOwner(String newOwner) throws OdpsException {
        String method = "PUT";
        String resource = ResourceBuilder.buildResourceResource(this.project, this.model.name);
        HashMap<String, String> params = NameSpaceSchemaUtils.initParamsWithSchema(this.model.schemaName);
        params.put("updateowner", null);
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("x-odps-owner", newOwner);
        this.client.request(resource, method, params, headers, null);
        this.model.owner = newOwner;
    }

    public List<Tag> getTags() {
        this.reloadTagInfo();
        return TagUtils.getTags(this.resourceTagInfo, this.odps);
    }

    public Map<String, Map<String, String>> getSimpleTags() {
        this.reloadTagInfo();
        return TagUtils.getSimpleTags(this.resourceTagInfo);
    }

    public void addTag(Tag tag) throws OdpsException {
        TagUtils.ObjectRef objectRef = new TagUtils.ObjectRef(TagUtils.OBJECT_TYPE.RESOURCE, this.project, this.model.name, null);
        TagUtils.TagRef tagRef = new TagUtils.TagRef(tag.getClassification(), tag.getName());
        TagUtils.SetObjectTagInput setObjectTagInput = new TagUtils.SetObjectTagInput(TagUtils.OPERATION_TYPE.SET, objectRef, tagRef, null);
        TagUtils.updateTagInternal(setObjectTagInput, null, this.client);
    }

    public void addSimpleTag(String category, String key, String value) throws OdpsException {
        TagUtils.ObjectRef objectRef = new TagUtils.ObjectRef(TagUtils.OBJECT_TYPE.RESOURCE, this.project, this.model.name, null);
        TagUtils.SimpleTag simpleTag = new TagUtils.SimpleTag(category, Collections.singletonMap(key, value));
        TagUtils.SetObjectTagInput setObjectTagInput = new TagUtils.SetObjectTagInput(TagUtils.OPERATION_TYPE.SET, objectRef, null, simpleTag);
        TagUtils.updateTagInternal(setObjectTagInput, null, this.client);
    }

    public void removeTag(Tag tag) throws OdpsException {
        Objects.requireNonNull(tag);
        TagUtils.ObjectRef objectRef = new TagUtils.ObjectRef(TagUtils.OBJECT_TYPE.RESOURCE, this.project, this.model.name, null);
        TagUtils.TagRef tagRef = new TagUtils.TagRef(tag.getClassification(), tag.getName());
        TagUtils.SetObjectTagInput setObjectTagInput = new TagUtils.SetObjectTagInput(TagUtils.OPERATION_TYPE.UNSET, objectRef, tagRef, null);
        TagUtils.updateTagInternal(setObjectTagInput, null, this.client);
    }

    public void removeSimpleTag(String category, String key, String value) throws OdpsException {
        Objects.requireNonNull(category);
        Objects.requireNonNull(key);
        Objects.requireNonNull(value);
        TagUtils.ObjectRef objectRef = new TagUtils.ObjectRef(TagUtils.OBJECT_TYPE.RESOURCE, this.project, this.model.name, null);
        TagUtils.SimpleTag simpleTag = new TagUtils.SimpleTag(category, Collections.singletonMap(key, value));
        TagUtils.SetObjectTagInput setObjectTagInput = new TagUtils.SetObjectTagInput(TagUtils.OPERATION_TYPE.UNSET, objectRef, null, simpleTag);
        TagUtils.updateTagInternal(setObjectTagInput, null, this.client);
    }

    @Root(name="Resource", strict=false)
    static class ResourceModel {
        @Element(name="SchemaName", required=false)
        @Convert(value=SimpleXmlUtils.EmptyStringConverter.class)
        String schemaName;
        @Element(name="Name", required=false)
        @Convert(value=SimpleXmlUtils.EmptyStringConverter.class)
        String name;
        @Element(name="Owner", required=false)
        @Convert(value=SimpleXmlUtils.EmptyStringConverter.class)
        String owner;
        @Element(name="Comment", required=false)
        @Convert(value=SimpleXmlUtils.EmptyStringConverter.class)
        String comment;
        @Element(name="ResourceType", required=false)
        @Convert(value=SimpleXmlUtils.EmptyStringConverter.class)
        String type;
        @Element(name="CreationTime", required=false)
        @Convert(value=SimpleXmlUtils.DateConverter.class)
        Date createdTime;
        @Element(name="LastModifiedTime", required=false)
        @Convert(value=SimpleXmlUtils.DateConverter.class)
        Date lastModifiedTime;
        @Element(name="LastUpdator", required=false)
        @Convert(value=SimpleXmlUtils.EmptyStringConverter.class)
        String lastUpdator;
        @Element(name="ResourceSize", required=false)
        Long size;
        @Element(name="TableName", required=false)
        @Convert(value=SimpleXmlUtils.EmptyStringConverter.class)
        String sourceTableName;
        String contentMD5;
        boolean isTempResource;
        String volumePath;

        ResourceModel() {
        }
    }

    public static enum Type {
        FILE,
        JAR,
        PY,
        ARCHIVE,
        TABLE,
        VOLUMEFILE,
        VOLUMEARCHIVE,
        UNKOWN;

    }
}

