/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.odps;

import com.aliyun.odps.Classifications;
import com.aliyun.odps.Functions;
import com.aliyun.odps.Instances;
import com.aliyun.odps.LogView;
import com.aliyun.odps.Projects;
import com.aliyun.odps.Quotas;
import com.aliyun.odps.Resources;
import com.aliyun.odps.Schemas;
import com.aliyun.odps.Streams;
import com.aliyun.odps.Tables;
import com.aliyun.odps.Task;
import com.aliyun.odps.Tenant;
import com.aliyun.odps.Volumes;
import com.aliyun.odps.XFlows;
import com.aliyun.odps.account.Account;
import com.aliyun.odps.account.AccountFormat;
import com.aliyun.odps.account.AppAccount;
import com.aliyun.odps.account.AppStsAccount;
import com.aliyun.odps.commons.transport.DefaultTransport;
import com.aliyun.odps.ml.OfflineModels;
import com.aliyun.odps.rest.RestClient;
import com.aliyun.odps.tunnel.Configuration;
import com.aliyun.odps.tunnel.TableTunnel;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Map;

public class Odps {
    private static final String defaultEndpoint = "http://service.odps.aliyun.com/api";
    private Account account;
    private AppAccount appAccount;
    private AppStsAccount appStsAccount;
    private String endpoint;
    private String defaultProject;
    private String currentSchema;
    private String tunnelEndpoint;
    private Tenant tenant;
    private Projects projects;
    private Schemas schemas;
    private Tables tables;
    private Instances instances;
    private Resources resources;
    private Functions functions;
    private Volumes volumes;
    private XFlows xflows;
    private OfflineModels offlineModels;
    private Classifications classifications;
    private Quotas quotas;
    private Streams streams;
    protected RestClient client;
    private String userAgent;
    private String logViewHost;
    private AccountFormat accountFormat = null;

    public void setAccount(Account account) {
        this.client.setAccount(account);
        this.account = account;
    }

    public void setAppAccount(AppAccount appAccount) {
        this.client.setAppAccount(appAccount);
        this.appAccount = appAccount;
    }

    public void setAppStsAccount(AppStsAccount appStsAccount) {
        this.client.setAppStsAccount(appStsAccount);
        this.appStsAccount = appStsAccount;
    }

    public Odps(Account account) {
        this(account, null);
    }

    public Odps(Account account, AppAccount appAccount) {
        this.account = account;
        this.appAccount = appAccount;
        this.client = new RestClient(new DefaultTransport());
        this.client.setAccount(account);
        this.client.setAppAccount(appAccount);
        this.setUserAgent("");
        this.setEndpoint(defaultEndpoint);
        this.tenant = new Tenant(this);
        this.projects = new Projects(this);
        this.schemas = new Schemas(this);
        this.tables = new Tables(this);
        this.streams = new Streams(this);
        this.instances = new Instances(this);
        this.resources = new Resources(this);
        this.functions = new Functions(this);
        this.volumes = new Volumes(this.client);
        this.xflows = new XFlows(this);
        this.offlineModels = new OfflineModels(this);
        this.classifications = new Classifications(this);
        this.quotas = new Quotas(this);
    }

    public Odps(Odps odps) {
        this(odps.account, odps.appAccount);
        this.setDefaultProject(odps.getDefaultProject());
        this.setUserAgent(odps.getUserAgent());
        this.setEndpoint(odps.getEndpoint());
        this.setLogViewHost(odps.getLogViewHost());
        this.client.setIgnoreCerts(odps.getRestClient().isIgnoreCerts());
        if (odps.getRestClient().getProxy() != null) {
            this.client.setProxy(odps.getRestClient().getProxy());
        }
        this.instances.setDefaultRunningCluster(odps.instances.getDefaultRunningCluster());
    }

    public Tenant tenant() {
        return this.tenant;
    }

    public Projects projects() {
        return this.projects;
    }

    public Schemas schemas() {
        return this.schemas;
    }

    public Tables tables() {
        return this.tables;
    }

    public Streams streams() {
        return this.streams;
    }

    public Instances instances() {
        return this.instances;
    }

    public Resources resources() {
        return this.resources;
    }

    public Functions functions() {
        return this.functions;
    }

    public Volumes volumes() {
        return this.volumes;
    }

    public Classifications classifications() {
        return this.classifications;
    }

    public TableTunnel tableTunnel() {
        return new TableTunnel(this);
    }

    public TableTunnel tableTunnel(Configuration configuration) {
        return new TableTunnel(this, configuration);
    }

    public Quotas quotas() {
        return this.quotas;
    }

    public Account getAccount() {
        return this.account;
    }

    public AppAccount getAppAccount() {
        return this.appAccount;
    }

    public AppStsAccount getAppStsAccount() {
        return this.appStsAccount;
    }

    public String getEndpoint() {
        return this.endpoint;
    }

    public void setEndpoint(String endpoint) {
        try {
            URI uri = new URI(endpoint);
            this.endpoint = uri.toString();
            this.client.setEndpoint(this.endpoint);
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public void setTunnelEndpoint(String tunnelEndpoint) {
        this.tunnelEndpoint = tunnelEndpoint;
    }

    public String getTunnelEndpoint() {
        return this.tunnelEndpoint;
    }

    public String getDefaultProject() {
        return this.defaultProject;
    }

    public String getCurrentSchema() {
        return this.currentSchema;
    }

    public void setDefaultProject(String defaultProject) {
        this.defaultProject = defaultProject;
        this.currentSchema = null;
        this.client.setDefaultProject(defaultProject);
        this.client.setCurrentSchema(null);
    }

    public void setCurrentSchema(String schema) {
        this.currentSchema = schema;
        this.client.setCurrentSchema(schema);
    }

    public void setUserAgent(String userAgent) {
        this.userAgent = userAgent;
        this.client.setUserAgent(userAgent);
    }

    public String getUserAgent() {
        return this.userAgent;
    }

    public LogView logview() {
        return new LogView(this);
    }

    public XFlows xFlows() {
        return this.xflows;
    }

    public OfflineModels offlineModels() {
        return this.offlineModels;
    }

    public Odps clone() {
        return new Odps(this);
    }

    public RestClient getRestClient() {
        return this.client;
    }

    public String getLogViewHost() {
        return this.logViewHost;
    }

    public void setLogViewHost(String host) {
        this.logViewHost = host;
    }

    public void setAccountFormat(AccountFormat format) {
        this.accountFormat = format;
    }

    public AccountFormat getAccountFormat() {
        return this.accountFormat;
    }

    public void setGlobalSettings(Map<String, String> settings) {
        Task.setGlobalSettings(settings);
    }

    public Map<String, String> getGlobalSettings() {
        return Task.getGlobalSettings();
    }
}

