/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.odps;

import com.aliyun.odps.Classification;
import com.aliyun.odps.ListIterator;
import com.aliyun.odps.NoSuchObjectException;
import com.aliyun.odps.Odps;
import com.aliyun.odps.OdpsException;
import com.aliyun.odps.commons.transport.Response;
import com.aliyun.odps.rest.ResourceBuilder;
import com.aliyun.odps.rest.RestClient;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;

public class Classifications
implements Iterable<Classification> {
    private static final Gson GSON = new GsonBuilder().registerTypeHierarchyAdapter(Classification.AttributeDefinition.class, (Object)new Classification.AttributeDeserializer()).registerTypeHierarchyAdapter(Classification.AttributeDefinition.class, (Object)new Classification.AttributeSerializer()).registerTypeAdapter(Classification.ClassificationModel.class, (Object)new Classification.ClassificationModelDeserializer()).registerTypeAdapter(Classification.ClassificationModel.class, (Object)new Classification.ClassificationModelSerializer()).create();
    RestClient client;
    Odps odps;

    Classifications(Odps odps) {
        this.odps = Objects.requireNonNull(odps);
        this.client = odps.getRestClient();
    }

    public void create(String name, Map<String, Classification.AttributeDefinition> attributes, boolean ifNotExists) throws OdpsException {
        Classification.ClassificationModel model = new Classification.ClassificationModel();
        model.project = this.odps.getDefaultProject();
        model.name = Objects.requireNonNull(name);
        model.attributes = Objects.requireNonNull(attributes);
        Classification classification = new Classification(model, this.odps);
        JsonObject root = new JsonObject();
        root.add("ClassificationInput", GSON.toJsonTree((Object)classification.model));
        root.addProperty("IfNotExists", Boolean.valueOf(ifNotExists));
        String resource = ResourceBuilder.buildClassificationsResource(this.odps.getDefaultProject());
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Content-Type", "application/json");
        String body = GSON.toJson((JsonElement)root);
        this.client.request(resource, "POST", null, headers, body.getBytes());
    }

    public void delete(String name) throws OdpsException {
        String resource = ResourceBuilder.buildClassificationResource(this.odps.getDefaultProject(), Objects.requireNonNull(name));
        this.client.request(resource, "DELETE", null, null, null);
    }

    public boolean exists(String name) throws OdpsException {
        try {
            Classification classification = this.get(name);
            classification.reload();
            return true;
        }
        catch (NoSuchObjectException e) {
            return false;
        }
    }

    public Classification get(String name) {
        Classification.ClassificationModel model = new Classification.ClassificationModel();
        model.project = this.odps.getDefaultProject();
        model.name = Objects.requireNonNull(name);
        return new Classification(model, this.odps);
    }

    @Override
    public Iterator<Classification> iterator() {
        return new ClassificationIterator(this.odps.getDefaultProject());
    }

    private class ClassificationIterator
    extends ListIterator<Classification> {
        Map<String, String> params = new HashMap<String, String>();
        private String project;

        ClassificationIterator(String project) {
            this.project = Objects.requireNonNull(project);
        }

        @Override
        protected List<Classification> list() {
            LinkedList<Classification> classifications = new LinkedList<Classification>();
            String lastMarker = this.params.get("NextPageToken");
            if (this.params.containsKey("NextPageToken") && lastMarker.isEmpty()) {
                return null;
            }
            String resource = ResourceBuilder.buildClassificationsResource(this.project);
            try {
                Response resp = Classifications.this.client.request(resource, "GET", this.params, null, null);
                String respBody = new String(resp.getBody(), StandardCharsets.UTF_8);
                JsonParser parser = new JsonParser();
                JsonElement parsedRespBody = parser.parse(respBody);
                JsonObject jsonObject = parsedRespBody.getAsJsonObject();
                if (jsonObject.has("NextPageToken")) {
                    this.params.put("NextPageToken", jsonObject.get("NextPageToken").getAsString());
                }
                if (jsonObject.has("Classifications")) {
                    Type t = new TypeToken<List<Classification.ClassificationModel>>(){}.getType();
                    List classificationModels = (List)GSON.fromJson((JsonElement)jsonObject.get("Classifications").getAsJsonArray(), t);
                    classifications.addAll(classificationModels.stream().map(m -> new Classification((Classification.ClassificationModel)m, Classifications.this.odps)).collect(Collectors.toList()));
                }
            }
            catch (OdpsException e) {
                throw new RuntimeException(e.getMessage(), e);
            }
            return classifications;
        }
    }
}

