/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.odps.mapred.lib;

import com.aliyun.odps.data.Record;
import com.aliyun.odps.mapred.Partitioner;
import com.aliyun.odps.mapred.conf.JobConf;
import com.aliyun.odps.mapred.lib.KeyFieldHelper;
import com.aliyun.odps.mapred.utils.UTF8ByteArrayUtils;
import java.io.UnsupportedEncodingException;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class KeyFieldBasedPartitioner
extends Partitioner {
    private static final Log LOG = LogFactory.getLog((String)KeyFieldBasedPartitioner.class.getName());
    private int numOfPartitionFields;
    private KeyFieldHelper keyFieldHelper = new KeyFieldHelper();
    private JobConf conf;

    @Override
    public void configure(JobConf conf) {
        this.conf = conf;
        this.keyFieldHelper = new KeyFieldHelper();
        String keyFieldSeparator = UTF8ByteArrayUtils.unescapeSeparator(conf.get("map.output.key.field.separator", "\t"));
        this.keyFieldHelper.setKeyFieldSeparator(keyFieldSeparator);
        this.numOfPartitionFields = conf.getInt("num.key.fields.for.partition", 0);
        this.keyFieldHelper.setKeyFieldSpec(1, this.numOfPartitionFields);
    }

    @Override
    public int getPartition(Record keyRec, Record valueRec, int numReduceTasks) {
        byte[] keyBytes;
        Object key = keyRec.get(0);
        List<KeyFieldHelper.KeyDescription> allKeySpecs = this.keyFieldHelper.keySpecs();
        if (allKeySpecs.size() == 0) {
            return this.getPartition(key.toString().hashCode(), numReduceTasks);
        }
        try {
            keyBytes = key.toString().getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("The current system does not support UTF-8 encoding!", e);
        }
        if (keyBytes.length == 0) {
            return 0;
        }
        int[] lengthIndicesFirst = this.keyFieldHelper.getWordLengths(keyBytes, 0, keyBytes.length);
        int currentHash = 0;
        for (KeyFieldHelper.KeyDescription keySpec : allKeySpecs) {
            int startChar = this.keyFieldHelper.getStartOffset(keyBytes, 0, keyBytes.length, lengthIndicesFirst, keySpec);
            if (startChar < 0) continue;
            int endChar = this.keyFieldHelper.getEndOffset(keyBytes, 0, keyBytes.length, lengthIndicesFirst, keySpec);
            currentHash = this.hashCode(keyBytes, startChar, endChar, currentHash);
        }
        return this.getPartition(currentHash, numReduceTasks);
    }

    protected int hashCode(byte[] b, int start, int end, int currentHash) {
        for (int i = start; i <= end; ++i) {
            currentHash = 31 * currentHash + b[i];
        }
        return currentHash;
    }

    protected int getPartition(int hash, int numReduceTasks) {
        return (hash & Integer.MAX_VALUE) % numReduceTasks;
    }
}

