/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.odps.volume;

import com.aliyun.odps.VolumeException;
import com.aliyun.odps.tunnel.io.VolumeOutputStream;
import com.aliyun.odps.volume.VolumeFSClient;
import java.io.IOException;
import java.io.OutputStream;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.util.Progressable;

public class VolumeFSOutputStream
extends OutputStream {
    private VolumeFSClient volumeClient;
    private String path;
    private OutputStream volumeOutputStream;
    private Progressable progress;
    private ExecutorService executorService = Executors.newFixedThreadPool(1);
    private long accumulationWithBlockSize = 0L;
    private long blockSize;
    private boolean overwrite;
    private boolean isClosed;

    public VolumeFSOutputStream(String path, VolumeFSClient volumeClient, FsPermission permission, boolean overwrite, short replication, long blockSize, Progressable progress) throws VolumeException {
        this.path = path;
        this.volumeClient = volumeClient;
        this.volumeOutputStream = volumeClient.openOutputStream(path, overwrite, replication);
        this.isClosed = false;
        this.blockSize = blockSize;
        this.overwrite = overwrite;
        this.progress = progress;
    }

    @Override
    public void write(int b) throws IOException {
        this.volumeOutputStream.write(b);
        this.progress(1);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        this.volumeOutputStream.write(b, off, len);
        this.progress(len);
    }

    @Override
    public synchronized void close() throws IOException {
        if (this.isClosed) {
            return;
        }
        try {
            this.volumeClient.commitUploadSession(this.path, (VolumeOutputStream)this.volumeOutputStream, this.overwrite);
            this.isClosed = true;
        }
        catch (VolumeException e) {
            throw new IOException("Commit upload session fails:" + e.getMessage(), e);
        }
    }

    private void progress(int len) {
        if (this.progress != null) {
            this.accumulationWithBlockSize += (long)len;
            if (this.accumulationWithBlockSize >= this.blockSize) {
                this.executorService.submit(new Runnable(){

                    @Override
                    public void run() {
                        VolumeFSOutputStream.this.progress.progress();
                    }
                });
                this.accumulationWithBlockSize = 0L;
            }
        }
    }
}

