/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.odps.udf.local.util;

import com.aliyun.odps.udf.local.LocalRunException;
import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;

public class ClassUtils {
    public static Object newInstance(ClassLoader loader, String className) throws LocalRunException {
        try {
            Class<?> tfClz = Class.forName(className, true, loader);
            return tfClz.newInstance();
        }
        catch (Exception e) {
            throw new LocalRunException(e);
        }
    }

    public static Method findMethod(Class<?> clz, String methodName, Class[] parameterTypes) throws LocalRunException {
        Method method;
        block3: {
            try {
                method = clz.getMethod(methodName, parameterTypes);
            }
            catch (SecurityException e) {
                throw new LocalRunException(e);
            }
            catch (NoSuchMethodException e) {
                method = ClassUtils.findVarargMethod(clz, methodName, parameterTypes);
                if (method != null) break block3;
                throw new LocalRunException(e);
            }
        }
        return method;
    }

    public static Method findVarargMethod(Class<?> clz, String methodName, Class<?>[] parameterTypes) {
        if (parameterTypes.length == 0) {
            return null;
        }
        for (Method method : clz.getMethods()) {
            int firstVarargIndex;
            Class<?>[] methodParaTypes;
            if (!method.getName().equals(methodName) || Modifier.isStatic(method.getModifiers()) || method.isBridge() || parameterTypes.length < (methodParaTypes = method.getParameterTypes()).length) continue;
            boolean argMatch = false;
            if (parameterTypes.length == methodParaTypes.length) {
                for (int index = 0; index < parameterTypes.length && (argMatch = methodParaTypes[index].isAssignableFrom(parameterTypes[index])); ++index) {
                }
            }
            if (!argMatch && (firstVarargIndex = methodParaTypes.length - 1) >= 0 && methodParaTypes[firstVarargIndex].isArray()) {
                Class<?> varArgClass = methodParaTypes[firstVarargIndex].getComponentType();
                for (int index = 0; index < parameterTypes.length && (argMatch = index < firstVarargIndex ? methodParaTypes[index].isAssignableFrom(parameterTypes[index]) : varArgClass.isAssignableFrom(parameterTypes[index])); ++index) {
                }
            }
            if (!argMatch) continue;
            return method;
        }
        return null;
    }

    public static Object[] adaptVarargMethodDataIfNecessary(Method method, Object[] data) {
        int firstVarargIndex;
        Class<?>[] methodParaTypes = method.getParameterTypes();
        if (data.length >= methodParaTypes.length && (firstVarargIndex = methodParaTypes.length - 1) >= 0 && methodParaTypes[firstVarargIndex].isArray()) {
            Class<?> varArgClass = methodParaTypes[firstVarargIndex].getComponentType();
            int numOfVararg = data.length - firstVarargIndex;
            Object varArg = Array.newInstance(varArgClass, numOfVararg);
            for (int i = 0; i < numOfVararg; ++i) {
                Array.set(varArg, i, data[firstVarargIndex + i]);
            }
            Object[] varArgs = new Object[firstVarargIndex + 1];
            for (int i = 0; i < firstVarargIndex; ++i) {
                varArgs[i] = data[i];
            }
            varArgs[firstVarargIndex] = varArg;
            return varArgs;
        }
        return data;
    }
}

