/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.odps.udf.local.runner;

import com.aliyun.odps.Odps;
import com.aliyun.odps.io.Writable;
import com.aliyun.odps.local.common.Pair;
import com.aliyun.odps.local.common.security.SecurityClient;
import com.aliyun.odps.local.common.utils.LocalWritableUtils;
import com.aliyun.odps.type.TypeInfo;
import com.aliyun.odps.udf.Aggregator;
import com.aliyun.odps.udf.ExecutionContext;
import com.aliyun.odps.udf.UDFException;
import com.aliyun.odps.udf.annotation.Resolve;
import com.aliyun.odps.udf.local.LocalRunException;
import com.aliyun.odps.udf.local.runner.BaseRunner;
import com.aliyun.odps.udf.local.util.ClassUtils;
import com.aliyun.odps.udf.local.util.ResolveUtils;
import java.util.List;

public class AggregatorRunner
extends BaseRunner {
    private Aggregator aggregator;
    private Writable userDefineBuffer;
    private List<TypeInfo> inputTypes;
    private TypeInfo outputType;

    public AggregatorRunner(Odps odps, Aggregator aggregator) throws UDFException {
        super(odps);
        this.aggregator = aggregator;
        this.checkArguments(aggregator);
        try {
            SecurityClient.open();
            aggregator.setup((ExecutionContext)this.context);
            this.userDefineBuffer = aggregator.newBuffer();
        }
        catch (Exception ex) {
            throw new UDFException((Throwable)ex);
        }
        finally {
            SecurityClient.close();
        }
    }

    public AggregatorRunner(Odps odps, String className) throws LocalRunException {
        super(odps);
        try {
            SecurityClient.open();
            this.aggregator = (Aggregator)ClassUtils.newInstance(AggregatorRunner.class.getClassLoader(), className);
            this.checkArguments(this.aggregator);
            this.aggregator.setup((ExecutionContext)this.context);
            this.userDefineBuffer = this.aggregator.newBuffer();
        }
        catch (LocalRunException e) {
            throw e;
        }
        catch (UDFException e) {
            throw new LocalRunException(e);
        }
        finally {
            SecurityClient.close();
        }
    }

    private void checkArguments(Aggregator aggregator) {
        Resolve r = aggregator.getClass().getAnnotation(Resolve.class);
        if (r != null) {
            Pair<List<TypeInfo>, List<TypeInfo>> inputOutputTypes = ResolveUtils.parseResolve(r);
            this.inputTypes = (List)inputOutputTypes.getFirst();
            this.outputType = (TypeInfo)((List)inputOutputTypes.getSecond()).get(0);
        }
    }

    @Override
    public BaseRunner internalFeed(Object[] input) throws LocalRunException {
        Writable[] inputWritables = LocalWritableUtils.convert((Object[])input, this.inputTypes);
        try {
            SecurityClient.open();
            Writable partialBuffer = this.aggregator.newBuffer();
            this.aggregator.iterate(partialBuffer, inputWritables);
            this.aggregator.merge(this.userDefineBuffer, partialBuffer);
        }
        catch (UDFException e) {
            throw new LocalRunException(e);
        }
        finally {
            SecurityClient.close();
        }
        return this;
    }

    @Override
    public List<Object[]> internalYield() throws LocalRunException {
        try {
            SecurityClient.open();
            Writable result = this.aggregator.terminate(this.userDefineBuffer);
            this.buffer.add(new Object[]{LocalWritableUtils.convert((Writable)result, (TypeInfo)this.outputType)});
            this.aggregator.close();
        }
        catch (UDFException e) {
            throw new LocalRunException(e);
        }
        finally {
            SecurityClient.close();
        }
        this.aggregator = null;
        return this.buffer;
    }
}

