/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.odps.console;

import com.aliyun.odps.Instance;
import com.aliyun.odps.Odps;
import com.aliyun.odps.OdpsException;
import com.aliyun.odps.Session;
import com.aliyun.odps.data.Record;
import com.aliyun.odps.data.ResultSet;
import com.aliyun.odps.sqa.SQLExecutor;
import com.aliyun.odps.utils.StringUtils;
import com.aliyun.openservices.odps.console.ExecutionContext;
import com.aliyun.openservices.odps.console.ODPSConsoleException;
import com.aliyun.openservices.odps.console.RecordPrinter;
import com.aliyun.openservices.odps.console.commands.MultiClusterCommandBase;
import com.aliyun.openservices.odps.console.commands.SetCommand;
import com.aliyun.openservices.odps.console.output.state.InstanceProgressReporter;
import com.aliyun.openservices.odps.console.output.state.InstanceStateContext;
import com.aliyun.openservices.odps.console.utils.ODPSConsoleUtils;
import com.aliyun.openservices.odps.console.utils.SessionUtils;
import com.aliyun.openservices.odps.console.utils.SignalUtil;
import com.google.gson.Gson;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import sun.misc.SignalHandler;

public class InteractiveQueryCommand
extends MultiClusterCommandBase {
    private static SimpleDateFormat DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    private static String startRegex = "start\\s+session(\\s+(public\\.|quota\\.){0,1}\\w+)?";
    private static String useRegex = "use\\s+session\\s+(\\w+)";
    private static String attachRegex = "attach\\s+session\\s+((public\\.|quota\\.){0,1}\\w+)";
    private static String stopRegex = "stop\\s+session";
    private static String detachRegex = "detach\\s+session";
    private static String stopWithIdRegex = "stop\\s+session\\s+(\\w+)";
    private static String listRegex = "list\\s+session";
    private static String setInformationRegex = "session\\s+set\\s+(\\w+)\\s+(\\S+)";
    private static String getInformationRegex = "session\\s+get\\s+(\\w+)";
    private static String showVarsRegex = "show\\s+variables";
    private static String fallbackMessage = "Query failed";
    private static String rerunInteractiveMode = "Will rerun in interactive mode";
    private static String runOfflineMode = "Running in offline mode";
    private Lock waitLogviewLock = new ReentrantLock();
    private Condition waitLogviewCond = this.waitLogviewLock.newCondition();
    private AtomicBoolean logviewGenerated = new AtomicBoolean(false);

    private String getProgressFormatString(Session.SessionProgress progress) {
        return String.format("%s Session starting: %d/%d [%d%%]", DATE_FORMAT.format(new Date()), progress.launchedWorkerCount, progress.totalWorkerCount, progress.launchedPercentage);
    }

    private void finishReporter(ReporterThread reporterThread) {
        try {
            InstanceProgressReporter reporter;
            this.interruptReporter(reporterThread);
            InstanceStateContext instanceStateContext = reporterThread.getStateContext();
            if (instanceStateContext != null && (reporter = reporterThread.getReporter()) != null) {
                reporter.printProgress(true);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void interruptReporter(ReporterThread reporterThread) {
        reporterThread.finish();
        reporterThread.disableOutput();
        reporterThread.interrupt();
    }

    private void printRecords(ResultSet resultSet) throws IOException, ODPSConsoleException {
        RecordPrinter recordPrinter = RecordPrinter.createReporter(resultSet.getTableSchema(), this.getContext());
        recordPrinter.printFrame();
        recordPrinter.printTitle();
        recordPrinter.printFrame();
        while (resultSet.hasNext()) {
            ODPSConsoleUtils.checkThreadInterrupted();
            Record record = resultSet.next();
            if (record == null) break;
            recordPrinter.printRecord(record);
        }
        recordPrinter.printFrame();
    }

    private void waitLogviewGenerated() throws ODPSConsoleException {
        try {
            this.waitLogviewLock.lock();
            if (!this.logviewGenerated.get()) {
                this.waitLogviewCond.await();
            }
        }
        catch (InterruptedException e) {
            throw new ODPSConsoleException(e.getMessage(), (Throwable)e);
        }
        finally {
            this.waitLogviewLock.unlock();
        }
    }

    private void getQueryResult(long startTime) throws ODPSConsoleException {
        SQLExecutor executor = ExecutionContext.getExecutor();
        if (this.getContext().isInteractiveOutputCompatible()) {
            this.getWriter().writeResult("ID = " + executor.getInstance().getId());
        }
        ReporterThread reporterThread = new ReporterThread(this.getCurrentOdps(), executor, this.getContext());
        reporterThread.setDaemon(true);
        reporterThread.start();
        try {
            ResultSet resultSet = this.getContext().isUseInstanceTunnel() ? executor.getResultSet(this.getContext().getInstanceTunnelMaxRecord(), this.getContext().getInstanceTunnelMaxSize()) : executor.getResultSet();
            this.waitLogviewGenerated();
            this.finishReporter(reporterThread);
            String postMessage = "Session sub-query cost time: " + String.valueOf(System.currentTimeMillis() - startTime) + " ms.";
            if (this.getContext().isInteractiveOutputCompatible()) {
                String sqlstats = executor.getInstance().getTaskInfo("console_sqlrt_task", "sqlstats");
                Gson gson = new Gson();
                Session.SubQueryResponse respo = (Session.SubQueryResponse)gson.fromJson(sqlstats, Session.SubQueryResponse.class);
                this.getWriter().writeResult("Summary:\n" + respo.result);
            }
            if (resultSet.getTableSchema() != null && resultSet.getTableSchema().getColumns().size() != 0) {
                this.printRecords(resultSet);
            }
            this.getWriter().writeDebug(postMessage);
        }
        catch (OdpsException e) {
            this.waitLogviewGenerated();
            throw new ODPSConsoleException(e.toString(), (Throwable)e);
        }
        catch (IOException e) {
            this.waitLogviewGenerated();
            throw new ODPSConsoleException(e.getMessage(), (Throwable)e);
        }
        finally {
            if (reporterThread.isAlive()) {
                this.interruptReporter(reporterThread);
            }
        }
    }

    private void submitSubQuery() throws OdpsException, ODPSConsoleException {
        SQLExecutor executor;
        long startTime = System.currentTimeMillis();
        String commandString = this.getCommandText();
        if (!commandString.endsWith(";")) {
            commandString = commandString + ";";
        }
        if ((executor = ExecutionContext.getExecutor()) == null) {
            this.getWriter().writeError("FAILED: You need to start, use or attach session in advance.");
            return;
        }
        boolean isSelect = commandString.toUpperCase().matches("^SELECT[\\s\\S]*");
        HashMap settings = new HashMap();
        if (!SetCommand.setMap.isEmpty()) {
            for (Map.Entry property : SetCommand.setMap.entrySet()) {
                settings.put(property.getKey(), property.getValue());
            }
        }
        settings.put("odps.sql.select.output.format", "csv");
        executor.run(commandString, settings);
        this.getQueryResult(startTime);
        if (!isSelect) {
            this.getWriter().writeError("OK");
        }
    }

    private void detachSession() throws OdpsException {
        try {
            ExecutionContext.getExecutor().close();
        }
        catch (Exception ex) {
            this.getWriter().writeDebug(ex.toString());
        }
        finally {
            SessionUtils.clearSessionContext((ExecutionContext)this.getContext());
        }
    }

    private void attachSession(String sessionName) throws OdpsException, ODPSConsoleException {
        if (ExecutionContext.getExecutor() != null && ExecutionContext.getExecutor().getInstance() != null) {
            this.getWriter().writeDebug("You are already in a session. Session id: " + ExecutionContext.getExecutor().getInstance().getId() + ", will reattach to the new session: " + sessionName);
            this.getContext().setInteractiveQuery(false);
            ExecutionContext.setInstanceRunner(null);
        }
        try {
            Session session = Session.attach((Odps)this.getCurrentOdps(), (String)sessionName, (Map)SetCommand.setMap, (Long)0L, (String)this.getContext().getRunningCluster(), (String)"console_sqlrt_task");
            String startSessionMessage = session.getStartSessionMessage();
            if (startSessionMessage != null && startSessionMessage.length() > 0) {
                this.getWriter().writeError(startSessionMessage);
            }
            SessionUtils.resetSQLExecutor((String)sessionName, (Instance)session.getInstance(), (ExecutionContext)this.getContext(), (Odps)this.getCurrentOdps(), (boolean)true, null);
        }
        catch (OdpsException ex) {
            this.getContext().setInteractiveQuery(false);
            throw ex;
        }
        catch (ODPSConsoleException ex) {
            this.getContext().setInteractiveQuery(false);
            throw ex;
        }
    }

    private Session getCurrentSession() throws OdpsException, ODPSConsoleException {
        SQLExecutor executor = ExecutionContext.getExecutor();
        if (executor != null && executor.getInstance() != null) {
            return new Session(this.getCurrentOdps(), executor.getInstance());
        }
        return null;
    }

    public InteractiveQueryCommand(String commandText, ExecutionContext context) {
        super(commandText, context);
    }

    public void run() throws OdpsException, ODPSConsoleException {
        if (this.getCommandText().matches(attachRegex)) {
            Pattern attachPattern = Pattern.compile(attachRegex);
            Matcher matcher = attachPattern.matcher(this.getCommandText());
            matcher.matches();
            String attachName = matcher.group(1);
            this.attachSession(attachName);
            return;
        }
        if (this.getCommandText().matches(detachRegex)) {
            if (ExecutionContext.getExecutor() == null) {
                this.getWriter().writeError("FAILED: , You need to attach a session in advance.");
                return;
            }
            this.detachSession();
            return;
        }
        this.submitSubQuery();
    }

    public static InteractiveQueryCommand parse(String commandString, ExecutionContext sessionContext) {
        boolean matched = false;
        if (commandString.matches(attachRegex)) {
            matched = true;
            sessionContext.setInteractiveQuery(true);
        } else if (commandString.matches(detachRegex)) {
            matched = true;
            sessionContext.setInteractiveQuery(false);
        }
        if (matched || sessionContext.isInteractiveQuery()) {
            commandString = commandString.trim();
            return new InteractiveQueryCommand(commandString, sessionContext);
        }
        return null;
    }

    class ReporterThread
    extends Thread {
        private final byte[] lock = new byte[0];
        private boolean finished = false;
        private InstanceStateContext context = null;
        private Odps odps;
        private ExecutionContext executionContext;
        private AtomicBoolean disableOutput = new AtomicBoolean(false);
        private InstanceProgressReporter reporter = null;
        private SQLExecutor sqlExecutor = null;

        public ReporterThread(Odps currentOdps, SQLExecutor sqlExecutor, ExecutionContext context) {
            this.odps = currentOdps;
            this.sqlExecutor = sqlExecutor;
            this.executionContext = context;
        }

        public InstanceProgressReporter getReporter() {
            return this.reporter;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void finish() {
            byte[] byArray = this.lock;
            synchronized (this.lock) {
                this.finished = true;
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean isFinished() {
            byte[] byArray = this.lock;
            synchronized (this.lock) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return this.finished;
            }
        }

        InstanceStateContext getStateContext() {
            return this.context;
        }

        private void resetReporter() {
            this.context = this.constructStateContext();
            this.reporter = new InstanceProgressReporter(this.context);
        }

        private void checkQueryStatus() {
            List logs = this.sqlExecutor.getExecutionLog();
            if (!logs.isEmpty()) {
                boolean needAppendLogview = true;
                for (String log : logs) {
                    if (log.contains(rerunInteractiveMode)) {
                        needAppendLogview = true;
                        break;
                    }
                    if (!log.contains(fallbackMessage) && !log.contains(runOfflineMode)) continue;
                    needAppendLogview = false;
                }
                if (needAppendLogview) {
                    logs.add(this.sqlExecutor.getLogView());
                }
                for (String log : logs) {
                    if (this.executionContext.isInteractiveOutputCompatible()) {
                        this.executionContext.getOutputWriter().writeResult(log);
                        continue;
                    }
                    this.executionContext.getOutputWriter().writeDebug(log);
                }
                InteractiveQueryCommand.this.waitLogviewLock.lock();
                InteractiveQueryCommand.this.logviewGenerated.set(true);
                InteractiveQueryCommand.this.waitLogviewCond.signal();
                InteractiveQueryCommand.this.waitLogviewLock.unlock();
                this.resetReporter();
            }
            if (this.context == null) {
                this.resetReporter();
            }
        }

        private void registerSignalHandler() {
            Thread thread = ReporterThread.currentThread();
            SignalHandler instanceRunningIntSignalHandler = SignalUtil.getDefaultIntSignalHandler((Thread)thread);
            SignalUtil.registerSignalHandler((String)"INT", (SignalHandler)instanceRunningIntSignalHandler);
        }

        @Override
        public void run() {
            this.registerSignalHandler();
            boolean shouldCancel = false;
            try {
                while (!this.isFinished()) {
                    this.checkQueryStatus();
                    try {
                        if (shouldCancel) {
                            InteractiveQueryCommand.this.getWriter().writeError("Cancelling query");
                            this.sqlExecutor.cancel();
                            shouldCancel = false;
                        }
                        List stages = this.sqlExecutor.getProgress();
                        this.context.setTaskProgress(stages);
                        if (!this.disableOutput.get()) {
                            this.reporter.printProgress(false);
                        }
                    }
                    catch (Exception e) {
                        this.context.getExecutionContext().getOutputWriter().writeDebug(String.format("%s: %s, %s", "Instance progress reporter error", e.getMessage(), StringUtils.stringifyException((Throwable)e)));
                    }
                    try {
                        Thread.sleep(500L);
                    }
                    catch (InterruptedException e) {
                        shouldCancel = true;
                    }
                }
            }
            finally {
                if (!this.disableOutput.get()) {
                    this.registerSignalHandler();
                }
            }
            if (!this.disableOutput.get()) {
                this.registerSignalHandler();
            }
        }

        public InstanceStateContext constructStateContext() {
            InstanceStateContext isContext = null;
            try {
                Instance instance = this.sqlExecutor.getInstance();
                isContext = new InstanceStateContext(this.odps, instance, this.executionContext);
                isContext.setInstanceStartTime(System.currentTimeMillis());
            }
            catch (OdpsException e) {
                this.executionContext.getOutputWriter().writeDebug(String.format("%s: %s, %s", "Instance progress reporter error", e.getMessage(), StringUtils.stringifyException((Throwable)e)));
            }
            return isContext;
        }

        public void disableOutput() {
            this.disableOutput.compareAndSet(false, true);
        }
    }
}

