/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.odps.console.utils;

import com.aliyun.odps.Column;
import com.aliyun.odps.Instance;
import com.aliyun.odps.LazyLoad;
import com.aliyun.odps.Odps;
import com.aliyun.odps.OdpsException;
import com.aliyun.odps.OdpsType;
import com.aliyun.openservices.odps.console.ExecutionContext;
import com.aliyun.openservices.odps.console.ODPSConsoleException;
import com.aliyun.openservices.odps.console.commands.AbstractCommand;
import com.aliyun.openservices.odps.console.utils.ExtProperties;
import com.aliyun.openservices.odps.console.utils.ODPSConsoleReader;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.URL;
import java.net.UnknownHostException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.Formatter;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.reflect.MethodUtils;
import org.jline.reader.UserInterruptException;

public class ODPSConsoleUtils {
    public static final SimpleDateFormat DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss", Locale.getDefault());
    private static String cltVersion = "";
    private static String osName = "";
    private static String userIp = "";
    private static String userHostname = "";
    private static String mvnVersion;
    private static ODPSConsoleReader odpsConsoleReader;

    public static String formatDate(Date date) {
        if (date == null) {
            return "";
        }
        return DATE_FORMAT.format(date);
    }

    public static void formaterTable(List<String[]> contentList, int[] columnPercent, int width) {
        Formatter f1 = new Formatter(System.out);
        for (String[] str : contentList) {
            ODPSConsoleUtils.checkThreadInterrupted();
            ODPSConsoleUtils.formaterTableRow(str, columnPercent, width);
        }
        f1.flush();
    }

    public static void formaterTableRow(String[] str, int[] columnPercent, int width) {
        ODPSConsoleUtils.formatTableRow("", str, columnPercent, width);
    }

    public static void formatTableRow(String prefix, String[] str, int[] columnPercent, int width) {
        Formatter f1 = new Formatter(System.out);
        if (prefix != null && !prefix.isEmpty() && columnPercent.length > 0) {
            f1.format("%s ", prefix);
        }
        for (int i = 0; i < columnPercent.length; ++i) {
            StringBuilder formatter = new StringBuilder();
            int diswidth = (int)((double)columnPercent[i] / 100.0 * (double)width);
            if (str[i] == null || str[i].length() < diswidth) {
                formatter.append("%1$-").append(diswidth).append("s");
                f1.format(formatter.toString(), str[i]);
                continue;
            }
            f1.format("%s ", str[i]);
        }
        f1.format("\n", new Object[0]);
    }

    public static int getConsoleWidth() {
        int result = 150;
        return result;
    }

    public static boolean isWindows() {
        boolean flag = false;
        if (System.getProperties().getProperty("os.name").toUpperCase().indexOf("WINDOWS") != -1) {
            flag = true;
        }
        return flag;
    }

    public static String getConfigFilePath() {
        URL url = ODPSConsoleUtils.class.getClassLoader().getResource("odps_config.ini");
        if (url == null) {
            return null;
        }
        return url.getFile();
    }

    public static String getResourceFilePath(String filename) {
        URL url = ODPSConsoleUtils.class.getClassLoader().getResource(filename);
        if (url == null) {
            return null;
        }
        return url.getFile();
    }

    public static String getMvnVersion() {
        if (com.aliyun.odps.utils.StringUtils.isNullOrEmpty((String)mvnVersion)) {
            ODPSConsoleUtils.getUserAgent();
        }
        return mvnVersion;
    }

    public static String getUserAgent() {
        if (com.aliyun.odps.utils.StringUtils.isNullOrEmpty((String)cltVersion)) {
            InputStream is = null;
            try {
                is = ODPSConsoleUtils.class.getResourceAsStream("/com/aliyun/openservices/odps/console/version.txt");
                ExtProperties properties = new ExtProperties();
                properties.load(is);
                mvnVersion = ((Properties)properties).getProperty("MavenVersion");
                cltVersion = String.format("CLT(%s : %s)", mvnVersion, ((Properties)properties).getProperty("Revision"));
            }
            catch (Exception exception) {
            }
            finally {
                try {
                    is.close();
                }
                catch (IOException iOException) {}
            }
        }
        if (com.aliyun.odps.utils.StringUtils.isNullOrEmpty((String)osName)) {
            osName = System.getProperties().getProperty("os.name");
        }
        if (com.aliyun.odps.utils.StringUtils.isNullOrEmpty((String)userIp)) {
            try {
                userIp = ODPSConsoleUtils.getCurrentIp().getHostAddress();
            }
            catch (UnknownHostException is) {
                // empty catch block
            }
        }
        if (com.aliyun.odps.utils.StringUtils.isNullOrEmpty((String)userHostname)) {
            try {
                String hostname = InetAddress.getLocalHost().getHostName();
                if (!ODPSConsoleUtils.containsHanBlock(hostname)) {
                    userHostname = hostname;
                }
            }
            catch (UnknownHostException hostname) {
                // empty catch block
            }
        }
        String systemInfo = osName + "(" + userIp + "/" + userHostname + ")";
        return cltVersion + "; " + systemInfo;
    }

    public static boolean containsHanBlock(String s) {
        int codepoint;
        for (int i = 0; i < s.length(); i += Character.charCount(codepoint)) {
            codepoint = s.codePointAt(i);
            Character.UnicodeBlock block = Character.UnicodeBlock.of(codepoint);
            if (block != Character.UnicodeBlock.CJK_UNIFIED_IDEOGRAPHS && block != Character.UnicodeBlock.CJK_UNIFIED_IDEOGRAPHS_EXTENSION_A && block != Character.UnicodeBlock.CJK_UNIFIED_IDEOGRAPHS_EXTENSION_B && block != Character.UnicodeBlock.CJK_COMPATIBILITY_IDEOGRAPHS && block != Character.UnicodeBlock.CJK_COMPATIBILITY_IDEOGRAPHS_SUPPLEMENT) continue;
            return true;
        }
        return false;
    }

    public static String shiftOption(List<String> optionList, String option) {
        if (optionList.contains(option) && optionList.indexOf(option) + 1 < optionList.size()) {
            int index = optionList.indexOf(option);
            String cmd = optionList.get(index + 1);
            optionList.remove(optionList.indexOf(option));
            optionList.remove(optionList.indexOf(cmd));
            return cmd;
        }
        return null;
    }

    public static Boolean shiftBooleanOption(List<String> optionList, String option) {
        if (optionList.contains(option)) {
            optionList.remove(option);
            return true;
        }
        return false;
    }

    public static String getDefaultProject(ExecutionContext cxt) throws ODPSConsoleException {
        String project = cxt.getProjectName();
        if (project == null || com.aliyun.odps.utils.StringUtils.isBlank((String)project)) {
            throw new ODPSConsoleException("Project not be set! ");
        }
        return project;
    }

    public static String getDefaultSchema(ExecutionContext ctx) {
        if (ctx.isSchemaMode()) {
            return ctx.getSchemaName();
        }
        return null;
    }

    public static String getDisplaySchema(ExecutionContext ctx) {
        if (StringUtils.isBlank((String)ctx.getSchemaName())) {
            return "default";
        }
        return ctx.getSchemaName();
    }

    public static String generateLogView(Odps odps, Instance instance, ExecutionContext context) {
        try {
            return odps.logview().generateLogView(instance, (long)context.getLogViewLife());
        }
        catch (Exception e) {
            context.getOutputWriter().writeError("Generate LogView Failed:" + e.getMessage());
            return null;
        }
    }

    public static String[] translateCommandline(String line) throws ODPSConsoleException {
        if (com.aliyun.odps.utils.StringUtils.isNullOrEmpty((String)line)) {
            return new String[0];
        }
        boolean normal = false;
        boolean inQuote = true;
        int inDoubleQuote = 2;
        int state = 0;
        StringTokenizer tok = new StringTokenizer(line, "\"' \t\n\r\f", true);
        ArrayList<String> v = new ArrayList<String>();
        StringBuffer current = new StringBuffer();
        boolean lastTokenHasBeenQuoted = false;
        block4: while (tok.hasMoreTokens()) {
            String nextTok = tok.nextToken();
            switch (state) {
                case 1: {
                    if ("'".equals(nextTok)) {
                        lastTokenHasBeenQuoted = true;
                        state = 0;
                        current.append(nextTok);
                        continue block4;
                    }
                    current.append(nextTok);
                    continue block4;
                }
                case 2: {
                    if ("\"".equals(nextTok)) {
                        lastTokenHasBeenQuoted = true;
                        state = 0;
                        current.append(nextTok);
                        continue block4;
                    }
                    current.append(nextTok);
                    continue block4;
                }
            }
            if ("'".equals(nextTok)) {
                state = 1;
                current.append(nextTok);
            } else if ("\"".equals(nextTok)) {
                state = 2;
                current.append(nextTok);
            } else if (nextTok.matches("\\s")) {
                if (lastTokenHasBeenQuoted || current.length() != 0) {
                    v.add(current.toString());
                    current = new StringBuffer();
                }
            } else {
                current.append(nextTok);
            }
            lastTokenHasBeenQuoted = false;
        }
        if (lastTokenHasBeenQuoted || current.length() != 0) {
            v.add(current.toString());
        }
        if (state == 1 || state == 2) {
            throw new ODPSConsoleException("unbalanced quotes in " + line);
        }
        return v.toArray(new String[0]);
    }

    public static synchronized String runCommand(AbstractCommand command) throws OdpsException, ODPSConsoleException {
        ByteArrayOutputStream content = new ByteArrayOutputStream();
        PrintStream stream = new PrintStream(content);
        PrintStream oldout = System.out;
        PrintStream olderr = System.err;
        System.setOut(stream);
        System.setErr(stream);
        command.execute();
        System.setOut(oldout);
        System.setErr(olderr);
        return content.toString();
    }

    public static void checkThreadInterrupted() {
        if (Thread.interrupted()) {
            throw new UserInterruptException("thread interrupted");
        }
    }

    public static ODPSConsoleReader getOdpsConsoleReader() throws ODPSConsoleException {
        if (odpsConsoleReader == null) {
            odpsConsoleReader = new ODPSConsoleReader();
        }
        return odpsConsoleReader;
    }

    public static String safeGetString(LazyLoad resource, String methodName) {
        Object res = ODPSConsoleUtils.safeGetObject(resource, methodName);
        return res == null ? " " : res.toString();
    }

    public static String safeGetDateString(LazyLoad resource, String methodName) {
        Object res = ODPSConsoleUtils.safeGetObject(resource, methodName);
        return res == null ? " " : ODPSConsoleUtils.formatDate((Date)res);
    }

    public static Object safeGetObject(LazyLoad resource, String methodName) {
        try {
            return MethodUtils.invokeMethod((Object)resource, (String)methodName, null);
        }
        catch (Exception ex) {
            return null;
        }
    }

    public static int compareVersion(String left, String right) {
        String[] rightArray;
        if (left.equals(right)) {
            return 0;
        }
        String pattern = "[\\\\.\\\\_\\\\-]";
        String[] leftArray = left.split(pattern);
        int length = leftArray.length < (rightArray = right.split(pattern)).length ? leftArray.length : rightArray.length;
        for (int i = 0; i < length; ++i) {
            if (rightArray[i].equalsIgnoreCase(leftArray[i])) continue;
            if (StringUtils.isNumeric((String)rightArray[i]) && StringUtils.isNumeric((String)leftArray[i])) {
                if (Integer.parseInt(rightArray[i]) > Integer.parseInt(leftArray[i])) {
                    return -1;
                }
                if (Integer.parseInt(rightArray[i]) >= Integer.parseInt(leftArray[i])) continue;
                return 1;
            }
            int res = leftArray[i].compareToIgnoreCase(rightArray[i]);
            return res > 0 ? 1 : res;
        }
        if (leftArray.length == rightArray.length) {
            return 0;
        }
        return leftArray.length < rightArray.length ? -1 : 1;
    }

    public static Map<String, Integer> getDisplayWidth(List<Column> columns, List<Column> partitionsColumns, List<String> selectColumns) {
        if (columns == null || columns.isEmpty()) {
            return null;
        }
        LinkedHashMap<String, Integer> displayWith = new LinkedHashMap<String, Integer>();
        LinkedHashMap<String, OdpsType> fieldTypeMap = new LinkedHashMap<String, OdpsType>();
        for (Column column : columns) {
            fieldTypeMap.put(column.getName(), column.getTypeInfo().getOdpsType());
        }
        if (partitionsColumns != null) {
            for (Column column : partitionsColumns) {
                fieldTypeMap.put(column.getName(), column.getTypeInfo().getOdpsType());
            }
        }
        if (selectColumns != null && !selectColumns.isEmpty()) {
            Set set = fieldTypeMap.keySet();
            ArrayList arrayList = new ArrayList(set);
            for (Object o : set) {
                if (!selectColumns.contains(o)) continue;
                arrayList.remove(o);
            }
            for (Object o : arrayList) {
                fieldTypeMap.remove(o);
            }
        }
        for (Map.Entry entry : fieldTypeMap.entrySet()) {
            if ("BOOLEAN".equalsIgnoreCase(entry.getValue().toString())) {
                displayWith.put(entry.getKey().toString(), entry.getKey().toString().length() > 4 ? entry.getKey().toString().length() : 4);
                continue;
            }
            displayWith.put(entry.getKey().toString(), entry.getKey().toString().length() > 10 ? entry.getKey().toString().length() : 10);
        }
        return displayWith;
    }

    public static String makeOutputFrame(Map<String, Integer> displayWidth) {
        StringBuilder sb = new StringBuilder();
        sb.append("+");
        for (int width : displayWidth.values()) {
            for (int i = 0; i < width + 2; ++i) {
                sb.append("-");
            }
            sb.append("+");
        }
        return sb.toString();
    }

    public static String makeTitle(List<Column> columns, Map<String, Integer> displayWidth) {
        return ODPSConsoleUtils.makeTitleByString(columns.stream().map(Column::getName).collect(Collectors.toList()), displayWidth);
    }

    public static String makeTitleByString(List<String> columnName, Map<String, Integer> displayWidth) {
        StringBuilder titleBuf = new StringBuilder();
        titleBuf.append("| ");
        for (String str : columnName) {
            titleBuf.append(str);
            if (str.length() < displayWidth.get(str)) {
                for (int j = 0; j < displayWidth.get(str) - str.length(); ++j) {
                    titleBuf.append(" ");
                }
            }
            titleBuf.append(" | ");
        }
        return titleBuf.toString();
    }

    private static InetAddress getCurrentIp() throws UnknownHostException {
        try {
            Enumeration<NetworkInterface> networkInterfaces = NetworkInterface.getNetworkInterfaces();
            while (networkInterfaces.hasMoreElements()) {
                NetworkInterface ni = networkInterfaces.nextElement();
                Enumeration<InetAddress> nias = ni.getInetAddresses();
                while (nias.hasMoreElements()) {
                    InetAddress ia = nias.nextElement();
                    if (ia.isLinkLocalAddress() || ia.isLoopbackAddress() || !(ia instanceof Inet4Address)) continue;
                    return ia;
                }
            }
        }
        catch (SocketException socketException) {
            // empty catch block
        }
        return InetAddress.getLocalHost();
    }

    static {
        odpsConsoleReader = null;
    }
}

