/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.odps.console.utils;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonSyntaxException;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import org.apache.commons.codec.digest.DigestUtils;

public class LocalCacheUtils {
    private static boolean multiAttachSessionMode = false;
    private static int MAX_CACHE_COUNT = 5;
    private static final String cacheDirPrefix = ".session/";
    private static final String cacheFileName = ".odpscmd_interactive_cache";
    private static final String cacheLockFileName = ".odpscmd_interactive_cache_lock";
    private static Gson gson = new GsonBuilder().disableHtmlEscaping().create();
    private static FileLock gLock = null;
    private static String cacheDir;
    private static String configDir;

    public static void setCacheDir(String config, String sessionHash) {
        configDir = config;
        cacheDir = configDir + cacheDirPrefix + sessionHash + "/";
    }

    public static void enableMultiAttachSessionMode(Long maxAttachCount) {
        multiAttachSessionMode = true;
        MAX_CACHE_COUNT = maxAttachCount.intValue();
    }

    public static void setCacheDir(String configFile, String endpoint, String projectName, String accessId) throws IOException {
        if (!multiAttachSessionMode) {
            String configKey = endpoint + "_" + projectName + "_" + accessId;
            String sessionHash = DigestUtils.md5Hex((String)configKey).toUpperCase();
            LocalCacheUtils.setCacheDir(new File(configFile).getAbsoluteFile().getParent() + "/", sessionHash);
        } else {
            configDir = new File(configFile).getAbsoluteFile().getParent() + "/";
            File[] allCache = LocalCacheUtils.listAllCacheDir();
            if (allCache.length < MAX_CACHE_COUNT) {
                Double random = Math.random();
                String configKey = endpoint + "_" + projectName + "_" + accessId + "_" + System.currentTimeMillis() + random.toString();
                String sessionHash = DigestUtils.md5Hex((String)configKey).toUpperCase();
                LocalCacheUtils.setCacheDir(new File(configFile).getAbsoluteFile().getParent() + "/", sessionHash);
            } else {
                boolean found = false;
                for (File tmpCacheDir : allCache) {
                    String dir;
                    String lockPath;
                    File lockFile;
                    if (!tmpCacheDir.isDirectory() || !(lockFile = new File(lockPath = (dir = tmpCacheDir.getAbsolutePath() + "/") + cacheLockFileName)).exists()) continue;
                    FileChannel fileChannel = new FileOutputStream(lockPath).getChannel();
                    FileLock lock = fileChannel.tryLock();
                    if (lock == null) {
                        System.out.println("AttachSession is already in using:" + lockPath);
                        continue;
                    }
                    System.out.println("AttachSession is reusing:" + lockPath);
                    cacheDir = tmpCacheDir.getAbsolutePath() + "/";
                    lock.release();
                    fileChannel.close();
                    found = true;
                    break;
                }
                if (!found) {
                    throw new IOException("Attach session has reaches max count:" + MAX_CACHE_COUNT);
                }
            }
        }
    }

    public static String getCacheFile() {
        return cacheDir + cacheFileName;
    }

    public static String getCacheLockFile() {
        return cacheDir + cacheLockFileName;
    }

    public static FileLock lockCache(String path) throws IOException {
        File file;
        File sessionDir = new File(cacheDir);
        if (!sessionDir.exists()) {
            sessionDir.mkdirs();
        }
        if (!(file = new File(path)).exists()) {
            file.createNewFile();
        }
        FileChannel fileChannel = new FileOutputStream(path).getChannel();
        FileLock lock = fileChannel.tryLock();
        return lock;
    }

    public static File[] listAllCacheDir() {
        String cacheBasePath = configDir + cacheDirPrefix;
        File cacheBaseDir = new File(cacheBasePath);
        if (!cacheBaseDir.exists()) {
            cacheBaseDir.mkdirs();
        }
        File[] allCache = cacheBaseDir.listFiles();
        return allCache;
    }

    public static void checkAndClearAllUselessCache() throws IOException {
        File[] allCache = LocalCacheUtils.listAllCacheDir();
        if (allCache.length < MAX_CACHE_COUNT) {
            return;
        }
        for (File tmpCacheDir : allCache) {
            FileChannel fileChannel;
            FileLock lock;
            String dir;
            if (!tmpCacheDir.isDirectory() || cacheDir.equals(dir = tmpCacheDir.getAbsolutePath() + "/")) continue;
            boolean needClean = true;
            String lockPath = dir + cacheLockFileName;
            File lockFile = new File(lockPath);
            if (lockFile.exists() && (lock = (fileChannel = new FileOutputStream(lockPath).getChannel()).tryLock()) == null) {
                needClean = false;
            }
            if (!needClean) continue;
            new File(dir + cacheFileName).delete();
            new File(lockPath).delete();
            new File(dir).delete();
        }
    }

    public static void clearCache() {
        try {
            new File(LocalCacheUtils.getCacheFile()).delete();
            new File(LocalCacheUtils.getCacheLockFile()).delete();
            new File(cacheDir).delete();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void checkLock() throws IOException {
        if (gLock == null) {
            gLock = LocalCacheUtils.lockCache(LocalCacheUtils.getCacheLockFile());
        }
        if (gLock == null) {
            throw new IOException("Odpscmd has beed locked by another interactive mode progress.");
        }
        if (!multiAttachSessionMode) {
            try {
                LocalCacheUtils.checkAndClearAllUselessCache();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public static void writeCache(CacheItem cache) throws IOException {
        File sessionDir = new File(cacheDir);
        if (!sessionDir.exists()) {
            sessionDir.mkdirs();
        }
        FileWriter writer = new FileWriter(LocalCacheUtils.getCacheFile());
        writer.write(gson.toJson((Object)cache));
        writer.close();
    }

    public static CacheItem readCache() throws IOException {
        CacheItem cache = null;
        LocalCacheUtils.checkLock();
        try {
            String line;
            String result = "";
            FileInputStream is = new FileInputStream(LocalCacheUtils.getCacheFile());
            BufferedReader reader = new BufferedReader(new InputStreamReader(is));
            while ((line = reader.readLine()) != null) {
                result = result + line;
                result = result + "\n";
            }
            reader.close();
            ((InputStream)is).close();
            cache = (CacheItem)gson.fromJson(result, CacheItem.class);
        }
        catch (FileNotFoundException result) {
        }
        catch (JsonSyntaxException result) {
        }
        catch (IOException e) {
            throw e;
        }
        return cache;
    }

    public static class CacheItem {
        public Long attachTime;
        public String sessionId;
        public String projectName;
        public String sessionName;
        public String majorVersion;

        public CacheItem(String sessionId, Long attachTime, String projectName, String sessionName, String majorVersion) {
            this.sessionId = sessionId;
            this.attachTime = attachTime;
            this.projectName = projectName;
            this.sessionName = sessionName;
            this.majorVersion = majorVersion;
        }

        public String toString() {
            return gson.toJson((Object)this, CacheItem.class);
        }
    }
}

