/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.odps.console.utils;

import com.aliyun.odps.OdpsDeprecatedLogger;
import com.aliyun.odps.account.Account;
import com.aliyun.odps.utils.StringUtils;
import com.aliyun.openservices.odps.console.ExecutionContext;
import com.aliyun.openservices.odps.console.ODPSConsoleException;
import com.aliyun.openservices.odps.console.commands.AbstractCommand;
import com.aliyun.openservices.odps.console.commands.CompositeCommand;
import com.aliyun.openservices.odps.console.commands.InstancePriorityCommand;
import com.aliyun.openservices.odps.console.commands.InteractiveCommand;
import com.aliyun.openservices.odps.console.commands.LoginCommand;
import com.aliyun.openservices.odps.console.commands.UseProjectCommand;
import com.aliyun.openservices.odps.console.utils.PluginPriorityCommand;
import com.aliyun.openservices.odps.console.utils.PluginUtil;
import com.aliyun.openservices.odps.console.utils.antlr.AntlrObject;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.Options;
import org.apache.commons.io.FileUtils;
import org.jline.reader.Completer;

public class CommandParserUtils {
    private static final String COMMAND_PACKAGE = "com.aliyun.openservices.odps.console.commands";
    private static final String[] BASIC_COMMANDS = new String[]{"KonfigFromSysEnvCommand", "SetEndpointCommand", "LoginCommand", "AppLoginCommand", "UseProjectKeepSettingModeCommand", "UseProjectCommand", "UseQuotaCommand", "DryRunCommand", "MachineReadableCommand", "FinanceJsonCommand", "EnableLiteModeCommand", "AsyncModeCommand", "InstancePriorityCommand", "SkipCommand", "SetRetryCommand", "InteractiveCommand", "ExecuteCommand", "ExecuteFileCommand", "ExecuteScriptCommand", "HelpCommand", "ShowVersionCommand", "UseSchemaCommand", "SetCommand", "UnSetCommand", "SetenvCommand", "HistoryCommand", "ArchiveCommand", "MergeCommand", "ExternalProjectCommand", "CompactCommand", "FreezeCommand", "RestoreCommand"};
    private static final String HELP_TAGS_FIELD = "HELP_TAGS";
    private static final String COMPLETER_FIELD = "COMPLETER";
    private static final String HELP_PRINT_METHOD = "printUsage";
    private static final long COMMAND_DEFAULT_PRIORITY = 100000L;
    static List<PluginPriorityCommand> extendedCommandList;
    static URLClassLoader classLoader;

    public static String[] getCommandTokens(String cmd) throws ODPSConsoleException {
        AntlrObject antlr = new AntlrObject(cmd);
        String[] args = antlr.getTokenStringArray();
        if (args == null) {
            throw new ODPSConsoleException("Invalid parameters - Generic options must be specified.");
        }
        return args;
    }

    public static CommandLine getCommandLine(String[] args, Options opts) throws ODPSConsoleException {
        CommandLine cl;
        GnuParser clp = new GnuParser();
        try {
            cl = clp.parse(opts, args, false);
        }
        catch (Exception e) {
            throw new ODPSConsoleException("Unknown exception from client - " + e.getMessage(), e);
        }
        return cl;
    }

    public static CommandLine getCommandLine(String cmd, Options opts) throws ODPSConsoleException {
        return CommandParserUtils.getCommandLine(CommandParserUtils.getCommandTokens(cmd), opts);
    }

    public static AbstractCommand parseOptions(String[] args, ExecutionContext sessionContext) throws ODPSConsoleException {
        List<String> optionList = new LinkedList<String>(Arrays.asList(args));
        optionList = CommandParserUtils.populateOptions(optionList);
        CommandParserUtils.removeHook(optionList, sessionContext);
        LinkedList<AbstractCommand> commandList = new LinkedList<AbstractCommand>();
        CommandParserUtils.parseCommandLineCommand(commandList, optionList, sessionContext);
        if (optionList.size() > 0) {
            throw new ODPSConsoleException("Bad Command, Type \"help;\"(--help) or \"h;\"(-h) for help. ");
        }
        CommandParserUtils.checkLogin(commandList, sessionContext);
        CommandParserUtils.checkUseProject(commandList, sessionContext);
        return new CompositeCommand(commandList, "", sessionContext);
    }

    public static void removeHook(List<String> optionList, ExecutionContext sessionContext) {
        if (optionList.contains("--enablehook") && optionList.indexOf("--enablehook") + 1 < optionList.size()) {
            int index = optionList.indexOf("--enablehook");
            String hook = optionList.get(index + 1);
            optionList.remove(optionList.indexOf("--enablehook"));
            optionList.remove(optionList.indexOf(hook));
            if (!Boolean.valueOf(hook).booleanValue()) {
                sessionContext.setOdpsHooks(null);
            }
        }
    }

    public static AbstractCommand parseCommand(String commandLines, ExecutionContext sessionContext) throws ODPSConsoleException {
        if ((commandLines = commandLines.trim()).equals("")) {
            throw new ODPSConsoleException("Invalid parameter -e");
        }
        int index = commandLines.lastIndexOf(";");
        if (index != commandLines.length() - 1) {
            throw new ODPSConsoleException("Command must be end with \";\"");
        }
        OdpsDeprecatedLogger.getDeprecatedCalls().put("USER_COMMANDS :" + commandLines, 1L);
        List<String> commandLinelist = new AntlrObject(commandLines).splitCommands();
        if (commandLinelist.size() == 0 && !commandLines.trim().startsWith("--")) {
            commandLinelist.add(commandLines.substring(0, index));
        }
        LinkedList<AbstractCommand> odpsCommandList = new LinkedList<AbstractCommand>();
        int i = 0;
        int step = sessionContext.getStep();
        for (String command : commandLinelist) {
            if (step > ++i || (command = command.trim()).equals("")) continue;
            CommandParserUtils.parseInteractiveCommand(odpsCommandList, command, sessionContext, i);
        }
        if (step > i) {
            throw new ODPSConsoleException("[Error] invalid NUM for option k, total query count include empty query: " + i);
        }
        if (odpsCommandList.size() == 1) {
            return (AbstractCommand)odpsCommandList.get(0);
        }
        CompositeCommand compositeCommand = new CompositeCommand(odpsCommandList, "", sessionContext);
        return compositeCommand;
    }

    private static void checkLogin(List<AbstractCommand> commandList, ExecutionContext sessionContext) throws ODPSConsoleException {
        for (AbstractCommand command : commandList) {
            if (!(command instanceof LoginCommand)) continue;
            return;
        }
        Account.AccountProvider accountProvider = sessionContext.getAccountProvider();
        switch (accountProvider) {
            case ALIYUN: {
                if (!StringUtils.isNullOrEmpty((String)sessionContext.getAccessId()) && !StringUtils.isNullOrEmpty((String)sessionContext.getAccessKey())) break;
                throw new ODPSConsoleException("Need login info.");
            }
            case STS: {
                if (!StringUtils.isNullOrEmpty((String)sessionContext.getAccessId()) && !StringUtils.isNullOrEmpty((String)sessionContext.getAccessKey()) && !StringUtils.isNullOrEmpty((String)sessionContext.getStsToken())) break;
                throw new ODPSConsoleException("Need login info.");
            }
            default: {
                throw new ODPSConsoleException("Unsupported account provider.");
            }
        }
    }

    private static void checkUseProject(List<AbstractCommand> commandList, ExecutionContext sessionContext) {
        if (StringUtils.isNullOrEmpty((String)sessionContext.getProjectName())) {
            return;
        }
        boolean useProjectFlag = false;
        for (AbstractCommand command : commandList) {
            if (!(command instanceof UseProjectCommand) && !(command instanceof InteractiveCommand)) continue;
            useProjectFlag = true;
        }
        if (!useProjectFlag) {
            String commandText = "--project=" + sessionContext.getProjectName();
            UseProjectCommand useProjectCommand = new UseProjectCommand(commandText, sessionContext, sessionContext.getProjectName());
            int index = 0;
            boolean loginCommandExist = false;
            for (AbstractCommand command : commandList) {
                ++index;
                if (!(command instanceof LoginCommand)) continue;
                loginCommandExist = true;
                break;
            }
            if (loginCommandExist) {
                commandList.add(index, useProjectCommand);
            } else {
                commandList.add(0, useProjectCommand);
            }
        }
        boolean ipcExist = false;
        int useCommandIndex = 0;
        for (int i = 0; i < commandList.size(); ++i) {
            AbstractCommand command = commandList.get(i);
            if (command instanceof InstancePriorityCommand) {
                ipcExist = true;
                continue;
            }
            if (!(command instanceof UseProjectCommand)) continue;
            useCommandIndex = i + 1;
        }
        if (!ipcExist) {
            InstancePriorityCommand ipc = new InstancePriorityCommand(sessionContext.getPriority(), "--instance_priority", sessionContext);
            commandList.add(useCommandIndex, ipc);
        }
    }

    private static void addCommand(List<AbstractCommand> commandList, AbstractCommand command, ExecutionContext sessionContext) {
        if (command != null) {
            commandList.add(command);
        }
    }

    public static List<PluginPriorityCommand> getExtendedCommandList() {
        if (extendedCommandList == null) {
            extendedCommandList = PluginUtil.getExtendCommandList();
            for (int i = 0; i < BASIC_COMMANDS.length; ++i) {
                String commandName = "com.aliyun.openservices.odps.console.commands." + BASIC_COMMANDS[i];
                extendedCommandList.add(new PluginPriorityCommand(commandName, 100000L - (long)i));
            }
            Collections.sort(extendedCommandList);
        }
        return extendedCommandList;
    }

    public static Set<String> getAllCommandKeyWords() {
        HashSet<String> keys = new HashSet<String>();
        List<PluginPriorityCommand> ecList = CommandParserUtils.getExtendedCommandList();
        for (PluginPriorityCommand command : ecList) {
            try {
                Class<? extends AbstractCommand> commandClass = CommandParserUtils.getClassFromPlugin(command.getCommandName());
                Field tags_field = commandClass.getField(HELP_TAGS_FIELD);
                keys.addAll(Arrays.asList((String[])tags_field.get(null)));
            }
            catch (NoSuchFieldException noSuchFieldException) {
            }
            catch (IllegalAccessException illegalAccessException) {}
        }
        return keys;
    }

    public static List<Completer> getCompleters() {
        ArrayList<Completer> completers = new ArrayList<Completer>();
        List<PluginPriorityCommand> ecList = CommandParserUtils.getExtendedCommandList();
        for (PluginPriorityCommand command : ecList) {
            try {
                Class<? extends AbstractCommand> commandClass = CommandParserUtils.getClassFromPlugin(command.getCommandName());
                Field completerField = commandClass.getField(COMPLETER_FIELD);
                Completer completer = (Completer)completerField.get(null);
                completers.add(completer);
            }
            catch (IllegalAccessException | NoSuchFieldException reflectiveOperationException) {}
        }
        return completers;
    }

    public static void printHelpInfo(List<String> keywords, ExecutionContext ctx) {
        HashMap<String, Integer> matched = new HashMap<String, Integer>(){};
        ArrayList<String> allCommands = new ArrayList<String>();
        List<PluginPriorityCommand> ecList = CommandParserUtils.getExtendedCommandList();
        for (PluginPriorityCommand command : ecList) {
            allCommands.add(command.getCommandName());
        }
        if (classLoader == null) {
            CommandParserUtils.loadPlugins();
        }
        for (String commandName : allCommands) {
            try {
                Class<? extends AbstractCommand> commandClass = CommandParserUtils.getClassFromPlugin(commandName);
                Field tags_field = commandClass.getField(HELP_TAGS_FIELD);
                String[] tags = (String[])tags_field.get(null);
                int count = 0;
                block5: for (String tag : tags) {
                    for (String keyword : keywords) {
                        if (!tag.equalsIgnoreCase(keyword)) continue;
                        ++count;
                        continue block5;
                    }
                }
                if (count == 0) continue;
                matched.put(commandName, count);
            }
            catch (NoSuchFieldException noSuchFieldException) {
            }
            catch (IllegalAccessException illegalAccessException) {}
        }
        boolean found = false;
        System.out.println();
        for (int i = keywords.size(); i >= 1; --i) {
            for (Map.Entry entry : matched.entrySet()) {
                if (i != (Integer)entry.getValue()) continue;
                Class<? extends AbstractCommand> commandClass = CommandParserUtils.getClassFromPlugin((String)entry.getKey());
                found = CommandParserUtils.invokePrintUsage(commandClass, System.out, ctx);
            }
            if (found) break;
        }
        System.out.println();
    }

    private static void parseCommandLineCommand(List<AbstractCommand> commandList, List<String> optionList, ExecutionContext sessionContext) throws ODPSConsoleException {
        List<PluginPriorityCommand> ecList = CommandParserUtils.getExtendedCommandList();
        for (PluginPriorityCommand command : ecList) {
            String commandName = command.getCommandName();
            if (commandName == null || "".equals(commandName.trim())) continue;
            AbstractCommand cmd = null;
            try {
                cmd = CommandParserUtils.reflectCommandObject(commandName, new Class[]{List.class, ExecutionContext.class}, optionList, sessionContext);
            }
            catch (AssertionError e) {
                sessionContext.getOutputWriter().writeDebug(((Throwable)((Object)e)).getMessage());
                System.err.println("fail to load user command, pls check:" + commandName);
            }
            if (cmd == null) continue;
            CommandParserUtils.addCommand(commandList, cmd, sessionContext);
        }
    }

    private static void parseInteractiveCommand(List<AbstractCommand> commandList, String commandText, ExecutionContext sessionContext, int queryNumber) throws ODPSConsoleException {
        List<PluginPriorityCommand> ecList = CommandParserUtils.getExtendedCommandList();
        String userCommands = sessionContext.getUserCommands();
        if (userCommands != null) {
            for (String commandString : Arrays.asList(userCommands.split(","))) {
                ecList.add(new PluginPriorityCommand(commandString, Float.POSITIVE_INFINITY));
            }
        }
        Collections.sort(ecList);
        for (PluginPriorityCommand command : ecList) {
            String commandName = command.getCommandName();
            if (commandName == null || "".equals(commandName.trim())) continue;
            AbstractCommand cmd = null;
            try {
                cmd = CommandParserUtils.reflectCommandObject(commandName, new Class[]{String.class, ExecutionContext.class}, commandText, sessionContext);
            }
            catch (AssertionError e) {
                sessionContext.getOutputWriter().writeDebug(((Throwable)((Object)e)).getMessage());
                System.err.println("fail to load user command, pls check:" + commandName);
            }
            if (cmd == null) continue;
            cmd.setCommandStep(queryNumber);
            CommandParserUtils.addCommand(commandList, cmd, sessionContext);
            return;
        }
    }

    public static void loadPlugins() {
        List<URL> pluginJarList = PluginUtil.getPluginsJarList();
        URL[] urls = pluginJarList.toArray(new URL[pluginJarList.size()]);
        classLoader = new URLClassLoader(urls, Thread.currentThread().getContextClassLoader());
    }

    public static Class<? extends AbstractCommand> getClassFromPlugin(String commandName) {
        if (classLoader == null) {
            CommandParserUtils.loadPlugins();
        }
        try {
            Class<?> commandClass = Class.forName(commandName, true, classLoader);
            return commandClass;
        }
        catch (ClassNotFoundException e) {
            throw new AssertionError((Object)("Cannot find the command:" + commandName));
        }
    }

    private static AbstractCommand reflectCommandObject(String commandName, Class<?>[] argTypes, Object ... args) throws ODPSConsoleException {
        Class<? extends AbstractCommand> commandClass = null;
        try {
            commandClass = CommandParserUtils.getClassFromPlugin(commandName);
            Method parseMethod = commandClass.getDeclaredMethod("parse", argTypes);
            Object commandObject = parseMethod.invoke(null, args);
            if (commandObject != null) {
                return (AbstractCommand)commandObject;
            }
            return null;
        }
        catch (SecurityException e) {
            throw new AssertionError((Object)("Cannot find the parse method on the command: " + commandName));
        }
        catch (NoSuchMethodException e) {
            return null;
        }
        catch (IllegalArgumentException e) {
            throw new AssertionError((Object)("Failed to invoke the parse method on the command:" + commandName));
        }
        catch (IllegalAccessException e) {
            throw new AssertionError((Object)("Failed to invoke the parse method on the command:" + commandName));
        }
        catch (InvocationTargetException e) {
            if (e.getCause() instanceof ODPSConsoleException) {
                String output;
                String msg = e.getCause().getMessage();
                if (!StringUtils.isNullOrEmpty((String)msg) && msg.contains("Bad Command, Type \"help;\"(--help) or \"h;\"(-h) for help. ") && commandClass != null && (output = CommandParserUtils.getCommandUsageString(commandClass, (ExecutionContext)args[args.length - 1])) != null) {
                    throw new ODPSConsoleException(e.getCause().getMessage() + "\n" + output);
                }
                throw (ODPSConsoleException)e.getCause();
            }
            throw new ODPSConsoleException(e.getCause());
        }
    }

    private static String getCommandUsageString(Class<?> commandClass, ExecutionContext ctx) {
        try {
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            PrintStream ps = new PrintStream(os);
            boolean invokeSucceeded = CommandParserUtils.invokePrintUsage(commandClass, ps, ctx);
            if (invokeSucceeded) {
                return os.toString("UTF8");
            }
            return null;
        }
        catch (UnsupportedEncodingException e) {
            return null;
        }
    }

    private static boolean invokePrintUsage(Class<?> commandClass, PrintStream ps, ExecutionContext ctx) {
        try {
            Method printMethod = commandClass.getDeclaredMethod(HELP_PRINT_METHOD, PrintStream.class, ExecutionContext.class);
            printMethod.invoke(null, ps, ctx);
            return true;
        }
        catch (NoSuchMethodException e) {
            try {
                Method printMethod = commandClass.getDeclaredMethod(HELP_PRINT_METHOD, PrintStream.class);
                printMethod.invoke(null, ps);
                return true;
            }
            catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException reflectiveOperationException) {
            }
        }
        catch (IllegalAccessException | InvocationTargetException reflectiveOperationException) {
            // empty catch block
        }
        return false;
    }

    private static List<String> populateOptions(List<String> optionList) {
        LinkedList<String> resultList = new LinkedList<String>();
        for (String optionStr : optionList) {
            if (StringUtils.isNullOrEmpty((String)optionStr)) continue;
            String option = optionStr.trim();
            if (option.matches("^--[^= ]+ *= *[^ ]+")) {
                String[] cmds = option.split("=", 2);
                if (cmds[0].trim().equals("--username")) {
                    resultList.add("-u");
                } else if (cmds[0].trim().equals("--password")) {
                    resultList.add("-p");
                } else {
                    resultList.add(cmds[0].trim());
                }
                resultList.add(cmds[1].trim());
                continue;
            }
            if (option.matches("-[a-z].+")) {
                resultList.add(option.substring(0, 2));
                resultList.add(option.substring(2));
                continue;
            }
            resultList.add(option);
        }
        return resultList;
    }

    public static String[] getCommandArgs(String[] args) throws ODPSConsoleException {
        if (args.length == 2 && args[0].trim().equalsIgnoreCase("-I")) {
            return CommandParserUtils.getArgsFromTempFile(args[1]);
        }
        return args;
    }

    private static String[] getArgsFromTempFile(String file) throws ODPSConsoleException {
        String params = CommandParserUtils.readFromFile(file);
        ArrayList<String> optionList = new ArrayList<String>();
        if (!StringUtils.isNullOrEmpty((String)params)) {
            String[] options;
            for (String opt : options = params.split("\u0000")) {
                if (StringUtils.isNullOrEmpty((String)opt)) continue;
                optionList.add(opt);
            }
        }
        return optionList.toArray(new String[0]);
    }

    private static String readFromFile(String fileName) throws ODPSConsoleException {
        String string;
        File file = null;
        try {
            file = new File(fileName);
            string = FileUtils.readFileToString((File)file, (String)"utf-8");
        }
        catch (IOException e) {
            try {
                throw new ODPSConsoleException("read args file error: " + e.getMessage(), e);
            }
            catch (Throwable throwable) {
                FileUtils.deleteQuietly(file);
                throw throwable;
            }
        }
        FileUtils.deleteQuietly((File)file);
        return string;
    }
}

