/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.odps.console.output.state;

import com.aliyun.odps.Instance;
import com.aliyun.odps.OdpsException;
import com.aliyun.odps.Task;
import com.aliyun.odps.data.ResultSet;
import com.aliyun.odps.task.SQLTask;
import com.aliyun.odps.tunnel.TunnelException;
import com.aliyun.odps.utils.StringUtils;
import com.aliyun.openservices.odps.console.output.state.InstanceProgressReporter;
import com.aliyun.openservices.odps.console.output.state.InstanceState;
import com.aliyun.openservices.odps.console.output.state.InstanceStateContext;
import com.aliyun.openservices.odps.console.output.state.InstanceSuccess;
import com.aliyun.openservices.odps.console.utils.FormatUtils;
import com.aliyun.openservices.odps.console.utils.statemachine.State;
import java.net.URI;
import java.net.URISyntaxException;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;

public class InstanceTerminated
extends InstanceState {
    private static final String INSTANCE_NOT_TERMINATED = "InstanceNotTerminate";
    private static final String TASK_FAILED = "TaskFailed";

    @Override
    public State run(InstanceStateContext context) throws OdpsException {
        try {
            Task task = context.getTasks().get(0);
            if (InstanceTerminated.isGetResultByInstanceTunnel(context, task)) {
                this.setTaskResultByInstanceTunnel(context);
            } else {
                this.setTaskResult(context);
            }
        }
        catch (OdpsException e) {
            if (context.getInstance().isSync()) {
                context.printLogview();
            }
            throw e;
        }
        if (context.getInstance().isSync()) {
            return State.END;
        }
        if (!context.isProgressReportFinish()) {
            InstanceProgressReporter reporter = new InstanceProgressReporter(context);
            reporter.printProgress(true);
        }
        return new InstanceSuccess();
    }

    private void setTaskResult(InstanceStateContext context) throws OdpsException {
        Instance.InstanceResultModel.TaskResult taskResult = (Instance.InstanceResultModel.TaskResult)context.getInstance().getRawTaskResults().get(0);
        String resultStr = taskResult.getResult().getString();
        Instance.TaskStatus.Status taskStatus = !StringUtils.isNullOrEmpty((String)taskResult.getStatus()) ? Instance.TaskStatus.Status.valueOf((String)taskResult.getStatus().toUpperCase()) : context.getTaskStatus().getStatus();
        if (Instance.TaskStatus.Status.FAILED.equals((Object)taskStatus)) {
            throw new OdpsException(resultStr);
        }
        if (Instance.TaskStatus.Status.CANCELLED.equals((Object)taskStatus)) {
            throw new OdpsException("Task got cancelled");
        }
        if (!Instance.TaskStatus.Status.SUCCESS.equals((Object)taskStatus)) {
            throw new OdpsException("Task not successfully terminated: status[" + taskStatus + "]");
        }
        ArrayList<String> result = new ArrayList<String>();
        result.add(resultStr);
        context.setResult(result.iterator());
    }

    private void setTaskResultByInstanceTunnel(InstanceStateContext context) throws OdpsException {
        URI tunnelUri;
        Long sessionMaxRow = context.getExecutionContext().getInstanceTunnelMaxRecord();
        String tunnelEndpoint = context.getExecutionContext().getTunnelEndpoint();
        try {
            tunnelUri = StringUtils.isNullOrEmpty((String)tunnelEndpoint) ? null : new URI(tunnelEndpoint);
        }
        catch (URISyntaxException e) {
            throw new OdpsException("Illegal tunnel endpoint: " + tunnelEndpoint + "please check the config.", (Throwable)e);
        }
        DateTimeFormatter dateFormat = FormatUtils.DATETIME_FORMATTER;
        if (!StringUtils.isNullOrEmpty((String)context.getExecutionContext().getSqlTimezone())) {
            try {
                ZoneId zoneId = ZoneId.of(context.getExecutionContext().getSqlTimezone());
                dateFormat = dateFormat.withZone(zoneId);
            }
            catch (Exception e) {
                throw new OdpsException("Failed to get TimeZone, " + e.getMessage(), (Throwable)e);
            }
        }
        try {
            ResultSet resultSet = SQLTask.getResultSet((Instance)context.getInstance(), (String)context.getRunningTaskName(), (Long)sessionMaxRow, (boolean)false, (URI)tunnelUri);
            FormatUtils.FormattedResultSet result = new FormatUtils.FormattedResultSet(resultSet, FormatUtils.DEFAULT_COMPLEX_TYPE_FORMAT_GSON, dateFormat);
            context.setResult(result);
        }
        catch (TunnelException e) {
            if (INSTANCE_NOT_TERMINATED.equals(e.getErrorCode()) || TASK_FAILED.equals(e.getErrorCode())) {
                this.setTaskResult(context);
            }
            throw e;
        }
        catch (OdpsException e) {
            throw new OdpsException("Failed to get query result by instance tunnel, " + e.getMessage(), (Throwable)e);
        }
    }

    private static boolean isGetResultByInstanceTunnel(InstanceStateContext context, Task task) {
        return task instanceof SQLTask && ((SQLTask)task).getQuery().toUpperCase().matches("^SELECT[\\s\\S]*") && context.getExecutionContext().isUseInstanceTunnel();
    }
}

