/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.odps.console.commands;

import com.aliyun.odps.NoSuchObjectException;
import com.aliyun.odps.OdpsException;
import com.aliyun.odps.Quota;
import com.aliyun.odps.utils.StringUtils;
import com.aliyun.openservices.odps.console.ExecutionContext;
import com.aliyun.openservices.odps.console.ODPSConsoleException;
import com.aliyun.openservices.odps.console.commands.AbstractCommand;
import com.aliyun.openservices.odps.console.commands.SetCommand;
import com.aliyun.openservices.odps.console.utils.ODPSConsoleUtils;
import java.io.PrintStream;
import java.security.InvalidParameterException;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class UseQuotaCommand
extends AbstractCommand {
    private static final String OPTION_REGION_ID = "--quota-region-id";
    private static final String OPTION_QUOTA_NAME = "--quota-name";
    private static final String OPTION_DEFAULT_QUOTA_FLAG = "default";
    public static final String[] HELP_TAGS = new String[]{"use", "quota"};
    private static final Pattern PATTERN = Pattern.compile("USE\\s+QUOTA\\s+([\\u4E00-\\u9FA5A-Za-z0-9_\\-]+)(\\s+IN\\sREGION\\s(.+))?", 2);
    private String regionId;
    private String quotaName;

    public static void printUsage(PrintStream stream) {
        stream.println("Usage:");
        stream.println("  use quota <quota name>[ in region <region id>];");
        stream.println("Examples:");
        stream.println("  use quota my_quota;");
        stream.println("  use quota my_quota in region cn-beijing;");
    }

    public UseQuotaCommand(String commandText, ExecutionContext context, String regionId, String quotaName) {
        super(commandText, context);
        this.regionId = regionId;
        this.quotaName = quotaName;
    }

    @Override
    protected void run() throws ODPSConsoleException, OdpsException {
        if (this.quotaName == null || this.quotaName.isEmpty()) {
            throw new InvalidParameterException("Invalid parameter: Quota name is empty.");
        }
        if (this.quotaName.equalsIgnoreCase(OPTION_DEFAULT_QUOTA_FLAG)) {
            SetCommand.setMap.remove("odps.task.wlm.quota");
            this.getContext().setQuotaName("");
            this.getContext().setQuotaRegionId("");
            return;
        }
        if (this.regionId == null || this.regionId.isEmpty()) {
            this.regionId = this.getCurrentOdps().projects().get(this.getCurrentProject()).getDefaultQuotaRegion();
        }
        Quota quota = null;
        try {
            quota = this.getCurrentOdps().quotas().get(this.regionId, this.quotaName);
            quota.reload();
            if (quota.isParentQuota().booleanValue()) {
                throw new InvalidParameterException("Level 1 quota is not allowed to use. Please use a Level 2 quota.");
            }
            if (quota.getResourceSystemType() != null && quota.getResourceSystemType().equalsIgnoreCase("FUXI_ONLINE")) {
                throw new InvalidParameterException("Online quota is not allowed to use manually. It can only be used automatically by entering interactive mode.");
            }
        }
        catch (NoSuchObjectException e) {
            String errMsg = "Quota " + this.quotaName + " is not found in region " + this.regionId + ". It may be in another region or not exist at all.";
            NoSuchObjectException ee = new NoSuchObjectException(errMsg, (Throwable)e);
            ee.setStatus(e.getStatus());
            ee.setRequestId(e.getRequestId());
            throw ee;
        }
        catch (OdpsException e) {
            String errMsg = "Read quota " + this.quotaName + " in region " + this.regionId + " failed.";
            OdpsException ee = new OdpsException(errMsg, (Throwable)e);
            ee.setStatus(e.getStatus());
            ee.setRequestId(e.getRequestId());
            throw ee;
        }
        String value = String.format("%s@%s", quota.getNickname(), quota.getRegionId());
        SetCommand.setMap.put("odps.task.wlm.quota", value);
        this.getContext().setQuotaName(quota.getNickname());
        this.getContext().setQuotaRegionId(quota.getRegionId());
    }

    public static UseQuotaCommand parse(List<String> optionList, ExecutionContext sessionContext) {
        String regionId = ODPSConsoleUtils.shiftOption(optionList, OPTION_REGION_ID);
        String quotaName = ODPSConsoleUtils.shiftOption(optionList, OPTION_QUOTA_NAME);
        if (!StringUtils.isNullOrEmpty((String)quotaName)) {
            return new UseQuotaCommand("", sessionContext, regionId, quotaName);
        }
        return null;
    }

    public static UseQuotaCommand parse(String commandString, ExecutionContext sessionContext) {
        Matcher matcher = PATTERN.matcher(commandString);
        if (matcher.matches()) {
            return new UseQuotaCommand(commandString, sessionContext, matcher.group(3), matcher.group(1));
        }
        return null;
    }
}

