/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.odps.console.commands;

import com.aliyun.odps.Odps;
import com.aliyun.odps.OdpsException;
import com.aliyun.odps.Project;
import com.aliyun.odps.utils.StringUtils;
import com.aliyun.openservices.odps.console.ExecutionContext;
import com.aliyun.openservices.odps.console.ODPSConsoleException;
import com.aliyun.openservices.odps.console.commands.DirectCommand;
import com.aliyun.openservices.odps.console.commands.SetCommand;
import com.aliyun.openservices.odps.console.utils.ODPSConsoleUtils;
import com.aliyun.openservices.odps.console.utils.OdpsConnectionFactory;
import java.io.PrintStream;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.net.ssl.SSLHandshakeException;

public class UseProjectCommand
extends DirectCommand {
    private static final String OPTION_PROJECT_NAME = "--project";
    private static final Pattern PATTERN = Pattern.compile("\\s*USE\\s+(\\w+)\\s*(with-settings)?\\s*", 2);
    private final String projectName;
    private final boolean withSettings;

    public static void printUsage(PrintStream stream) {
        stream.println("Usage: use <project name> [with-settings];");
        stream.println("Notice: this command will clear all session settings, use with-settings param to avoid this");
    }

    public UseProjectCommand(String commandText, ExecutionContext context, String projectName) {
        this(commandText, context, projectName, context.isUseProjectWithSettings());
    }

    public UseProjectCommand(String commandText, ExecutionContext context, String projectName, boolean withSettings) {
        super(commandText, context);
        this.projectName = projectName;
        this.withSettings = withSettings;
    }

    @Override
    public void run() throws OdpsException, ODPSConsoleException {
        Odps odps = OdpsConnectionFactory.createOdps(this.getContext()).clone();
        if (this.getContext().isInteractiveMode()) {
            odps.getRestClient().setRetryTimes(0);
            odps.getRestClient().setReadTimeout(30);
        } else {
            odps.getRestClient().setRetryTimes(3);
            odps.getRestClient().setReadTimeout(120);
            odps.getRestClient().setConnectTimeout(30);
        }
        Project project = odps.projects().get(this.projectName);
        odps.getRestClient().setIgnoreCerts(false);
        try {
            project.reload();
        }
        catch (RuntimeException e) {
            if (e.getCause() instanceof SSLHandshakeException) {
                if (this.getContext().isHttpsCheck()) {
                    throw e;
                }
                String msg = "WARNING: untrusted https connection:'" + this.getContext().getEndpoint() + "', add https_check=true in config file to avoid this warning.";
                this.getContext().getOutputWriter().writeError(msg);
                odps.getRestClient().setIgnoreCerts(true);
                project = odps.projects().get(this.projectName);
                project.reload();
            }
            throw e;
        }
        this.clearSession();
        this.initSession(odps, project);
        this.getContext().setInitialized(true);
        if (this.getContext().isInteractiveMode()) {
            this.getContext().print();
        }
    }

    private void clearSession() {
        this.getContext().setDefaultSqlTimezone(TimeZone.getDefault().getID());
        if (!this.withSettings) {
            SetCommand.aliasMap.clear();
            SetCommand.setMap.clear();
        }
        if (!this.withSettings || !this.getContext().isUserSetSqlTimezone()) {
            this.getContext().setSqlTimezone(TimeZone.getDefault().getID());
        }
        this.getContext().setQuotaName(null);
        this.getContext().setQuotaRegionId(null);
        if (this.getContext().isInteractiveQuery()) {
            this.getContext().getOutputWriter().writeError("You are under interactive mode, use another project will exit interactive mode.");
            this.getContext().getOutputWriter().writeError("Exiting...");
            try {
                if (ExecutionContext.getExecutor().isActive()) {
                    ExecutionContext.getExecutor().getInstance().stop();
                }
                ExecutionContext.setExecutor(null);
                this.getContext().setInteractiveQuery(false);
                this.getContext().getOutputWriter().writeError("You are in offline mode now.");
            }
            catch (Exception e) {
                this.getContext().getOutputWriter().writeErrorFormat("Exception happened when exiting interactive mode, message: %s", e.getMessage());
            }
        }
    }

    private void initSession(Odps odps, Project project) throws OdpsException, ODPSConsoleException {
        SetCommand.setMap.put("odps.idata.useragent", ODPSConsoleUtils.getUserAgent());
        try {
            Map projectProps = project.getAllProperties();
            if (projectProps != null) {
                String tz = (String)projectProps.get("odps.sql.timezone");
                this.getContext().setDefaultSqlTimezone(tz);
                if (!this.withSettings || !this.getContext().isUserSetSqlTimezone()) {
                    this.getContext().setSqlTimezone(tz);
                }
                this.getContext().setSchemaName(null);
                boolean parseFlag = Boolean.parseBoolean(odps.tenant().getProperty("odps.namespace.schema"));
                this.getContext().setOdpsNamespaceSchema(parseFlag);
            }
        }
        catch (Exception | NoSuchMethodError e) {
            this.getContext().getOutputWriter().writeDebug(e);
        }
        Map<String, String> predefinedSetCommands = this.getContext().getPredefinedSetCommands();
        if (!predefinedSetCommands.isEmpty()) {
            for (Map.Entry<String, String> entry : predefinedSetCommands.entrySet()) {
                String commandText = "SET " + entry.getKey() + "=" + entry.getValue();
                System.err.println("Executing predefined SET command: " + commandText);
                SetCommand setCommand = new SetCommand(true, entry.getKey(), entry.getValue(), commandText, this.getContext());
                setCommand.run();
            }
        }
        this.getContext().setProjectName(this.projectName);
        if (!this.withSettings) {
            this.getContext().setPriority(ExecutionContext.DEFAULT_PRIORITY);
            this.getContext().setPaiPriority(ExecutionContext.DEFAULT_PAI_PRIORITY);
        }
    }

    public static UseProjectCommand parse(List<String> optionList, ExecutionContext sessionContext) {
        String projectName = ODPSConsoleUtils.shiftOption(optionList, OPTION_PROJECT_NAME);
        if (!StringUtils.isNullOrEmpty((String)projectName)) {
            return new UseProjectCommand("", sessionContext, projectName);
        }
        return null;
    }

    public static UseProjectCommand parse(String commandString, ExecutionContext sessionContext) {
        Matcher matcher = PATTERN.matcher(commandString);
        if (matcher.matches()) {
            String withSettings = matcher.group(2);
            if (withSettings != null) {
                return new UseProjectCommand(commandString, sessionContext, matcher.group(1), true);
            }
            return new UseProjectCommand(commandString, sessionContext, matcher.group(1));
        }
        return null;
    }

    public boolean isWithSettings() {
        return this.withSettings;
    }
}

