/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.odps.console.commands;

import com.aliyun.odps.OdpsException;
import com.aliyun.openservices.odps.console.ExecutionContext;
import com.aliyun.openservices.odps.console.ODPSConsoleException;
import com.aliyun.openservices.odps.console.commands.AbstractCommand;
import java.util.List;

public class SetRetryCommand
extends AbstractCommand {
    int retryTimes;

    public int getRetryTimes() {
        return this.retryTimes;
    }

    public SetRetryCommand(int retryTimes, String commandText, ExecutionContext context) {
        super(commandText, context);
        this.retryTimes = retryTimes;
    }

    @Override
    public void run() throws OdpsException, ODPSConsoleException {
        this.getContext().setRetryTimes(this.retryTimes);
    }

    public static SetRetryCommand parse(List<String> optionList, ExecutionContext sessionContext) throws ODPSConsoleException {
        if (optionList.contains("-r") && optionList.indexOf("-r") + 1 < optionList.size()) {
            int index = optionList.indexOf("-r");
            String retryStr = optionList.get(index + 1);
            int step = 0;
            try {
                step = Integer.valueOf(retryStr);
            }
            catch (NumberFormatException e) {
                throw new ODPSConsoleException("Bad Command, Type \"help;\"(--help) or \"h;\"(-h) for help. :need int value[" + retryStr + "]");
            }
            optionList.remove(optionList.indexOf("-r"));
            optionList.remove(retryStr);
            return new SetRetryCommand(step, "-r", sessionContext);
        }
        return null;
    }
}

