/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.odps.console.commands;

import com.aliyun.odps.Odps;
import com.aliyun.odps.OdpsException;
import com.aliyun.odps.security.SecurityConfiguration;
import com.aliyun.odps.security.SecurityManager;
import com.aliyun.openservices.odps.console.ExecutionContext;
import com.aliyun.openservices.odps.console.ODPSConsoleException;
import com.aliyun.openservices.odps.console.commands.AbstractCommand;
import com.aliyun.openservices.odps.console.utils.FileUtil;
import java.io.PrintStream;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class SetCommand
extends AbstractCommand {
    protected static final String[] HELP_TAGS = new String[]{"set", "alias"};
    private static final String SET_REGEX = "^SET\\s+\\S+\\s*=\\s*\\S+.*";
    private static final String ALIAS_REGEX = "^ALIAS\\s+\\S+\\s*=\\s*\\S+.*";
    public static Map<String, String> setMap = new HashMap<String, String>();
    public static Map<String, String> aliasMap = new HashMap<String, String>();
    private static final List<String> ACL_LIST = Arrays.asList("OBJECTCREATORHASACCESSPERMISSION", "OBJECTCREATORHASGRANTPERMISSION", "CHECKPERMISSIONUSINGACL", "CHECKPERMISSIONUSINGPOLICY", "PROJECTPROTECTION", "LABELSECURITY", "EXTERNALRESOURCEACCESSCONTROL");
    private final boolean isSet;
    private final String key;
    private final String value;

    public static void printUsage(PrintStream stream) {
        stream.println("Usage: set|alias <key>=<value>");
    }

    public boolean isSet() {
        return this.isSet;
    }

    public String getKey() {
        return this.key;
    }

    public String getValue() {
        return this.value;
    }

    public SetCommand(boolean isSet, String key, String value, String commandText, ExecutionContext context) {
        super(commandText, context);
        this.isSet = isSet;
        this.key = key;
        this.value = value;
    }

    @Override
    public void run() throws OdpsException, ODPSConsoleException {
        if (this.isSet) {
            if ("odps.instance.priority".equalsIgnoreCase(this.key)) {
                try {
                    this.getContext().setPriority(Integer.parseInt(this.value));
                    this.getContext().setPaiPriority(Integer.parseInt(this.value));
                }
                catch (NumberFormatException e) {
                    throw new ODPSConsoleException("priority need int value[odps.instance.priority=" + this.value + "]");
                }
            }
            if ("odps.running.cluster".equalsIgnoreCase(this.key)) {
                this.getContext().setRunningCluster(this.value);
            }
            if ("odps.sql.timezone".equalsIgnoreCase(this.key)) {
                this.getContext().setSqlTimezone(this.value);
                this.getContext().setUserSetSqlTimezone(true);
            }
            if ("enable_interactive_mode".equals(this.key)) {
                this.getContext().setInteractiveQuery(Boolean.parseBoolean(this.value));
                this.getWriter().writeError("OK");
                return;
            }
            if (this.key.startsWith("fallback.")) {
                switch (this.key) {
                    case "fallback.resource": {
                        this.getContext().getFallbackPolicy().fallback4ResourceNotEnough(Boolean.parseBoolean(this.value));
                        break;
                    }
                    case "fallback.unsupported": {
                        this.getContext().getFallbackPolicy().fallback4UnsupportedFeature(Boolean.parseBoolean(this.value));
                        break;
                    }
                    case "fallback.upgrading": {
                        this.getContext().getFallbackPolicy().fallback4Upgrading(Boolean.parseBoolean(this.value));
                        break;
                    }
                    case "fallback.timeout": {
                        this.getContext().getFallbackPolicy().fallback4RunningTimeout(Boolean.parseBoolean(this.value));
                        break;
                    }
                    case "fallback.attach": {
                        this.getContext().getFallbackPolicy().fallback4AttachError(Boolean.parseBoolean(this.value));
                        break;
                    }
                    case "fallback.unknown": {
                        this.getContext().getFallbackPolicy().fallback4UnknownError(Boolean.parseBoolean(this.value));
                        break;
                    }
                    default: {
                        throw new ODPSConsoleException("unknown fallback policy: " + this.key);
                    }
                }
                this.getWriter().writeError("OK");
                return;
            }
            if ("console.sql.result.instancetunnel".equalsIgnoreCase(this.key)) {
                this.getContext().setUseInstanceTunnel(Boolean.parseBoolean(this.value));
            }
            if ("odps.default.schema".equalsIgnoreCase(this.key)) {
                if (this.getContext().isProjectMode()) {
                    throw new ODPSConsoleException("Can't set default schema if odps.namespace.schema is false");
                }
                if (!this.getCurrentOdps().schemas().exists(this.value)) {
                    throw new ODPSConsoleException("schema " + this.value + " not exists in project " + this.getCurrentOdps().getDefaultProject());
                }
                this.getContext().setSchemaName(this.value);
            }
            if ("odps.namespace.schema".equals(this.key)) {
                SetCommand.isBooleanStr(this.value, this.key);
                this.getContext().setOdpsNamespaceSchema(Boolean.parseBoolean(this.value));
            }
            if (ACL_LIST.contains(this.key.toUpperCase())) {
                this.setSecurityConfig(this.key);
            } else {
                setMap.put(this.key, this.value);
            }
        } else {
            aliasMap.put(this.key, this.value);
        }
        this.getWriter().writeError("OK");
    }

    private void setSecurityConfig(String key) throws ODPSConsoleException, OdpsException {
        String project = this.getCurrentProject();
        Odps odps = this.getCurrentOdps();
        SecurityManager securityManager = odps.projects().get(project).getSecurityManager();
        SecurityConfiguration securityConfig = securityManager.getSecurityConfiguration();
        if (!SetCommand.isStringContainingWith(this.value)) {
            SetCommand.isBooleanStr(this.value, key);
        }
        if ("PROJECTPROTECTION".equalsIgnoreCase(key)) {
            if (SetCommand.isStringContainingWith(this.value)) {
                SetCommand.isBooleanStr(this.value.substring(0, this.value.toLowerCase().indexOf("with")).trim(), key);
                String fileName = this.value.substring(this.value.toLowerCase().indexOf("exception") + 9).trim();
                securityConfig.enableProjectProtection(FileUtil.getStringFromFile(fileName));
            } else {
                boolean enable = Boolean.parseBoolean(this.value);
                if (enable) {
                    securityConfig.enableProjectProtection();
                } else {
                    securityConfig.disableProjectProtection();
                }
            }
        }
        if ("EXTERNALRESOURCEACCESSCONTROL".equalsIgnoreCase(key)) {
            if (SetCommand.isStringContainingWith(this.value)) {
                String prefix = this.value.substring(0, this.value.toLowerCase().indexOf("with")).trim();
                SetCommand.isBooleanStr(prefix, key);
                boolean enable = Boolean.parseBoolean(prefix);
                if (!enable) {
                    throw new ODPSConsoleException("External resource locations can only be set when external resource access control is enabled");
                }
                String locations = this.value.substring(this.value.toLowerCase().indexOf("locations") + 9).trim();
                securityConfig.enableExternalResourceAccessControl(locations);
            } else {
                boolean enable = Boolean.parseBoolean(this.value);
                if (enable) {
                    securityConfig.enableExternalResourceAccessControl();
                } else {
                    securityConfig.disableExternalResourceAccessControl();
                }
            }
        }
        boolean enable = Boolean.parseBoolean(this.value);
        if ("OBJECTCREATORHASACCESSPERMISSION".equalsIgnoreCase(key)) {
            if (enable) {
                securityConfig.enableObjectCreatorHasAccessPermission();
            } else {
                securityConfig.disableObjectCreatorHasAccessPermission();
            }
        } else if ("OBJECTCREATORHASGRANTPERMISSION".equalsIgnoreCase(key)) {
            if (enable) {
                securityConfig.enableObjectCreatorHasGrantPermission();
            } else {
                securityConfig.disableObjectCreatorHasGrantPermission();
            }
        } else if ("CHECKPERMISSIONUSINGACL".equalsIgnoreCase(key)) {
            if (enable) {
                securityConfig.enableCheckPermissionUsingAcl();
            } else {
                securityConfig.disableCheckPermissionUsingAcl();
            }
        } else if ("CHECKPERMISSIONUSINGPOLICY".equalsIgnoreCase(key)) {
            if (enable) {
                securityConfig.enableCheckPermissionUsingPolicy();
            } else {
                securityConfig.disableCheckPermissionUsingPolicy();
            }
        } else if ("LABELSECURITY".equalsIgnoreCase(key)) {
            if (enable) {
                securityConfig.enableLabelSecurity();
            } else {
                securityConfig.disableLabelSecurity();
            }
        }
        securityManager.setSecurityConfiguration(securityConfig);
    }

    private static void isBooleanStr(String str, String key) throws ODPSConsoleException {
        if (!"TRUE".equalsIgnoreCase(str) && !"FALSE".equalsIgnoreCase(str)) {
            throw new ODPSConsoleException(key + " must be boolean String(set XXX=true|false) " + "Bad Command, Type \"help;\"(--help) or \"h;\"(-h) for help. ");
        }
    }

    private static boolean isStringContainingWith(String value) {
        return value.toLowerCase().indexOf("with") >= 1;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static SetCommand parse(String commandString, ExecutionContext sessionContext) throws ODPSConsoleException {
        SetCommand command = null;
        if (commandString.toUpperCase().matches(SET_REGEX)) {
            String keyValue = commandString.substring(3).trim();
            String[] temp = keyValue.split("=", 2);
            if (temp.length != 2) throw new ODPSConsoleException("Bad Command, Type \"help;\"(--help) or \"h;\"(-h) for help. ");
            return new SetCommand(true, temp[0].trim(), temp[1].trim(), commandString, sessionContext);
        }
        if (!commandString.toUpperCase().matches(ALIAS_REGEX)) return command;
        String keyValue = commandString.substring(5).trim();
        String[] temp = keyValue.split("=");
        if (temp.length != 2) throw new ODPSConsoleException("Bad Command, Type \"help;\"(--help) or \"h;\"(-h) for help. ");
        return new SetCommand(false, temp[0].trim(), temp[1].trim(), commandString, sessionContext);
    }
}

