/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.odps.console.commands;

import com.aliyun.odps.OdpsException;
import com.aliyun.odps.OdpsHooks;
import com.aliyun.odps.Task;
import com.aliyun.openservices.odps.console.ExecutionContext;
import com.aliyun.openservices.odps.console.ODPSConsoleException;
import com.aliyun.openservices.odps.console.commands.AbstractCommand;
import com.aliyun.openservices.odps.console.commands.SetCommand;
import com.aliyun.openservices.odps.console.output.DefaultOutputWriter;
import com.aliyun.openservices.odps.console.output.InstanceRunner;
import com.aliyun.openservices.odps.console.utils.ODPSConsoleUtils;
import com.aliyun.openservices.odps.console.utils.QueryUtil;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.util.Iterator;
import java.util.Map;

public abstract class MultiClusterCommandBase
extends AbstractCommand {
    private static final String PMC_TASK_NAME = "console_pmc_task";
    protected String instanceId = "";

    public MultiClusterCommandBase(String commandText, ExecutionContext context) {
        super(commandText, context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void runJob(Task task) throws OdpsException, ODPSConsoleException {
        ExecutionContext context = this.getContext();
        Map config = task.getProperties();
        MultiClusterCommandBase.addSetting(config, SetCommand.setMap);
        for (Map.Entry property : config.entrySet()) {
            task.setProperty((String)property.getKey(), (String)property.getValue());
        }
        InstanceRunner runner = new InstanceRunner(this.getCurrentOdps(), task, context);
        runner.submit();
        OdpsHooks hooks = runner.getInstance().getOdpsHooks();
        runner.getInstance().setOdpsHooks(null);
        if (context.isPMCMode() && SetCommand.setMap.get("odps.progressive.instants") == null) {
            this.instanceId = runner.getInstance().getId();
            runner.printLogview();
            return;
        }
        if (context.isAsyncMode()) {
            this.instanceId = runner.getInstance().getId();
            return;
        }
        if (context.isInteractiveQuery()) {
            ExecutionContext.setInstanceRunner(runner);
            runner.printLogview();
            return;
        }
        runner.waitForCompletion();
        this.instanceId = runner.getInstance().getId();
        try {
            this.reportResult(runner);
        }
        finally {
            if (context.isPMCMode()) {
                QueryUtil.printSubQueryLogview(this.getCurrentOdps(), runner.getInstance(), PMC_TASK_NAME, context);
            }
            if (hooks != null) {
                hooks.after(runner.getInstance(), this.getCurrentOdps());
            }
        }
    }

    protected void reportResult(InstanceRunner runner) throws OdpsException, ODPSConsoleException {
        Iterator<String> queryResult = runner.getResult();
        while (queryResult.hasNext()) {
            ODPSConsoleUtils.checkThreadInterrupted();
            this.writeResult(queryResult.next());
        }
    }

    protected void writeResult(String queryResult) throws ODPSConsoleException {
        DefaultOutputWriter writer = this.getContext().getOutputWriter();
        writer.writeResult(queryResult);
    }

    protected static void addSetting(Map<String, String> config, Map<String, String> setting) {
        String origSettings = null;
        String addedSettings = null;
        Map.Entry<String, String> property = null;
        for (Map.Entry<String, String> pr : config.entrySet()) {
            if (!"settings".equals(pr.getKey())) continue;
            property = pr;
            origSettings = pr.getValue();
            break;
        }
        if (property == null || origSettings == null) {
            try {
                addedSettings = new GsonBuilder().disableHtmlEscaping().create().toJson(setting);
            }
            catch (Exception e) {
                return;
            }
            if (addedSettings != null) {
                config.put("settings", addedSettings);
            }
        } else {
            try {
                JsonObject jsob = new JsonParser().parse(origSettings).getAsJsonObject();
                for (Map.Entry<String, String> prop : setting.entrySet()) {
                    jsob.addProperty(prop.getKey(), prop.getValue());
                }
                addedSettings = jsob.toString();
            }
            catch (Exception e) {
                return;
            }
            if (addedSettings != null) {
                property.setValue(addedSettings);
            }
        }
    }
}

