/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.odps.console.commands;

import com.aliyun.odps.OdpsException;
import com.aliyun.odps.Task;
import com.aliyun.odps.task.MergeTask;
import com.aliyun.odps.utils.StringUtils;
import com.aliyun.openservices.odps.console.ExecutionContext;
import com.aliyun.openservices.odps.console.ODPSConsoleException;
import com.aliyun.openservices.odps.console.commands.MultiClusterCommandBase;
import com.aliyun.openservices.odps.console.output.DefaultOutputWriter;
import com.aliyun.openservices.odps.console.utils.QueryUtil;
import java.io.PrintStream;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jline.reader.UserInterruptException;

public class CompactCommand
extends MultiClusterCommandBase {
    public static final String[] HELP_TAGS = new String[]{"merge", "table", "alter", "compact"};
    private String compactType;
    private String taskName = "";

    public static void printUsage(PrintStream stream) {
        stream.println("Usage: alter table <table_name> [partition (partition_key = 'partition_value' [, ...])] compact [major|minor]");
    }

    private boolean checkTransactional(String tablePart) throws OdpsException, ODPSConsoleException {
        String projectName = this.getCurrentProject();
        String tableName = tablePart.split("\\s+")[0];
        if (tableName.contains(".")) {
            tableName = tableName.split("\\.")[1];
        }
        return this.getCurrentOdps().tables().get(projectName, tableName).isTransactional();
    }

    @Override
    public void run() throws OdpsException, ODPSConsoleException {
        ExecutionContext context = this.getContext();
        DefaultOutputWriter writer = context.getOutputWriter();
        if (!this.checkTransactional(this.getCommandText())) {
            throw new OdpsException(this.getCommandText() + " is not a transactional table.");
        }
        int retryTime = context.getRetryTimes();
        int n = retryTime = retryTime > 0 ? retryTime : 1;
        while (retryTime > 0) {
            MergeTask task = null;
            try {
                this.taskName = "console_merge_task_" + Calendar.getInstance().getTimeInMillis();
                task = new MergeTask(this.taskName, this.getCommandText());
                HashMap<String, String> taskConfig = QueryUtil.getTaskConfig();
                HashMap<String, String> settings = new HashMap<String, String>();
                settings.put("odps.merge.txn.table.compact", this.compactType);
                settings.put("odps.merge.restructure.action", "hardlink");
                CompactCommand.addSetting(taskConfig, settings);
                for (Map.Entry<String, String> property : taskConfig.entrySet()) {
                    task.setProperty(property.getKey(), property.getValue());
                }
                this.runJob((Task)task);
                break;
            }
            catch (UserInterruptException e) {
                throw e;
            }
            catch (Exception e) {
                if (--retryTime == 0) {
                    throw new ODPSConsoleException(e.getMessage());
                }
                writer.writeError("retry " + retryTime);
                writer.writeDebug(StringUtils.stringifyException((Throwable)e));
            }
        }
        writer.writeError("OK");
    }

    public String getTaskName() {
        return this.taskName;
    }

    public String getInstanceId() {
        return this.instanceId;
    }

    public CompactCommand(String command, String compactType, ExecutionContext context) {
        super(command, context);
        this.compactType = compactType;
    }

    private static String getCompactType(String type) {
        if (StringUtils.isNullOrEmpty((String)type)) {
            return null;
        }
        if (type.equalsIgnoreCase("major")) {
            return "major_compact";
        }
        if (type.equalsIgnoreCase("minor")) {
            return "minor_compact";
        }
        return null;
    }

    public static CompactCommand parse(String commandString, ExecutionContext sessionContext) throws ODPSConsoleException {
        String regstr = "\\s*ALTER\\s+TABLE\\s+(.*)\\s+COMPACT\\s+(.*)";
        Pattern p = Pattern.compile(regstr, 2);
        Matcher m = p.matcher(commandString);
        if (m.find()) {
            String tablePart = m.group(1).trim();
            String compactType = CompactCommand.getCompactType(m.group(2).trim());
            if (compactType == null) {
                throw new ODPSConsoleException("Bad Command, Type \"help;\"(--help) or \"h;\"(-h) for help. Compact type should be MAJOR or MINOR.");
            }
            return new CompactCommand(tablePart, compactType, sessionContext);
        }
        return null;
    }
}

