/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.odps.console.commands;

import com.aliyun.odps.OdpsException;
import com.aliyun.odps.Task;
import com.aliyun.odps.task.MergeTask;
import com.aliyun.odps.utils.StringUtils;
import com.aliyun.openservices.odps.console.ExecutionContext;
import com.aliyun.openservices.odps.console.ODPSConsoleException;
import com.aliyun.openservices.odps.console.commands.MultiClusterCommandBase;
import com.aliyun.openservices.odps.console.output.DefaultOutputWriter;
import com.aliyun.openservices.odps.console.utils.QueryUtil;
import com.google.gson.GsonBuilder;
import java.io.PrintStream;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jline.reader.UserInterruptException;

public class ArchiveCommand
extends MultiClusterCommandBase {
    public static final String[] HELP_TAGS = new String[]{"archive"};
    private String taskName = "";
    private final String ARCHIVE_FLAG = "odps.merge.archive.flag";
    private final String ARCHIVE_SETTING = "archiveSettings";

    public static void printUsage(PrintStream stream) {
        stream.println("Usage: alter table <table name> (<partition spec>)? archive");
    }

    @Override
    public void run() throws OdpsException, ODPSConsoleException, ODPSConsoleException {
        ExecutionContext context = this.getContext();
        DefaultOutputWriter writer = context.getOutputWriter();
        int retryTime = context.getRetryTimes();
        retryTime = retryTime > 0 ? retryTime : 1;
        while (true) {
            try {
                MergeTask task = null;
                this.taskName = "console_archive_task_" + Calendar.getInstance().getTimeInMillis();
                task = new MergeTask(this.taskName, this.getCommandText());
                for (Map.Entry<String, String> entry : QueryUtil.getTaskConfig().entrySet()) {
                    task.setProperty(entry.getKey(), entry.getValue());
                }
                HashMap<String, String> archiveSettings = new HashMap<String, String>();
                archiveSettings.put("odps.merge.archive.flag", "true");
                Task.Property property = new Task.Property("archiveSettings", new GsonBuilder().disableHtmlEscaping().create().toJson(archiveSettings));
                task.setProperty(property.getName(), property.getValue());
                this.runJob((Task)task);
                writer.writeError("OK");
            }
            catch (UserInterruptException e) {
                throw e;
            }
            catch (Exception e) {
                if (--retryTime <= 0) {
                    throw new ODPSConsoleException(e.getMessage());
                }
                writer.writeError("retry " + retryTime);
                writer.writeDebug(StringUtils.stringifyException((Throwable)e));
                continue;
            }
            break;
        }
    }

    public String getTaskName() {
        return this.taskName;
    }

    public String getInstanceId() {
        return this.instanceId;
    }

    public ArchiveCommand(String commandText, ExecutionContext context) {
        super(commandText, context);
    }

    public static ArchiveCommand parse(String commandString, ExecutionContext sessionContext) {
        String content = commandString;
        String regstr = "\\s*ALTER\\s+TABLE\\s+(.*)\\s+(ARCHIVE\\s*)$";
        Pattern p = Pattern.compile(regstr, 2);
        Matcher m = p.matcher(content);
        if (m.find()) {
            return new ArchiveCommand(m.group(1), sessionContext);
        }
        return null;
    }
}

