/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.odps.console;

import com.aliyun.odps.account.Account;
import com.aliyun.odps.sqa.FallbackPolicy;
import com.aliyun.odps.sqa.SQLExecutor;
import com.aliyun.odps.utils.StringUtils;
import com.aliyun.openservices.odps.console.ODPSConsoleException;
import com.aliyun.openservices.odps.console.output.DefaultOutputWriter;
import com.aliyun.openservices.odps.console.output.InstanceRunner;
import com.aliyun.openservices.odps.console.utils.ExtProperties;
import com.aliyun.openservices.odps.console.utils.FileUtil;
import com.aliyun.openservices.odps.console.utils.LocalCacheUtils;
import com.aliyun.openservices.odps.console.utils.ODPSConsoleUtils;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.URLDecoder;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.TimeZone;

public class ExecutionContext
implements Cloneable {
    public static final Integer DEFAULT_PRIORITY = 9;
    public static final Integer DEFAULT_PAI_PRIORITY = 9;
    public static final Long DEFAULT_ATTACH_SESSION_TIMEOUT = 60L;
    private static final String SET_COMMAND_PREFIX = "set.";
    private boolean initialized = false;
    private String projectName = "";
    private String schemaName = null;
    private String parseSchemaName = null;
    private String endpoint = "";
    private String quotaRegionId;
    private String quotaName;
    private Account.AccountProvider accountProvider = Account.AccountProvider.ALIYUN;
    private String accessId = "";
    private String accessKey = "";
    private String stsToken = "";
    private String appAccessId = "";
    private String appAccessKey = "";
    private String proxyHost;
    private Integer proxyPort;
    private boolean debug = false;
    private boolean interactiveMode = false;
    private Long attachSessionTimeout = DEFAULT_ATTACH_SESSION_TIMEOUT;
    private Double conformDataSize = null;
    private boolean autoSessionMode = false;
    private String interactiveSessionName = "public.default";
    private LocalCacheUtils.CacheItem localCache = null;
    private boolean odpsNamespaceSchema = false;
    private boolean parseNamespaceSchema = false;
    private boolean interactiveOutputCompatible = false;
    private String userCommands;
    private Integer priority = DEFAULT_PRIORITY;
    private Integer paiPriority = DEFAULT_PAI_PRIORITY;
    private String sqlTimezone = null;
    private boolean userSetTimezone = false;
    private String defaultSqlTimezone = TimeZone.getDefault().getID();
    private boolean isDryRun = false;
    private boolean isJson = false;
    private int consoleWidth = 150;
    private boolean isAsyncMode = false;
    private boolean pMCMode = false;
    private int step = 0;
    private boolean machineReadable = false;
    private int retryTimes = 1;
    private String odpsHooks;
    private DefaultOutputWriter outputWriter = new DefaultOutputWriter(this);
    private String logViewHost;
    private int logViewLife = 720;
    private String updateUrl;
    private boolean testEnv = false;
    private String tunnelEndpoint;
    private String datahubEndpoint;
    private String configFile;
    private String runningCluster;
    private boolean isInteractiveQuery;
    private Map<String, String> predefinedSetCommands = new HashMap<String, String>();
    private static InstanceRunner instanceRunner;
    private static SQLExecutor executor;
    private boolean httpsCheck = false;
    private boolean useInstanceTunnel = false;
    private Long instanceTunnelMaxRecord = null;
    private Long instanceTunnelMaxSize = null;
    private FallbackPolicy fallbackPolicy = FallbackPolicy.alwaysFallbackExceptAttachPolicy();
    private String odpsCupidProxyEndpoint;
    private Long maxAttachSessionInstances = null;
    private boolean liteMode;
    private boolean useProjectWithSettings = false;
    public static Map<String, String> commandBeforeHook;

    public boolean isInteractiveOutputCompatible() {
        return this.interactiveOutputCompatible;
    }

    public void setInteractiveOutputCompatible(boolean interactiveOutputCompatible) {
        this.interactiveOutputCompatible = interactiveOutputCompatible;
    }

    public boolean isInteractiveMode() {
        return this.interactiveMode;
    }

    public void setInteractiveMode(boolean interactiveMode) {
        this.interactiveMode = interactiveMode;
    }

    public boolean isHttpsCheck() {
        return this.httpsCheck;
    }

    public void setHttpsCheck(boolean httpsCheck) {
        this.httpsCheck = httpsCheck;
    }

    public boolean isInitialized() {
        return this.initialized;
    }

    public void setInitialized(boolean initialized) {
        this.initialized = initialized;
    }

    public boolean isTestEnv() {
        return this.testEnv;
    }

    public void setTestEnv(boolean testEnv) {
        this.testEnv = testEnv;
    }

    public String getUpdateUrl() {
        return this.updateUrl;
    }

    public void setUpdateUrl(String updateUrl) {
        this.updateUrl = updateUrl;
    }

    public String getLogViewHost() {
        return this.logViewHost;
    }

    public void setLogViewHost(String logViewHost) {
        this.logViewHost = logViewHost;
    }

    public int getLogViewLife() {
        return this.logViewLife;
    }

    public void setLogViewLife(int i) {
        this.logViewLife = i;
    }

    public String getOdpsHooks() {
        return this.odpsHooks;
    }

    public void setOdpsHooks(String odpsHooks) {
        this.odpsHooks = odpsHooks;
    }

    public boolean isMachineReadable() {
        return this.machineReadable;
    }

    public void setMachineReadable(boolean machineReadable) {
        this.machineReadable = machineReadable;
    }

    public int getRetryTimes() {
        return this.retryTimes;
    }

    public void setRetryTimes(int retryTimes) {
        this.retryTimes = retryTimes;
    }

    public boolean isAsyncMode() {
        return this.isAsyncMode;
    }

    public void setAsyncMode(boolean isAsyncMode) {
        this.isAsyncMode = isAsyncMode;
    }

    public boolean isPMCMode() {
        return this.pMCMode;
    }

    public void setPMCMode(boolean pmcMode) {
        this.pMCMode = pmcMode;
    }

    public boolean isDryRun() {
        return this.isDryRun;
    }

    public void setDryRun(boolean isDryRun) {
        this.isDryRun = isDryRun;
    }

    public boolean isJson() {
        return this.isJson;
    }

    public void setJson(boolean isJson) {
        this.isJson = isJson;
    }

    public int getStep() {
        return this.step;
    }

    public void setStep(int step) {
        this.step = step;
    }

    public String getProjectName() {
        return this.projectName;
    }

    public void setProjectName(String projectName) {
        if (projectName != null) {
            this.projectName = projectName.trim();
        }
    }

    public String getSchemaName() {
        return this.schemaName;
    }

    public void setSchemaName(String schemaName) {
        this.schemaName = schemaName;
    }

    public String getParseSchemaName() {
        return this.parseSchemaName;
    }

    public String getEndpoint() {
        return this.endpoint;
    }

    public void setEndpoint(String endpoint) {
        if (endpoint != null) {
            this.endpoint = endpoint.trim();
        }
    }

    public String getAccessId() {
        return this.accessId;
    }

    public void setAccessId(String accessId) {
        if (accessId != null) {
            this.accessId = accessId.trim();
        }
    }

    public String getAccessKey() {
        return this.accessKey;
    }

    public void setAccessKey(String accessKey) {
        if (accessKey != null) {
            this.accessKey = accessKey.trim();
        }
    }

    public String getAppAccessId() {
        return this.appAccessId;
    }

    public void setAppAccessId(String appAccessId) {
        if (appAccessId != null) {
            this.appAccessId = appAccessId;
        }
    }

    public String getAppAccessKey() {
        return this.appAccessKey;
    }

    public void setAppAccessKey(String appAccessKey) {
        if (appAccessKey != null) {
            this.appAccessKey = appAccessKey;
        }
    }

    public void setConfirmDataSize(Double cost) {
        this.conformDataSize = cost;
    }

    public Double getConfirmDataSize() {
        return this.conformDataSize;
    }

    public String getProxyHost() {
        return this.proxyHost;
    }

    public void setProxyHost(String proxyHost) {
        this.proxyHost = proxyHost;
    }

    public Integer getProxyPort() {
        return this.proxyPort;
    }

    public void setProxyPort(Integer proxyPort) {
        this.proxyPort = proxyPort;
    }

    public int getConsoleWidth() {
        return this.consoleWidth;
    }

    public void setConsoleWidth(int consoleWidth) {
        this.consoleWidth = consoleWidth;
    }

    public boolean isDebug() {
        return this.debug;
    }

    public void setDebug(boolean isDebug) {
        this.debug = isDebug;
    }

    public DefaultOutputWriter getOutputWriter() {
        return this.outputWriter;
    }

    public void setOutputWriter(DefaultOutputWriter outputWriter) {
        this.outputWriter = outputWriter;
    }

    public Integer getPriority() {
        return this.priority;
    }

    public Integer getPaiPriority() {
        return this.paiPriority;
    }

    public void setPriority(Integer priority) {
        this.priority = priority;
    }

    public void setPaiPriority(Integer paiPriority) {
        this.paiPriority = paiPriority;
    }

    public void setSqlTimezone(String timezone) {
        this.sqlTimezone = timezone;
    }

    public void setDefaultSqlTimezone(String defaultSqlTimezone) {
        this.defaultSqlTimezone = defaultSqlTimezone;
    }

    public String getDefaultSqlTimezone() {
        return this.defaultSqlTimezone;
    }

    public void setUserSetSqlTimezone(boolean userSetTimezone) {
        this.userSetTimezone = userSetTimezone;
    }

    public boolean isUserSetSqlTimezone() {
        return this.userSetTimezone;
    }

    public String getSqlTimezone() {
        return this.sqlTimezone;
    }

    public void setInteractiveQuery(boolean isInteractive) {
        this.isInteractiveQuery = isInteractive;
    }

    public boolean isInteractiveQuery() {
        return this.isInteractiveQuery;
    }

    public void setAttachTimeout(Long timeout) {
        this.attachSessionTimeout = timeout;
    }

    public Long getAttachTimeout() {
        return this.attachSessionTimeout;
    }

    public Map<String, String> getPredefinedSetCommands() {
        return this.predefinedSetCommands;
    }

    public static void setInstanceRunner(InstanceRunner runner) {
        instanceRunner = runner;
    }

    public static InstanceRunner getInstanceRunner() {
        return instanceRunner;
    }

    public String getOdpsCupidProxyEndpoint() {
        return this.odpsCupidProxyEndpoint;
    }

    private void setOdpsCupidProxyEndpoint(String odpsCupidProxyEndpoint) {
        this.odpsCupidProxyEndpoint = odpsCupidProxyEndpoint;
    }

    public ExecutionContext clone() {
        try {
            return (ExecutionContext)super.clone();
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
    }

    public static ExecutionContext init() throws ODPSConsoleException {
        return ExecutionContext.load(null);
    }

    public static ExecutionContext load(String config) throws ODPSConsoleException {
        String configFile;
        ExecutionContext context = new ExecutionContext();
        if (config != null) {
            config = FileUtil.expandUserHomeInPath(config);
        }
        String string = configFile = config != null ? config : ODPSConsoleUtils.getConfigFilePath();
        if (configFile == null) {
            return context;
        }
        try {
            configFile = URLDecoder.decode(configFile, "utf-8");
        }
        catch (Exception exception) {
            // empty catch block
        }
        File file = new File(configFile);
        if (!file.exists()) {
            return context;
        }
        context.setConfigFile(configFile);
        FileInputStream configInputStream = null;
        try {
            String liteMode;
            String sessionOutputCompatible;
            String sessionAutoRerun;
            String instanceTunnelMaxSize;
            String instanceTunnelMaxRecord;
            String attachSessionTimeout;
            String maxAttachSessionInstances;
            String useInstanceTunnel;
            String httpsCheck;
            String instancePriority;
            String accountProviderStr;
            String testEnv;
            configInputStream = new FileInputStream(configFile);
            ExtProperties properties = new ExtProperties();
            properties.load(configInputStream);
            String projectName = ((Properties)properties).getProperty("project_name");
            String schemaName = ((Properties)properties).getProperty("schema_name");
            String endpoint = ((Properties)properties).getProperty("end_point");
            String accessId = ((Properties)properties).getProperty("access_id");
            String accessKey = ((Properties)properties).getProperty("access_key");
            String appAccessId = ((Properties)properties).getProperty("app_access_id");
            String appAccessKey = ((Properties)properties).getProperty("app_access_key");
            String dataSizeConfirm = ((Properties)properties).getProperty("data_size_confirm");
            String host = ((Properties)properties).getProperty("proxy_host");
            String port = ((Properties)properties).getProperty("proxy_port");
            String hooks = ((Properties)properties).getProperty("post_hook_class");
            String tunnelEndpoint = ((Properties)properties).getProperty("tunnel_endpoint");
            String datahubEndpoint = ((Properties)properties).getProperty("hub_endpoint");
            String runningCluster = ((Properties)properties).getProperty("running_cluster");
            String logViewHost = ((Properties)properties).getProperty("log_view_host");
            String logViewLife = ((Properties)properties).getProperty("log_view_life");
            String updateUrl = ((Properties)properties).getProperty("update_url");
            String odpsCupidProxyEndpoint = ((Properties)properties).getProperty("cupid_proxy_end_point");
            String interactiveSessionMode = ((Properties)properties).getProperty("enable_interactive_mode");
            String interactiveSessionName = ((Properties)properties).getProperty("interactive_service_name");
            String interactiveOutputCompatible = ((Properties)properties).getProperty("interactive_output_compatible");
            context.setOdpsCupidProxyEndpoint(odpsCupidProxyEndpoint);
            context.setLogViewHost(logViewHost);
            if (!StringUtils.isNullOrEmpty((String)logViewLife)) {
                context.setLogViewLife(Integer.parseInt(logViewLife));
            }
            context.setUpdateUrl(updateUrl);
            context.setProxyHost(host);
            if (!StringUtils.isNullOrEmpty((String)port)) {
                context.setProxyPort(Integer.valueOf(port));
            }
            context.setAccessId(accessId);
            context.setAccessKey(accessKey);
            context.setAppAccessId(appAccessId);
            context.setAppAccessKey(appAccessKey);
            context.setEndpoint(endpoint);
            context.setProjectName(projectName);
            if (!StringUtils.isNullOrEmpty((String)dataSizeConfirm)) {
                Double value = Double.valueOf(dataSizeConfirm);
                if (value <= 0.0) {
                    value = null;
                }
                context.setConfirmDataSize(value);
            }
            context.setOdpsHooks(hooks);
            context.setTunnelEndpoint(tunnelEndpoint);
            context.setDatahubEndpoint(datahubEndpoint);
            context.setRunningCluster(runningCluster);
            context.setUserCommands(((Properties)properties).getProperty("user_commands"));
            String isDebug = ((Properties)properties).getProperty("debug");
            if (isDebug != null) {
                context.setDebug(Boolean.valueOf(isDebug));
            }
            if ((testEnv = ((Properties)properties).getProperty("test_env")) != null) {
                context.setTestEnv(Boolean.valueOf(testEnv));
            }
            if ((accountProviderStr = ((Properties)properties).getProperty("account_provider")) != null) {
                context.setAccountProvider(Account.AccountProvider.valueOf((String)accountProviderStr.toUpperCase()));
            }
            if ((instancePriority = ((Properties)properties).getProperty("instance_priority")) != null) {
                context.setPriority(Integer.valueOf(instancePriority));
                context.setPaiPriority(Integer.valueOf(instancePriority));
            }
            if ((httpsCheck = ((Properties)properties).getProperty("https_check")) != null) {
                context.setHttpsCheck(Boolean.valueOf(httpsCheck));
            }
            if (!StringUtils.isNullOrEmpty((String)(useInstanceTunnel = ((Properties)properties).getProperty("use_instance_tunnel")))) {
                context.setUseInstanceTunnel(Boolean.valueOf(useInstanceTunnel));
            }
            if (!StringUtils.isNullOrEmpty((String)(maxAttachSessionInstances = ((Properties)properties).getProperty("interactive_max_attach")))) {
                Long num = Long.parseLong(maxAttachSessionInstances);
                if (num <= 0L) {
                    num = null;
                }
                context.setMaxAttachSessionInstances(num);
            }
            if (!StringUtils.isNullOrEmpty((String)(attachSessionTimeout = ((Properties)properties).getProperty("attach_session_timeout")))) {
                context.setAttachTimeout(Long.valueOf(attachSessionTimeout));
            }
            if (!StringUtils.isNullOrEmpty((String)(instanceTunnelMaxRecord = ((Properties)properties).getProperty("instance_tunnel_max_record")))) {
                Long num = Long.parseLong(instanceTunnelMaxRecord);
                if (num <= 0L) {
                    num = null;
                }
                context.setInstanceTunnelMaxRecord(num);
            }
            if (!StringUtils.isNullOrEmpty((String)(instanceTunnelMaxSize = ((Properties)properties).getProperty("instance_tunnel_max_size")))) {
                Long size = Long.parseLong(instanceTunnelMaxSize);
                if (size <= 0L) {
                    size = null;
                }
                context.setInstanceTunnelMaxSize(size);
            }
            if (!StringUtils.isNullOrEmpty((String)(sessionAutoRerun = ((Properties)properties).getProperty("interactive_auto_rerun")))) {
                context.fallbackPolicy = Boolean.valueOf(sessionAutoRerun) != false ? FallbackPolicy.alwaysFallbackExceptAttachPolicy() : FallbackPolicy.nonFallbackPolicy();
            }
            if (!StringUtils.isNullOrEmpty((String)interactiveSessionMode) && Boolean.valueOf(interactiveSessionMode).booleanValue()) {
                context.setAutoSessionMode(true);
                if (!StringUtils.isNullOrEmpty((String)interactiveSessionName)) {
                    context.setInteractiveSessionName(interactiveSessionName);
                }
                if (!StringUtils.isNullOrEmpty((String)maxAttachSessionInstances)) {
                    LocalCacheUtils.enableMultiAttachSessionMode(context.getMaxAttachSessionInstances());
                    int maxRetry = 10;
                    boolean readCacheSucc = false;
                    while (maxRetry-- > 0) {
                        try {
                            LocalCacheUtils.setCacheDir(configFile, endpoint, projectName, accessId);
                            context.localCache = LocalCacheUtils.readCache();
                            readCacheSucc = true;
                            break;
                        }
                        catch (Exception e) {
                            Thread.sleep(200L);
                        }
                    }
                    if (!readCacheSucc) {
                        throw new ODPSConsoleException("Try to find available attach session failed after retry");
                    }
                } else {
                    LocalCacheUtils.setCacheDir(configFile, endpoint, projectName, accessId);
                    context.localCache = LocalCacheUtils.readCache();
                }
            }
            if (!StringUtils.isNullOrEmpty((String)(sessionOutputCompatible = ((Properties)properties).getProperty("interactive_output_compatible")))) {
                context.interactiveOutputCompatible = Boolean.valueOf(sessionOutputCompatible) != false;
            }
            if (!StringUtils.isNullOrEmpty((String)(liteMode = ((Properties)properties).getProperty("lite_mode")))) {
                context.setLiteMode(Boolean.valueOf(liteMode));
            }
            context.setConsoleWidth(ODPSConsoleUtils.getConsoleWidth());
            for (String propertyName : properties.stringPropertyNames()) {
                if (!propertyName.toLowerCase().startsWith(SET_COMMAND_PREFIX)) continue;
                String key = propertyName.substring(SET_COMMAND_PREFIX.length()).trim();
                String value = ((Properties)properties).getProperty(propertyName).trim();
                context.predefinedSetCommands.put(key, value);
            }
        }
        catch (Exception e) {
            throw new ODPSConsoleException("Load odps config error", e);
        }
        finally {
            if (configInputStream != null) {
                try {
                    configInputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
        return context;
    }

    private void setInteractiveSessionName(String interactiveSessionName) {
        this.interactiveSessionName = interactiveSessionName;
    }

    public String getStsToken() {
        return this.stsToken;
    }

    public void setStsToken(String stsToken) {
        this.stsToken = stsToken;
    }

    public Account.AccountProvider getAccountProvider() {
        return this.accountProvider;
    }

    public void setAccountProvider(Account.AccountProvider accountProvider) {
        this.accountProvider = accountProvider;
    }

    public String getUserCommands() {
        return this.userCommands;
    }

    public void setUserCommands(String userCommands) {
        this.userCommands = userCommands;
    }

    public String getTunnelEndpoint() {
        return this.tunnelEndpoint;
    }

    public void setTunnelEndpoint(String tunnelEndpoint) {
        this.tunnelEndpoint = tunnelEndpoint;
    }

    public String getDatahubEndpoint() {
        return this.datahubEndpoint;
    }

    public void setDatahubEndpoint(String datahubEndpoint) {
        this.datahubEndpoint = datahubEndpoint;
    }

    public String getConfigFile() {
        return this.configFile;
    }

    public void setConfigFile(String configFile) {
        this.configFile = configFile;
    }

    public JsonObject toJson() throws JsonParseException {
        JsonObject jsonObj = new JsonObject();
        jsonObj.addProperty("project", this.projectName);
        jsonObj.addProperty("endpoint", this.endpoint);
        jsonObj.addProperty("proxyHost", this.proxyHost);
        jsonObj.addProperty("proxyPort", (Number)this.proxyPort);
        jsonObj.addProperty("debug", Boolean.valueOf(this.debug));
        jsonObj.addProperty("accountProvider", this.accountProvider.toString());
        jsonObj.addProperty("userCommands", this.userCommands);
        jsonObj.addProperty("priority", Integer.toString(this.priority));
        jsonObj.addProperty("isDryRun", Boolean.valueOf(this.isDryRun));
        jsonObj.addProperty("isJson", Boolean.valueOf(this.isJson));
        jsonObj.addProperty("consoleWidth", (Number)this.consoleWidth);
        jsonObj.addProperty("isAsyncMode", Boolean.valueOf(this.isAsyncMode));
        jsonObj.addProperty("isPMCMode", Boolean.valueOf(this.pMCMode));
        jsonObj.addProperty("step", (Number)this.step);
        jsonObj.addProperty("machineReadable", Boolean.valueOf(this.machineReadable));
        jsonObj.addProperty("retryTimes", (Number)this.retryTimes);
        jsonObj.addProperty("odpsHooks", this.odpsHooks);
        jsonObj.addProperty("logViewHost", this.logViewHost);
        jsonObj.addProperty("logViewLife", (Number)this.logViewLife);
        jsonObj.addProperty("tunnelEndpoint", this.tunnelEndpoint);
        jsonObj.addProperty("runningCluster", this.runningCluster);
        jsonObj.addProperty("https_check", Boolean.valueOf(this.httpsCheck));
        return jsonObj;
    }

    public void setRunningCluster(String runningCluster) {
        this.runningCluster = runningCluster;
    }

    public String getRunningCluster() {
        return this.runningCluster;
    }

    public void setUseInstanceTunnel(boolean useInstanceTunnel) {
        this.useInstanceTunnel = useInstanceTunnel;
    }

    public boolean isUseInstanceTunnel() {
        return this.useInstanceTunnel;
    }

    public void setInstanceTunnelMaxRecord(Long number) {
        this.instanceTunnelMaxRecord = number;
    }

    public void setMaxAttachSessionInstances(Long maxAttachSessionInstances) {
        this.maxAttachSessionInstances = maxAttachSessionInstances;
    }

    public Long getMaxAttachSessionInstances() {
        return this.maxAttachSessionInstances;
    }

    public void setInstanceTunnelMaxSize(Long size) {
        this.instanceTunnelMaxSize = size;
    }

    public Long getInstanceTunnelMaxRecord() {
        return this.instanceTunnelMaxRecord;
    }

    public Long getInstanceTunnelMaxSize() {
        return this.instanceTunnelMaxSize;
    }

    public FallbackPolicy getFallbackPolicy() {
        return this.fallbackPolicy;
    }

    public void setAutoSessionMode(boolean b) {
        this.autoSessionMode = b;
    }

    public boolean getAutoSessionMode() {
        return this.autoSessionMode;
    }

    public String getInteractiveSessionName() {
        return this.interactiveSessionName;
    }

    public LocalCacheUtils.CacheItem getLocalCache() {
        return this.localCache;
    }

    public static SQLExecutor getExecutor() {
        return executor;
    }

    public static void setExecutor(SQLExecutor executor) {
        ExecutionContext.executor = executor;
    }

    public boolean setLocalCache(LocalCacheUtils.CacheItem localCache) {
        this.localCache = localCache;
        try {
            LocalCacheUtils.writeCache(this.localCache);
            return true;
        }
        catch (IOException e) {
            return false;
        }
    }

    public boolean isLiteMode() {
        return this.liteMode;
    }

    public void setLiteMode(boolean liteMode) {
        this.liteMode = liteMode;
    }

    public String getQuotaName() {
        return this.quotaName;
    }

    public void setQuotaName(String quotaName) {
        this.quotaName = quotaName;
    }

    public String getQuotaRegionId() {
        return this.quotaRegionId;
    }

    public void setQuotaRegionId(String quotaRegionId) {
        this.quotaRegionId = quotaRegionId;
    }

    public void print() {
        DefaultOutputWriter writer = this.getOutputWriter();
        String endpoint = this.getEndpoint();
        String projectName = this.getProjectName();
        writer.writeErrorFormat("Endpoint: %s\nProject: %s\n", endpoint, projectName);
        if (this.isSchemaMode()) {
            writer.writeErrorFormat("Schema: %s\n", ODPSConsoleUtils.getDisplaySchema(this));
        }
        String quotaRegionId = this.getQuotaRegionId();
        String quotaName = this.getQuotaName();
        writer.writeErrorFormat("Quota: %s in region %s\n", org.apache.commons.lang.StringUtils.defaultIfEmpty((String)quotaName, (String)"default"), org.apache.commons.lang.StringUtils.defaultIfEmpty((String)quotaRegionId, (String)"N/A"));
        String timezone = this.getSqlTimezone();
        writer.writeErrorFormat("Timezone: %s\n", org.apache.commons.lang.StringUtils.defaultIfEmpty((String)timezone, (String)"default"));
    }

    public boolean isOdpsNamespaceSchema() {
        return this.odpsNamespaceSchema;
    }

    public boolean isProjectMode() {
        return !this.odpsNamespaceSchema;
    }

    public boolean isSchemaMode() {
        return this.odpsNamespaceSchema;
    }

    public void setOdpsNamespaceSchema(boolean odpsNamespaceSchema) {
        this.odpsNamespaceSchema = odpsNamespaceSchema;
    }

    public boolean isUseProjectWithSettings() {
        return this.useProjectWithSettings;
    }

    public void setUseProjectWithSettings(boolean useProjectWithSettings) {
        this.useProjectWithSettings = useProjectWithSettings;
    }

    static {
        commandBeforeHook = new HashMap<String, String>();
    }
}

