/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.odps.console.volume2;

import com.aliyun.odps.OdpsException;
import com.aliyun.odps.Volume;
import com.aliyun.odps.Volumes;
import com.aliyun.openservices.odps.console.ExecutionContext;
import com.aliyun.openservices.odps.console.ODPSConsoleException;
import com.aliyun.openservices.odps.console.volume2.ExternalVolumeCommand;
import java.io.PrintStream;
import java.util.List;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;

public class CreateExternalVolumeCommand
extends ExternalVolumeCommand {
    private static final String OP_SP = "storage_provider";
    private static final String OP_URL = "url";
    private static final String OP_RA = "role_arn";
    private static final String OP_ACD = "acd";
    private static final String OP_LIFECYCLE = "lifecycle";
    private static List<String> SUB_COMMAND_WHITELIST = null;
    private String[] args = null;
    private String storageProvider = null;
    private String externalLocation = null;
    private String roleArn = null;
    private Long lifecycle = null;
    private String comment = null;
    private String extVolumeName = null;
    private boolean autoCreateDir = false;

    public static void printCreateExtVolumeUsage(PrintStream out) {
        out.println("");
        out.println("Usage: vfs <-create > <volume_name> <-storage_provider> <type> <-url> <external_url> [-role_arn <role_arn>] [-lifecycle <number>] [comment];");
    }

    public CreateExternalVolumeCommand(String commandText, ExecutionContext context) {
        super(commandText, context);
    }

    @Override
    public void run() throws OdpsException, ODPSConsoleException {
        String[] commandSplits = this.getCommandText().split("\\s+");
        if (commandSplits.length < 7) {
            CreateExternalVolumeCommand.printCreateExtVolumeUsage(System.err);
            throw new ODPSConsoleException("Invalid create external volume command.");
        }
        this.extVolumeName = commandSplits[2].toLowerCase();
        this.args = new String[commandSplits.length - 3];
        System.arraycopy(commandSplits, 3, this.args, 0, commandSplits.length - 3);
        this.createExternalVolume();
        this.getWriter().writeError("OK");
    }

    private void createExternalVolume() throws OdpsException, ODPSConsoleException {
        Volumes.VolumeBuilder builder;
        this.processCreateOptions(this.args);
        if (this.storageProvider.equalsIgnoreCase("oss")) {
            builder = new Volumes.VolumeBuilder();
            builder.project(this.getCurrentProject()).volumeName(this.extVolumeName).type(Volume.Type.EXTERNAL).extLocation(this.externalLocation);
            if (this.lifecycle != null) {
                builder.lifecycle(this.lifecycle.longValue());
            }
            if (this.comment != null) {
                builder.comment(this.comment);
            }
            if (this.roleArn != null) {
                builder.addProperty("odps.properties.rolearn", this.roleArn);
            }
        } else {
            throw new ODPSConsoleException("Illegal storage provider: " + this.storageProvider);
        }
        builder.autoMkDir(this.autoCreateDir);
        this.getCurrentOdps().volumes().create(builder);
    }

    private Options initOptions() {
        Options opts = new Options();
        Option sp = new Option(OP_SP, OP_SP, true, "storage provider");
        sp.setRequired(true);
        Option url = new Option(OP_URL, OP_URL, true, "external location url");
        url.setRequired(true);
        Option role = new Option(OP_RA, OP_RA, true, "role arn");
        role.setRequired(false);
        Option autoCreateDir = new Option(OP_ACD, OP_ACD, true, "auto create dir");
        autoCreateDir.setRequired(false);
        Option lifecycle = new Option(OP_LIFECYCLE, OP_LIFECYCLE, true, OP_LIFECYCLE);
        lifecycle.setRequired(false);
        opts.addOption(sp);
        opts.addOption(url);
        opts.addOption(role);
        opts.addOption(autoCreateDir);
        opts.addOption(lifecycle);
        return opts;
    }

    protected void processCreateOptions(String[] args) throws ODPSConsoleException {
        List leftArgs;
        String acdValue;
        CommandLine cl;
        Options opts = this.initOptions();
        DefaultParser clp = new DefaultParser();
        try {
            cl = clp.parse(opts, args, false);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Illegal command: " + e.getMessage(), e);
        }
        if (!cl.hasOption(OP_SP)) {
            CreateExternalVolumeCommand.printCreateExtVolumeUsage(System.err);
            throw new ODPSConsoleException("storage_providerparameter is required.");
        }
        this.storageProvider = cl.getOptionValue(OP_SP);
        if (!cl.hasOption(OP_URL)) {
            CreateExternalVolumeCommand.printCreateExtVolumeUsage(System.err);
            throw new ODPSConsoleException("urlparameter is required.");
        }
        this.externalLocation = cl.getOptionValue(OP_URL);
        if (cl.hasOption(OP_RA)) {
            this.roleArn = cl.getOptionValue(OP_RA);
        }
        if (cl.hasOption(OP_ACD) && Boolean.parseBoolean(acdValue = cl.getOptionValue(OP_ACD))) {
            this.autoCreateDir = true;
        }
        if (cl.hasOption(OP_LIFECYCLE)) {
            this.lifecycle = Long.parseLong(cl.getOptionValue(OP_LIFECYCLE));
        }
        if ((leftArgs = cl.getArgList()).size() > 1) {
            CreateExternalVolumeCommand.printCreateExtVolumeUsage(System.err);
            throw new ODPSConsoleException("Invalid parameters: " + String.join((CharSequence)", ", leftArgs));
        }
        if (leftArgs.size() == 1) {
            this.comment = (String)leftArgs.get(0);
        }
    }
}

