/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.odps.console.resource;

import com.aliyun.odps.NoSuchObjectException;
import com.aliyun.odps.Odps;
import com.aliyun.odps.OdpsException;
import com.aliyun.openservices.odps.console.ExecutionContext;
import com.aliyun.openservices.odps.console.ODPSConsoleException;
import com.aliyun.openservices.odps.console.commands.AbstractCommand;
import com.aliyun.openservices.odps.console.utils.CommandParserUtils;
import com.aliyun.openservices.odps.console.utils.CommandWithOptionP;
import com.aliyun.openservices.odps.console.utils.Coordinate;
import java.io.PrintStream;

public class DropFunctionCommand
extends AbstractCommand {
    public static final String[] HELP_TAGS = new String[]{"drop", "delete", "function"};
    private Coordinate coordinate;
    private String projectName;
    private String schemaName;
    private String functionName;
    boolean checkExistence;

    public static void printUsage(PrintStream out, ExecutionContext ctx) {
        out.println("Usage: ");
        if (ctx.isProjectMode()) {
            out.println(" drop function [if exists] [<project name>.]<function name>");
        } else {
            out.println(" drop function [if exists] [[<project name>.]<schema name>.]<function name>");
        }
    }

    public DropFunctionCommand(boolean checkExistence, Coordinate coordinate, String commandText, ExecutionContext context) {
        super(commandText, context);
        this.coordinate = coordinate;
        this.checkExistence = checkExistence;
    }

    public void run() throws ODPSConsoleException, OdpsException {
        this.coordinate.interpretByCtx(this.getContext());
        this.projectName = this.coordinate.getProjectName();
        this.schemaName = this.coordinate.getSchemaName();
        this.functionName = this.coordinate.getObjectName();
        Odps odps = this.getCurrentOdps();
        try {
            if (this.checkExistence && !odps.functions().exists(this.projectName, this.schemaName, this.functionName)) {
                this.getWriter().writeError("OK");
                return;
            }
            odps.functions().delete(this.projectName, this.schemaName, this.functionName);
            this.getWriter().writeError("OK");
        }
        catch (NoSuchObjectException e) {
            this.getWriter().writeError(e.getMessage());
        }
        catch (OdpsException e) {
            throw new ODPSConsoleException(e.getMessage());
        }
    }

    public static DropFunctionCommand parse(String commandString, ExecutionContext sessionContext) throws ODPSConsoleException {
        Coordinate coordinate;
        boolean matchDelete;
        String[] args = CommandParserUtils.getCommandTokens((String)commandString);
        if (args.length < 2) {
            return null;
        }
        boolean matchDrop = "DROP".equalsIgnoreCase(args[0]) && "FUNCTION".equalsIgnoreCase(args[1]);
        boolean bl = matchDelete = "DELETE".equalsIgnoreCase(args[0]) && "FUNCTION".equalsIgnoreCase(args[1]);
        if (!matchDelete && !matchDrop) {
            return null;
        }
        String project = null;
        String function = null;
        boolean checkExists = false;
        CommandWithOptionP cmdP = new CommandWithOptionP(commandString);
        if (matchDelete) {
            project = cmdP.getProjectValue();
            args = cmdP.getArgs();
        }
        if (args.length == 3) {
            function = args[2];
        } else if (args.length == 5) {
            boolean matchIfExists;
            boolean bl2 = matchIfExists = "IF".equalsIgnoreCase(args[2]) && "EXISTS".equalsIgnoreCase(args[3]);
            if (!matchIfExists) {
                throw new ODPSConsoleException("Bad Command, Type \"help;\"(--help) or \"h;\"(-h) for help. ");
            }
            function = args[4];
            checkExists = true;
        } else {
            throw new ODPSConsoleException("Bad Command, Type \"help;\"(--help) or \"h;\"(-h) for help. ");
        }
        if (matchDelete) {
            if (function.contains(".")) {
                throw new ODPSConsoleException("Bad Command, Type \"help;\"(--help) or \"h;\"(-h) for help. ");
            }
            coordinate = Coordinate.getCoordinateOptionP((String)project, (String)function);
        } else {
            coordinate = Coordinate.getCoordinateABC((String)function);
        }
        return new DropFunctionCommand(checkExists, coordinate, commandString, sessionContext);
    }
}

