/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.odps.console.resource;

import com.aliyun.odps.FileResource;
import com.aliyun.odps.Odps;
import com.aliyun.odps.OdpsException;
import com.aliyun.odps.Resource;
import com.aliyun.odps.TableResource;
import com.aliyun.odps.utils.StringUtils;
import com.aliyun.openservices.odps.console.ExecutionContext;
import com.aliyun.openservices.odps.console.ODPSConsoleException;
import com.aliyun.openservices.odps.console.commands.AbstractCommand;
import com.aliyun.openservices.odps.console.utils.CommandWithOptionP;
import com.aliyun.openservices.odps.console.utils.Coordinate;
import com.aliyun.openservices.odps.console.utils.ODPSConsoleUtils;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.Date;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class DescribeResourceCommand
extends AbstractCommand {
    public static final String[] HELP_TAGS = new String[]{"describe", "desc", "resource"};
    private Coordinate coordinate;
    private static final Pattern PATTERN = Pattern.compile("\\s*(DESCRIBE|DESC)\\s+RESOURCE\\s+(.*)", 2);

    public static void printUsage(PrintStream stream, ExecutionContext ctx) {
        stream.println("Usage: ");
        if (ctx.isProjectMode()) {
            stream.println("  describe|desc resource <project name>:<resource name>");
        } else {
            stream.println("  describe|desc resource <schema name>:<resource name>");
            stream.println("  describe|desc resource <project name>:<schema name>:<resource name>");
        }
    }

    public DescribeResourceCommand(Coordinate coordinate, String cmd, ExecutionContext ctx) {
        super(cmd, ctx);
        this.coordinate = coordinate;
    }

    public void run() throws OdpsException, ODPSConsoleException {
        this.coordinate.interpretByCtx(this.getContext());
        String projectName = this.coordinate.getProjectName();
        String schemaName = this.coordinate.getSchemaName();
        String resourceName = this.coordinate.getObjectName();
        Odps odps = this.getCurrentOdps();
        if (!odps.resources().exists(projectName, schemaName, resourceName)) {
            throw new ODPSConsoleException("Resource not found : " + resourceName);
        }
        Resource r = odps.resources().get(projectName, schemaName, resourceName);
        PrintWriter out = new PrintWriter(System.out);
        out.printf("%-40s%-40s\n", "Name", r.getName());
        out.printf("%-40s%-40s\n", "Owner", r.getOwner());
        out.printf("%-40s%-40s\n", "Type", r.getType());
        if (r.getType() == Resource.Type.TABLE) {
            TableResource tr = (TableResource)r;
            String tableSource = tr.getSourceTable().getProject() + "." + tr.getSourceTable().getName();
            if (tr.getSourceTablePartition() != null) {
                tableSource = tableSource + " partition(" + tr.getSourceTablePartition().toString() + ")";
            }
            out.printf("%-40s%-40s\n", "SourceTableName", tableSource);
        }
        out.printf("%-40s%-40s\n", "Comment", r.getComment());
        out.printf("%-40s%-40s\n", "CreatedTime", ODPSConsoleUtils.formatDate((Date)r.getCreatedTime()));
        out.printf("%-40s%-40s\n", "LastModifiedTime", ODPSConsoleUtils.formatDate((Date)r.getLastModifiedTime()));
        out.printf("%-40s%-40s\n", "LastUpdator", r.getLastUpdator());
        if (r.getSize() != null) {
            out.printf("%-40s%-40s\n", "Size", r.getSize());
        }
        if (r instanceof FileResource && !StringUtils.isNullOrEmpty((String)((FileResource)r).getContentMd5())) {
            out.printf("%-40s%-40s\n", "Md5sum", ((FileResource)r).getContentMd5());
        }
        out.flush();
    }

    public static DescribeResourceCommand parse(String cmd, ExecutionContext ctx) throws ODPSConsoleException {
        Matcher m = PATTERN.matcher(cmd);
        if (!m.matches()) {
            return null;
        }
        Coordinate coordinate = DescribeResourceCommand.parseOptionP(cmd, ctx);
        if (coordinate == null) {
            coordinate = Coordinate.getCoordinateABC((String)m.group(2), (String)":");
        }
        return new DescribeResourceCommand(coordinate, cmd, ctx);
    }

    public static Coordinate parseOptionP(String cmd, ExecutionContext ctx) throws ODPSConsoleException {
        CommandWithOptionP command = new CommandWithOptionP(cmd);
        if (!command.hasOptionP()) {
            return null;
        }
        if (command.getArgs().length != 3) {
            throw new ODPSConsoleException("Bad Command, Type \"help;\"(--help) or \"h;\"(-h) for help.  Invalid resource name.");
        }
        String resource = command.getArgs()[2];
        if (resource.contains(":")) {
            throw new ODPSConsoleException("Bad Command, Type \"help;\"(--help) or \"h;\"(-h) for help.  project name conflict");
        }
        String project = command.getProjectValue();
        return Coordinate.getCoordinateOptionP((String)project, (String)resource);
    }
}

