/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.odps.cupid.requestcupid;

import apsara.odps.cupid.protocol.CupidTaskParamProtos;
import com.aliyun.odps.Instance;
import com.aliyun.odps.cupid.CupidSession;
import com.aliyun.odps.cupid.CupidUtil;
import com.aliyun.odps.cupid.requestcupid.CupidTaskOperatorConst;
import com.aliyun.odps.cupid.requestcupid.SubmitJobUtil;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public class CreateK8sClusterUtil {
    private static final Logger LOG = Logger.getLogger(CreateK8sClusterUtil.class);
    private static final String DEFAULT_RUNNING_TYPE = "longtime";

    public static Instance submitCluster(HashMap<String, String> conf, CupidSession cupidSession) throws Exception {
        Instance instance;
        CupidTaskParamProtos.CupidTaskOperator.Builder cupidTaskOperator = CupidTaskParamProtos.CupidTaskOperator.newBuilder();
        cupidTaskOperator.setMoperator(CupidTaskOperatorConst.CUPID_TASK_START);
        cupidTaskOperator.setMlookupName("");
        String engineType = DEFAULT_RUNNING_TYPE;
        if (conf.containsKey("odps.cupid.engine.running.type")) {
            engineType = conf.get("odps.cupid.engine.running.type");
        }
        cupidTaskOperator.setMenginetype(engineType);
        boolean isLongRunning = engineType.equals(DEFAULT_RUNNING_TYPE);
        int priority = 1;
        if (conf.containsKey("odps.cupid.job.priority")) {
            priority = Integer.parseInt(conf.get("odps.cupid.job.priority"));
        }
        conf.put("odps.cupid.isolation.default", "false");
        conf.put("odps.cupid.master.type", "kubernetes");
        CupidTaskParamProtos.JobConf.Builder confBuilder = CupidTaskParamProtos.JobConf.newBuilder();
        for (Map.Entry<String, String> entry : conf.entrySet()) {
            if (!entry.getKey().startsWith("odps.") && !entry.getKey().startsWith("cupid.")) continue;
            CupidTaskParamProtos.JobConfItem.Builder itemBuilder = CupidTaskParamProtos.JobConfItem.newBuilder();
            itemBuilder.setKey(entry.getKey());
            itemBuilder.setValue(entry.getValue());
            confBuilder.addJobconfitem(itemBuilder);
        }
        CupidTaskParamProtos.CupidTaskParam.Builder cupidTaskParamPB = CupidTaskParamProtos.CupidTaskParam.newBuilder();
        cupidTaskParamPB.setMcupidtaskoperator(cupidTaskOperator);
        cupidTaskParamPB.setJobconf(confBuilder);
        try {
            instance = SubmitJobUtil.submitJob(cupidTaskParamPB.build(), "eHasFuxiJob", priority, isLongRunning, cupidSession);
        }
        catch (Exception e) {
            LOG.error((Object)"Getting instance failed. ", (Throwable)e);
            throw e;
        }
        LOG.info((Object)("Instance ID: " + instance.getId()));
        return instance;
    }

    public static boolean waitClusterRunning(Instance instance) throws Exception {
        CupidTaskParamProtos.CupidTaskDetailResultParam res;
        try {
            res = CupidUtil.getResult(instance);
        }
        catch (Exception e) {
            LOG.error((Object)"Getting result failed. ", (Throwable)e);
            return false;
        }
        if (res.getRunning() != null) {
            return true;
        }
        if (res.getFailed() != null) {
            throw new Exception("create odps cluster fail, error message is: " + res.getFailed().getBizFailed().getBizFailedMsg());
        }
        if (res.getCancelled() != null) {
            throw new Exception("create odps cluster fail, error message is: instance was canceled. ");
        }
        if (res.getSuccess() != null) {
            throw new Exception("create odps cluster fail, error message is: " + res.getSuccess().getSuccessMsg());
        }
        throw new Exception("create odps cluster fail, error message is: unexpected status. ");
    }

    public static String createCluster(HashMap<String, String> conf, CupidSession cupidSession) throws Exception {
        Instance instance = CreateK8sClusterUtil.submitCluster(conf, cupidSession);
        if (CreateK8sClusterUtil.waitClusterRunning(instance)) {
            return instance.getId();
        }
        return null;
    }
}

